// BigONSpaceTablesTest.c: Test program for creation of Tables with O(N) size
////////////////////////////////////////////////////////////////////////////////
//
//   Copyright (C) 2008   Georg S. Weber
//
//   This file is part of the Essen Modular package programs.
//
//   The Essen Modular package programs are
//   free software:
//   you can redistribute them and/or modify them
//   under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   The Essen Modular package programs are
//   distributed in the hope that they will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License along
//   with the Essen Modular package programs,
//   see the text file COPYING in this directory.
//   If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////
//
//   history / version (the version is YYYYMMDD of the last change)
//   2008-02-27: creation (gsw) of first version
//
////////////////////////////////////////////////////////////////////////////////

#include "./BigONSpaceTables.h"


//
// function     : main
//
// param     x: 
// param array: 
//              
//              
//              
//              
//              
// returns      : we use exit()
//
// changes      : 2008-02-27, creation (gsw)
//

int main(int argc, char * argv[])
{
    EF_sng N;                       //level (natural number > 1)

    EF_sng sizeOfP1ZNZ = 0x0;       //size of P^1(Z/NZ)
    
    EF_sng * listReps;
    
    EF_sng i;                       //counter variable
    

    if(0x2 == argc)
    {
        N = (EF_sng)strtoll(argv[0x1], (char **)NULL, 10);
    }
    else
    {
        printf("Error: Wrong number of arguments!\n");
        exit(1);
    }
    
    switch( BigONSpaceTablesConstruction(N) )
    {
        case 0x0:
        {
            //success
            //get list
            sizeOfP1ZNZ = listOfRepresentatives( (EF_sng **)(&listReps) );
    
            break;
        }
        case 0x1:
        {
            printf("Error: Tables already created --- internal error!\n");
            break;
        }
        case 0x2:
        {
            printf("Error: N must be greater or equal to 2!\n");
            break;
        }
        case 0x5:
        {
            printf("Error: For the time being, N must be a prime power!\n");
            break;
        }
        default:
        {
            printf("Error: Not enough memory!\n");
            break;
        }
    }
    
    if(0x0 == sizeOfP1ZNZ)
    {
        exit(1);
    }
    
    printf("%u\n", sizeOfP1ZNZ);
    
    //output list
    for(i = 0; i < sizeOfP1ZNZ; i++)
    {
        printf("( %u : %u )\n", listReps[i<<0x1], listReps[(i<<0x1) + 1]);
    }
    
    BigONSpaceTablesDestruction();
    
    exit(0);    
}

