// EratosthenesFermatTest.c: Test program for EratosthenesFermat algorithm
////////////////////////////////////////////////////////////////////////////////
//
//   Copyright (C) 2008   Georg S. Weber
//
//   This file is part of the Essen Modular package programs.
//
//   The Essen Modular package programs are
//   free software:
//   you can redistribute them and/or modify them
//   under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   The Essen Modular package programs are
//   distributed in the hope that they will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License along
//   with the Essen Modular package programs,
//   see the text file COPYING in this directory.
//   If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////
//
//   history / version (the version is YYYYMMDD of the last change)
//   2008-02-03: creation (gsw) 
//
////////////////////////////////////////////////////////////////////////////////


#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>

#include "./EratosthenesFermat.h" 
#include "./PrimeFactors.h"     //used in newer versions of EratosthenesFermatP

#define TESTLENGTH  400000u
//#define TEST_X      399955577u
#define TEST_X              4u


//
// function     : main
//
// param     x: 
// param array: 
//              
//              
//              
//              
//              
// returns      : we use exit()
//
// changes      : 2008-02-03, creation (gsw)
//                2008-02-08, modified (gsw)
//                2008-03-23, use PrimeFactors (gsw)
//

int main(void)
{
    EF_sng * TestArray;
    
    EF_sng TestX = TEST_X;
    
    EF_sng i;
    
    printf("9th Test\n");

    if( 0x0 != PrimeFactorsTableConstruction(TestX) )
    {
        printf("Table Construction failed!\n");
        exit(1);
    }
    
    TestArray = (EF_sng *) malloc(TESTLENGTH * sizeof(EF_sng));
    
    if(NULL == TestArray)
    {
        printf("Not enough memory available!\n");
        
        PrimeFactorsTableDestruction();
        exit(1);
    }
    
    
    EratosthenesFermatP(TestX, TestArray, 1);
    
    for(i = 0; i < 20; i++)
    {
        printf("%d\n", TestArray[i]);
    }
    
    free(TestArray);
    PrimeFactorsTableDestruction();
    exit(0);
}

