/* ************************************************************
   ** Database.mg                                            **
   **                                                        **
   ** Database handling for weight 1.                        **
   **                                                        **
   ** Gabor Wiese                                            **
   ** version of 01/01/2008                                  **
   **                                                        **
   ************************************************************ */

import "Structure.mg" : ModF, WholeLevel;

intrinsic WriteFile ( mf :: Rec, file :: MonStgElt : 
  Overwrite := false, noOperators := true, noCoefficients := false, noHeckeAlgebra := false)
{Appends the eigenform mf to the given file.
The options noOperators resp. noCoefficients have the obvious meaning.
Note, however, that if no operators are stored, then no new computation
can be performed.}
  m1 := rec< ModF | 
    Level             := mf`Level,
    Characteristic    := mf`Characteristic,
    FieldDegree       := mf`FieldDegree,
    Dimension         := mf`Dimension
  >;
  if assigned mf`Weight then m1`Weight := mf`Weight; end if;
  if assigned mf`Character then m1`Character := mf`Character; end if;

  if not noOperators then
    if assigned mf`F then m1`F := mf`F; end if;
    if assigned mf`BasisWt1 then m1`BasisWt1 := mf`BasisWt1; end if;
    if assigned mf`HeckeList then m1`HeckeList := mf`HeckeList; end if;
  end if;

  if not noCoefficients then
    // this is stupid! But otherwise reloading does not work.
    if assigned mf`CoefficientList then 
       m1`CoefficientList := [];
       for T in mf`CoefficientList do
         S := <T[1], MatrixAlgebra(Parent(T[2]),1)!(T[2])>;
         Append(~m1`CoefficientList,S);
       end for;
    end if;
  end if;

  if not noHeckeAlgebra then
    if assigned mf`HeckeAlgebra then m1`HeckeAlgebra := mf`HeckeAlgebra; end if;
  end if;

  s := "Append(~L," * Sprint(m1,"Magma") * ");";
  PrintFile(file, s : Overwrite := Overwrite);
end intrinsic;

