/*
********************************************
* Gorenstein.mg                            *
*                                          *
* Computes the Gorenstein defect           *
* of an Artin algebra.                     *
*                                          *
* Gabor Wiese, version of 31/12/2007       *
********************************************
*/


/* ONLY WORKS OVER FINITE FIELDS CURRENTLY!!!! */

intrinsic GorensteinDefect ( A :: RngMPolRes) -> RngIntElt
{Returns the Gorenstein defect of the local commutative algebra A, that is 
the number of module generators of the annihilator of the maximal ideal minus one.}
  return GorensteinDefect(MatrixAlgebra(A));
end intrinsic;

intrinsic GorensteinDefect ( A :: AlgAss) -> RngIntElt
{Returns the Gorenstein defect of the local commutative algebra A, that is 
the number of module generators of the annihilator of the maximal ideal minus one.}
  return GorensteinDefect(MatrixAlgebra(A));
end intrinsic;

intrinsic GorensteinDefect ( A :: AlgMat ) -> RngIntElt
{Returns the Gorenstein defect of the local commutative algebra A, that is 
the number of module generators of the annihilator of the maximal ideal minus one.}
  local m,n,an;

  if Dimension(A) eq 0 then return 0; end if;

  A := Algebra(A); // change type
  m := MaximalIdeals(A);
  error if #m ne 1, "Error. The algebra is not local!";

  an := LeftAnnihilator(A,m[1]);
  n := Dimension (A) - Dimension(m[1]);

  return ((Dimension(an)) div n) - 1;
end intrinsic;

intrinsic IsGorenstein ( M :: AlgMat ) -> BoolElt
{Tests whether the commutative local algebra M is Gorenstein.}
  return (GorensteinDefect(M) eq 0);
end intrinsic;

intrinsic IsGorenstein ( M :: RngMPolRes ) -> BoolElt
{Tests whether the commutative local algebra M is Gorenstein.}
  return (GorensteinDefect(M) eq 0);
end intrinsic;

intrinsic IsGorenstein ( M :: AlgAss ) -> BoolElt
{Tests whether the commutative local algebra M is Gorenstein.}
  return (GorensteinDefect(M) eq 0);
end intrinsic;

