// This is not the best way...


/*
********************************************
* Localisation.mg                          *
*                                          *
* Computes the localisations of a          *
* finite dimensional commutative algebra.  *
* Only works over finite fields.           *
*                                          *
* Gabor Wiese, version of 31/12/2007       *
********************************************
*/


// ---------------- associative algebra manipulations -------------------


intrinsic Localisations ( A :: AlgAss ) -> SeqEnum
{Returns a list of all localisations of the
Artin associative algebra A (assumed to be commutative).
The output is a list of associative algebras.}
  max := MaximalIdeals(A);

  if #max eq 1 then
    return [A];
  end if;

  output := [];
  for m in max do
    n := m;
    while Dimension(m*n) ne Dimension(n) do
      n := n*m;
    end while;

    Append(~output,quo<A |n>);
  end for;

  return output;
end intrinsic;

intrinsic Localisations ( L :: SeqEnum ) -> Tup, Tup
{Given a list L of commuting matrices, this function computes two
tuples C,D, where C contains a tuple consisting of the localisations
of the matrix algebra generated by L, and D consists of the
corresponding base change tuples.}
  return Localisations (MatrixAlgebra(L));
end intrinsic;

intrinsic Localisations ( A :: AlgMat ) -> Tup, Tup
{Given an Artin matrix algebra A which is assumed to be commutative,
this function computes two tuples C,D, where C contains a tuple
consisting of the localisations of A, and D consists of the
corresponding base change tuples.}
  max := MaximalIdeals(A);

  gen := SetToSequence(Generators(A));

  bctup := <>;
  alg := <>;
  for m in max do
    n := m;
    while Dimension(m*n) ne Dimension(n) do
      n := n*m;
    end while;

    bas := Basis (n);
    Vm := VectorSpace(BaseRing(A),Degree(A));
    for i := 1 to #bas do
      Vm := Vm meet Kernel(bas[i]);
    end for;

    bcmat := BaseChangeMatrices(Vm);
    Append(~bctup,bcmat);
    Append(~alg, MatrixAlgebra([BaseChange(h,bcmat) : h in gen]));
  end for;

  return alg,bctup;
end intrinsic;



