AttachSpec("PATH/ArtinAlgebras.spec");

M := CuspidalSubspace(ModularSymbols(229,2,1));
L := [HeckeOperator(M,n) : n in [1..50]];
A := MatrixAlgebra(L);
D := Decomposition(A);
#D;

A1 := BaseChange(A,D[1]);
Dimension(A1);
A2 := BaseChange(A,D[2]);
Dimension(A2);
Basis(A2);
A3 := BaseChange(A,D[3]);
Dimension(A3);

I := CompleteOrthogonalIdempotents(A);
I1 := Idempotents(D);

M := CuspidalSubspace(ModularSymbols(229,2,GF(5),1));
L := [HeckeOperator(M,n) : n in [1..50]];
A := MatrixAlgebra(L);
D := Decomposition(A);
#D;

A3 := BaseChange(A,D[3]);
Dimension(A3);
Basis(A3);

AffineAlgebraTup(A3);
AffineAlgebra(A3);
[AffineAlgebraTup(BaseChange(A,d)): d in D];

M := CuspidalSubspace(ModularSymbols(229,2,GF(2),1));
L := [HeckeOperator(M,n) : n in [1..50]];
A := MatrixAlgebra(L);
D := Decomposition(A);
[AffineAlgebraTup(BaseChange(A,d)): d in D];

[GorensteinDefect(BaseChange(A,d)): d in D];

M := CuspidalSubspace(ModularSymbols(431,2,GF(2),1));
L := [HeckeOperator(M,n) : n in [1..50]];
A := MatrixAlgebra(L);
D := Decomposition(A);
[AffineAlgebraTup(BaseChange(A,d)): d in D];
[GorensteinDefect(BaseChange(A,d)): d in D];

A1 := BaseChange(A,D[1]);
Basis(A1);
A1T := CommonLowerTriangular(A1);
Basis(A1T);

A2 := BaseChange(A,D[2]);
Basis(A2);

B2 := ChangeToResidueField(A2)[1];
Basis(B2);
