/*****************************************
 * FB_Kohnen_Basis.m                     *
 * part of                               *
 * FastBases Magma Package               *
 * Author: Gabor Wiese                   *
 * 22 April 2020                         *
 *****************************************/


intrinsic FB_Kohnen_basis (k,bound) -> Any
{Compute the Kohnen basis of the plus-space of half-integral weight k modular forms of level Gamma_0(4).}
  l := Floor(k-1/2);     // this is what is called k in Kohnen's paper: k = l+1/2
  assert ((l+1/2) eq k); // only defined for k = l + 1/2
  assert (l ge 12);      // only implemented for weights >= 25/2
  
  out_basis := [];       // write the Kohnen basis here

  // get basic modular forms
  E4 := FB_eisenstein(4,bound);
  E6 := FB_eisenstein(6,bound);

  // for speeding up computations later, compute square and cube
  E6sq := E6^2;
  E4cube := E4^3;

  // compute the maximum target integral weight, i.e. we compute the spaces of weight n and n-2.
  if IsEven(l) then
    n := l;
  else
    n := l-3;
  end if;

  // choose the forms used to get from the target integral weight space to the half integral one
  if IsEven(l) then
    amult := FB_theta(bound);
    bmult := FB_H5_2(bound);
  else
    amult := FB_H7_2(bound);
    bmult := FB_H11_2(bound);
  end if;

  Amult := E6*amult;
  Bmult := E4*bmult;

  a0 := l mod 3;
  m := (l-4*a0-6) div 6; // this is an exact division

  // compute and store the powers of E6 that will be used
  if IsEven(m) then
    currentE6 := Parent(E6)!1;
   else
    currentE6 := E6;
  end if;  

  E6_list := [currentE6];
  for a := 1 to m div 2 do
    currentE6 := currentE6 * E6sq;
    Append(~E6_list, currentE6);
  end for;  

  // this code computes a basis in weight n-6 and puts it into the half-integral weight target space via Amult and Bmult
  currentE4 := E4^a0;
  f := currentE4 * E6_list[#E6_list];
  Append(~out_basis, f*Amult);
  Append(~out_basis, f*Bmult);
  for a := 1 to m div 2 do
    currentE4 := currentE4 * E4cube;
    f := currentE4 * E6_list[#E6_list - a];
    Append(~out_basis, f*Amult);
    Append(~out_basis, f*Bmult);
  end for;

  // two special cases
  if a0 eq 2 then // this is equivalent to 6 dividing (n-2)
    Append(~out_basis,E6_list[#E6_list] * E6sq * bmult);
  end if;
  if IsOdd(m) then // this is equivalent to 4 dividing n
    Append(~out_basis,currentE4 * E4cube * amult);
  end if;

  return out_basis;
end intrinsic;

