/*****************************************
 * FB_General.m                          *
 * part of                               *
 * FastBases Magma Package               *
 * Author: Gabor Wiese                   *
 * 5 December 2019                       *
 *****************************************/



intrinsic qDerivative (f,a) -> Any
{Compute the a-th q-derivative of the power series f, where the q-derivative is q d/dq.}
  R := Parent(f);
  q := R.1;
  for i := 1 to a do
    f := q*Derivative(f);
  end for;
  return f;
end intrinsic;

intrinsic FB_binomial (n,k) -> Any
{Compute the generalised binomial coefficient where n is any number and k an integer.}
  R := Parent(n);
  c := R!1;
  for j := 1 to k do
    c := c * (n+1-j)/j;
  end for;
  return c;
end intrinsic;

intrinsic FB_vector(f,d) -> Any
{Puts the power series f into a rational vector of size d, starting with the 0th coefficient.}
  V := VectorSpace(Rationals(),d);
  L := [];
  for i := 0 to d-1 do
    Append(~L,Coefficient(f,i));
  end for;
  return V!L;
end intrinsic;

intrinsic FB_gen_vector(f,cl,d) -> Any
{Puts those coefficients of the power series f into a rational vector of size d the index of which mod 4 lies in cl, starting with the 0th coefficient.}
  V := VectorSpace(Rationals(),d);
  L := [];
  i := 0;
  repeat
    if (i mod 4) in cl then Append(~L,Coefficient(f,i)); end if;
    i := i + 1;
  until #L ge d;
  return V!L;
end intrinsic;

intrinsic FB_plus_subspace(B,k : d := -1) -> Any
{Given linearly independent modular forms of weight k in the array B, compute a basis for the Kohnen plus subspace. By default, the entire known q-expansion is used in the computation. By setting d to some positive value, d coefficients (of indices such that the corresponding coefficients in the plus-space are zero) are used.}
  if d le -1 then
    d := (Precision(Parent(B[1])) div 2)-2;
  end if;

  l := Floor(k-1/2);
  
  if IsEven(l) then
    cl := [2,3];
  else
    cl := [1,2];
  end if;
  
  L := [FB_gen_vector(f,cl,d) : f in B];
  M := Matrix(L);
  bas := Basis(Kernel(M));
  out_basis := [];
  for b in bas do
    v := Eltseq(b);
    f := v[1] * B[1];
    for i := 2 to #v do
      f := f + v[i]*B[i];
    end for;
    Append(~out_basis,f);
  end for;
  return out_basis;
end intrinsic;

intrinsic FB_subspace(B,d) -> Any
{Creates the subspace generated by the FB_vector's of the power series in B with precision d, starting with the 0th coefficient.}
  V := VectorSpace(Rationals(),d);
  L := [FB_vector(b,d) : b in B];
  return sub<V | L>;
end intrinsic;
  
