/*****************************************
 * FB_Kohnen_Basis.m                     *
 * part of                               *
 * FastBases Magma Package               *
 * Author: Gabor Wiese                   *
 * 1 June 2021                           *
 *****************************************/


intrinsic FB_Kohnen_basis (k,bound) -> Any
{Compute the Kohnen basis of the plus-space of half-integral weight k modular forms of level Gamma_0(4).}
  l := Floor(k-1/2);     // this is what is called k in Kohnen's paper: k = l+1/2
  assert ((l+1/2) eq k); // only defined for k = l + 1/2
  assert (l ge 2);       // only implemented for weights >= 5/2
  
  Kohnen_basis := [];       // write the Kohnen basis here

  // get basic modular forms
  E4 := FB_eisenstein(4,bound);
  E6 := FB_eisenstein(6,bound);

  Rq := Parent(E4); // get the power series ring
  
  // for speeding up computations later, compute square and cube
  E6sq := E6^2;
  E4cube := E4^3;

  a0 := l mod 3;

  // distinguish even and odd cases
  if IsEven(l) then
    m := (l-4*a0-6) div 6; // this is an exact division; have l-6 = 4a_0 + 6m    
    amult := FB_theta(bound);
    bmult := FB_H5_2(bound);
  else // odd case
    m := (l-4*a0-9) div 6; // this is an exact division; have l-9 = 4a_0 + 6m
    amult := FB_H7_2(bound);
    bmult := FB_H11_2(bound);
  end if;
  Amult := E6*amult;
  Bmult := E4*bmult;

  // compute a basis B of M_{l-6} or M_{l-9} in even and odd case, respectively
  B := [];
  if m ge 0 then
    // we need E_6^m, E_6^{m-2}, ... put them in a list
    if IsEven(m) then
      currentE6 := Parent(E6)!1;
    else
      currentE6 := E6;
    end if;  
    E6_list := [currentE6];
    for a := 1 to m div 2 do
      currentE6 := currentE6 * E6sq;
      Append(~E6_list, currentE6);
    end for;  

    // now compute E_4^a * E_6^b such that 4a+6b=l-6
    currentE4 := E4^a0;
    for a := 0 to (#E6_list)-1 do
      Append(~B, currentE4*E6_list[#E6_list-a]);
      if a lt (#E6_list)-1 then currentE4 := currentE4 * E4cube; end if;
    end for;
  end if;
  
  // compute the Kohnen basis now
  // first go from M_{l-6} into M_k via Amult (via M_l) and Bmult (via M_{l-2}) in even case, or from M_{l-9} into M_k via Amult and Bmult
  for b in B do
    Append(~Kohnen_basis, b*Amult);
    Append(~Kohnen_basis, b*Bmult);
  end for;

  
  
  // there are two special cases to be taken care of, corresponding to elements of M_l and M_{l-2} not obtained from M_{l-6} (even case) and similar in odd case

  // two special cases

  if a0 eq 2 then // this is equivalent to 6 dividing l-2 (even case)
    if m ge 0 then
      Append(~Kohnen_basis,E6_list[#E6_list] * E6sq * bmult);
    else
      // cases when M_{l-6} or M_{l-9} is zero
      if (l eq 2) or (l eq 5) then
        Append(~Kohnen_basis,bmult);
      else // (l eq 8) or (l eq 11)
        Append(~Kohnen_basis,E6*bmult);
      end if;
    end if;
    /*
    else
      
    end if;
      // cases when M_{l-6} or M_{l-9} is zero
      if (l eq 2) or (l eq 5) then
        Append(~Kohnen_basis,bmult);
      else // (l eq 8) or (l eq 11)
        Append(~Kohnen_basis,E6*bmult);
      end if;
*/
  end if;


  if IsOdd(m) then // this is equivalent to 4 dividing l (or l-3)
    if m ge 0 then
      Append(~Kohnen_basis,currentE4 * E4cube * amult);
    else
      // cases when M_{l-6} or M_{l-9} is zero
      if (l eq 3) then
        Append(~Kohnen_basis,amult);
      elif (l eq 4) or (l eq 7) then
        Append(~Kohnen_basis,E4*amult);
      else // (l eq 8) or (l eq 11)
        Append(~Kohnen_basis,E4*E4*amult);
      end if;
    end if;
  end if;
 
  return Kohnen_basis;
end intrinsic;

