// BigONSpaceTables.h: header
////////////////////////////////////////////////////////////////////////////////
//
//   Copyright (C) 2008   Georg S. Weber
//
//   This file is part of the Essen Modular package programs.
//
//   The Essen Modular package programs are
//   free software:
//   you can redistribute them and/or modify them
//   under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   The Essen Modular package programs are
//   distributed in the hope that they will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License along
//   with the Essen Modular package programs,
//   see the text file COPYING in this directory.
//   If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////
//
//   history / version (the version is YYYY-MM-DD of the last change)
//   2008-02-22: creation (gsw) 
//
////////////////////////////////////////////////////////////////////////////////

#ifndef BIG_O_N_SPACE_TABLES_H
#define BIG_O_N_SPACE_TABLES_H

#include "./EssenModularGlobal.h"


//functions
uint8_t BigONSpaceTablesConstruction(EF_sng N);

void BigONSpaceTablesDestruction(void);

inline EF_sng addModN(EF_sng a, EF_sng b);

inline EF_sng listOfSumsModN(EF_sng ** ptrptr_list);

inline EF_sng inverseModN(EF_sng a);

inline EF_sng listOfInversesModN(EF_sng ** ptrptr_list);

inline EF_sng listOfRepresentatives(EF_sng ** ptrptr_list);

inline EF_sng indexOfRepresentativeAndTheFactor(EF_sng u,
                                                EF_sng v,
                                                EF_sng * factor
                                               );

//inline EF_sng indexOfRepresentative(EF_sng u, EF_sng v);

inline EF_sng listOfVirtualStartMatricesLowerEntries(EF_sng e11ModN,
                                                     EF_sng detModN,
                                                     EF_sng ** ptrptr_list);

inline EF_sng retrieveK(EF_sng a, EF_sng b, EF_sng ka, EF_sng kb);

inline EF_sng negateModN(EF_sng a);

inline EF_sng listOfCoprimesAndNegatives(EF_sng xN, EF_sng ** ptrptr_list);

inline int8_t PrimeFactorizationCurrentN(EF_sng factors[][0x2]);

inline EF_sng listOfXmodN(EF_sng primesSubset, EF_sng ** ptrptr_list);

#endif //BIG_O_N_SPACE_TABLES_H

