// EratosthenesFermat.h: given int x>0, for 0<=y<x, return int y^-1 mod x, or 0
////////////////////////////////////////////////////////////////////////////////
//
//   Copyright (C) 2008   Georg S. Weber
//
//   This file is part of the Essen Modular package programs.
//
//   The Essen Modular package programs are
//   free software:
//   you can redistribute them and/or modify them
//   under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   The Essen Modular package programs are
//   distributed in the hope that they will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License along
//   with the Essen Modular package programs,
//   see the text file COPYING in this directory.
//   If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////
//
//   history / version (the version is YYYYMMDD of the last change)
//   2008-02-03: creation (gsw) 
//
////////////////////////////////////////////////////////////////////////////////

#ifndef ERATOSTHENES_FERMAT_H
#define ERATOSTHENES_FERMAT_H

#include "./EssenModularGlobal.h"

//
// function   : EratosthenesFermat
//
// param     x: integer (EF_sng), with respect to which inverses are computed
// param array: array of integers (EF_sng) of length x, which will be filled
//              ATTENTION: No buffer overflow (array length) check is done!
//                         It is the caller's responsibility to take care!!!
//              The content of array[y] after calculation will be:
//                y^{-1} mod x (between 0 and x-1)    if gcd(x,y) == 1, or
//                0                                   if gcd(x,y) > 1 
// returns    : void
//
// last change: 2008-02-03, creation (gsw)
//
void EratosthenesFermat(EF_sng x, EF_sng * array);

//
// function   : EratosthenesFermatP
//
// param     x: integer (EF_sng), with respect to which inverses are computed
// param array: array of integers (EF_sng) of length x, which will be filled
//              ATTENTION: No buffer overflow (array length) check is done!
//                         It is the caller's responsibility to take care!!!
//              The content of array[y] after calculation will be:
//               P* y^{-1} mod x (between 0 and x-1)    if gcd(x,y) == 1, or
//                  0                                   if gcd(x,y) > 1 
// param     P: a prime P such that P mod x is invertible mod x
// returns    : void
//
// last change: 2008-03-12, creation (gsw)
//
inline void EratosthenesFermatP(EF_sng x, EF_sng * array, EF_dbl P);

#endif //ERATOSTHENES_FERMAT_H

