// ApplyHeilbronnMatrices.h: header, 
////////////////////////////////////////////////////////////////////////////////
//
//   Copyright (C) 2008   Georg S. Weber
//
//   This file is part of the Essen Modular package programs.
//
//   The Essen Modular package programs are
//   free software:
//   you can redistribute them and/or modify them
//   under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   The Essen Modular package programs are
//   distributed in the hope that they will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License along
//   with the Essen Modular package programs,
//   see the text file COPYING in this directory.
//   If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////
//
//   history / version (the version is YYYY-MM-DD of the last change)
//   2008-03-05: creation (gsw) 
//
////////////////////////////////////////////////////////////////////////////////

#ifndef APPLY_HEILBRONN_MATRICES_H
#define APPLY_HEILBRONN_MATRICES_H

#include "./EssenModularGlobal.h"


//macros
#define     BASMAJI_SEQ_O_OF_NSQUARE    0x01u

//functions

//Rationale: Depending on "whichMethodForHeilbronnMatrices"
//           some of the given arrays may have zero length;
//           so we have a common interface for algorithms with
//           storage needs of O(N^2) size, or O(N) size, or even less.
//
//           On the other hand, none of the space needed shall be
//           allocated here, but rather by the caller (who knows
//           "whichMethodForHeilbronnMatrices", of course), so the
//           handling in case of memory shortage is not the business
//           of the core functions from now on, nor freeing the memory
//           afterwards etc.

inline
void ApplyHeilbronnMatrices(EF_sng N,
                            EF_sng * arrayOfSumsModN,
                            EF_sng * arrayOfInversesModN,
                            EF_sng quantityOfRepresentativesModN,
                            EF_sng * representativesModN,
                            EF_sng * arrayOfProductsModN,
                            EF_sng * lookupTableRepresentativesModN,
                            EF_sng NBound,                      //O(N) or O(N^2)
                            EF_dbl * NBoundSizeWorkingArray,
                            EF_dbl p,
                            EF_sng pBound,
                            EF_sng * pBoundSizeWorkingArray,
                            EF_sng quantityOfInputManinSymbols,
                            EF_sng * inputManinSymbols,
                            EF_dbl * outputManinSymbolsCoefficients,
                            uint8_t whichMethodForHeilbronnMatrices
                           );
//TODO: split this up into a module "init" function,
//      setting values (whose number may depend on the method to use),
//      and an explicit "start calculation" function

inline
void ApplyReducedMatrixToManinSymbols(EF_dbl coeff, //coefficient > 0
                                      EF_sng a11,   // 0 <= a11 < N
                                      EF_sng a12,   // 0 <= a12 < N
                                      EF_sng a21,   // 0 <= a21 < N
                                      EF_sng a22    // 0 <= a22 < N
                                     );


inline void ApplyBasmajiSeriesACmodNpartial2(EF_sng yModN,
                                             EF_sng indexK,
                                             EF_sng lengthModN
                                            );

inline void ApplyBasmajiSeriesBDmodNpartial2(EF_sng yModN,
                                             EF_sng indexK,
                                             EF_sng lengthModN
                                            );

inline void ApplyBasmajiSeriesACmodNfull2(EF_sng yModN, EF_dbl lengthDivN);

inline void ApplyBasmajiSeriesACBDmodNpartial3( EF_sng index,
                                                EF_sng lengthModN
                                              );


inline void ApplyNSquareSeriesToManinSymbols(EF_sng upperLeftEntry,
                                             EF_sng * lowerStartEntries
                                            );
#endif //APPLY_HEILBRONN_MATRICES_H

