// BasmajiSequencesTest.c: Test program for Basmaji Sequences generation
////////////////////////////////////////////////////////////////////////////////
//
//   Copyright (C) 2008   Georg S. Weber
//
//   This file is part of the Essen Modular package programs.
//
//   The Essen Modular package programs are
//   free software:
//   you can redistribute them and/or modify them
//   under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   The Essen Modular package programs are
//   distributed in the hope that they will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License along
//   with the Essen Modular package programs,
//   see the text file COPYING in this directory.
//   If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////
//
//   history / version (the version is YYYY-MM-DD of the last change)
//   2008-02-09: creation (gsw) 
//
////////////////////////////////////////////////////////////////////////////////


#define FIXED_ARRAY_SIZE    100

#include <math.h>

#include "./BasmajiSequences.h"


//
// function     : main
//
// param     x: 
// param array: 
//              
//              
//              
//              
//              
// returns      : we use exit()
//
// changes      : 2008-02-09, creation (gsw)
//                2008-02-10, modified (gsw)
//

int main(int argc, char * argv[])
{
    uint32_t N;                     //level (natural number > 1)
    
    uint64_t p;                     //odd prime not dividing N
        
    EF_sng TestArray[FIXED_ARRAY_SIZE];

    //start input parsing
    if( argc != 0x3)
    {
        printf("Error: Wrong number of arguments!\n");
        exit(1);
    }
    
    //first argument: the level
    N = strtol(argv[0x1], (char **)NULL, 10);
    
    if(N < 0x2)
    {
        printf("Error: The level N must be greater than 1!\n");
        exit(1);
    }
    else if( N > 65535)
    {
        printf("Error: Levels N > 65535 are currently not supported!\n");
        exit(1);
    }
    
    //second argument: the odd prime p
    p = strtoll(argv[0x2], (char **)NULL, 10);
    
    if( (p <= 0x1)
        ||
        (0x0 == p%0x2)
        ||
        (p > FIXED_ARRAY_SIZE * FIXED_ARRAY_SIZE)
      )
    {
        printf("Error: The prime p must be odd. (or p is bigger than ");
        printf("FIXED_ARRAY_SIZE --- adjust and recompile)!\n");
        //well, "9" passes, and is not prime ...
        //let's not bother about this, hoping the caller takes care
        // (below, we check for N and p to be coprime, and if they are,
        //  the algorithms run smoothly through to the end ---
        //  more precisely, the HeilbronnManin family is well-defined
        //  for any odd number m coprime to N, but we do produce the whole
        //  set only under the assumption that m itself is being a prime p,
        //  otherwise some of the matrices will be missing/omitted ...
        //  so in case "p" is odd, but not a prime, the result is garbage)
        exit(1);
    }

    
    //printf("\nTest\n");
    
    BasmajiSequencesCreation( (EF_sng)N,
                              (EF_dbl)p,
                              (EF_sng)(ceil(sqrt(p))),
                              TestArray);
    
    
    exit(0);
}

