/* ************************************************************
   **                                                        **
   ** General.mg                                             **
   **                                                        **
   ** Some general functions.                                **
   **                                                        **
   ** Gabor Wiese                                            **
   ** version of 01/01/08                                    **
   **                                                        **
   ************************************************************ */


// This function can be very much improved upon for small
// degrees by trying all irreducible small polynomials!!!!!

intrinsic FactorisationDeg ( f :: Any, deg :: RngIntElt ) -> SeqEnum
{Computes the factors of f up to degree deg. If deg is zero,
this is the usual factorisation function.}
  if deg eq 0 then
    return Factorisation(f);
  else
    return [F : F in Factorisation(f) | Degree(F[1]) le deg];
  end if;
end intrinsic;


intrinsic FactorisationFpbar ( f :: Any ) -> Any
{Factorisation of the polynomial f with coefficients in a finite field
over an algebraic closure.}
  k := CoefficientRing(f);
  F := Factorisation(f);
  L := [Degree(a[1]) : a in F];
  d := Lcm(L);
  K := ext<k | d>;
  R := PolynomialRing(K);
  return Factorisation(R!f);
end intrinsic;
