/* ************************************************************
   **                                                        **
   ** Structure.mg                                           **
   **                                                        **
   ** Structures for Hecke Algebras.                         **
   **                                                        **
   ** Gabor Wiese                                            **
   ** version of 01/01/08                                    **
   **                                                        **
   ************************************************************ */


// ******** global definitions ***********************

declare verbose HeckeAlgebra,1;

ModularFormFormat := recformat <
  Character           : GrpDrchElt,
  Weight              : RngIntElt,
  CoefficientFunction : Map, 
  ImageName           : MonStgElt, // name of the image of the Galois representation 
  Polynomial          : RngUPolElt // defining polynomial for extension
>;

AlgebraData := recformat <
  Level             : RngIntElt,
  Weight            : RngIntElt,
  Characteristic    : RngIntElt, // the characteristic of the base field
  BaseFieldDegree   : RngIntElt, // the degree of the base field for modular symbols
  CharacterOrder    : RngIntElt, // the order of the character
  CharacterConductor: RngIntElt, // the conductor of the character
  CharacterIndex    : RngIntElt, // the index in Elements(DirichletGroup())

  AlgebraFieldDegree: RngIntElt, // the degree of the base field of the algebra
  ResidueDegree     : RngIntElt, // the residue field degree of the algebra
  Dimension         : RngIntElt, // the dimension of the local algebra
  GorensteinDefect  : RngIntElt,
  EmbeddingDimension: RngIntElt,
  NilpotencyOrder   : RngIntElt,
  Relations         : Tup,

  NumberGenUsed     : RngIntElt, // number of generators used
  ImageName         : MonStgElt, // name of the image of the Galois representation
  Polynomial        : RngUPolElt // defining polynomial for extension
>;

intrinsic GetLevel (a :: Rec) -> Any
{Returns the level of a which must be a record of type AlgebraData.}
  if assigned a`Level then
    return a`Level;
  else
    return "";
  end if;
end intrinsic;

intrinsic GetWeight (a :: Rec) -> Any
{Returns the weight of a which must be a record of type AlgebraData.}
  if assigned a`Weight then
    return a`Weight;
  else
    return "";
  end if;
end intrinsic;

intrinsic GetCharacteristic (a :: Rec) -> Any
{Returns the characteristic of a which must be a record of type AlgebraData.}
  if assigned a`Characteristic then
    return a`Characteristic;
  else
    return "";
  end if;
end intrinsic;

intrinsic GetResidueDegree (a :: Rec) -> Any
{Returns the residue degree of a which must be a record of type AlgebraData.}
  if assigned a`ResidueDegree then
    return a`ResidueDegree;
  else
    return "";
  end if;
end intrinsic;

intrinsic GetDimension (a :: Rec) -> Any
{Returns the dimension of a which must be a record of type AlgebraData.}
  if assigned a`Dimension then
    return a`Dimension;
  else
    return "";
  end if;
end intrinsic;

intrinsic GetGorensteinDefect (a :: Rec) -> Any
{Returns the GorensteinDefect of a which must be a record of type AlgebraData.}
  if assigned a`GorensteinDefect then
    return a`GorensteinDefect;
  else
    return "";
  end if;
end intrinsic;

intrinsic GetEmbeddingDimension (a :: Rec) -> Any
{Returns the embedding dimension of a which must be a record of type AlgebraData.}
  if assigned a`EmbeddingDimension then
    return a`EmbeddingDimension;
  else
    return "";
  end if;
end intrinsic;

intrinsic GetNilpotencyOrder (a :: Rec) -> Any
{Returns the nilpotency order of a which must be a record of type AlgebraData.}
  if assigned a`NilpotencyOrder then
    return a`NilpotencyOrder;
  else
    return "";
  end if;
end intrinsic;

intrinsic GetNumberOperatorsUsed (a :: Rec) -> Any
{Returns the number of operators used for a which must be a record of type AlgebraData.}
  if assigned a`NumberGenUsed then
    return a`NumberGenUsed;
  else
    return "";
  end if;
end intrinsic;

intrinsic GetHeckeBound (a :: Rec) -> Any
{Returns the Hecke bound for a which must be a record of type AlgebraData.}
  if (assigned a`Weight) and (assigned a`Level) then
    return HeckeBound(a`Level, a`Weight);
  else
    return "";
  end if;
end intrinsic;

intrinsic GetPrimesUpToHeckeBound (a :: Rec) -> Any
{Returns how many primes there are up to the Hecke bound for a 
which must be a record of type AlgebraData.}
  if (assigned a`Weight) and (assigned a`Level) then
    return #PrimesUpTo(HeckeBound(a`Level, a`Weight));
  else
    return "";
  end if;
end intrinsic;

intrinsic GetPolynomial (a :: Rec) -> Any
{Returns the polynomial of a which must be a record of type AlgebraData.}
  if assigned a`Polynomial then
    return a`Polynomial;
  else
    return "";
  end if;
end intrinsic;

intrinsic GetImageName (a :: Rec) -> Any
{Returns the name of the image of a which must be a record of type AlgebraData.}
  if assigned a`ImageName then
    return "$"*a`ImageName*"$";
  else
    return "";
  end if;
end intrinsic;

