AttachSpec("~/PATH1/ArtinAlgebras.spec");
AttachSpec("~/PATH2/HeckeAlgebra.spec");

SetVerbose ("HeckeAlgebra",false);

my_file := "datafile";
CreateStorageFile(my_file);

dih  := DihedralForms(2039 : ListOfPrimes := [2], completely_split := false);
for f in dih do
    ha := HeckeAlgebras(f);
    HeckeAlgebraPrint1(ha);
    StoreData(my_file, ha);
end for;

dih1 := DihedralForms (431 : bound := 20);
for f in dih1 do
    ha := HeckeAlgebras(f);
    HeckeAlgebraPrint1(ha);
    StoreData(my_file, ha);
end for;

R<x> := PolynomialRing(Integers());
pol := x^5-x^4-780*x^3-1795*x^2+3106*x+344;
f := A5Form(pol);
print Modulus(f`Character);
ha := HeckeAlgebras(f : DegreeBound := 4);
HeckeAlgebraPrint1(ha);
StoreData(my_file, ha);
ha := HeckeAlgebras(DirichletGroup(229,GF(2)).1,2);
HeckeAlgebraPrint1(ha);
StoreData(my_file,ha);

load "datafile";
mf := RecoverData(LoadIn,LoadInRel);
HeckeAlgebraPrint(mf);

HeckeAlgebraLaTeX(mf,"table.tex");

A,B,M,C := HeckeAlgebras(DirichletGroup(253,GF(2)).1,2 : over_residue_field := true);
i := 4;
T := BaseChange(HeckeOperator(M,17),C[i]);
print Eigenvalues(T);
e := SetToSequence(Eigenvalues(T))[1][1];
A1,B1,M1,C1 := HeckeAlgebras(DirichletGroup(253,GF(2)).1,2 : over_residue_field := false);

T1 := BaseChange(HeckeOperator(M1,17),C1[i]);
print Eigenvalues(T1);
print Evaluate(MinimalPolynomial(T1),e);
