/* ************************************************************
   **                                                        **
   ** LatexOutput.mg                                         **
   **                                                        **
   ** Gabor Wiese                                            **
   ** version of 01/01/08                                    **
   **                                                        **
   ************************************************************ */

import "Structure.mg" : ModularFormFormat, AlgebraData;

intrinsic HeckeAlgebraLaTeX (ha :: SeqEnum, filename :: MonStgElt :
  which := [ <GetLevel,"Level">,
             <GetWeight,"Wt">,
             <GetResidueDegree,"ResD">,
             <GetDimension,"Dim">,
             <GetEmbeddingDimension,"EmbDim">,
             <GetNilpotencyOrder,"NilO">,
             <GetGorensteinDefect,"GorDef">,
             <GetNumberOperatorsUsed,"\\\#Ops">,
             <GetPrimesUpToHeckeBound,"\\\#(p$<$HB)">,
             <GetImageName,"Gp">
                                                    ] )
{Creates the LaTeX file filename containing a longtable consisting
of certain properties of the objects in ha
which are records of type AlgebraData. The properties to be written are
indicated by the option which that is a list consisting of tuples <f, name>.
Here f is a function
that evaluates a record of type AlgebraData to some Magma object
which is afterwards transformed into a string using Sprint.
The name will appear in the table header.}
  // print table header

  s := "";
  for l in which do s := s*"|c"; end for;
  PrintFile (filename,"\\begin{longtable}{|"*s*"||}" : Overwrite := true);
  PrintFile (filename, "\\hline");

  // print first row

  s := "";
  for i := 1 to #which do 
    s := s*which[i][2];
    if i eq #which then
      s := s*" \\\\";
    else
      s := s*" & ";
    end if;
  end for; 

  PrintFile (filename, s);
  PrintFile (filename, "\\hline\\endhead\\hline\\endfoot\\hline\\hline\\endlastfoot");

  for a in ha do
    s := "";
    for i := 1 to #which do 
      s := s*Sprint(which[i][1](a));
      if i eq #which then
        s := s*" \\\\";
      else
        s := s*" & ";
      end if;
    end for; 

    PrintFile (filename, s);
  end for;


  // print table bottom
  PrintFile (filename, "\\end{longtable}");

end intrinsic;
