/* ************************************************************
   ** EigenformsWtp.mg                                       **
   **                                                        **
   ** Gabor Wiese                                            **
   ** version of 01/01/2008                                  **
   **                                                        **
   ************************************************************ */

import "Structure.mg" : ModF, WholeLevel;

// ******** weight p eigenforms belonging to system of evs ****

intrinsic Eigenforms ( W, SoEV :: Rec ) -> SeqEnum
{Given a system of eigenvalues SoEV, computes a list of 
eigenform belonging to it in weight equal to the characteristic.}
  require Set(Names(Format(SoEV))) eq Set(Names(ModF)) : "Argument 1 must have recformat ModF.";
  p := SoEV`Characteristic;

  // we have to split according to the operator T_p
  dec := DecompositionUpToConjugation(HeckeOperator(W,SoEV,p));
  output := [];
  for d in dec do
    mf := SoEV;
    mf`Weight := p;
    deg := Degree(CoefficientRing(d[1]));
//    dim := Nrows(d[1]);
    mf`FieldDegree := deg;
    mf`Basis := BaseChange(SoEV`Basis,d);
    StoreHeckeOperators(W,~mf);
    StoreCoefficients(~mf);
    StoreHeckeAlgebra(~mf);
    dim := Dimension(mf`HeckeAlgebra);
    mf`Dimension := dim;
    Append (~output, mf);
  end for;

  return output;
end intrinsic;

intrinsic Eigenforms ( W :: Rec, L :: SeqEnum ) -> SeqEnum
{Given a list L of systems of eigenvalues SoEV, computes a list of 
eigenform belonging to it in weight equal to the characteristic.}
  output := [];
  for l in L do
    output := output cat Eigenforms(W,l);
  end for;
  return output;
end intrinsic;

intrinsic Eigenforms ( W :: Rec ) -> SeqEnum
{Given a list L of systems of eigenvalues SoEV, computes a list of 
eigenform belonging to it in weight equal to the characteristic.}
  output := [];
  for l in W`SoEVs do
    output := output cat Eigenforms(W,l);
  end for;
  return output;
end intrinsic;
