/* ************************************************************
   ** Structure.mg                                           **
   **                                                        **
   ** The structure for weight one compuations.              **
   **                                                        **
   ** Gabor Wiese                                            **
   ** version of 01/01/2008                                  **
   **                                                        **
   ************************************************************ */



// ******** global definitions ***********************

declare verbose Weight1,1;
SetVerbose ("Weight1",1);

ModF := recformat <
  Level             : RngIntElt,
  Characteristic    : RngIntElt,
  Character         : GrpDrchElt,
  FieldDegree       : RngIntElt,
  Dimension         : RngIntElt,
  Weight            : RngIntElt,
  BasisWt1          : SeqEnum,
  F                 : Mtrx,
  MS                : Any,
  Basis             : Tup,
  HeckeList         : SeqEnum,
  CoefficientList   : SeqEnum,
  HeckeAlgebra      : AlgMat
>;

WholeLevel := recformat <
  N                 : RngIntElt,
  k                 : RngIntElt,
  Character         : GrpDrchElt,
  tp                : Map,
  HeckeList         : SeqEnum,
  SoEVs             : SeqEnum
>;

// ********* access functions ********************

intrinsic  Level ( mf :: Rec ) -> RngIntElt
{Returns the level.}
  return mf`Level;
end intrinsic;

intrinsic  Characteristic ( mf :: Rec ) -> RngIntElt
{Returns the characteristic.}
  return mf`Characteristic;
end intrinsic;

intrinsic  Character ( mf :: Rec ) -> GrpDrchElt
{Returns the character.}
  return mf`Character;
end intrinsic;

intrinsic  FieldDegree ( mf :: Rec ) -> RngIntElt
{Returns the field degree.}
  return mf`FieldDegree;
end intrinsic;

intrinsic  Dimension ( mf :: Rec ) -> RngIntElt
{Returns the dimension.}
  return mf`Dimension;
end intrinsic;

intrinsic  Weight ( mf :: Rec ) -> RngIntElt
{Returns the weight.}
  return mf`Weight;
end intrinsic;


// *********** Whole level handling *****************************

intrinsic Create ( N :: RngIntElt, k :: RngIntElt ) -> Rec
{Creates a "whole level" with level N, weight k.}
  require IsPrime(k) : "Argument 2 must be prime.";
  require (N gt 0) : "Argument 1 must be greater 0.";

  WL := rec< WholeLevel |
    N := N,
    k := k
  >;

  return WL;
end intrinsic;

intrinsic Create ( eps :: GrpDrchElt, k : RngIntElt ) -> Rec
{Creates a "whole level" with Dirichlet character in weight k.}
  require IsPrime(k) : "Argument 2 must be prime.";
  require Type(Parent(Evaluate(eps,1))) in {FldFin,FldRat}:
    "Coefficient field must be either the rationals or a finite field.";
  require (Type(Parent(Evaluate(eps,1))) eq FldRat) or
          (Characteristic(Parent(Evaluate(eps,1))) eq k) :
    "The characteristic of the base field must be zero or equal to the second argument.";

  WL := rec< WholeLevel |
    N := Modulus(eps),
    k := k,
    Character := eps
  >;

  return WL;
end intrinsic;

intrinsic Create ( eps :: GrpDrchElt ) -> Rec
{Creates a "whole level" with Dirichlet character taking values in a
finite field.}
  require Type(Parent(Evaluate(eps,1))) eq FldFin:
    "Coefficient field must be a finite field.";
  k := Characteristic(Parent(Evaluate(eps,1)));

  WL := rec< WholeLevel |
    N := Modulus(eps),
    k := k,
    Character := eps
  >;

  return WL;
end intrinsic;

