!!!! MODULE characters
!!!! Description: contains characters and multipliersystems we need

      module characters
      use commonvariables
      use numtheory
      use groups
      
      implicit none
      integer, save :: CMod   
      ! character modulus (should usually be set to P)
      integer, save :: CType 
      ! which character in case there are many 
      integer,save::global_p
      real(DP),dimension(:),allocatable::dir_char
      integer,dimension(:,:),allocatable,save::kar_vec   
      logical::char_read
      integer,save::num_chars,num_even_chars
      integer,save::char_modulus,alpha_N
      real(DP),save,dimension(:),allocatable :: alphas
      complex(DP),save,dimension(:),allocatable :: cont_chars
      logical::do_eta
      logical::triv_mult=.false.
      logical::do_cont_char=.false.

      logical::char_deb=.false. 
      ! Character type, 0 is trivial character,
      ! 1 is the first dirichlet character, etc.
      public :: get_char,get_multiplier
      private:: get_char_r,get_char_c,get_multiplier_i,get_multiplier_r
     
      interface get_char
      module procedure get_char_r      
      module procedure get_char_c
      module procedure get_char_rmap
      end interface

      interface get_char_cont
      module procedure get_char_cont_r      
      module procedure get_char_cont_i
      end interface

      interface get_multiplier
      module procedure get_multiplier_i
      module procedure get_multiplier_r
      end interface

      interface multiplier
      module procedure multiplier_i
      module procedure multiplier_r
      end interface



      contains

!cccc  FRONTENDS:
!      get_multiplier(gamma,x,y)
!    
!c     function autom_j_r(gamma,x_in,y_in,k) 
!c     function multiplier(gamma)
!c     subroutine get_alphas()
!c     subroutine show_alphas()
!c     function eta_multiplier(gamma)
!c     function theta_multiplier(gamma)
!c
!c     function get_char_if(d)  !!! calls get_char_i and transforms to real
!c     subroutine get_char_i(d,char)
!c     subroutine get_char_c(d,char)
!c     subroutine get_dc(d,char,modulus) 
!c      function omega(A,B)
!c
!c
  ! multiply the multiplier v(gamma) with 
      ! exp(i*k*arg(cz+d))
      function get_multiplier_i(gamma,x_in,y_in)
      implicit none
      complex(DP)::get_multiplier_i
      real(DP),intent(in)::x_in,y_in
      integer,dimension(2,2)::gamma
      integer::a,b,c,d
      real(DP)::x,y,arg
      complex(DP)::multip,char
!      write(*,*) 'gamma_i=',gamma
      multip=dcmplx(1.0_DP,0.0_DP)
      if(triv_mult.and.(weight.ne.0.0)) then
      else
!         if(do_cont_char) then
!            call get_char_cont(gamma,char)
!         else 
            call get_char(gamma(2,2),char)
!         endif
         multip=multip*char
         if(weight.eq.0.0) then
            get_multiplier_i=multip
            return
         endif
         multip=multip*multiplier(gamma)
      endif         
      a=gamma(1,1)
      b=gamma(1,2)
      c=gamma(2,1)
      d=gamma(2,2)
      x=real(c,DP)*x_in+real(d,DP)
      y=y_in*real(c,DP)
      arg=argument(x,y)
      get_multiplier_i=multip*exp(dcmplx(0.0,weight*arg))
      end function

      function get_multiplier_r(gamma,x_in,y_in)
      implicit none
      complex(DP)::get_multiplier_r
      real(DP),intent(in)::x_in,y_in
      real(DP),dimension(2,2)::gamma
      real(DP)::a,b,c,d
      real(DP)::x,y,arg
      integer::k
      complex(DP)::multip,char
!      write(*,*) 'gamma_r=',gamma
      multip=dcmplx(1.0_DP,0.0_DP)
      char=dcmplx(1.0_DP,0.0_DP)
      if(triv_mult.and.(weight.ne.0.0)) then
!         write(*,*) 'trivial multiplier!'
      else
!         if(do_cont_char) then
!            call get_char_cont(gamma,char)
!         else
!            write(*,*) 'nontrivial multiplier!,anint(d)='anint(gamma(2,2))
            if(CType.ge.1) then
               call get_char(int(gamma(2,2)),char)
            endif
!         endif
         multip=multip*char
         if(weight.eq.0.0) then
            get_multiplier_r=multip
            return
         endif         
         !! we need integer entries here...
         if(is_int(gamma(2,1)).and.is_int(gamma(2,2))) then
!            write(*,*) 'g_r_i='anint(gamma(:,:))
            multip=multip*multiplier(int(gamma(:,:)))
         else
            write(*,*) 'Multiplier for integer entries only!!'
            write(*,*) 'floor=',floor(gamma(2,1))
            write(*,*) '|c-floor|=',abs(gamma(2,1)-ceiling(gamma(2,1)))
            write(*,*) 'ceiling=',ceiling(gamma(2,1))
            write(*,*) 'floor(d)=',floor(gamma(2,2))
            write(*,*) 'ceiling(d)=',ceiling(gamma(2,2))
            write(*,*) 'gamma=',gamma(:,:)
            stop
         endif
      endif
      a=gamma(1,1)
      b=gamma(1,2)
      c=gamma(2,1)
      d=gamma(2,2)
      x=c*x_in+d
      y=y_in*c
      arg=argument(x,y)
!      write(*,*) 'gamma=[',a,',',b,'][',c,',',d,']'
!      write(*,*) 'z=',x_in,y_in
!      write(*,*) 'cz+d=',x,y
!      write(*,*) 'arG=',arg
!      write(*,*) 'multip=',multip
      arg=arg*weight
      k=floor(arg/PI2)
      arg=arg-real(k,DP)*PI2
      get_multiplier_r=multip*exp(dcmplx(0.0,arg))
      end function

 
      !!! The automorphic factor j(A,z)^k=exp(i*Arg(cz+d)*k)
!!! For a holomorphic function j(A,z)^k=(det(A))^k*(cz+d)^k
!!! But we really look at f=y^k*F  and f has the usual automorphy factor
      !!! A is a real-matrix
      function autom_j_r(gamma,x_in,y_in,k) 
      implicit none
      real(DP),dimension(2,2)::gamma
      real(DP)::x_in,y_in,a,b,c,d,x,y,arg
      real(DP)::k,det
      complex(DP)::autom_j_r
!      if(.not.(PRESENT(k))) then
!         k=weight
!      endif
      a=gamma(1,1)
      b=gamma(1,2)
      c=gamma(2,1)
      d=gamma(2,2)
      !! If the matrix is not in SL we could make it so...
      !! (but it is of course not really neccessary if we just use the argument...)
      x=c*x_in+d
      y=y_in*c     
!      if(holomorphic) then 
!         det=a*d-b*c
!         if(det.ne.1.0_DP) then
!            write(*,*) 'det',det
!            stop
!         endif
!  !       c=c/sqrt(det)
!  !       d=d/sqrt(det)
!         autom_j_r=(dcmplx(det,0.0_DP)*dcmplx(x,y))**dcmplx(k,0.0_DP)      
!      else
      arg=argument(x,y)
      autom_j_r=exp(dcmplx(0.0,k*arg))
      
      end function


      function multiplier_r(gamma)
      implicit none
      real(DP),dimension(2,2)::gamma
      real(DP)::a,b,c,d
      complex(DP)::multiplier_r
      a=gamma(1,1); b=gamma(1,2); c=gamma(2,1); d=gamma(2,2)
      if((triv_mult.or.(weight.eq.0.0)).and.(CType.eq.0)) then 
         multiplier_r=1.0_DP
      elseif(is_int(a).and.is_int(b).and.is_int(c).and.(is_int(d)))      &
     &        then
         multiplier_r=multiplier_i(int(gamma(:,:)))
      else
         write(*,*) 'ERROR: Non-triv multiplier only for integer mats!'
         write(*,*) 'gamma=',gamma(:,:)
         stop
      endif
      end function
         

      function multiplier_i(gamma)
      use groups
      implicit none
      integer::a,b,c,d
      integer,dimension(2,2)::gamma
      complex(DP)::multiplier_i,char
      if((weight.eq.0.0).or.(triv_mult)) then
         multiplier_i=dcmplx(1.0_DP,0.0_DP)
      elseif((MOD(Level,4).ne.0).or.(do_eta)) then
         multiplier_i=eta_multiplier(gamma)
      else
         multiplier_i=theta_multiplier(gamma)
      endif
      if((CType.ge.1)) then
!         if(do_cont_char) then
!            call get_char_cont(gamma,char)
!         else
            call get_char(gamma(2,2),char)            
!         endif
         if(char.eq.0.0) then
            write(*,*) 'char(',gamma,')=0'
            call show_characters(CType)
            stop
            return

         endif
         multiplier_i=multiplier_i*char
      endif

      end function



      !! compute the alpha_j=1/2pi*arg(v(S_j))
      subroutine get_alphas()
      use groups
      implicit none
      integer::j,k
      complex(DP)::mul_tmp
      integer,dimension(2,2)::B
      if(allocated(alphas)) then
         deallocate(alphas)
      endif
      allocate(alphas(1:real_num_cusps))
!      write(*,*) 'In get_alphas!'
      do j=1,real_num_cusps
!deb         write(*,*) 'S_(',j,')=',cusp_fixer(j,:,:)
         mul_tmp=multiplier(cusp_fixer(j,:,:))
         alphas(j)=argument(real(mul_tmp,DP),dimag(mul_tmp))/PI2
         !!! we use the positive value of alpha
         if(alphas(j).lt.0) then
            k=ceiling(-alphas(j))
            alphas(j)=alphas(j)+real(k,DP)
         elseif(alphas(j).ge.1) then
            k=dnint(alphas(j))
            alphas(j)=alphas(j)-real(k,DP)
         endif
!deb         write(*,*) 'v(',cusp_fixer(j,:,:),')=',mul_tmp
      enddo
      alpha_N=Level
      end subroutine

      !! print all the alphas
      subroutine show_alphas()
      use groups
      implicit none
      integer::j
      complex(DP)::mul_tmp
      integer,dimension(2,2)::B
      if((.not.(allocated(alphas))).or.(Level.ne.alpha_N)) then
         call get_alphas()
      endif
      do j=1,real_num_cusps
         write(*,*) 'shift at cusp',j,'=',alphas(j)
      enddo
      end subroutine

      subroutine show_characters(c_type)
      implicit none
      integer,optional::c_type
      integer::i,j,k,ctyp_old
      complex(DP)::char,char1,char2
      logical::are_mod

      if(CMod.eq.0) then
         CMod=Level         
      endif
      if(Cmod.eq.0) then
         write(*,*) 'Error: must have a modulus for the character1'
         stop
      endif
      IF(Ctype.eq.1) then !! Quadratic residue symbol
         num_chars=1
      elseif(.not.(char_read)) then
         call read_char()
      endif
      if(num_chars.eq.1) then
         call get_char(1,char)  ! set everything
      endif
!      if(triv_mult) then 
!         write(*,*) 'Note: The trivial multiplier/character is used!'
!      endif
      ctyp_old=CType
      do i=1,num_chars
         if(PRESENT(c_type).and.(i.ne.c_type)) then
            cycle
         endif
         Ctype=i
         write(*,'(A)',ADVANCE='NO') 'chi('
         write(*,'(I3)',ADVANCE='NO') i
         write(*,'(A)',ADVANCE='NO') ')=['
!         write(*,'(A)',ADVANCE='NO') i
         do j=1,Cmod 
            call get_char(j,char)
            call show_exp(char)
            write(*,'(A)',ADVANCE='NO') ' '
         enddo
         write(*,'(A)',ADVANCE='NO') ']'
         write(*,*)
         !!! try to locate any modulus < CMod
         do j=2,Cmod-1
            if(MOD(Cmod,j).eq.0) then
               are_mod=.true.
               do k=1,Cmod
                  call get_char(k,char1)
                  call get_char(k+j,char2)
                  if(abs(char1-char2).gt.1E-14) then
                     are_mod=.false.
                     exit
                  endif
               enddo
               if(are_mod) then
                  write(*,'(A)',ADVANCE='NO') 'MOD '
                  write(*,'(I2)',ADVANCE='NO') j
                  write(*,*)
                  exit
               endif
            endif
            
         enddo                  
      enddo
      CType=ctyp_old
      end subroutine
      
      subroutine show_exp(char)
      implicit none
      complex(DP)::char
      real(DP)::c_r,c_i,eps
      integer::j
      eps=1.0E-14
      if(abs(char-dcmplx(1.0_DP,0.0_DP)).lt.eps) then
         write(*,'(A)',ADVANCE='NO') '1'
      elseif(abs(char-dcmplx(-1.0_DP,0.0_DP)).lt.eps) then
         write(*,'(A)',ADVANCE='NO') '-1'         
      elseif(abs(char).lt.eps) then
         write(*,'(A)',ADVANCE='NO') '0'         
      elseif(abs(char-dcmplx(0.0_DP,1.0_DP)).lt.eps) then
         write(*,'(A)',ADVANCE='NO') 'i'         
      elseif(abs(char-dcmplx(0.0_DP,-1.0_DP)).lt.eps) then
         write(*,'(A)',ADVANCE='NO') '-i'         
      else !!! else it is exp(2*Pi*i*j/num_chars) for some j
         c_r=imag(log(char))
         j=nint(c_r*real(num_chars,DP)/PI2)
         if(j.eq.0) then
            write(*,'(A)',ADVANCE='NO') '1'
         else
            write(*,'(A)',ADVANCE='NO') 'e('
            if((j.gt.99).or.(j.lt.0))  then
               write(*,'(I3)',ADVANCE='NO') j
            else
               write(*,'(I2)',ADVANCE='NO') j
            endif
            write(*,'(A)',ADVANCE='NO') '/'
            if(num_chars.gt.99) then
               write(*,'(I3)',ADVANCE='NO') num_chars
            else
               write(*,'(I2)',ADVANCE='NO') num_chars
            endif
               write(*,'(A)',ADVANCE='NO') ')'
         endif
                  
      endif
      end subroutine


      !! eta-multiplier v(gamma)
      function eta_multiplier(gamma)
      implicit none
      integer::a,b,c,d
      integer,dimension(2,2)::gamma
      complex(DP)::exponent
      real(DP)::arg
      complex(DP)::eta_multiplier
      a=gamma(1,1)
      b=gamma(1,2)
      c=gamma(2,1)
      d=gamma(2,2)
      if(c.eq.0) then
         if(a.eq.1) then        ! want a=d=1, and we know ad=1, otherwise look at -gamma instead
            arg=real(b,DP)/12.0_DP
         else ! switch matrix to -gamma
            arg=-0.5_DP-real(b,DP)/12.0_DP
         endif
      elseif(c.gt.0) then
!         arg=real(a+d-3*c,DP)/real(12*c,DP)-dedekind_sum(d,c)
         arg=-0.25_DP+(real(a,DP)+real(d,DP))/(12.0_DP*real(c,DP))-       &
     &        dedekind_sum(d,c)
!         write(*,*) 'ded(',d,',',c,')=',dedekind_sum(d,c)
      else
         arg=0.25_DP+real(a+d,DP)/real(12*c,DP)-dedekind_sum(-d,-c)
      endif
      exponent=dcmplx(0.0_DP,PI2*weight*arg)
      eta_multiplier=exp(exponent)
      end function

      function theta_multiplier(gamma)
      implicit none
      integer::a,b,c,d
      integer,dimension(2,2)::gamma
      integer::modul,j
      complex(DP)::eps_bar
      real(DP)::arg,arg1,arg2
      complex(DP)::theta_multiplier
      a=gamma(1,1)
      b=gamma(1,2)
      c=gamma(2,1)
      d=gamma(2,2)
      modul=mod(d,4)
      select case(modul)
      case(1,-3)
         eps_bar=dcmplx(1.0_DP,0)
      case(-1,3)
         eps_bar=dcmplx(0,-1.0_DP)
      case default
            write(*,*) 'd mod 4 /=0 since Level mod 4 = 0!!, d=',d
            write(*,*) 'a,b,c=',a,b,c
            write(*,*) 'modul=',modul
            stop
      end select
  !    write(*,*) 'eps_bar=',eps_bar
  !    write(*,*) 'kron(',c,',',d,')=',kronecker(c,d)
   !   theta_multiplier=1.0_DP   !abs(eps_bar*kronecker(c,d))
      if(real(eps_bar,DP).eq.1.0_DP) then         
         arg1=0.0_DP
         if(kronecker(c,d).lt.0) then ! it is -1 so have to let arg=Pi
            arg2=Pi
            arg=weight*2.0_DP*Pi !2.0_DP*weight*(arg1+arg2)=weight*2Pi=0Pi
         else
            arg2=0.0_DP
            arg=0.0_DP
         endif         
      else                      !it is -i
         arg1=-1.0_DP*Pihalf
         if(kronecker(c,d).lt.0) then ! it is -1 so have to let arg=Pi
              arg=Pi*weight              !!2*( -Pi/2+Pi)=2*(Pi/2)=Pi
         else
            arg2=0.0_DP
            arg=-1.0_DP*Pi*weight      ! 2*(-Pi/2+0)=-Pi 
         endif                  
      endif
      theta_multiplier=exp(dcmplx(0.0_DP,arg))
      end function

!c$$$      function get_char_if(d)
!c$$$      implicit none
!c$$$      integer :: d,get_char_if
!c$$$      real(DP)::char
!c$$$      complex(DP)::char_c
!c$$$      if(is_prime(Level).and.(MOD(4,1).eq.1)) then
!c$$$         call get_char_i(d,char)
!c$$$         get_char_ifanint(char)     
!c$$$      else
!c$$$         call get_char_c(d,char_c)
!c$$$         get_char_ifanint(real(char_c,DP))              
!c$$$      endif
!c$$$      end function

      ! get character chi(d) of an integer d
      subroutine get_char_r(d,char)
      implicit none
      integer :: M,j,modul,d
      integer :: maximum,minimum,rest
      real(kind=DP) :: char1,char2,char,char5,char13
      complex(DP)::char_c
      integer::sgd,n
      ! If we use principal character
!      write(*,*) 'In get_char_r!'
      if(char_deb) then 
         write(*,*) 'In get_char_r!'
      endif
      if(CMod<=0) then
         CMod=Level
      endif
      if(.not.(is_prime(CMod))) then
         call gcd(d,cmod,sgd,m,n)
         if(sgd.ne.1) then
            char=0.0_DP
            return
         endif
      elseif(mod(d,Cmod).eq.0) then
         char=0.0_DP
         return
      endif
         
      !! char nr. 1 is always trivial 
      if(CType.lt.1) then
         char=1.0_DP
         return
      elseif(CType.eq.1) then
         if(MOD(Cmod,4).eq.1) then
            call get_dc(d,char)
            return
         elseif(MOD(Cmod,4).eq.0) then
            rest=Cmod/4
            if(is_prime(rest).and.(MOD(rest,4).eq.1)) then
               call get_dc(d,char1,rest) !! this is an even character
               call get_dc(d,char2,4) !! and this too
               char=char1*char2
               return
            elseif(is_prime(rest).and.(MOD(rest,4).eq.3)) then
               call get_dc(d,char1,rest) !! this is an odd character
            !! and this too
               if((mod(d,4).eq.1).or.(mod(d,4).eq.-3))then 
                  char2=1.0_DP
               else
                  char2=-1.0_DP
               endif
               char=char1*char2
               return
            endif
         endif
      endif
      !! we have to go to the complex character
      call get_char_c(d,char_c)
      char1=real(char_c)
                                !! If the character is not real we have to stop
      if(abs(dcmplx(char1,0.0)-char_c).gt.1E-14) then
         write(*,*) 'ERROR: character is not real!'
         write(*,*) 'char_c=',char_c
         stop
      endif
      char=char1
      end subroutine get_char_r

      subroutine get_char_rmap(r,char)
      implicit none
      real(DP)::r
      complex(DP)::char
      if(is_int(r)) then
         call get_char(int(r),char)
      else
         write(*,*) 'char called with real argument! =',r
      endif
      end subroutine



      ! complex characters
      subroutine get_char_c(d,char)
      implicit none
      integer :: modul,d
!      integer,dimension(2,2),optional::gamma
      real(DP)::char_r
      complex(kind=DP) :: char,chai,c_ett
      integer::sgd,m,n
!      call show_characters(CType)
!      stop
      c_ett=dcmplx(1.0_DP,0.0_DP)
      !! character nr. 1 is always trivial
      if(Cmod.eq.0) then
         Cmod=Level
      elseif(cmod.ne.Level) then 
         cmod=Level
      endif
!      write(*,*) 'Cmopd=',Cmod
      if(.not.(is_prime(CMod))) then
         call gcd(d,cmod,sgd,m,n)
         if(sgd.ne.1) then
            char=0.0_DP
            return
         endif
      elseif(mod(d,Cmod).eq.0) then
         char=0.0_DP
         return
      endif
      if(CType.lt.1) then
         char=c_ett
         return
      endif
      if(CType.eq.1) then
         call get_dc(d,char_r,Cmod) 
         char=dcmplx(char_r,0.0D0)
         return
      endif

      !! remember that a CType=1 means the real Kronecker-Jacobi symbol if it exists here
      !! otherwise it means the trivial character

      !! This should not be the case if there exists a file with characters!

!      if(CType.eq.1) then
!         if(is_prime(Cmod).and.(MOD(CMod,4).eq.1)) then
!            call get_char_r(d,char_r)
!            char=dcmplx(char_r)
!         else
!            char=c_ett
!         endif
!         return
!      endif
      if(char_read) then
          !! If we have managed to change index and not reread the character
         char=get_read_char(d)
      else
         call read_char() 
         char=get_read_char(d)
      endif
      end subroutine

      !! This gives the default quadratic residue symbol 
      !! mod P, where P==1 (mod 4)
      subroutine get_dc(d,char,modulus) 
      implicit none
      real(DP)::char
      integer,optional::modulus
      integer::d,modul,N,k,j
      if(PRESENT(modulus)) then
         N=modulus
      elseif(CMod.gt.0) then
         N=Cmod
      elseif(Level.gt.0) then
         N=Level
      else
         write(*,*) 'ERROR: no modulus!'
      endif
      modul=mod(d,N)
      if(allocated(dir_char)) then
         if(size(dir_char,1).eq.(2*N-2)) then
            char=dir_char(modul)
            return
         else
            deallocate(dir_char)
         endif
      endif
      allocate(dir_char(1-N:N-1))
      dir_char(0)=0.0_DP
      do k=1,N-1
         dir_char(k)=-1.0_DP
      enddo
      do k=1,N-1
         j=mod(k*k,N)
         dir_char(j)=1.0_DP
      enddo
                                ! We use an even character
      do k=-N+1,-1
         dir_char(k)=dir_char(-k)
      enddo
      char=dir_char(modul)
      end subroutine




      
      function omega(A,B)
      implicit none 
      integer,dimension(2,2)::A,B,C
      complex(DP)::tmp1,tmp2,tmp3,Bi,omega
      real(DP)::arg,arg1,arg2,arg3
      if(weight.eq.0.0) then
         omega=dcmplx(1.0_DP,0.0_DP)
         return
      endif
      C=MATMUL(A,B)
      !! z=i
      !! j_B(i)=ai+b
!c$$$      tmp1=dcmplx(B(2,2),B(2,1))
!c$$$      !! Bi=(ai+b)/(ci+d)
!c$$$      Bi=dcmplx(B(1,2),B(1,1))/dcmplx(B(2,2),B(2,1))
!c$$$      !! j_A(Bi)        
!c$$$      tmp2=dcmplx(A(2,1),0.0_DP)*Bi+dcmplx(A(2,2),0.0_DP) 
!c$$$      !! j_AB(i)=j_C(i)
!c$$$      tmp3=dcmplx(C(2,2),C(2,1))
!c$$$      arg1=argument(real(tmp1,DP),dimag(tmp1))
!c$$$      arg2=argument(real(tmp2,DP),dimag(tmp2))
!c$$$      arg3=argument(real(tmp3,DP),dimag(tmp3))
!c$$$      arg=arg1+arg2-arg3
      !!!! Rankin formula (3.2.5)
      arg1=argument(real(A(2,2),DP),real(A(2,1),DP))
      arg2=argument(real(B(1,1),DP),real(B(2,1),DP))
      arg3=argument(real(A(2,2)*B(1,1)-A(2,1)*B(2,1),DP),                                 &
     &     real(A(2,1)*B(1,1)+A(2,2)*B(2,1),DP))
      arg=arg1+arg2-arg3
!c$$$      write(*,*) 'Bi=',Bi
!c$$$      write(*,*) 'om_arg1=',arg1
!c$$$      write(*,*) 'om_arg2=',arg2
!c$$$      write(*,*) 'om_arg3=',arg3
!c$$$      write(*,*) 'arg=',arg
      omega=exp(dcmplx(0.0_DP,weight*arg))
!      omega=(tmp1**dcmplx(weight,0.0_DP))*(tmp2**dcmplx(weight,0.0_DP))/         &
!     &     (tmp3**dcmplx(weight,0.0_DP))
      end function


      function omega_re(A,B)
      implicit none 
      real(DP),dimension(2,2)::A,B,C
      complex(DP)::tmp1,tmp2,tmp3,Bi,omega_re
      real(DP)::arg,arg1,arg2,arg3
      if(weight.eq.0.0) then
         omega_re=dcmplx(1.0_DP,0.0_DP)
         return
      endif
      C=MATMUL(A,B)
      !! z=i
      !! j_B(i)=ai+b
      !!!! Rankin formula (3.2.5)
      arg1=argument(A(2,2),A(2,1))
      arg2=argument(B(1,1),B(2,1))
      arg3=argument(A(2,2)*B(1,1)-A(2,1)*B(2,1),                                 &
     &     A(2,1)*B(1,1)+A(2,2)*B(2,1))
      arg=arg1+arg2-arg3
      omega_re=exp(dcmplx(0.0_DP,weight*arg))
      end function


      subroutine kar_19(d,char,c_typ)
      implicit none
      integer,dimension(1:18,1:19)::kar
      integer,optional::c_typ
      integer::d,chi_j,modul,num_ch
      complex(DP)::char
      if(.not.(PRESENT(c_typ))) then
         c_typ=Cmod
      endif
      if(C_typ.eq.0) then
         C_typ=1
      endif
      num_ch=18
      kar(1,:)=(/0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   &
     & 0/)
      kar(2,:)=(/0, 1, 13, 2, 16, 14, 6, 3, 8, 17, 12, 15, 5, 7, 11, 4,  &
     & 10, 9, 0/)
      kar(3,:)=(/0, 2, 8, 4, 14, 10, 12, 6, 16, 16, 6, 12, 10, 14, 4, 8, &
     & 2, 0, 0/)
      kar(4,:)=(/0, 3, 3, 6, 12, 6, 0, 9, 6, 15, 0, 9, 15, 3, 15, 12,    &
     & 12, 9, 0/)
      kar(5,:)=(/0, 4, 16, 8, 10, 2, 6, 12, 14, 14, 12, 6, 2, 10, 8, 16, &
     & 4, 0, 0/)
      kar(6,:)=(/0, 5, 11, 10, 8, 16, 12, 15, 4, 13, 6, 3, 7, 17, 1, 2, &
     & 14, 9, 0/)
      kar(7,:)=(/0, 6, 6, 12, 6, 12, 0, 0, 12, 12, 0, 0, 12, 6, 12, 6,  &
     & 6, 0, 0/)
      kar(8,:)=(/0, 7, 1, 14, 4, 8, 6, 3, 2, 11, 12, 15, 17, 13, 5, 10, &
     & 16, 9, 0/)
      kar(9,:)=(/0, 8, 14, 16, 2, 4, 12, 6, 10, 10, 6, 12, 4, 2, 16, 14, &
     & 8, 0, 0/)
      kar(10,:)=(/0, 9, 9, 0, 0, 0, 0, 9, 0, 9, 0, 9, 9, 9, 9, 0, 0, 9, &
     &     0/)
      kar(11,:)=(/0, 10, 4, 2, 16, 14, 6, 12, 8, 8, 12, 6, 14, 16, 2, 4, &
     &     10, 0, 0/)
      kar(12,:)=(/0, 11, 17, 4, 14, 10, 12, 15, 16, 7, 6, 3, 1, 5, 13,   &
     &     8, 2, 9, 0/)
      kar(13,:)=(/0, 12, 12, 6, 12, 6, 0, 0, 6, 6, 0, 0, 6, 12, 6, 12,    &
     &     12, 0, 0/)
      kar(14,:)=(/0, 13, 7, 8, 10, 2, 6, 3, 14, 5, 12, 15, 11, 1, 17,   &
     &     16, 4, 9, 0/)
      kar(15,:)=(/0, 14, 2, 10, 8, 16, 12, 6, 4, 4, 6, 12, 16, 8, 10, 2,&
     &     14, 0, 0/)
      kar(16,:)=(/0, 15, 15, 12, 6, 12, 0, 9, 12, 3, 0, 9, 3, 15, 3, 6, &
     &     6, 9, 0/)
      kar(17,:)=(/0, 16, 10, 14, 4, 8, 6, 12, 2, 2, 12, 6, 8, 4, 14, 10,&
     &     16, 0, 0/)
      kar(18,:)=(/0, 17, 5, 16, 2, 4, 12, 15, 10, 1, 6, 3, 13, 11, 7,   &
     &     14, 8, 9, 0/)
      modul=MOD(d,19)
      if(modul.le.0) then
         modul=modul+19
      endif
      chi_j=kar(c_typ,modul)
      char=exp(dcmplx(0.0_DP,PI2*real(chi_j,DP)/real(num_ch,DP)))
      end subroutine


      subroutine read_char()
      implicit none
      complex(DP)::char
      character(100)::curdir,tmpdir
      character(20)::FILENAME
      integer::i,j
      logical::I_exist
      if((Cmod.eq.0).and.(Level.eq.0)) then
         write(*,*) 'The group or modulus must be inited first!'
         stop
      endif

      if(CMod.ne.0) then
         if(Cmod.ne.Level) then 
            char_read=.false.
         endif
      else
         char_modulus=Level
      endif      
      if(char_read.and.((char_modulus.eq.cmod).or.                      &
     &     (char_modulus.eq.Level))) then
         return
      endif

      char_modulus=Level
      Cmod=Level
      num_chars=0
      FILENAME='chars_'// integer_to_char(char_modulus)
      !! We read this from the default input directory
      call GETCWD(curdir)
      write(*,*) 'currdir=',curdir
#ifdef indatadir
      call CHDIR('indatadir')
#endif
      call GETCWD(tmpdir)
      write(*,*) 'currdir=',tmpdir
      inquire(FILE=FILENAME,EXIST=I_EXIST)
      if(i_exist) then
         open(unit=12,FILE=FILENAME)
         read(12,*,END=832)
         read(12,*,END=832) num_chars
         if(num_chars.ne.(EulerPhi(char_modulus))) then
            write(*,*) 'num_chars=',num_chars
            write(*,*) 'EulerPhi(',char_modulus,')=',                     &
     &           EulerPhi(char_modulus)
            stop
         endif
         if(allocated(kar_vec)) then
            deallocate(kar_vec)
         endif
         allocate(kar_vec(1:num_chars,1:char_modulus))
         do i=1,num_chars
            read(12,*,END=832) 
            do j=1,char_modulus
               read(12,*,END=832) kar_vec(i,j)
            enddo
         enddo
 832     continue
         if(num_chars.eq.0) then
            write(*,*) 'Could not read any chars!'
            write(*,*) 'Using only the trivial character!'
            num_chars=1
            allocate(kar_vec(1,1:char_modulus))
            kar_vec(1,1:char_modulus)=0
         endif
         close(12)
         call CHDIR(CURDIR)
         char_read=.true.
      !! All characters should now be read
      !! see how many even characters there are
         num_even_chars=0
         do i=1,num_chars
            if(kar_vec(i,(char_modulus-1)).eq.0) then
               num_even_chars=num_even_chars+1
            endif
         enddo
         write(*,*) 'Read characters from ',FILENAME
      else
         write(*,*) 'Could not read characters from ',FILENAME
         if(CType.gt.1) then
            stop
         endif
      endif
      
!      call show_characters(CType)
      end subroutine


      function get_read_char(d,c_typ_in)
      integer,optional::c_typ_in
      integer::d,chi_j,modul,num_ch,c_typ,k
      complex(DP)::char,get_read_char
      real(DP)::char_r
      character(20)::FILENAME
      logical::I_exist
      if(char_deb) then 
         write(*,*) 'In get_read_char!'
      endif
      if(.not.(PRESENT(c_typ_in))) then
         c_typ=Ctype
      else
         c_typ=c_typ_in
      endif
      if(Cmod.le.0) then
         CMod=Level
      endif
      
      if(.not.(char_read)) then
         FILENAME='chars_'// integer_to_char(char_modulus)
         inquire(FILE=FILENAME,EXIST=I_EXIST)
         if(i_exist) then
            call read_char()
         else
            write(*,*) 'Character file does not exist! '
            write(*,*) 'Fall back to standard real character!'
            call get_char_r(d,char_r)
            get_read_char=dcmplx(char_r,0) 
            return
         endif
      endif
      if(char_modulus.ne.CMod) then
         call read_char() 
      endif
      modul=MOD(d,CMod)
!      write(*,*) 'cmod,d,modul=',Cmod,d,modul
      if(modul.lt.0) then
         modul=modul+CMod
      elseif(modul.eq.0) then
         get_read_char=dcmplx(0,0) 
         return
      endif
      chi_j=kar_vec(c_typ,modul)
      k=MOD(chi_j,num_chars)
      if(k.eq.0) then
         char=dcmplx(1.0_DP,0.0_DP) 
      elseif(num_chars.eq.2*abs(k)) then
         char=dcmplx(-1.0_DP,0.0_DP) 
      elseif(num_chars.eq.4*k) then
         char=dcmplx(0.0_DP,1.0_DP)
      elseif(num_chars.eq.-4*k) then
         char=dcmplx(0.0_DP,-1.0_DP)
      else
         char=exp(dcmplx(0.0_DP,PI2*real(chi_j,DP)/real(num_chars,DP)))
      endif
      get_read_char=char
!      write(*,*) 'kar_vec(',modul,')=',chi_j,' char=',char
      end function 


      subroutine get_char_cont_r(map_tmp,char_r)
      real(DP)::map_tmp(2,2)
      complex(DP)::char_r
      write(*,*) 'Not implemented!'
      stop
      end subroutine

      subroutine get_char_cont_i(map_tmp,char_r)
      integer::map_tmp(2,2)
      complex(DP)::char_r
      write(*,*) 'Not implemented!'
      stop
      end subroutine

   ! This produces a list of symmetry combinations
      ! for all cusps, with +-1 for the normalized and
      ! 0 for the rest
      subroutine Get_cusp_combinations()
      use commonvariables
      implicit none      
      integer :: tmp,i,j,num_normal,ex,n_norm
      real(DP),dimension(:),allocatable::e
      real(kind=DP)::tmp2
      if(num_cusps.eq.1) then 
         num_norm_cusp_combs=1
      else
         call get_alphas()
         n_norm=0
         do i=1,num_cusps
            if((alphas(i).eq.0.0).and.(sigma_j_in_normalizer(i).eq.1))      &
     &           then
               n_norm=n_norm+1
            endif
         enddo
         if(n_norm.ge.1) then
            num_norm_cusp_combs=2**(n_norm-1)+1 ! Added the 0 comb
         else
            num_norm_cusp_combs=2 !!! since I use to go from 1<=j<=num_norm_cusp_combs-1
         endif
      endif
                                ! useful for oldforms
      ! and a vector of the said combinations
      if(allocated(norm_cusp_combs)) deallocate(norm_cusp_combs)
      allocate(norm_cusp_combs(1:num_norm_cusp_combs,                   &
     &     1:real_num_cusps))
      allocate(e(1:real_num_cusps))
      do i=1,real_num_cusps
         e(i)=1.0_DP
      enddo
      norm_cusp_combs(:,:)=0.0_DP
      do i=1,num_norm_cusp_combs-1
         e(1)=1.0_DP
         num_normal=0
         do j=2,real_num_cusps 
            if((sigma_j_in_normalizer(j).gt.0).and.(alphas(j).eq.0.0))   &
     &           then
               num_normal=num_normal+1
               tmp=2**(n_norm-1-num_normal)                     
               ex=floor((i-1)/real(tmp,DP))
               e(j)=(-1.0_DP)**ex                     
            else
               e(j)=0.0_DP
            endif
         enddo
         norm_cusp_combs(i,:)=e(:)
      enddo
!      do i=1,num_norm_cusp_combs
!         write(*,*) 'Comb ',i,'=',norm_cusp_combs(i,:)
!      enddo
      ! I add a completely 0 combination at last
      if(real_num_cusps.gt.1) then
         norm_cusp_combs(num_norm_cusp_combs,:)=0.0_DP
         norm_cusp_combs(num_norm_cusp_combs,1)=1.0_DP
      else
         norm_cusp_combs(num_norm_cusp_combs,1)=1.0_DP
      endif
      end subroutine get_cusp_combinations

      subroutine clean_characters()
      if(allocated(alphas)) deallocate(alphas)
      if(allocated(dir_char)) deallocate(dir_char)
      if(allocated(kar_vec)) deallocate(kar_vec)   
      if(allocated(cont_chars)) deallocate(cont_chars)
      end subroutine clean_characters
      


      end module characters
