!!! MODULE: numtheory



      module numtheory
      use commonvariables
      integer,parameter,private::maxit=10000

      !! Aliases
      interface is_sq_free
      module procedure is_square_free
      end interface is_sq_free
      interface is_square_modN
      module procedure is_sq_modN
      end interface is_square_modN



      contains
      !! Calculate gcd(a,b) 
      !! m and n are s.t. am+bn=gcd(a,b)
      subroutine gcd(a,b,sgd,m,n)
      implicit none
      ! the integers to compute sgd for
      integer,intent(in) :: a,b
      ! the sgd and numbers n0,m0 s.t. a*m0+b*n0=sgd
      integer,intent(out) :: sgd
!      integer::m,n
      integer,intent(out)::m,n
      integer :: a0,b0,r0,a1,b1,r1,m0,n0,m1,n1,m2,n2,q1
      integer :: safety
      logical :: switched

      a0=max(abs(a),abs(b))
      a1=min(abs(a),abs(b))
      m0=1
      n0=0
      m1=0
      n1=1
      if(a1.eq.0) then
         if(a.eq.0) then
            sgd=b
            m=0
            n=1
         else
            sgd=a
            m=1
            n=0
         endif
         return
      endif
      if(a0.ne.abs(a)) then !if we cwitched places we have to switch back later
         switched=.true.
      else
         switched=.false.
      endif
      ! Euclidean algorithm
      do safety=1,maxit ! I don't want infinite loops 
         r1=mod(a0,a1)
         q1=(a0-r1)/a1   !this should be an integer
         
         if(r1.eq.0) then
            if(safety.eq.1) then ! e.g. the first step has to be handled with care
               m2=1
               n2=1-q1
            endif
            exit
         else
            a0=a1
            a1=r1           
            m2=m0-m1*q1
            n2=n0-n1*q1
            m0=m1
            n0=n1
            m1=m2
            n1=n2
         endif
      enddo
      if(switched) then  ! if we changedplace the m,n have to reflect that
         n=m2
         m=n2
      else
         m=m2
         n=n2
      endif
      m=m*sign(1,a)
      n=n*sign(1,b)
 

      sgd=a1
      end subroutine gcd

      !! Get the list of proper prime divisors of N together with multiplicities
      subroutine p_divisors(N,n_divs,divs)
      implicit none
      integer::N,n_divs
      integer,dimension(:,:),allocatable::temp_divs,divs
      integer::p,k,m,ni
      
      allocate(temp_divs(1:N,1:2)) 
      !! count the number of times each prime 1<=m<=First find the number of divisors of 
      temp_divs(:,:)=0      
      ni=0
      do p=2,N-1
!         write(*,*) 'p=',p,'mod(p,N)=',mod(p,N)
         if(is_prime(p).and.(mod(N,p).eq.0)) then                       
            ni=ni+1
!            write(*,*) p,'divides!',ni
            temp_divs(ni,1)=p
            temp_divs(ni,2)=1
            do k=2,ceiling(log(real(N,DP))/log(real(p,DP)))
               m=p**k
               if(mod(N,m).eq.0) then 
                  temp_divs(ni,2)=temp_divs(ni,2)+1
               else
                  exit
               endif
            enddo
         endif
      enddo
      !! ni = number of divisors
      n_divs=ni
      if(n_divs.lt.1) then 
      write(*,*) 'n_divs=',n_divs
      endif
      if(allocated(divs)) deallocate(divs)
      allocate(divs(1:n_divs,1:2))
      divs(1:n_divs,:)=temp_divs(1:n_divs,1:2)
      end subroutine

      subroutine print_divs(N)
      implicit none
      integer::N
      integer,dimension(:,:),allocatable::divs
      integer::n_divs,j

      call p_divisors(N,n_divs,divs)
      
      write(*,'(A)',ADVANCE='NO') 'Div('
      write(*,'(I3)',ADVANCE='NO') N
      write(*,'(A)',ADVANCE='NO') ')={'
      do j=1,n_divs
         write(*,'(A)',ADVANCE='NO') '{'
         write(*,'(I3)',ADVANCE='NO') divs(j,1)
         write(*,'(A)',ADVANCE='NO') ','
         write(*,'(I3)',ADVANCE='NO') divs(j,2)
         write(*,'(A)',ADVANCE='NO') '}'
      enddo
      write(*,'(A)',ADVANCE='NO') '}'
      write(*,*)
      end subroutine
      ! invert a mod N, return ai=0 if not invertible 
      ! q is the quotient (a*ai-1)/N
      subroutine invert_modN(a,ai,N,q)
      implicit none
      integer :: a,ai,N,q
      integer :: i,j
      ai=0

      if(mod(a,N).ne.0) then
         do i=-(N-1),N-1
            if(mod(a*i,N).eq.1) then
               ai=i
               exit
            endif
         enddo
         q=(a*ai-1)/N
      endif
      end subroutine invert_modN


       function EulerPhi(N)
      implicit none
      integer:: EulerPhi,N
      integer :: p,i
      integer :: tmp,a,b,sgd
      if(N.le.0) then
         write(*,*) 'ERROR! EulerPhi is defined for N>0'
         stop
      endif
      tmp=1
      do i=2,N-1
         call gcd(N,i,sgd,a,b)
         if(sgd.eq.1) then
            tmp=tmp+1
         endif
      enddo
      EulerPhi=tmp
      end function

      function is_prime(p)
      implicit none
      logical :: is_prime
      integer :: p,i
      
      if(p.eq.1) then
         is_prime=.false.
         return
      endif
      is_prime=.true.
      do i=2,min(p-1,ceiling(sqrt(real(p,DP))))
        ! write(*,*) 'mod(',p,',',i,')=',mod(p,i)
         if(mod(p,i).eq.0) then 
            is_prime=.false.
            exit
         endif
      enddo
      end function

      function is_square_free(n)
      implicit none
      logical :: is_square_free
      integer :: n,p,i,d
      
      is_square_free=.true.
      ! loop through all prime-factors
      do i=2,min(n-1,ceiling(sqrt(real(n,DP))))
         if(is_prime(i).and.(mod(n,i).eq.0)) then
            d=n/i
            if(mod(d,i).eq.0) then
               is_square_free=.false.
               return
            endif
         endif
      enddo
      end function
      !! If x== square mod N
      function is_sq_modN(x,n)
      implicit none
      integer::x,n,j
      logical::is_sq_modN
      real(DP)::r
      j=mod(x,n)
      !! is i a square
      r=sqrt(real(j,kind=DP))
      if(is_int(r)) then 
         is_sq_modN=.true.
      else
         is_sq_modN=.false.
      endif
      end function
      
      !! If D is a fundamental discriminant
      !! i.e. D==1 mod 4  or D=4E where E is square free and ==2,3 mod 4
      function is_fund_disc(D)
      implicit none
      integer::m4,D,E,j
      logical::is_fund_disc
      is_fund_disc=.false.
      m4=modulo(D,4)
      if(m4.eq.1) then 
         if(is_sq_free(D)) is_fund_disc=.true.
      endif
      if(m4.eq.0) then
         E=D/4
         j=modulo(E,4)
         if((j.eq.2).or.(j.eq.3)) then
            if(is_sq_free(E)) then
               is_fund_disc=.true.
            endif
         endif
      endif
      end function



      !!! Find the odd and even part of an integer N
      subroutine odd_even(N,odd,even)
      implicit none
      integer::N,odd,even
      integer::j

      odd=1
      do j=1,N
         if(mod(N/2**j,2).eq.1) then !! we have found the correct power of 2
            exit
         endif
      enddo         
      odd=N/2**j
      even=2**j
      end subroutine
            
            
         






      
      function dedekind_sum(d,c)
      implicit none
      integer::d,c,n
      real(DP)::x,sum,dedekind_sum

      sum=0.0_DP
      do n=1,c-1
         x=real(d,DP)*real(n,DP)/real(c,DP)
         sum=sum+real(n)/real(c)*(x-floor(x)-0.5_DP)
      enddo
      dedekind_sum=sum
      
      end function
      
      !!!!! Functions 
      !!!   r_shift, oddify and jacobi2
      !!!  are from the article: 
      !!!  "An efficient algorithm for computing the Jacobi Symbol"
      !!!   Shawna Meyer and Jonathan P. sorenson
      !!!  Journal of Symbolic Computation 26,4:509-523, 1998.


      !! computes the jacobi symbol (u/v)
      !! k= 2^(2r) and v is odd
      function r_shift(u_in,v_in,r,k)
      implicit none
      integer,intent(in)::u_in,v_in
      integer::u,v,r,k,r_shift
      integer::t,j,a,b,d
      integer::u_tmp
      integer::m,n
      u=u_in
      v=v_in
      if(mod(v,2).eq.0) then
         write(*,*) 'Input to r_shift should be odd v! v=',v
         stop
      elseif(2**(2*r).ne.k) then
         write(*,*) 'Input to r_shift should be k=2^(2r)!  k=',k,        &
     &        '  2^(2r)=',2**(2*r)
         stop
      endif
        t=1
      do j=1,maxit
         if(u.eq.0) then
            exit
         endif
         if(u.lt.0) then
            u=-u
            if(mod(v,4).eq.3) then
               t=-t
            endif
         endif
         call oddify(u,v,t,k)
         if(u.lt.v) then  !interchange u and v
            u_tmp=v
            v=u
            u=u_tmp
            if((mod(v,4).eq.3).and.mod(u,4).eq.3) then
               t=-t
            endif            
         endif

         call rfind(a,b,mod(u,k),mod(v,k),k)
         call gcd(mod(v,a),a,d,m,n)  ! d= gcd(mod(v,a),a)
         a=a/d
         v=v/d
         t=t*jacobi(mod(u,d),d)*jacobi2(a,v)
         if(t.eq.0) then
            r_shift=0
            return 
         endif
!         write(*,*) 'u=(',a,'*',u,'+',b,'*',v,')/',k,'=',(a*u+b*v)/k         
         u=(a*u+b*v)/k         
        
      enddo
      if(j.ge.maxit) then
         write(*,*) 'Maximum number of iterations occured in r_shift!!'
         stop
      endif
      if(v.eq.1) then
         r_shift=t
      else
         r_shift=0
      endif
      end function

      !!! V odd and 1=+-1
      subroutine oddify(u,v,t,k)
      implicit none
      integer::u,v,t,k
      integer::uu,j,jj,e,k_tmp
      if(mod(v,2).eq.0) then
         write(*,*) 'Oddify argument v must be odd!  v=',v
         stop
      elseif(abs(t).ne.1) then
         write(*,*) 'Oddify argument t must be +-1!  t=',t
         stop
      endif
      
      do j=1,maxit
         uu=mod(u,k)
         if(uu.eq.0) then
            ! e=log_2(k)
            !e=round(ln(real(k,DP))/ln(real(2,DP))) ! e should be an even integer
            k_tmp=k
            do jj=0,maxit
               if(mod(k_tmp,2).eq.1) then
                  exit
               endif
               k_tmp=k_tmp/2
            enddo
            if(jj.ge.maxit) then
               write(*,*) 'Maximum num it occured in oddify!!(jj)'
               stop
            endif
            e=jj
         else
            e=0
            do jj=1,maxit
               if(mod(uu,2).ne.0) then
                  exit
               else
                  e=e+1
                  uu=uu/2
               endif
            enddo
         endif
         do jj=1,e            
            u=u/2
         enddo
         if(jj.ge.maxit) then
            write(*,*) 'Maximum num it occured in jacobi!!(jj2)'
            stop
         endif
         if(uu.ne.0) then
            exit
         endif
      enddo
      if(j.ge.maxit) then
         write(*,*) 'Maximum number of iterations occured in oddify!!'
         stop
      endif
      if((mod(e,2).ne.0).and.((mod(v,8).eq.3).or.(mod(v,8).eq.5))) then
         t=-t
      endif
      return
      end subroutine



      subroutine rfind(a,b,u,v,k)
      implicit none
      integer::a,b,u,v,k
      integer::j,jj,vi
      integer::w,x1,x2,y1,y2,z1,z2,q


      call  invert_modN(v,vi,k,q)
      w=u*vi
      x1=k
      x2=0
      y1=w
      y2=1
      do j=1,maxit
         if(real(y1,DP).lt.sqrt(real(k,DP))) then
            exit
         endif
         q=floor(real(x1,DP)/real(y1,DP))
         z1=x1-q*y1
         z2=x2-q*y2
         x1=y1
         x2=y2
         y1=z1
         y2=z2
   
      enddo
      if(j.ge.maxit) then
         write(*,*) 'Maximum number of iterations occured in r_find!!'
         stop
      endif
      if(y2.lt.0) then
         a=-y2
         b=y1
      else
         a=y2
         b=-y1
      endif
      end subroutine
      
      !! u>=0 and v>0 odd 
      function jacobi2(u_in,v_in)
      implicit none
      integer,intent(in)::u_in,v_in
      integer::u,v,jacobi2
      integer::j,s
      u=u_in
      v=v_in
      if(u.lt.0) then
         write(*,*) 'Input to jacobi2(u,v) is u>0!! u=',u
         stop
      elseif((v.le.0).or.(mod(v,2).eq.0)) then
         write(*,*) 'Input to jacobi(u,v) is v>0 odd!! v=',v
         stop         
      elseif(u.eq.0) then
         if(v.eq.1) then
            jacobi2=1
            return
         else
            jacobi2=0
            return
         endif
      endif
         

      s=1     
      do j=1,maxit
         if(modulo(u,2).ne.0) then
            exit
         endif
         u=u/2
         if((modulo(v,8).eq.3).or.(modulo(v,8).eq.5)) then
            s=-s
         endif
      enddo
      if(j.ge.maxit) then
         write(*,*) 'Maximum number of iterations occured in jacobi2!!'
         stop
      endif
      if((modulo(u,4).eq.3).and.(modulo(v,4).eq.3)) then
         s=-s
      endif
      jacobi2=s*jacobi(mod(v,u),u)
      end function

      
      !!! THe function Jacobi_bin is from the article
      !!! "A binary algorithm for the Jacobi symbol"
      !!! Jeffrey Shallit and Jonathan Sorenson
      !!! SIGSAM bulleti, 27(1):4-11, January 1993 


      !! a integer and n>0 , n odd
      function jacobi(a_in,n_in)
      implicit none
      integer,intent(in)::a_in,n_in
      integer::a,n,jacobi
      integer::j,jj,t,a_tmp
      a=a_in
      n=n_in
      if(a.lt.0) then
!! extended to negative a also...
!! using (a/n)=(a mod n / n)
         do j=1,maxit
            if(a.ge.0) then
               exit
            endif
            a=a+n
         enddo
!         write(*,*) 'Input to jacobi(a,n) is a>=0!! a=',a
!         stop
      elseif((n.le.0).or.(mod(n,2).eq.0)) then
         write(*,*) 'Input to jacobi(a,n) is n>0 odd!! n=',n
         stop         
      endif
      t=1
      do j=1,maxit
         if(a.eq.0) then
            exit
         endif
         do jj=1,maxit
            if(modulo(a,2).ne.0) then
               exit
            endif
            a=a/2
            if((modulo(n,8).eq.3).or.(modulo(n,8).eq.5)) then
               t=-t
            endif
         enddo
         if(jj.ge.maxit) then
            write(*,*) 'Maximum num it occured in jacobi!!(jj)'
            stop
         endif
         !! interchange a and n
         a_tmp=n
         n=a
         a=a_tmp
         if((modulo(a,4).eq.3).and.(modulo(n,4).eq.3)) then
            t=-t
         endif
         a_tmp = modulo(a,n)
         a=a_tmp
      enddo
      if(j.ge.maxit) then
         write(*,*) 'Maximum number of iterations occured in jacobi!!'
         stop
      endif
      if(n.eq.1) then
         jacobi=t
      else
         jacobi=0
      endif
      end function
      

      !! Kroneckers extension to the legendre/jacobi symbol
      !! (n/m)
      !! here we allow m<0 or m even
      function kronecker(n_in,m_in)
      implicit none
      integer::m_in,n_in
      integer::m,n
      integer::kronecker,np,modul
      m=m_in
      n=n_in
      !! exclude the trivial cases
      if(mod(m,2).ne.0) then    !! if m is odd jacobi is ok
         if(m.gt.0) then
            kronecker=jacobi(n,m)
         else
            if(n.ge.0) then
               kronecker=jacobi(n,-m)
            else
               kronecker=-jacobi(n,-m)
            endif
         endif
      elseif(mod(n_in,2).eq.0) then  !! if both are even we get 0
         kronecker=0
      elseif(n.eq.0) then
         kronecker=0         
      else
        !!! here m is even
        !! want to use
        !! (n'/m)=(m/n)  for even m also
        !! have to find n'
        modul=mod(n,4)
        select case(modul)
        case(1,-3)
           np=n
        case(3,-1)
           np=-n
        end select
       
        !!! np is now an odd number, but might be negative
        !!!
        if(np.gt.0) then
           kronecker=jacobi(m,np)
        else
           if(m.lt.0) then
              kronecker=jacobi(m,-np)
           else
              kronecker=-jacobi(m,-np)
           endif
        endif
      endif
        end function


      !! primitive, i.e. for n_in=+-1 or 2
      function kronecker_prim(n_in,m_in)
      implicit none
      integer::m_in,n_in
      integer::m,n,kronecker_prim,modul
      m=m_in
      n=n_in
      if(m.eq.-1) then
         if(n.lt.0) then
            kronecker_prim=-1
         elseif(n.gt.0) then 
            kronecker_prim=1
         endif
      elseif(m.eq.2) then
         kronecker_prim=0
         modul=mod(n,8)
         select case(modul)
         case(-1,1,-7,7) 
            kronecker_prim=1
         case(-3,3,-5,5) 
            kronecker_prim=-1
         end select
      else
         write(*,*) 'Kronecker_prim(n,m) only for m=-1 or 2!! m=',m
         stop
      endif
      end function

      !! choose(n,k) 
      function binomial(n,k)
      implicit none
      integer::binomial,n,k,j
      integer*8::den,enum
      enum=n
      den=k
      do j=1,k-1
         enum=enum*(n-j)
         den=den*(k-j)
      enddo
      binomial=enum/den
      end function

      end module



