      module commonvariables
      implicit none
      integer, parameter  :: DP=kind(1D0)  
!This is what we set 0 to in practice when testing stuff
!      integer, parameter  :: intpol_deg =15
      !! arbitrary real weight.
      real(DP)::weight
      integer,save::plot_inside
      character(LEN=20) :: common_tmpname
      character(LEN=20) :: common_logname
      integer, save :: MAG2=1000
      logical,save::low_prec   !default=.false.
      real(kind=DP), parameter :: eps0=10E-13_DP 
      integer, parameter  :: intpol_deg =13
      real(kind=DP) ,parameter:: kbes_prec=10E-16_DP 
      real(DP):: whit_eps=1.0E-13_DP  !! precision in whittaker function module
      real(kind=DP) ,parameter:: it_prec=10E-12_DP 
      real(kind=DP), parameter :: PI = 3.14159265358979323846264_DP
      complex(DP),parameter ::CPI=dcmplx(3.14159265358979323846264_DP,      &
     &     0.0_DP)
      real(kind=DP), parameter :: PI2 = 6.2831853071795864770_DP
      real(kind=DP), parameter :: PI4 = 2.0_DP*6.2831853071795864770_DP
      real(DP),parameter::Pihalf=1.57079632679489661923132169164_DP
      complex(DP),parameter:: PI2I= (0.0_DP,6.2831853071795864770_DP)
      real(DP),parameter::sqrtPi=1.7724538509055160272981674833411452_DP
      real(kind=DP), parameter :: ln2PI=1.837877066409345483560659_DP
      real(DP),parameter::ln2PI_2=0.9189385332046727417803297_DP
      real(DP),parameter::one=1.0_DP
      real(DP),parameter::zero=0.0_DP
      real(DP),parameter::two=2.0_DP
      real(DP),parameter::half=0.5_DP
      complex(DP),parameter::cone=dcmplx(1.0_DP,0.0_DP)
      complex(DP),parameter::czero=dcmplx(0.0_DP,0.0_DP)
      complex(DP),parameter::ctwo=dcmplx(2.0_DP,0.0_DP)
      complex(DP),parameter::chalf=dcmplx(0.5_DP,0.0_DP)
      logical::do_real
      character(LEN=200)::MSG
      !! Do exceptional eigenvalues
      !! e.g. lambda<1/4
      !!
      logical,save::do_exceptional,interactive,holomorphic
      logical,save::do_interpolation_grid
      logical,save::do_multprec
      logical,save::use_sym_even,use_sym_odd
      interface argument
      module procedure argument_r
      module procedure argument_c
      end interface

      interface i2c
      module procedure integer_to_char
      module procedure integer_to_char2
      end interface
      interface r2c
      module procedure real_to_char
      end interface
     
     
  
      !!! These are the parameters u
!      integer,dimension(1:3)::parametrar

!      logical,parameter::low_prec=.true.
!      integer, saveR :: CType 


                             ! and intger_to_char converts any integer with less than 10 digits to a character string
      contains 
      function make_filename(filtyp,P,type,ctyp,eps,R)
      implicit none   
      character(LEN=20) :: sincos,evenodd,chartype,filtyp
      character(LEN=70) :: make_filename
      integer :: P,type,eps,ctyp
      real(kind=DP),optional :: R
      if(type.eq.0) then
         sincos  = 'cos'
      elseif(abs(type).eq.1) then
         sincos  = 'sin'        
      elseif(type.gt.1) then
         sincos  = 'n' // trim(integer_to_char(type))
      else
         sincos  = ''        
      endif

      if(eps.eq.1) then
         evenodd = 'even'
      elseif(eps.ne.0) then
         evenodd  ='odd'
      else
         evenodd  =''
      endif
      if(ctyp>0) then
         chartype='CH' // trim(integer_to_char(ctyp))
      else
         chartype=''
      endif
      if(weight.ne.0.0_DP) then
         chartype=chartype//'w'
      endif
      make_filename = trim(filtyp) // 'P' // trim(integer_to_char(P))    &
     &     // trim(chartype) // 'R'                                     &
     &     // trim(integer_to_char(int(10000.0_DP*R)))                       &
     &     // trim(sincos) // trim(evenodd) // '.txt'

      
      end function make_filename
      
      !!! Open files and perform tests on existence etc. in advance
      !! MOD=R/W/A  (read/write/append)
      subroutine my_open(NAMN,ui,MOD)
      implicit none
      character*(100)::NAMN
      integer::ui
      character*(1)::MOD
      integer::ierr,j,jj
      logical::ext
      if(ui.eq.0) ui=10
      !!! First of all we must make sure that no unit is attached to ui (=unit id)
      !!! (unless we want to append)
      if((MOD(1).eq.'A').or.(MOD(1).eq.'a')) then
         !! If the file 'NAMN' exist and is attached to number j
         INQUIRE(FILE=NAMN,NUMBER=j,EXIST=ext,IOSTAT=ierr)
         if(ext) then
            ui=j
         endif
      elseif((MOD(1).eq.'R').or.(MOD(1).eq.'r')) then
         do j=ui,30             !! If we supplied a non-valid ui 
            jj=j
            INQUIRE(FILE=NAMN,NUMBER=jj,EXIST=ext,IOSTAT=ierr)
            if(.not.(ext)) then
               write(*,*) 'Err: Doesnt exist:',NAMN
               stop
            endif
            if(ierr.ne.0) then
               write(*,*) 'Err: ierr:',ierr
               stop
            endif
         enddo
      endif               
      !!! If we want to read from a file it must exist





      end subroutine








      ! convert integers with less than 15 digits to a character string
      function integer_to_char(i)
      implicit none
      integer :: i,j,res,tal
      character(LEN=10) :: resultat
      character(LEN=10) :: integer_to_char
      integer_to_char = ''
      resultat = ''
!      write(*,*) 'tal=',i
      if(i.lt.0) then
         tal=-i
      else
         tal = i
      endif
      do j=0,9
         res = mod(tal,10)
!         write(*,*) 'res=',res
         resultat = char(48+res)  // resultat
         tal = tal - res         
         tal = tal/10
         if(tal==0) then
            exit
         endif
      enddo
      if(i.lt.0) then
         resultat='-' // resultat
      endif
      integer_to_char = trim(resultat)
      end function integer_to_char

      function integer_to_char2(i)
      implicit none
      integer*8 :: i,j,res,tal,ten,noll
      character(LEN=15) :: resultat
      character(LEN=15) :: integer_to_char2
      ten=int(10)
      noll=int(0)
      integer_to_char2 = ''
      resultat = ''
!      write(*,*) 'tal=',i
      if(i.lt.noll) then
         tal=-i
      else
         tal = i
      endif
      do j=0,14
         res = mod(tal,ten)
!         write(*,*) 'res=',res
         resultat = char(48+res)  // resultat
         tal = tal - res         
         tal = tal/ten
         if(tal==0) then
            exit
         endif
      enddo
      if(i.lt.0) then
         resultat='-' // resultat
      endif
      integer_to_char2 = trim(resultat)
      end function integer_to_char2


      ! convert real number r to a string (using k decimals)
      function real_to_char(r,k)
      implicit none
      character(LEN=50) :: real_to_char
      real(DP)::r,rr,tmp
      integer::k,j,m
      integer*8 :: i,res,tal
      character(LEN=50) :: resultat,s1,s2,sg
      real_to_char = ''
      resultat = ''
      if(r.lt.0.0D0) then 
         sg='-'
         rr=-r
      else
         sg=''
         rr=r
      endif      
      i=floor(rr)  !! Integer part
      s1=trim(sg)//trim(integer_to_char2(i))//'.'
      tmp=rr-real(i,DP) !! fractional part
!      write(*,*) 'tmp=',tmp
      do j=1,k
         if(tmp.lt.10.0D0**(-real(j,DP))) then 
            s1=trim(s1)//'0'
         endif
      enddo
      s2=''
      m=mod(k,5)
      do j=1,(k-m)/5
         tmp=(10.0_DP**5)*tmp
!         write(*,*) 'tmp2=',tmp
         tal=floor(tmp)
!         write(*,*) 'tal=',tal
         s2=trim(s2)//trim(integer_to_char2(tal))
         tmp=tmp-real(tal,DP)
      enddo
      tmp=(10.0_DP**m)*tmp
!      write(*,*) 'tmp2=',tmp
      tal=floor(tmp)
!      write(*,*) 'tal=',tal
      s2=trim(s2)//trim(integer_to_char2(tal))
      resultat=trim(s1)//trim(s2)
      real_to_char = trim(resultat)
      end function real_to_char

      
      function char_to_real(string,l)
      implicit none
      character::string(l),ch
      integer::l
      real(DP)::char_to_real
      open(unit=188,file='tmp_c_to_r.txt')
      write(188,*) string(1:l) 
      close(188)
      open(unit=189,file='tmp_c_to_r.txt')
      read(189,*) char_to_real
      close(189)
      call unlink('tmp_c_to_r.txt')
      end function 

      function char_to_int(string,l)
      implicit none
      character::string(l),ch
      integer::l
      integer::char_to_int,j,i,n,jj
      n=0
      jj=0
      do j=0,l-1
         !!! we don't increment jj unless there is an actual digit
         ch=trim(string(l-j))
!         write(*,*) ' ch=(',ch,')'
!         write(*,*) 'jj=',jj
         select case(ch)
         case('1')
            n=n+(10**jj)
         case('2')
            n=n+2*(10**jj)
         case('3')
            n=n+3*(10**jj)
         case('4')
            n=n+4*(10**jj)
         case('5')
            n=n+5*(10**jj)
         case('6')
            n=n+6*(10**jj)
         case('7')
            n=n+7*(10**jj)
         case('8')
            n=n+8*(10**jj)
         case('9')
            n=n+9*(10**jj)
         case('0')
            n=n
         case default
!            write(*,*) 'ERROR: ch=',ch
!            stop
            jj=jj-1
         end select
         jj=jj+1
!         write(*,*) 'n=',n
!         write(*,*) 'r=',strang(l+1-j)
!         write(*,*) 'r=
      enddo
      char_to_int=n

      end function 

      !!! Determine if x is an integer
      function is_int(x)
      implicit none
      real(DP)::x
      logical::is_int
      is_int=.false.
      if(floor(x).eq.ceiling(x)) is_int=.true.
!!! But we might have a little "fuzz" also 
!!! even in double precision it is hard to tell if 2.0000000000000001
!!! is representing 2 or not 
      if(abs(x-real(floor(x),DP))/abs(x).lt.1.0E-15_DP) is_int=.true.
      if(abs(x-real(ceiling(x),DP))/abs(x).lt.1.0E-15_DP) is_int=.true.
      !! We might also have something close to zero !!
      !! remember we only have 16 digits correctly represented
      if(abs(x).lt.1.0E-16_DP) is_int=.true.
      end function 









      subroutine makegrid(Left,Right,N,grid)   
      implicit none
      real(kind=DP) :: Left,Right
      integer:: N,j
      real(kind=DP), dimension(0:N):: grid
      
      do j=0,N
         grid(j)=Left+real(j,DP)*(Right-Left)/real(N,DP)
      end do
      end subroutine makegrid
   
                                ! Simply computes M>=(R+R^(1/3))/(2*Pi*Y)
      subroutine get_M(R,Y,M) 
      implicit none
      real(DP)::R,Y
      integer::M      
      M=ceiling((R+15.0_DP*R**(0.3333333333_DP))/(PI2*Y))      
      end subroutine get_M



      ! principal argument of z=x+iy, -Pi<arg(z)<=Pi
      function argument_r(x,y)
      implicit none
      real(kind=DP)::x,y,argument_r,argument

      if(y.eq.0.0_DP) then
         if(x.ge.0.0_DP) then
            argument=0.0_DP
         else            
            argument=PI
         endif
      elseif(x.lt.0.0_DP) then
         if(y.lt.0.0_DP) then
            argument=datan(y/x)-PI
!            argument=Pi+datan(y/x)
         else
            argument=(Pi+datan(y/x))
         endif
      elseif(x.gt.0.0_DP) then
         argument=datan(y/x)
      else !if x=0
         if(y.ge.0.0_DP) then
            argument=Pihalf
         else
            argument=-1.0_DP*Pihalf
         endif
      endif
      argument_r=argument
      end function

      function argument_c(z)
      implicit none
      complex(DP)::z
      real(DP)::argument_c
      argument_c=argument_r(real(z,DP),dimag(z))
      end function

      subroutine print_matrix(V,r,k)
      implicit none
      integer::r,k
      complex(DP),dimension(1:r,1:k)::V
      
      integer::i,j


      do i=1,r
         do j=1,k
            write(*,'(ES6.1)',ADVANCE='NO') real(V(i,j),DP)
            write(*,'(A)',ADVANCE='NO') ' '
         enddo
         write(*,*)
      enddo

      end subroutine

      !!! Reads y/Y/n/N  and returns true or false (yes or no)
      function get_answer_yn()
      implicit none
      logical::get_answer_yn
      character(LEN=1) ANS
      get_answer_yn=.false.
      read(*,*) ANS
      if((ANS.eq.'y').or.(ANS.eq.'Y')) then
         get_answer_yn=.true.
      endif
      end function


      subroutine errmsg(stat,iu)
      implicit none
      integer::stat,iu
!      character,dimension(:)::str
!      character**::str
      write(iu,*) MSG
      if(stat.eq.1) stop
      end subroutine errmsg

      end module commonvariables 
      
      module giant_mod
      use commonvariables
      real(kind=DP), dimension(:,:,:),allocatable :: giant_system

      real(kind=DP),dimension(:,:,:,:),allocatable :: giant_total_system
      complex(kind=DP),dimension(:,:,:,:),allocatable ::                   &
     &     giant_total_system_cplx
      complex(kind=DP),dimension(:,:,:,:,:),allocatable ::                   &
     &     giant_total_system_cplx2
      real(kind=DP),dimension(:,:,:,:,:,:),allocatable ::                   &
     &     giant_total_system2
      real(kind=DP),dimension(:,:,:,:,:),allocatable ::                   &
     &     giant_total_system3
      contains
      subroutine clean_giant_mod()
      if(allocated(giant_system)) deallocate(giant_system)
      if(allocated(giant_total_system)) deallocate(giant_total_system)
      if(allocated(giant_total_system2)) deallocate(giant_total_system2)
      if(allocated(giant_total_system3)) deallocate(giant_total_system3)
      if(allocated(giant_total_system_cplx))                                &
     &     deallocate(giant_total_system_cplx)
      if(allocated(giant_total_system_cplx2))                               &
     &     deallocate(giant_total_system_cplx2)
      end subroutine
      end module giant_mod


      
