! module containing various subroutines for manipulating                                
! coefficient sets
!
!
!  030313 : Keep only functions working on complex coefficients
!
      module coefficients
!c$$$
!c$$$      interface
!c$$$               subroutine get_all_coeff(R,CY,typ,e,M0)
!c$$$               use commonvariables
!c$$$               real(kind=DP),intent(in) :: R
!c$$$               integer :: Q,M0,typ
!c$$$               complex(kind=DP), dimension(1:num_cusps*M0) :: CY
!c$$$               real(kind=DP), dimension(0:num_cusps-1) :: e
!c$$$               end subroutine get_all_coeff
!c$$$      end interface
!c$$$      
      use sys_solve
      integer,save::i1_set,i2_set,i3_set
      real(DP),save,private::ytmp2_old
!      logical,save::set_kvec
      real(DP),dimension(:),allocatable,save,private::k_vec

!      use sys_solve_cplx
      !! generic procedure for setting up the grid
      interface get_all_coeff_grid
!      module procedure get_all_coeff_g_w
!      module procedure get_all_coeff_g_cplx
!      module procedure get_all_coeff_g_2y_cplx
      module procedure get_all_coeff_g_real
      module procedure get_all_coeff_g_2y_real
      end interface
      
      interface evalMaass
      module procedure evalMaass_r
      module procedure evalMaass_c
!      module procedure evalMaass_c_sym
      end interface
      

      
      interface compute_coeffs
      module procedure compute_coeffs_cplx
      module procedure compute_coeffs_cplx2
      end interface

      interface display_coefficients2
      module procedure display_coefficients2_c
      module procedure display_coefficients2_r
      end interface


      interface Hecke_relations
      module procedure Hecke_relations_re
      module procedure Hecke_relations_cplx
      end interface 

      contains
      
      ! This subroutine sets up the whole grid of coefficients which 
      ! I use to interpolate over later
      ! For complex coeficients
   
      ! This subroutine sets up the whole grid of coefficients which 
      ! I use to interpolate over later
      ! For complex coefficients
      ! Stored in A(Y), B(Y) is then 
      ! one set of interpolating coefficients for each combination
      ! (wrt to parity of the cusps)
 
      !!! We do both Y1 and Y2 at the same time to
      !!! save some time at the interpolaiton stage
      !!! since the same R-value is involved....

!c$$$      subroutine get_all_coeff_g_2y_cplx(Y1,Y2,M0,Q,N0,N1,I1,I2,           &
!c$$$     &     grid0,grid1,AY1,BY1,AY2,BY2,num_comb,j_in_grid,y_no) 
!c$$$      use commonvariables
!c$$$      use system
!c$$$      use giant_mod
!c$$$      use groups
!c$$$      implicit none
!c$$$      complex(kind=DP),dimension(1:num_cusps)::e
!c$$$      real(kind=DP),intent(in) :: Y1,Y2
!c$$$      integer:: j_in_grid ! The index we have in the grid, if>0 
!c$$$                                ! we don't need to calculate the first points again
!c$$$      integer,optional::y_no
!c$$$      integer::y_n              ! I can't use same saved grid for different Y's
!c$$$      integer :: M0             ! the size of the system
!c$$$      real(kind=DP),dimension(0:N0) :: grid0 ! the grid to interpolate  over
!c$$$      real(kind=DP),dimension(0:N1) :: grid1 ! the grid to compute the coefficients at
!c$$$      integer :: N0,N1          ! length-1 of the two grids
!c$$$      integer :: Q,I1,I2
!c$$$      integer :: ex,num_comb
!c$$$      real(kind=DP) :: tmp
!c$$$      real(kind=DP),dimension(0:N1,0:0,1:M0                                &
!c$$$     &     ,0:0,1:num_comb)::AY1,BY1,AY2,BY2
!c$$$      complex(kind=DP), dimension(:,:),allocatable ::CY,CNY
!c$$$      complex(kind=DP), dimension(:,:),allocatable::UCP
!c$$$      real(kind=DP) :: RR,R,index_of_RR
!c$$$      integer :: i,ij,j,k,l,M,NDEG,NN
!c$$$      integer,dimension(1)::which
!c$$$      complex(DP),dimension(1)::cs
!c$$$      NN=num_cusps*(2*M0+1)
!c$$$      allocate(UCp(1:NN,1:NN))
!c$$$      allocate(CY(1:num_cusps,1:(M0+1)))
!c$$$      allocate(CNY(1:num_cusps,1:M0))      
!c$$$        
!c$$$      if(.not.(allocated(giant_total_system_cplx))) then
!c$$$         allocate(giant_total_system_cplx(0:intpol_deg,1:NN,1:NN,       &
!c$$$     &        1:2))
!c$$$      elseif(allocated(giant_total_system_cplx).and.                    &
!c$$$     &        size(giant_total_system_cplx,1).ne.NN) then
!c$$$         deallocate(giant_total_system_cplx)
!c$$$         allocate(giant_total_system_cplx(0:intpol_deg,1:NN,1:NN,        &
!c$$$     &        1:2))
!c$$$      endif
!c$$$      write(*,*) 'in sub get_coeff(',Y1,',',Y2,',',M0,',',N0,',',N1,','   &
!c$$$     &     ,I1,')'
!c$$$      ! just a check to see that we come here with sane values
!c$$$      if((grid0(0)>grid1(0)) .or. (grid0(N0)<grid1(N1))) then
!c$$$         write(*,*) 'ERROR: the grid are set up wrong!!'
!c$$$         write(*,*) 'grid0:',grid0(0),grid0(N0)
!c$$$         write(*,*) 'grid1:',grid1(0),grid1(N1)
!c$$$         stop
!c$$$      endif
!c$$$      NDEG = intpol_deg
!c$$$      if(j_in_grid.gt.0) then
!c$$$         do i=0,NDEG-2
!c$$$            do y_n=1,2
!c$$$               giant_total_system_cplx(i,:,:,y_n)=                             &
!c$$$     &              giant_total_system_cplx(i+2,:,:,y_n)
!c$$$            enddo
!c$$$         enddo
!c$$$         do i=NDEG-1,NDEG
!c$$$            R=grid0(i)
!c$$$            call computeVnl3_co_tot_cplx(R,Y1,Q,M0,Ucp)
!c$$$            giant_total_system_cplx(i,:,:,1)=UCp(:,:)
!c$$$            call computeVnl3_co_tot_cplx(R,Y2,Q,M0,UCp) ! KBMAT(R,U)
!c$$$            giant_total_system_cplx(i,:,:,2)=UCp(:,:)
!c$$$         end do
!c$$$      else  
!c$$$         ! If this is our first step we compute at all points
!c$$$         do i=0,NDEG
!c$$$            R=grid0(i)
!c$$$            call computeVnl3_co_tot_cplx(R,Y1,Q,M0,UCp) ! KBMAT(R,U)
!c$$$            giant_total_system_cplx(i,:,:,1)=UCp(:,:)
!c$$$            call computeVnl3_co_tot_cplx(R,Y2,Q,M0,UCp) ! KBMAT(R,U)
!c$$$            giant_total_system_cplx(i,:,:,2)=UCp(:,:)
!c$$$         end do
!c$$$      endif
!c$$$      j=0
!c$$$      ! nu � giant(n,l,j)=V_nl(R_1,j)
!c$$$      ! use the rest of the points
!c$$$      ! (we can only use NDEG+1 points at a time to interpolate
!c$$$      !  by an NDEG-degree polynomial)
!c$$$      ! but we want to take them into account anway
!c$$$!      write(*,*) 'in sub get_coeff 1 N0=',N0,' N1=',N12
!c$$$
!c$$$      ! Copy the correct data to the giant system we will use
!c$$$      do k=0,N1
!c$$$         RR=grid1(k)
!c$$$                                ! I1 is the index in grid0 of the startpoint in grid1 
!c$$$         index_of_RR = real(I1,DP)+                                        &
!c$$$     &        real(I2-I1,DP)*real(k,DP)/real(N1,DP)
!c$$$                                ! interpolate the real and imaginary parts
!c$$$                                !   write(*,*) 'interpolate index=',index_of_RR
!c$$$         call interpolate_total_cplx_w(index_of_RR,UCp,M0,1)
!c$$$         which(1)=1
!c$$$         cs(1)=dcmplx(1.0_DP,0.0_DP)
!c$$$         do l=1,num_norm_cusp_combs-1
!c$$$            e(:)=dcmplx(norm_cusp_combs(l,:))
!c$$$            call set_norm(1,1,cs,e,which)
!c$$$            call solve_system(UCp(:,:),CY,CNY,M0,NN)
!c$$$!0,0,e) 
!c$$$                                !!! remember, to search for eigenvalues we might need
!c$$$                                !!! only the real part of the coefficients
!c$$$                                !!! at the first cusp...
!c$$$            AY1(k,0,1:M0,0,l)=real(CY(1,2:M0+1),DP)
!c$$$            BY1(k,0,1:M0,0,l)=dimag(CY(1,2:M0+1))
!c$$$         enddo
!c$$$         call interpolate_total_cplx_w(index_of_RR,UCp,M0,2)
!c$$$         do l=1,num_norm_cusp_combs-1
!c$$$            e(:)=norm_cusp_combs(l,:)
!c$$$            call set_norm(1,1,cs,e,which)
!c$$$            call solve_system(UCp(:,:),CY,CNY,M0,NN)
!c$$$!,0,dcmplx(e)) 
!c$$$            AY2(k,0,1:M0,0,l)=real(CY(1,2:M0+1),DP)
!c$$$            BY2(k,0,1:M0,0,l)=dimag(CY(1,2:M0+1))
!c$$$         enddo
!c$$$         
!c$$$      end do
!c$$$      deallocate(UCp)
!c$$$      deallocate(CY)
!c$$$      deallocate(CNY)
!c$$$      
!c$$$                                ! so now we have (grid0_size-N) sets of coefficients
!c$$$      ! for each R in the grid and we must test them
!c$$$      ! to conclude where in grid1 to continue searching
!c$$$      ! 
!c$$$
!c$$$!      deallocate(giant_total_system_cplx)
!c$$$      end subroutine get_all_coeff_g_2y_cplx
      
!*     !! solves the system with nparams different parameters to the 
!*     !! sys_solve routine and hence get a 
!*     !! 
!c$$$      subroutine get_all_coeff_g_cplx(Y,M0,Q,N0,N1,I1,I2,grid0,              &
!c$$$     &     grid1,CY,CNY,num_comb,j_in_grid,y_no,nparams,params,es_set,                &
!c$$$     &     nums_set,cs_set,which_cs) 
!c$$$      use commonvariables
!c$$$      use system
!c$$$      use sys_solve
!c$$$      use giant_mod
!c$$$      use groups
!c$$$      use characters
!c$$$      implicit none
!c$$$      real(kind=DP),intent(in) :: Y
!c$$$      integer,intent(in) :: M0,Q,N0,N1,I1,I2         
!c$$$      real(kind=DP),dimension(0:N0),intent(in) :: grid0 ! the grid to interpolate  over
!c$$$      real(kind=DP),dimension(0:N1),intent(in) :: grid1 ! the grid to compute the coefficients at     
!c$$$      complex(DP),dimension(0:N1,1:num_cusps,1:(M0+1),                                 &
!c$$$     &     1:nparams)::CY
!c$$$      complex(DP),dimension(0:N1,1:num_cusps,1:M0,1:nparams)::CNY
!c$$$      integer,intent(in)::num_comb,j_in_grid,y_no,nparams
!c$$$      integer::npars
!c$$$      integer,dimension(1:nparams)::params
!c$$$      complex(kind=DP),dimension(1:nparams,1:num_cusps),optional::es_set
!c$$$      complex(kind=DP),dimension(:),allocatable::e
!c$$$      complex(kind=DP),dimension(1:nparams,1:M0),optional::cs_set
!c$$$      complex(kind=DP),dimension(1:M0)::cs
!c$$$      integer, dimension(1:nparams,1:M0),optional::which_cs
!c$$$      integer, dimension(1:M0)::which_coeff
!c$$$      integer, dimension(1:nparams),optional::nums_set  
!c$$$      integer::num
!c$$$      integer :: ex
!c$$$      real(kind=DP) :: tmp,memsize
!c$$$      complex(DP), dimension(:,:),allocatable::UCp,UCP0
!c$$$      real(kind=DP) :: Y1,Y2,RR,R,index_of_RR
!c$$$      integer :: i,ij,j,jj,k,l,M,NDEG,NN,par
!c$$$      npars=nparams
!c$$$      !! now we have both positive and negative coefficients
!c$$$      NN=num_cusps*(2*M0+1)
!c$$$!      write(*,*) 'in get_coeff! NN=',NN,' Y=',Y
!c$$$!      write(*,*) 'rnc=',real_num_cusps
!c$$$      allocate(e(1:num_cusps))
!c$$$      allocate(UCp(1:NN,1:NN))
!c$$$      allocate(UCp0(1:NN,1:NN))
!c$$$!     allocate(e(1:2))
!c$$$!      write(*,*) 'in get_coeff! NN=',NN,' Y=',Y,'size=',                  &
!c$$$!     &     NN*NN*(intpol_deg+1)*2
!c$$$      memsize=real(NN*NN*(intpol_deg+1),DP)/(1024.0_DP)**3*16.0_DP
!c$$$!      write(*,*) 'memzise=',memsize
!c$$$      if(memsize.ge.2.0) then
!c$$$         do_interpolation_grid=.false.
!c$$$      endif
!c$$$      if(do_interpolation_grid.and.(memsize.lt.2.0)) then
!c$$$         if(.not.(allocated(giant_total_system_cplx))) then
!c$$$            allocate(giant_total_system_cplx(0:intpol_deg,1:NN,1:NN,    &
!c$$$     &           1:2))
!c$$$                                !! we only need one symmetry since working with exponentials
!c$$$         elseif(size(giant_total_system_cplx,1).ne.NN) then
!c$$$            deallocate(giant_total_system_cplx)
!c$$$            allocate(giant_total_system_cplx(0:intpol_deg,1:NN,1:NN,    &
!c$$$     &           1:2))
!c$$$         endif
!c$$$      endif
!c$$$!      write(*,*) 'size(giant,1)=',size(giant_total_system_cplx,1)
!c$$$!      write(*,*) 'size(giant,2)=',size(giant_total_system_cplx,2)
!c$$$!      write(*,*) 'size(giant,3)=',size(giant_total_system_cplx,3)
!c$$$!      write(*,*) 'size(giant,4)=',size(giant_total_system_cplx,4)
!c$$$!      write(*,*) 'size(giant,5)=',size(giant_total_system_cplx,5)
!c$$$                                ! just a check to see that we come here with sane values
!c$$$      if((grid0(0)>grid1(0)) .or. (grid0(N0)<grid1(N1))) then
!c$$$         write(*,*) 'ERROR: the grid are set up wrong!!'
!c$$$         write(*,*) 'grid0:',grid0(0),grid0(N0)
!c$$$         write(*,*) 'grid1:',grid1(0),grid1(N1)
!c$$$         stop
!c$$$      endif
!c$$$      NDEG = intpol_deg
!c$$$      if(do_interpolation_grid) then
!c$$$         if(j_in_grid.gt.0) then
!c$$$            do i=0,NDEG-2
!c$$$!               write(*,*) 'i=',i,'i+2=',i+2
!c$$$!!DEB
!c$$$!               R=grid0(i)            
!c$$$!               call computeVnl3_co_tot_cplx(R,Y,Q,M0,UCp) ! KBMAT(R,U)
!c$$$               do jj=1,NN
!c$$$                  giant_total_system_cplx(i,jj,1:NN,y_no)=                             &
!c$$$     &              giant_total_system_cplx(i+1,jj,1:NN,y_no)
!c$$$               enddo
!c$$$!     &              UCp(1:NN,1:NN)
!c$$$
!c$$$            enddo
!c$$$            do i=NDEG-1,NDEG
!c$$$               R=grid0(i)            
!c$$$               call computeVnl3_co_tot_cplx(R,Y,Q,M0,UCp) ! KBMAT(R,U)
!c$$$               giant_total_system_cplx(i,1:NN,1:NN,y_no)=                &
!c$$$     &              UCp(1:NN,1:NN)
!c$$$            end do
!c$$$         else  
!c$$$                                ! If this is our first step we compute at all points
!c$$$
!c$$$            do i=0,NDEG
!c$$$!               write(*,*) 'before computing!, size=',size(UCp)
!c$$$               R=grid0(i)
!c$$$               call computeVnl3_co_tot_cplx(R,Y,Q,M0,UCp) ! KBMAT(R,U)
!c$$$!               write(*,*) 'after computing! i,y_no=',i,y_no
!c$$$!               write(*,*) 'ia=',ALLOCATED(giant_total_system_cplx)
!c$$$               giant_total_system_cplx(i,:,:,y_no)=UCp(:,:)
!c$$$!               write(*,*) 'after assigning!'
!c$$$            end do
!c$$$         endif
!c$$$      endif
!c$$$      do k=0,N1
!c$$$         index_of_RR = real(I1,DP)+                                        &
!c$$$     &        real(I2-I1,DP)*real(k,DP)/real(N1,DP)
!c$$$         RR=grid1(k)
!c$$$!	 write(*,*) 'RR=',RR
!c$$$!	 write(*,*) 'k=',k
!c$$$         if(do_interpolation_grid) then
!c$$$            call interpolate_total_cplx_w(index_of_RR,UCp0,M0,y_no)
!c$$$         else
!c$$$            RR=grid1(k)
!c$$$            call computeVnl3_co_tot_cplx(RR,Y,Q,M0,UCp0) ! KBMAT(R,U)
!c$$$         endif
!c$$$         if(npars.gt.0) then
!c$$$            do j=1,npars
!c$$$               UCP=UCP0                                 
!c$$$               par=params(j)
!c$$$               if(par.ne.-1) then 
!c$$$                  if(present(which_cs)) then !! either everything is set or nothing
!c$$$                     num=nums_set(j)
!c$$$                     which_coeff(1:num)=which_cs(j,1:num)
!c$$$                     cs(1:num)=cs_set(j,1:num)
!c$$$                  else
!c$$$                     if(.not.(allocated(alphas))) then 
!c$$$                        call get_alphas()
!c$$$                     endif
!c$$$                     if(alphas(1).ne.0.0) then 
!c$$$                        num=1
!c$$$                        which_coeff(1)=1
!c$$$                        cs(1)=dcmplx(1.0_DP,0.0_DP)
!c$$$                     else
!c$$$                        num=2
!c$$$                        which_coeff(1)=0
!c$$$                        cs(1)=dcmplx(0.0_DP,0.0_DP)
!c$$$                        which_coeff(2)=1
!c$$$                        cs(2)=dcmplx(1.0_DP,0.0_DP)
!c$$$                     endif
!c$$$                  endif
!c$$$                  if(present(es_set)) then
!c$$$                     e(1:num_cusps)=es_set(j,1:num_cusps)
!c$$$                  else
!c$$$                     e(:)=0.0_DP
!c$$$                     e(1)=dcmplx(1.0_DP,0.0_DP)
!c$$$                  endif
!c$$$                  call set_norm(1,num,cs(1:num),e,                                 &
!c$$$     &                 which_coeff(1:num))
!c$$$               endif
!c$$$               !!! If par=-1 then we should have set all parameters beforehand
!c$$$!		write(*,*) 'solving'
!c$$$               call solve_system(UCp,CY(k,:,:,j),CNY(k,:,:,j),M0,NN)
!c$$$!		write(*,*) 'after solving'
!c$$$!               if(k.eq.98) then
!c$$$!                  write(*,*) 'R=',RR,' Y=',Y
!c$$$!                  write(*,*) 'C2(R,Y)=',CY(k,1,3,j)
!c$$$!               endif	
!c$$$!               elseif(present(e_set)) then
!c$$$!                  call solve_system(UCp,CY(k,:,:,j),CNY(k,:,:,j),M0,par,       &
!c$$$!     &                 e_set(j,:))
!c$$$!               else
!c$$$!                  call solve_system(UCp,CY(k,:,:,j),CNY(k,:,:,j),M0,par)       
!c$$$!               endif
!c$$$            enddo
!c$$$         else
!c$$$            UCP=UCP0
!c$$$            call solve_system(UCp,CY(k,:,:,1),CNY(k,:,:,1),M0,NN)
!c$$$         endif
!c$$$      end do
!c$$$!      write(*,*) 'leaving get_coeff!'
!c$$$!      deallocate(giant_total_system_cplx)
!c$$$      end subroutine get_all_coeff_g_cplx
!c$$$
!c$$$
!c$$$  
      
      !! Optimized
      !! For real coefficients, real characters  and prime index!!
      subroutine get_all_coeff_g_real(Y,M0,Q,N0,N1,I1,I2,                  &
     &     grid0,grid1,CY,num_comb,j_in_grid,y_no,interp) 
      use commonvariables
      use system
      use giant_mod
      use groups
      implicit none
      real(kind=DP),dimension(0:num_cusps-1)::e
      real(kind=DP),intent(in) :: Y
      integer:: j_in_grid ! The index we have in the grid, if>0 
      ! we don't need to calculate the first points again
      integer::y_no  ! I can't use same saved grid for different Y's
      integer :: M0  ! the size of the system
      real(kind=DP),dimension(0:N0) :: grid0 ! the grid to interpolate  over
      real(kind=DP),dimension(0:N1) :: grid1 ! the grid to compute the coefficients at
      integer :: N0,N1 ! length-1 of the two grids
      integer :: Q,I1,I2
      integer :: ex,num_comb
      logical,optional::interp
      real(kind=DP) :: tmp
!      real(kind=DP),dimension(0:N1,0:0,1:M0*num_cusps                    &
!     &     ,0:1,1:num_comb)::AY,BY
      real(kind=DP),dimension(0:N1,0:0,1:M0                              &
     &     ,0:1,1:num_comb-1)::CY
!      real(kind=DP), dimension(1:M0-1) ::CYtmp
      real(kind=DP), dimension(1:M0-1,1:M0,0:1,0:num_comb-2)::V
      real(kind=DP) :: Y1,Y2,RR,R,index_of_RR
      integer :: i,j,k,l,M,NDEG,NN,type,maxi,kk
      real(DP)::TT,temp,epsilon


      if(.not.(PRESENT(interp))) then
         interp=.false.
      endif
!      write(*,*) 'Interp=',interp
!      NN=num_cusps*M0
!      if(.not.(allocated(giant_total_system2))) then
!         allocate(giant_total_system2(1:NN,1:NN,0:intpol_deg,0:1,         &
!     &        1:2))
!      endif
      
      !!! If we are using invoutions we only need a single Y value
      if(y_no.eq.0) then 
         if(.not.(allocated(giant_total_system2))) then
            allocate(giant_total_system2(1:M0-1,1:M0,0:intpol_deg,0:1,         &
     &           y_no:y_no,0:1))
         else
            if(size(giant_total_system2,2).ne.M0) then 
               deallocate(giant_total_system2)
               allocate(giant_total_system2(1:M0-1,1:M0,0:intpol_deg,          &
     &              0:1,y_no:y_no,0:1))
               write(*,*) ' reallocated giant matrix!'
            endif
         endif
      else
         if(.not.(allocated(giant_total_system2))) then
            allocate(giant_total_system2(1:M0-1,1:M0,0:intpol_deg,0:1,         &
     &           1:2,0:1))
         else
            if(size(giant_total_system2,2).ne.M0) then
               deallocate(giant_total_system2)
               allocate(giant_total_system2(1:M0-1,1:M0,0:intpol_deg,          &
     &              0:1,1:2,0:1))
               write(*,*) ' reallocated giant matrix!'
            endif
         endif
      endif
      if((grid0(0)>grid1(0)) .or. (grid0(N0)<grid1(N1))) then
         write(*,*) 'ERROR: the grid are set up wrong!!'
         write(*,*) 'grid0:',grid0(0),grid0(N0)
         write(*,*) 'grid1:',grid1(0),grid1(N1)
         stop
      endif
      NDEG = intpol_deg
      if(j_in_grid.gt.0) then
         do i=0,NDEG-2
            giant_total_system2(:,:,i,:,y_no,0:1)=                             &
     &           giant_total_system2(:,:,i+2,:,y_no,0:1)
         enddo
         do i=NDEG-1,NDEG
            R=grid0(i)
            call computeMat_real(R,Y,Q,M0,V,.true.,interp)
            giant_total_system2(:,:,i,:,y_no,:)=V(:,:,:,:)
         end do
      else  
                                ! If this is our first step we compute at all points
         do i=0,NDEG-1
            R=grid0(i)
            call computeMat_real(R,Y,Q,M0,V,.true.,interp)
            giant_total_system2(:,:,i,:,y_no,:)=V(:,:,:,:)
         end do
            R=grid0(NDEG)
            call computeMat_real(R,Y,Q,M0,V,.true.,interp)
            giant_total_system2(:,:,NDEG,:,y_no,:)=V(:,:,:,:)
      endif
      ! nu � giant(n,l,j)=V_nl(R_1,j)
      ! use the rest of the points
      ! (we can only use NDEG+1 points at a time to interpolate
      !  by an NDEG-degree polynomial)
      ! but we want to take them into account anway
!      write(*,*) 'in sub get_coeff 1 N0=',N0,' N1=',N12

      ! Copy the correct data to the giant system we will use

  !    write(*,*) 'intpol_deg 1 =',NDEG
      !write(*,*) 'Y=',Y,' M0=',M0,' Q=',Q
      do k=0,N1
         RR=grid1(k)
                                ! I1 is the index in grid0 of the startpoint in grid1 
         index_of_RR = real(I1,DP)+                                        &
     &        real(I2-I1,DP)*real(k,DP)/real(N1,DP)
                                ! interpolate the real and imaginary parts
         call interpolate_total2(index_of_RR,V,M0,y_no)
!        call computeMat_real(RR,Y,Q,M0,V,.true.,.true.)
                                !         write(*,*) 'V0=',V(:,:,0)
                                !         write(*,*) 'V1=',V(:,:,1)
         do l=0,num_norm_cusp_combs-2
                                !   e(:)=norm_cusp_combs(l+1,:)
                                ! l signifies the combination number
            do type=0,1
               do M=1,M0-1
                  TEMP=0.0_DP
                  MAXI=1
                  do j=M,M0-1
                     if(temp.lt.abs(V(j,m,type,l))) then
                        temp=abs(V(j,m,type,l))
                        maxi=j
                     endif
                  enddo
                                !    swap rows if necessary
                  if(maxi.ne.m) THEN
                     do j=1,M0
                        TT=V(maxi,j,type,l)
                        V(maxi,j,type,l)=V(m,j,type,l)
                        V(m,j,type,l)=TT
                     enddo
                  endif
                                ! normalize s.t. max(j=m+1,..,N){|U(m,j)|}=1
                                !  use that element as pivot
                  temp=V(m,m,type,l)
                  V(m,m,type,l)=1.0_DP
                  if(TEMP.eq.0.0_DP) then 
                     write(*,*) 'ERROR: pivot(',M,')== 0, system bad!!!'
                     stop
                  endif
                  do j=m+1,M0
                     V(m,j,type,l)=V(m,j,type,l)/TEMP
                  enddo
                                ! eliminate from all other rows
                  do j=1,M0-1
                     if(j.ne.m) then
                        TT=V(j,m,type,l)
                        V(j,m,type,l)=0.0_DP
                        do kk=m+1,M0
                           V(J,kk,type,l)=V(J,kk,type,l)-                  &
     &                           (TT*V(M,kk,type,l))
                        enddo
                     endif
                  enddo
               enddo
               CY(k,0,1,type,l+1)=1.0_DP
               do M=2,M0
                  CY(k,0,m,type,l+1)=V(m-1,m0,type,l)
               enddo                
            enddo
         end do
      enddo
      
      ! so now we have (grid0_size-N) sets of coefficients
      ! for each R in the grid and we must test them
      ! to conclude where in grid1 to continue searching
      ! 

!      deallocate(giant_total_system_cplx)
       end subroutine get_all_coeff_g_real

    
      !! Optimized
      !! For real coefficients, real characters  and prime index!!

      !!!  And to be used for 2 simultaneous Y-values
      !!! to utilize the K-Bessel interpolation in R 
      subroutine get_all_coeff_g_2y_real(Y1,Y2,M0,Q,N0,N1,I1,I2,           &
     &     grid0,grid1,CY1,CY2,num_comb,j_in_grid,interp,                  &
     &     grid_interp) 
      use commonvariables
      use system
      use giant_mod
      use groups
      implicit none
      real(kind=DP),dimension(0:num_cusps-1)::e
      real(kind=DP),intent(in) :: Y1,Y2
      integer:: j_in_grid ! The index we have in the grid, if>0 
      ! we don't need to calculate the first points again
      integer::y_no  ! I can't use same saved grid for different Y's
      integer :: M0  ! the size of the system
      real(kind=DP),dimension(0:N0) :: grid0 ! the grid to interpolate  over
      real(kind=DP),dimension(0:N1) :: grid1 ! the grid to compute the coefficients at
      integer :: N0,N1 ! length-1 of the two grids
      integer :: Q,I1,I2
      integer :: ex,num_comb,l_start,l_stop
      logical,optional::interp,grid_interp
      real(kind=DP) :: tmp
      real(kind=DP),dimension(0:N1,0:0,1:M0                              &
     &     ,0:1,1:num_comb-1)::CY1,CY2
      real(kind=DP), dimension(:,:,:,:),allocatable::V
      real(kind=DP) :: RR,R,index_of_RR
      integer :: i,j,k,l,M,NDEG,NN,type,maxi,kk
      real(DP)::TT,temp,epsilon
      allocate(V(1:M0-1,1:M0,0:1,0:1))
!      write(*,*) 'In get coeffs 2y'
      if(.not.(PRESENT(interp))) then
         interp=.false.
      endif
      if(.not.(PRESENT(grid_interp))) then
         grid_interp=.true.
      endif
!      write(*,*) 'Interp=',interp
                                ! just a check to see that we come here with sane values
      if((grid0(0)>grid1(0)) .or. (grid0(N0)<grid1(N1))) then
         write(*,*) 'ERROR: the grid are set up wrong!!'
         write(*,*) 'grid0:',grid0(0),grid0(N0)
         write(*,*) 'grid1:',grid1(0),grid1(N1)
         stop
      endif
      !!! If we are using invoutions we only need a single Y value
      if(grid_interp) then
         if(.not.(allocated(giant_total_system2))) then
            allocate(giant_total_system2(1:M0-1,1:M0,0:intpol_deg,0:1,         &
     &           1:2,0:1))
         else
            if(size(giant_total_system2,2).ne.M0) then
               deallocate(giant_total_system2)
               allocate(giant_total_system2(1:M0-1,1:M0,0:intpol_deg,          &
     &              0:1,1:2,0:1))
               write(*,*) ' reallocated giant matrix!'
            endif
         endif
         NDEG = intpol_deg
         if(j_in_grid.gt.0) then
            do i=0,NDEG-2
               giant_total_system2(:,:,i,:,1:2,0:1)=                             &
     &              giant_total_system2(:,:,i+2,:,1:2,0:1)
            enddo
            do i=NDEG-1,NDEG
               R=grid0(i)
               call computeMat_real(R,Y1,Q,M0,V,.true.,interp)
               giant_total_system2(:,:,i,:,1,:)=V(:,:,:,:)
               call computeMat_real(R,Y2,Q,M0,V,.true.,interp)
               giant_total_system2(:,:,i,:,2,:)=V(:,:,:,:)
            end do
         else  
                                ! If this is our first step we compute at all points
            do i=0,NDEG-1
               R=grid0(i)
               call computeMat_real(R,Y1,Q,M0,V,.true.,interp)
               giant_total_system2(:,:,i,:,1,:)=V(:,:,:,:)
               call computeMat_real(R,Y2,Q,M0,V,.true.,interp)
               giant_total_system2(:,:,i,:,2,:)=V(:,:,:,:)
            end do
            R=grid0(NDEG)
            call computeMat_real(R,Y1,Q,M0,V,.true.,interp)
            giant_total_system2(:,:,NDEG,:,1,:)=V(:,:,:,:)
            call computeMat_real(R,Y2,Q,M0,V,.true.,interp)
            giant_total_system2(:,:,NDEG,:,2,:)=V(:,:,:,:)
         endif
      endif
      ! nu � giant(n,l,j)=V_nl(R_1,j)
      ! use the rest of the points
      ! (we can only use NDEG+1 points at a time to interpolate
      !  by an NDEG-degree polynomial)
      ! but we want to take them into account anway
!      write(*,*) 'in sub get_coeff 1 N0=',N0,' N1=',N12

      ! Copy the correct data to the giant system we will use
      l_start=0
      if(num_cusps.gt.1) then 
         l_stop=num_norm_cusp_combs-2
      else
         l_stop=0
      endif
      do k=0,N1
         RR=grid1(k)
                                ! I1 is the index in grid0 of the startpoint in grid1 
         index_of_RR = real(I1,DP)+                                        &
     &        real(I2-I1,DP)*real(k,DP)/real(N1,DP)
                                ! interpolate the real and imaginary parts
         do y_no=1,2
            if(allocated(V)) deallocate(V)
            allocate(V(1:M0,1:M0,0:1,0:1))
            if(grid_interp) then
               call interpolate_total2(index_of_RR,V,M0,y_no)
            elseif(y_no.eq.1) then
               call computeMat_real(RR,Y1,Q,M0,V,.true.,interp)  
            else
               call computeMat_real(RR,Y2,Q,M0,V,.true.,interp)  
            endif
            do l=l_start,l_stop
               do type=0,1
                  do M=1,M0-1
                     TEMP=0.0_DP
                     MAXI=1
                     do j=M,M0-1
                        if(temp.lt.abs(V(j,m,type,l))) then
                           temp=abs(V(j,m,type,l))
                           maxi=j
                        endif
                     enddo
                                !    swap rows if necessary
                     if(maxi.ne.m) THEN
                        do j=1,M0
                           TT=V(maxi,j,type,l)
                           V(maxi,j,type,l)=V(m,j,type,l)
                           V(m,j,type,l)=TT
                        enddo
                     endif
                                ! normalize s.t. max(j=m+1,..,N){|U(m,j)|}=1
                                !  use that element as pivot
                     temp=V(m,m,type,l)

                     V(m,m,type,l)=1.0_DP
                     if(TEMP.eq.0.0_DP) then 
                        write(*,*) 'ERROR: pivot(',M,')= 0, system bad!'
                   !! rescue...
                        TEMP=1.0_DP-32
                        stop
                     endif
                     do j=m+1,M0
                        V(m,j,type,l)=V(m,j,type,l)/TEMP
                     enddo
                                ! eliminate from all other rows
                     do j=1,M0-1
                        if(j.ne.m) then
                           TT=V(j,m,type,l)
                           V(j,m,type,l)=0.0_DP
                           do kk=m+1,M0
                              V(J,kk,type,l)=V(J,kk,type,l)-                  &
     &                             (TT*V(M,kk,type,l))
                           enddo
                        endif
                     enddo
                  enddo
                  if(y_no.eq.1) then
                     CY1(k,0,1,type,l+1)=1.0_DP
                     do M=2,M0
                        CY1(k,0,m,type,l+1)=V(m-1,m0,type,l)
                     enddo    
                  else
                     CY2(k,0,1,type,l+1)=1.0_DP
                     do M=2,M0
                        CY2(k,0,m,type,l+1)=V(m-1,m0,type,l)
                     enddo    
                  endif
!c$$$                  if(RR.gt.9.53.and.(RR.lt.9.535)) then
!c$$$                     write(*,*) 'type=',type
!c$$$                     write(*,*) 'RR=',RR
!c$$$                     do m=1,M0
!c$$$                        write(*,*) 'C(',m,')=',CY2(k,0,m,type,1)
!c$$$                     enddo
!c$$$                     
!c$$$                  endif
               enddo
            enddo
         enddo
      enddo  ! k      
      ! so now we have (grid0_size-N) sets of coefficients
      ! for each R in the grid and we must test them
      ! to conclude where in grid1 to continue searching
      ! 
      
!      deallocate(giant_total_system_cplx)
       end subroutine get_all_coeff_g_2y_real


  !! Optimized
      !! For real coefficients, real characters  and prime index!!

      !!!  And to be used for 2 simultaneous Y-values
      !!! to utilize the K-Bessel interpolation in R 
      subroutine get_gridcoef_2y_real_new(Y1,Y2,M0,Q,N0,N1,I1,I2,        &
     &     M00,grid0,grid1,A,sym0,sym1,j_in_grid,interp,                  &
     &     grid_interp) 
      use commonvariables
      use pullback,only:clean_pullback
      use system
      use giant_mod
      use groups
      use matrix
      use sys_solve
      implicit none
      real(kind=DP),dimension(0:num_cusps-1)::e
      real(kind=DP),intent(in) :: Y1,Y2
      integer:: sym0,sym1,j_in_grid ! The index we have in the grid, if>0 
      ! we don't need to calculate the first points again
      integer::y_no  ! I can't use same saved grid for different Y's
      integer :: M0,M00  ! the size of the system
      real(kind=DP),dimension(0:N0) :: grid0 ! the grid to interpolate  over
      real(kind=DP),dimension(0:N1) :: grid1 ! the grid to compute the coefficients at
      integer :: N0,N1 ! length-1 of the two grids
      integer :: Q,I1,I2
      integer :: ex,l_start,l_stop
      logical,optional::interp,grid_interp
      real(kind=DP) :: tmp
      real(kind=DP),dimension(1:2,0:N1,1:M00,0:1,sym0:sym1)::A
!      real(kind=DP), dimension(:,:,:,:),allocatable::V
      complex(kind=DP), dimension(:,:),allocatable::UCP
      real(kind=DP), dimension(:,:,:),allocatable::U
      real(kind=DP), dimension(:,:),allocatable::CY,CYN
      complex(kind=DP), dimension(:,:),allocatable::CCY,CCNY
      real(kind=DP) :: RR,R,index_of_RR
      integer :: i,j,k,l,M,NDEG,NN,type,maxi,kk,sym_type
      real(DP)::TT,temp,epsilon,Yv(2)
      logical::reallocate
      NDEG = intpol_deg
      Yv(1:2)=(/Y1,Y2/)
      if(.not.(PRESENT(interp))) then
         interp=.false.
      endif
      if(.not.(PRESENT(grid_interp))) then
         grid_interp=.true.
      endif
!      WRITE(*,*) 'SYM0,SYM1=',SYM0,SYM1
                                ! just a check to see that we come here with sane values
      if((grid0(0)>grid1(0)) .or. (grid0(N0)<grid1(N1))) then
         write(*,*) 'ERROR: the grids are set up wrong!!'
         write(*,*) 'grid0:',grid0(0),grid0(N0)
         write(*,*) 'grid1:',grid1(0),grid1(N1)
         stop
      endif
      !!! If we are using invoutions we only need a single Y value
      reallocate=.false.
!      reallocate=.true.
      if(grid_interp) then
         if(.not.(allocated(giant_total_system3))) then
            allocate(giant_total_system3(0:intpol_deg,1:M0*num_cusps,     &
     &           1:M0*num_cusps,0:1,1:2))
         else
!!!       If we changed the M0 we have to recumpute everything
!!!       else we keep as much as we can
            if(size(giant_total_system3,2).ne.M0*num_cusps) then
               deallocate(giant_total_system3)
               allocate(giant_total_system3(0:intpol_deg,1:M0*num_cusps,                   &
     &              1:M0*num_cusps,0:1,1:2))
               reallocate=.true.
            endif
         endif
         if((j_in_grid.gt.0).and.(.not.(reallocate))) then
            do i=0,NDEG-2
               giant_total_system3(i,:,:,:,1:2)=                             &
     &              giant_total_system3(i+2,:,:,:,1:2)
            enddo
            do i=NDEG-1,NDEG
               R=grid0(i)
               call computeVnl_all_real(R,Y1,Q,M0,U,interp,-1)
               giant_total_system3(i,:,:,:,1)=U
               call computeVnl_all_real(R,Y2,Q,M0,U,interp,-1)
               giant_total_system3(i,:,:,:,2)=U
            end do
         else
            ! If this is our first step we compute at all points
            do i=0,NDEG
               R=grid0(i)
               call computeVnl_all_real(R,Y1,Q,M0,U,interp,-1)
               giant_total_system3(i,:,:,:,1)=U
                call computeVnl_all_real(R,Y2,Q,M0,U,interp)
               giant_total_system3(i,:,:,:,2)=U
            end do
         endif
      endif
      ! use the rest of the points
      ! (we can only use NDEG+1 points at a time to interpolate
      !  by an NDEG-degree polynomial)
      ! but we want to take them into account anway
      ! Copy the correct data to the giant system we will use
      l_start=0
      if(num_cusps.gt.1) then 
         l_stop=num_norm_cusp_combs-2
      else
         l_stop=0
      endif
      if(allocated(CY)) deallocate(CY)
      allocate(CY(1:num_cusps,1:M0))
      if(allocated(U)) deallocate(U)
      allocate(U(1:num_cusps*M0,1:num_cusps*M0,0:1))
      do k=0,N1
         RR=grid1(k)
! I1 is the index in grid0 of the startpoint in grid1 
         index_of_RR = real(I1,DP)+                                        &
     &        real(I2-I1,DP)*real(k,DP)/real(N1,DP)
         if(k.eq.101) then 
!            write(*,*) 'RR(',k,')=',RR
         endif
!c$$$         if(k.eq.136) then 
!c$$$            write(*,*) 'RR(',k,')=',RR
!c$$$            write(*,*) 'index_of_RR=',indeX_of_RR
!c$$$         endif
         do y_no=1,2
            if(grid_interp) then
               call interpolate_total3(index_of_RR,U,M0*num_cusps,y_no)
            else
               call computeVnl_all_real(RR,Yv(y_no),Q,M0,U,interp,-1)
            endif         
            do type=0,1
               do sym_type=sym0,sym1
!                  if(allocated(inv_ev)) deallocate(inv_ev)
!                  allocate(inv_ev(1:num_cusps))
!                  inv_ev(:)=dcmplx(real(norm_cusp_combs(sym_type,:),DP))
                  call set_cusp_norm(norm_cusp_combs(sym_type,:))
                  call solve_system_real_use_sym_lap(U(:,:,type),CY,M0,          &
     &                 .true.)
                  do m=1,M00
                     A(y_no,k,m,type,sym_type)=CY(1,m)
                  enddo
!c$$$               if((k.eq.132).and.(type.eq.0))                            
!c$$$!     &              (abs(RR-8.75).lt.0.01))  then 
!c$$$                  write(*,*) 'Y=',Yv(:),' M0=',M0
!c$$$                  write(*,*) 'inv_ev=',inv_ev(:)
!c$$$                  write(*,*) 'R=',RR
!c$$$                  do m=1,M00                     
!c$$$                     write(*,*) 'C101(1',y_no,',',type,',',sym_type,         &
!c$$$     &                    ',',m,')=',CY(1,m)
!c$$$                  enddo
!c$$$               endif
               enddo
            enddo
         enddo
      enddo                     ! k      
!      stop
      if(j_in_grid.ge.NDEG) then 
         if(allocated(giant_total_system3))                                    &
     &        deallocate(giant_total_system3)
      endif

      ! so now we have (grid0_size-N) sets of coefficients
      ! for each R in the grid and we must test them
      ! to conclude where in grid1 to continue searching
      end subroutine get_gridcoef_2y_real_new


    !!!  And to be used for 2 simultaneous Y-values
      !!! to utilize the K-Bessel interpolation in R 
      subroutine get_gridcoef_2y_cplx_new(Y1,Y2,M0,Q,N0,N1,I1,I2,        &
     &     M00,grid0,grid1,A,num_comb,j_in_grid,interp,                  &
     &     grid_interp) 
      use commonvariables
      use pullback,only:clean_pullback
      use system
      use giant_mod
      use groups
      use matrix
      use sys_solve
      implicit none
      real(kind=DP),dimension(0:num_cusps-1)::e
      real(kind=DP),intent(in) :: Y1,Y2
      integer:: j_in_grid ! The index we have in the grid, if>0 
      ! we don't need to calculate the first points again
      integer::y_no  ! I can't use same saved grid for different Y's
      integer :: M0,M00  ! the size of the system
      real(kind=DP),dimension(0:N0) :: grid0 ! the grid to interpolate  over
      real(kind=DP),dimension(0:N1) :: grid1 ! the grid to compute the coefficients at
      integer :: N0,N1 ! length-1 of the two grids
      integer :: Q,I1,I2
      integer :: ex,num_comb,l_start,l_stop
      logical,optional::interp,grid_interp
      real(kind=DP) :: tmp
      complex(kind=DP),dimension(1:2,0:N1,1:M00,1:num_comb-1)::A
!      real(kind=DP), dimension(:,:,:,:),allocatable::V
      complex(kind=DP), dimension(:,:),allocatable::UCP
      complex(kind=DP), dimension(:,:,:),allocatable::U
      complex(kind=DP), dimension(:,:),allocatable::CY
      real(kind=DP) :: RR,R,index_of_RR
      integer :: i,j,k,l,M,NDEG,NN,type,maxi,kk,sym_type
      real(DP)::TT,temp,epsilon,Yv(2)
      logical::reallocate
      integer::n_tmp,icusp,n,MM0
!      write(*,*) 'In get_all_coef M0=',M0,' Y1,Y2=',Y1,Y2
      MM0=2*M0+1
      NDEG = intpol_deg
      Yv(1:2)=(/Y1,Y2/)
      if(.not.(PRESENT(interp))) then
         interp=.false.
      endif
      if(.not.(PRESENT(grid_interp))) then
         grid_interp=.true.
      endif
                                ! just a check to see that we come here with sane values
      if((grid0(0)>grid1(0)) .or. (grid0(N0)<grid1(N1))) then
         write(*,*) 'ERROR: the grids are set up wrong!!'
         write(*,*) 'grid0:',grid0(0),grid0(N0)
         write(*,*) 'grid1:',grid1(0),grid1(N1)
         stop
      endif
      if(allocated(UCP)) deallocate(UCP)
      allocate(UCP(1:num_cusps*MM0,1:num_cusps*MM0))
      !!! If we are using invoutions we only need a single Y value
      reallocate=.false.
      reallocate=.true.
      if(grid_interp) then
         if(.not.(allocated(giant_total_system_cplx))) then
            allocate(giant_total_system_cplx(0:intpol_deg,                &
     &           1:MM0*num_cusps,1:MM0*num_cusps,1:2))
         else
!!!       If we changed the M0 we have to recumpute everything
!!!       else we keep as much as we can
            if(size(giant_total_system_cplx,2).ne.M0*num_cusps) then
               deallocate(giant_total_system_cplx)
               allocate(giant_total_system_cplx(0:intpol_deg,             &
     &              1:MM0*num_cusps,1:MM0*num_cusps,1:2))
               reallocate=.true.
            endif
         endif
         if((j_in_grid.gt.0).and.(.not.(reallocate))) then
            do i=0,NDEG-2
               giant_total_system_cplx(i,:,:,1:2)=                             &
     &              giant_total_system_cplx(i+2,:,:,1:2)
            enddo
            do i=NDEG-1,NDEG
               R=grid0(i)
               call computeVnl3_co_tot_cplx_char(R,Y1,Q,M0,UCP)
               giant_total_system_cplx(i,:,:,1)=UCP
               call computeVnl3_co_tot_cplx_char(R,Y2,Q,M0,UCP)
               giant_total_system_cplx(i,:,:,2)=UCP
            end do
         else
            ! If this is our first step we compute at all points
            do i=0,NDEG
               R=grid0(i)
               call computeVnl3_co_tot_cplx_char(R,Y1,Q,M0,UCP)
               giant_total_system_cplx(i,:,:,1)=UCP
                call computeVnl3_co_tot_cplx_char(R,Y2,Q,M0,UCP)
               giant_total_system_cplx(i,:,:,2)=UCP
            end do

         endif
      endif
      
      ! use the rest of the points
      ! (we can only use NDEG+1 points at a time to interpolate
      !  by an NDEG-degree polynomial)
      ! but we want to take them into account anway
      ! Copy the correct data to the giant system we will use
      l_start=0
      if(num_cusps.gt.1) then 
         l_stop=num_norm_cusp_combs-2
      else
         l_stop=0
      endif
      if(allocated(CY)) deallocate(CY)
      allocate(CY(1:num_cusps,-M0:M0))
      do k=0,N1
         RR=grid1(k)
! I1 is the index in grid0 of the startpoint in grid1 
         index_of_RR = real(I1,DP)+                                        &
     &        real(I2-I1,DP)*real(k,DP)/real(N1,DP)
!c$$$         if(k.eq.114) then 
!c$$$            write(*,*) 'RR(',k,')=',RR
!c$$$            write(*,*) 'index_of_RR=',indeX_of_RR
!c$$$         endif
         if(grid_interp) then
            if(allocated(U)) deallocate(U)
            allocate(U(1:num_cusps*MM0,1:num_cusps*MM0,1:2))
            call interpolate_total_cplx(index_of_RR,U,M0)
         endif
         do y_no=1,2
            if(.not.(grid_interp)) then
               call computeVnl3_co_tot_cplx_char(RR,Yv(y_no),Q,M0,UCP)
            endif         
            do sym_type=1,num_comb-1
!               if(allocated(inv_ev)) deallocate(inv_ev)
!               allocate(inv_ev(1:num_cusps))
!               inv_ev(:)=dcmplx(real(norm_cusp_combs(sym_type,:),DP))
!               write(*,*) 'sym_type=',sym_type
!               write(*,*) 'inv_e=',norm_cusp_combs(sym_type,:)
               call set_cusp_norm(norm_cusp_combs(sym_type,:))
               if(grid_interp) then 
                  call solve_system_cplx_use_sym_lap(U(:,:,y_no),CY,M0,          &
     &              .true.)
               else
                  call solve_system_cplx_use_sym_lap(UCP(:,:),CY,M0,          &
     &                 .true.)
               endif
               do m=1,M00
                  A(y_no,k,m,sym_type)=CY(1,m)

               enddo
!c$$$               if((k.eq.114).and.(sym_type.eq.num_comb-1).and.           &
!c$$$     &              (abs(RR-9.93).lt.0.1))  then 
!c$$$                  write(*,*) 'Y=',Yv(:)
!c$$$                  write(*,*) 'inv_ev=',inv_ev(:)
!c$$$                  write(*,*) 'R=',RR
!c$$$                  do m=1,M00                     
!c$$$                     write(*,*) 'C101(1',y_no,',',sym_type,',',m,')=',         &
!c$$$     &                    CY(1,m)
!c$$$                  enddo
!c$$$               endif
            enddo
         enddo
      enddo                     ! k      
      if(j_in_grid.ge.NDEG) then 
         if(allocated(giant_total_system_cplx))                                    &
     &        deallocate(giant_total_system_cplx)
      endif
      ! so now we have (grid0_size-N) sets of coefficients
      ! for each R in the grid and we must test them
      ! to conclude where in grid1 to continue searching
      end subroutine get_gridcoef_2y_cplx_new



!!!   Called with a singele vector of coefficients
      subroutine compute_coeffs_cplx2(R,C,M0_in,Y_in,Q_in)
      use commonvariables
      use system
      use sys_solve
      use characters
      use groups
      implicit none
      real(DP),intent(in)::R
      complex(kind=DP), dimension(:,:),allocatable :: C
      complex(kind=DP), dimension(:,:),allocatable :: CY,CNY
      integer::M0_in
      real(DP),optional::Y_in
      integer,optional::Q_in
      integer::j,k,m
      if(PRESENT(Q_in)) then
         call compute_coeffs_cplx(R,CY,CNY,M0_in,Y_in,Q_in)
      elseif(PRESENT(Y_in)) then
         call compute_coeffs_cplx(R,CY,CNY,M0_in,Y_in)
      else
         call compute_coeffs_cplx(R,CY,CNY,M0_in)
      endif
      m=size(CNY,2)
      if(allocated(C)) deallocate(C)
      allocate(C(1:num_cusps,-m:m))
      do k=1,num_cusps
            C(k,0)=CY(k,1)
         do j=1,m
            C(k,j)=CY(k,j+1)
            C(k,-j)=CNY(k,j)
         enddo
      enddo
      if(allocated(CY)) deallocate(CY)
      if(allocated(CNY)) deallocate(CNY)
      end subroutine compute_coeffs_cplx2

      subroutine compute_coeffs_cplx(R,CY,CNY,M0_in,Y_in,Q_in)
      use commonvariables
      use system
      use sys_solve
      use characters
      use groups
      implicit none
      real(DP),intent(in)::R
      complex(kind=DP), dimension(:,:),allocatable :: CY,CNY,U
      complex(kind=DP), dimension(:,:),allocatable :: CCY
      real(kind=DP), dimension(:,:),allocatable :: CRY
      real(kind=DP), dimension(:,:),allocatable :: CYR,CNYR,UR
      integer::M0
      integer::M0_in
      real(DP),optional::Y_in
      integer,optional::Q_in
      real(kind=DP), dimension(1:num_cusps)::e
      real(DP)::Y,diff
      integer::Q,NN,j,i,k
!      write(*,*) 'in compute_coeffs_cplx!'
      if(do_real) then 
!c$$$         e(:)=0.0D0
!c$$$         e(1)=1.0D0
!c$$$         call compute_coeffs_cplx(R,CRY,-1,e,M0_in,Y_in,Q_in)
!c$$$         allocate(CY(1:M0+1))
!c$$$         allocate(CNY(1:M0))
!c$$$         CY(:,1:M0+1)=CRY(0:M0)
!c$$$         CNY(:,1:M0)=CRY(:,-1:-M0:-1)
!c$$$         return
         write(*,*) 'Use this routine to compute complex coefficients!'
      endif
      Y=0.0_DP
      M0=M0_in
      Q=M0+10
      if(PRESENT(Y_in)) Y=Y_in
      if(PRESENT(Q_in).and.(Q_in.gt.M0)) Q=Q_in
      if(present(Q_in).and.(Q_in.gt.0).and.(M0_in.gt.0)) then 
      else
         write(*,*) 'Recomputing M,Q!!!!!!!!!!!!'
         if(real(M0*Q,DP)*Y.eq.0.0_DP) then
!     if(M0.eq.0) write(*,*) 'ERROR! M0==0! comp new M0!'
            call get_M0_Q_Y(R,M0,Q,Y)
         endif
      endif
      if(PRESENT(Q_in)) Q_in=Q
      M0_in=M0
      Q=M0+10
      if(M0.eq.0) write(*,*) 'ERROR! M0==0!'
      NN=num_cusps*(2*M0+1)
      if(allocated(CY).and.(size(CY,2).ne.M0+1))deallocate(CY)
      if(allocated(CNY).and.(size(CNYR,2).ne.M0))deallocate(CNY)
      if(.not.(allocated(CY))) allocate(CY(1:num_cusps,1:M0+1))
      if(.not.(allocated(CNY)))   allocate(CNY(1:num_cusps,1:M0))
      allocate(U(1:NN,1:NN))
!c     ! if the normalization is set we do not reset it here, otherwise call interactively
      if(.not.(set_normalization)) then
         write(*,*) 'Not normalized yet!'
         call set_norm(-1)
      endif
!      write(*,*) 'R=',R, 'M0=',M0,'Y=',Y
      if(holomorphic) then
         call computeVnl3_co_tot_cplx_w_holo(R,Y,Q,M0,U)
      else
         call computeVnl3_co_tot_cplx(R,Y,Q,M0,U)
      endif
      if(allocated(CCY)) deallocate(CCY)
      allocate(CCY(1:num_cusps,-M0:M0))
      call solve_system_cplx_use_sym_lap(U(:,:),CCY,M0)
      CY(:,1:M0+1)=CCY(:,0:M0)
      do j=1,num_cusps
         do k=1,M0
            CNY(j,k)=CCY(j,-k)
         enddo
      enddo
      end subroutine compute_coeffs_cplx


!! This is used when we have real coefficients
      subroutine compute_coeffs_real(R,CY,type,e,M0_in,Q_in,Y_in,lap_in)
      use commonvariables
      use system
      use sys_solve
      use characters
      use groups
      implicit none
      real(DP),intent(in)::R
      real(kind=DP), dimension(:,:),allocatable :: CY
      real(kind=DP), dimension(:,:,:),allocatable :: V
      integer::M0
      integer::M0_in
      logical,optional::lap_in !! do lapack 
      logical::lap !! do lapack
      real(DP),optional::Y_in
      integer,optional::Q_in
      real(kind=DP), dimension(1:num_cusps)::e
      real(DP)::Y,diff
      integer::Q,NN,j,i,type,sym_type
      
!      logical::do_real
!    write(*,*) 'Comp coeffs_real R=',R,'Y=',Y_in,'Q=',Q_in
!      write(*,*) 'type=',type
      M0=M0_in
      Q=M0+10
      lap=.false.
      if(PRESENT(lap_in)) lap=lap_in
      if(PRESENT(Y_in)) Y=Y_in
      if(PRESENT(Q_in).and.(Q_in.gt.M0)) Q=Q_in
      if(present(Q_in).and.(Q_in.gt.0).and.(M0_in.gt.0)) then 
      else
!         write(*,*) 'Recomputing M,Q!!!!!!!!!!!!'
         if(real(M0*Q,DP)*Y.eq.0.0_DP) then
!     if(M0.eq.0) write(*,*) 'ERROR! M0==0! comp new M0!'
            call get_M0_Q_Y(R,M0,Q,Y)
         endif
      endif
      if(PRESENT(Q_in)) Q_in=Q
      M0_in=M0
      Q=M0+10
      if(M0.eq.0) write(*,*) 'ERROR! M0==0!'
      NN=num_cusps*(2*M0+1)
      NN=num_cusps*M0
      if(allocated(V)) deallocate(V)
      allocate(V(1:NN,1:NN,type:type))
!     ! if the normalization is set we do not reset it here, otherwise call interactively
      if(.not.(set_normalization)) then
         write(*,*) 'Not normalized yet!'
         call set_norm(-1)
      endif
      call computeVnl_all_real(R,Y,Q,M0,V,do_interp,type)
      write(*,*) 'Computed Vnl'
      if(allocated(inv_ev)) deallocate(inv_ev)
      allocate(inv_ev(1:num_cusps))
      inv_ev(:)=e(:)
      if(allocated(CY)) deallocate(CY)
      allocate(CY(1:num_cusps,1:M0))
      call solve_system_real_use_sym_lap(V(:,:,type),CY,M0,lap)
      end subroutine compute_coeffs_real

      !! Gets a set of symmetrized coefficients
      subroutine get_all_coeff_real(R,Y,M0,Q,CY,interp,s_cs,s_inv)
      use kbessel
      use commonvariables
      use groups
      use system
      use interpolation
      implicit none
      real(DP)::R,Y,epsilon
      logical,optional::interp  !use interpolation
      integer,optional::s_cs,s_inv   ! if the eigenvalues for reflection and involution are set 
      integer::N,m,j,k,l,M0,Q
      integer::icusp,jcusp,type
      !! Two cusps only
      real(DP),dimension(1:num_cusps,1:M0,0:1,1:num_norm_cusp_combs)::CY
      real(DP),dimension(:,:,:,:),allocatable::V
      real(DP),dimension(:,:,:),allocatable::U
      complex(DP),dimension(:,:,:),allocatable::UCp
      real(DP),dimension(:,:),allocatable::Vnlije,Vnlijo
      real(DP)::n_r,l_r
      real(DP)::ypb,xpb,tmp,rkbes,argpb,arg_m,tmpVe,tmpVo
      integer::maxi,kk
      real(DP)::TT,temp,Kbes
      integer::num_intervals,er,num_er
      integer::type_start,type_stop,inv_start,inv_stop
      real(DP),dimension(1:M0*num_cusps)::AY,BY
      real(DP),dimension(1:num_cusps,1:M0*num_cusps)::AAY
      real(DP),dimension(1:num_cusps)::e
      integer::num_evals
      if(.not.(PRESENT(interp))) then
         interp=.false.
      endif
!      write(*,*) 'compute_coeff! args='
!      write(*,*) R,Y,M0,Q,interp,s_cs,s_inv  
      !! Only use interpolation if we actually gain something      
      if(interp) then
             !! Only use interpolation if we actually gain something      
         call get_ndeg_and_intervals(num_evals,R,Y)
         if(num_evals.lt.((Q*num_cusps**2+1)*M0-1)) then
            interp=.false.
         endif
      endif
      !! s_cs = 0 or 1   if cosine or sine respectively
      if((present(s_cs)).and.(s_cs.ge.0))then
         type_start=s_cs
         type_stop=s_cs
      else
         type_start=0
         type_stop=1
      endif
      !! s_inv = 0 or 1 if  w_Nf=+f or w_Nf=-f respectively
      if((present(s_inv)).and.(s_inv.gt.0)) then
         inv_start=s_inv
         inv_stop=s_inv
      elseif(num_cusps.gt.1) then
         inv_start=1
         inv_stop=num_norm_cusp_combs-1
      else
         inv_start=1
         inv_stop=1
      endif
!      write(*,*) 'inv_start,inv_stop=',inv_start,inv_stop
!      write(*,*) 'type_start,type_stop=',type_start,type_stop
!      write(*,*) 'R=',R
!      write(*,*) 'Level=',Level

      allocate(U(1:M0*num_cusps,1:M0*num_cusps,0:1))
      call computeVnl_all_real(R,Y,Q,M0,U,interp)

      allocate(UCp(1:M0*num_cusps,1:M0*num_cusps,0:1))
      UCp(:,:,:)=dcmplx(U(:,:,:))
      do l=inv_start,inv_stop
!         e(1:num_cusps)=real(norm_cusp_combs(l,1:num_cusps),DP)
!     write(*,*) 'e(',l,')=',e(:)
         call set_cusp_norm(norm_cusp_combs(l,1:num_cusps))
         do k=type_start,type_stop
!     call solve_system_Complex6(UCP(:,:,k),AY,BY,M0,e) 
            call solve_system_real_use_sym_lap(U(:,:,k),CY(:,:,k,l),M0)
         enddo
      enddo
      deallocate(U)
      end subroutine

      !! Computes for all symmetries at once
      !! and returns a matrix with coefficients for all symmetries
      subroutine get_all_coeff_evenCpl2_sym(R,Y,Q,M0,CY)
      use commonvariables
      use system
      use groups
      implicit none
      real(kind=DP),intent(in) :: R
      real(kind=DP),intent(in) :: Y
      complex(kind=DP) :: II
      integer :: Q,M0,m ! typ = sin(1) el cos(0) eps=+-1
      complex(kind=DP), dimension(1:M0*num_cusps,0:num_norm_cusp_combs-  &
     &     1,0:1) :: CY
      real(kind=DP), dimension(1:M0*num_cusps) :: AY
      real(kind=DP), dimension(1:M0*num_cusps) :: BY
!      real(kind=DP), dimension(:),allocatable :: CYtmp
      real(kind=DP), dimension(M0*num_cusps,M0*num_cusps,0:1)::URe,UIm
      complex(kind=DP), dimension(M0*num_cusps,M0*num_cusps,0:1)::UCp
      integer :: checkstat,k
      real(kind=DP), dimension(0:num_cusps-1) :: e
!      allocate(CYtmp(1:num_cusps*M0))
   !   write(*,*) 'in sub get_coeff_evenCPl2_sym R,Y,Q,M0=',R,Y,Q,M0
      II=dcmplx(0.0_DP,1.0_DP)
      call computeVnl3_co_cplx3(R,Y,Q,M0,UCp)
      do m=1,num_norm_cusp_combs-1             
         e(0:num_cusps-1)=norm_cusp_combs(m,0:num_cusps-1)                            
         call solve_system_Complex6(UCp(:,:,0),AY,BY,M0,e) 
         CY(:,m,0)=dcmplx(AY(:),BY(:))
         call solve_system_Complex6(UCp(:,:,1),AY,BY,M0,e) 
         CY(:,m,1)=dcmplx(AY(:),BY(:))
      enddo
    !  write(*,*) 'end sub get_coef'
      end subroutine get_all_coeff_evenCpl2_sym


!ccccc   Here is the section with all tests I perform to locate 
!ccccc   the true eigenvalues

      subroutine check_tests(grid0,N0,grid1,N1,                            &
     &     tests,num_tests,results,num_res,v_max,deb_in)
      ! The CY1 and CY2 vectors and the range we shall check in
      ! are  [M1,M2]xM0 
      use commonvariables
      use groups
!      use giant_mod
      use system
!      use pullback
      implicit none
      ! I now use all coefficients I can get simultaneously
      ! both cos/sin and all parities
      ! Tests is what should be zero
      logical,optional::deb_in
      real(kind=DP),dimension(0:N1,2:num_tests+1),intent(in)::tests
      real(kind=DP), dimension(0:N0),intent(in) ::grid0
      real(kind=DP), dimension(0:N1),intent(in) ::grid1
!      integer,optional::mm
      integer,intent(in) :: N0,N1,num_tests,num_res
      real(kind=DP)::R_L,R_R,MY,S_M
      ! A vector of interesting intervals together with 
      ! velocity of coefficients 
      real(kind=DP),dimension(1:num_res,1:2,1:num_tests+1)::results
      real(kind=DP),dimension(1:num_res):: v_max
      integer :: i,j,n,m,k,l,ll,n_res
      real(kind=DP),dimension(2:num_tests+1):: DY
      logical :: deb,is_zero
!      write(*,*) 'In check_tests! N1=',N1,' num_Tests=',num_tests
      deb=.false.
      if(present(deb_in)) then
         deb=deb_in
      endif
!      deb=.true.
!c$$$      open(UNIT=12,FILE='h_test2.txt',POSITION='APPEND')
!c$$$      open(UNIT=13,FILE='h_test3.txt',POSITION='APPEND')
!c$$$      open(UNIT=14,FILE='h_test4.txt',POSITION='APPEND')
      n_res=0
      results(:,:,:)=0
 1940 FORMAT('t_ev(',I2,')=',ES12.4,2X,ES12.4,' at R=',F12.6)
 1941 FORMAT('t_ev(',I2,I5,')=',ES12.4,2X,ES12.4,' at R=',F12.6)
      test_crossing: do M=0,N1-1
      if(deb) then
!         write(*,*) 'checking R:',grid1(M),',',grid1(M+1)
      endif
      is_zero=.true.
!c$$$      
!c$$$      write(12,*) grid1(M),tests(M,2) 
!c$$$      write(13,*) grid1(M),tests(M,3) 
!c$$$      write(14,*) grid1(M),tests(M,4) 
      do j=2,num_tests+1         
         if(deb) then
            write(*,1941) j,M,tests(M,j),tests(M+1,j),grid1(M)
         endif
!! Some of these we discard directly        
         if((tests(M,j)*tests(M+1,j).le.0.0_DP)) then                       
            if(deb) then
               write(*,*) 'possible zero!'
 !             write(*,*) 'possible zero!'
               write(*,1940) j,tests(M,j),tests(M+1,j),grid1(M)
            endif
            if(tests(M,j)*tests(M+1,j)<0.0_DP) then
               DY(j)=tests(M+1,j)-tests(M,j)
            endif
            
         elseif(min(abs(tests(M,j)),abs(tests(M+1,j))).lt.eps0) then
            ! WE MIGHT HAVE A ZERO ANYWAY, but we just happened to hit it
!            is_zero=.true.
            if(deb) then
               write(*,*) 'Near 0: t_ev(',j,')',tests(M,j),                       &
     &              tests(M+1,j)
            endif
            DY(j)=tests(M+1,j)-tests(M,j)
         elseif(max(abs(tests(M,j)),abs(tests(M+1,j))).gt.(1.0_DP/eps0)) &
     &           then            
           ! We might have a zero here too, but it is also at a singularity of K Bessel
!           is_zero=.true.
            if(deb) then
               write(*,*) 'Singularity: t_ev(',j,')',tests(M,j),                       &
     &              tests(M+1,j)
            endif
            DY(j)=tests(M+1,j)-tests(M,j)
         else
            is_zero=.false.
         endif
      enddo

      if(is_zero) then          ! If we have a zero for all coefficients
         R_L=grid1(M)
         R_R=grid1(M+1)       
         ! Look at the max derivative of the coefficients
         MY=maxval(abs(DY(:)))
!         write(*,*) 'DY=',DY(:)
!         write(*,*) 'MY=',MY,' antal=',real(count(DY(1:num_tests)>0),DP)
         S_M=MY/(R_R-R_L)
!!! We must have a reasonable rate of change for the coefficients
         if(abs(S_M).gt.1E+5) then 
            if(deb) then
               write(*,*) 'v_m=',S_M,' too large!'
            endif
            cycle
         endif
         n_res=n_res+1
         results(n_res,1,1)=R_L
         results(n_res,1,2:num_tests+1)=tests(M,2:num_tests+1)
         results(n_res,2,1)=R_R
         results(n_res,2,2:num_tests+1)=tests(M+1,2:num_tests+1)
         v_max(n_res)=S_M
!         results(n_res,1:3,1)=(/R_L,R_R,S_M/)
         if(deb) then
            write(*,*) 'is a zero at ',R_L,'-',R_R,' v_m=',S_M
         endif                  !               exit             ! returning to outer loop
         if(n_res.ge.num_res) then
            write(*,*) 'Too many zeros here! (i.e.',n_res,'>num_res)'
            return
         endif
      endif
      enddo test_crossing      
!      close(12)
!      close(13)
!      close(14)

      end subroutine check_tests






      !! Check the grid "grid" for crossings of the "functional" F
      !! where F and G are really a dataset on the grid
      !! we want F=G, and sometimes we use F-G=0 and other 
      !! times F/G=1

      !! For example we can call this subroutine with
      !! CY1(:,1),CY2(:,1)
      !! or with an appropriate Hecke-relation
      subroutine check_grid_for_crossings(F,G,NO,grid,NN)
      use commonvariables
      implicit none
      integer :: NN,NO
      real(kind=DP), dimension(NO,0:NN) :: F,G
      real(kind=DP), dimension(0:NN) :: grid 
      integer :: MSP,n
      integer :: j,k,l,M,no_relations
!      real(kind=DP) :: x,xh,S,NR1
      real(kind=DP) :: minimum,eps1
      real(kind=DP), dimension(-2:3,1:NO) :: diff,diff2,test,test2

      no_relations = NO ! number of relations we want to minimize
      eps1 = 0.01_DP
 !     eps2 = 0.0001_DP

      test_for_crossing : do j=2,NN-3 ! keep inside the dataset
         write(*,*) 'checking region R:',grid(j),grid(j+1)
         do n=-2,3 ! I check at the surrounding points also
                   ! but I want the crossing in the above interval
            do k=1,no_relations
               diff(n,k) = F(k,j+n)-G(k,j+n)
               if(abs(G(k,j+n)) > 0) then
                  diff2(n,k) = F(k,j+n)/G(k,j+n)
               elseif(F(k,j+n) > 0) then
                  diff2(n,k) = 1.0_DP
               else 
                  diff2(n,k) = 0.0_DP
               endif
            end do
         end do
         MSP = 0
         do k=1,no_relations
            if(diff(0,k)*diff(1,k) < 0) then ! we have a signchange
               MSP = k
            endif
         end do
         if(MSP.ne.0) then 
            ! we must check that the other relations
            ! are sufficiently satisfied
            
            ! make a Newton-Raphson approximation
            ! of the zero of the F(MSP,:)
!            x  = grid(j)
!            xh = grid(j+1)
!            S  = diff(0,MSP)/(diff(0,MSP)-diff(1,MSP))
!            NR = (1.0_DP-S)*x+S*xh
 !           write(*,*) 'NR1=',NR1            
 !           do k=1,no_relations
               
            !!! ROUGH
            do k=1,no_relations
               do n = -2,3
                  test(n,k) = abs(diff(n,k))
                  test2(n,k)= abs(diff2(n,k)-1.0_DP)
               end do
               ! minimum of a relation over the point-set
               ! (e.g. both relative and absolute min)
               minimum=min(minval(test(:,k)),minval(test2(:,k)))
               if(minimum>eps1) then
                  cycle test_for_crossing
               endif
            end do
            ! If we got this far we are at least close
            ! to a true minimum
  
            write(*,*) 'near a minimum at R=',grid(j)

         endif
      end do test_for_crossing
      end subroutine check_grid_for_crossings


   ! test Automorphy
      subroutine test_autom(D,R,type)
      use commonvariables
      use pullback
      use groups
      use characters
      implicit none
      integer :: M,Q,QY,j,k,M0
      real(kind=DP),dimension(:,:) :: D
      integer, dimension(2,2) :: mapping
      real(kind=DP) :: R,x,y,x1,y1,F,F2,Y0,F1,tmp
      integer :: xsize,ysize,type,P
      real(kind=DP) :: xmin,xmax,ymin,ymax
      character(30) :: FILENAME
      character(5) :: ANS      
      M0=size(D)
      write(*,*) 'Y?'
      read(*,*) Y
      xsize=50
      xmin=-0.5_DP
      do j=0,xsize
         x=(real(j,DP)+xmin*real(xsize,DP))/real(xsize,DP)
         F=evalMaass(x,y,D,M0,R,type)
         call pullback_to_gamma0N_map(x,y,x1,y1,mapping)
         F1=evalMaass(x1,y1,D,M0,R,type)
         call get_char(mapping(2,2),tmp)
         write(*,90) F,tmp,F1,abs(F-tmp*F1)
      enddo

 90   FORMAT(F15.7,'-',F6.3,'*',F15.7,ES12.3)      
 100  FORMAT(F6.3,1X,F6.3,1X,ES12.3)      
      end subroutine test_autom


      ! With complex coefficients and 
      ! complex exponential instead of sin/cos
      subroutine test_automCplx(D,R,type)
      use commonvariables
      use pullback
      use groups
      use characters
      implicit none
      integer :: M,Q,QY,j,k,M0
      complex(kind=DP),dimension(:,:) :: D
      complex(kind=DP)::F,F1,F2
      integer, dimension(2,2) :: mapping
      real(kind=DP) :: R,x,y,x1,y1,Y0,tmp
      integer :: xsize,ysize,type,P
      real(kind=DP) :: xmin,xmax,ymin,ymax
      character(30) :: FILENAME
      character(5) :: ANS      

      M0=size(D)
!      write(*,*) 'xsize?'
!      read(*,*) xsize
      write(*,*) 'Y?'
      read(*,*) Y
      xsize=50
      xmin=-0.5_DP
      do j=0,xsize
         x=(real(j,DP)+xmin*real(xsize,DP))/real(xsize,DP)
         if(j.eq.0) then
            write(*,*) 'x,y=',x,y
         endif
         F=evalMaass(x,y,D,M0,R,type)
                                !            call apply_map(x,y,x1,y1,S)
         call pullback_to_gamma0N_map(x,y,x1,y1,mapping)
         if(j.eq.0) then
            write(*,*) 'x*,y*=',x1,y1
            write(*,*) 'map(c)=',mapping(:,:)
         endif 
         F1=evalMaass(x1,y1,D,M0,R,type)
                                !            write(12,FMT=100) F
         call get_char(mapping(2,2),tmp)
                                !            write(*,*) 'x,y',x,y,':x1,y1',x1,y1,':','F1-chi(T)F2=',     &
                                !     &           abs(F-F1)
!         write(*,91) x,y,x1,y1,abs(F-tmp*F1)

         write(*,90) real(F,DP),dimag(F),real(F1),dimag(F1),                  & 
     &        abs(F-F1)
      enddo
 90   FORMAT(F15.6,'+I*',F15.6,'-',F15.6,'+I*',F15.6,ES12.3)      

 100  FORMAT(F6.3,1X,F6.3,1X,ES12.3)      
      end subroutine test_automCplx

!! Evaluate a Maass waveform with real coefficients
!! and hence no multiplier and only a real character possible

!!! computes f(z)*exp(Pi*R/2)
      function evalMaass_r(X,Y,C,M,R,type,hq_in)
      use commonvariables
      use kbessel
      use whittakerw
      use characters
      use groups
      use interpolation
      use pullback
      implicit none
      real(kind=DP) :: X,Y,R,YN,XN
      real(DP)::evalMaass_r
      logical,optional::hq_in
      logical::hq
      integer :: M
      integer,optional::type
      real(kind=DP),dimension(1:num_cusps,1:M)::C
      complex(DP)::multip,char1,char2,char3
      real(DP)::summa,char
      integer,dimension(2,2)::map_tmp,maptmp2,maptmp3
      real(DP),dimension(2,2)::B
      real(kind=DP) :: wt,tmp,xtmp,ytmp,xpb,ypb,xtmp2,ytmp2,l_r
      integer :: j,ind_cusp,ind_vertex
      real(DP)::alpha
      if(PRESENT(hq_in)) then
         hq=hq_in
      else
         hq=.false.
      endif
      hq=.true.
!      write(*,*) 'in evalMAss(',X,Y,'C',M,R,type,')' 
!      write(*,*) 'C=',C
      if(maxval(real(C(:,:),DP))==0.0_DP) then
         write(*,*) 'no coefficients present!'
         stop
      endif
 !     write(*,*) 'do_interp=',do_interp
 !     do_interp=.false.
      summa=0.0D0
      !!! We want to evaluate the function
      !!! with respect to the correct cusp
      !!! e.g. using the correct set of coefficients
      map_tmp=mapId
      char1=cone
!      write(*,*) 'x,y=',x,y
      call pullback_map(X,Y,xpb,ypb,map_tmp)               
      call seek_vertex(xpb,ypb,ind_vertex)
      call get_cusp_from_vertex(ind_vertex,ind_cusp)
      call apply_map_int(xpb,ypb,xtmp,ytmp,Uw(ind_vertex,:,:)) 
      if(CType.ne.0) then 
         maptmp2=MATMUL(Uw(ind_vertex,:,:),map_tmp)
         call invert_sl2z(maptmp2,maptmp3)
         ! now we are at the right cusp, and we have to normalize
         char1=get_multiplier(maptmp3,xtmp,ytmp)
                  !! This should be real
         if(dimag(char1).gt.0.0001D0) then 
            write(*,*) 'Error: we are in real algorithm and char=cplx!'
            stop
         endif
         char=real(char1,DP)
      else
         char=1.0D0
      endif
!      write(*,*) 'after'
      
      call gl_inverse(sigma_j(ind_cusp,:,:),B)
      call apply_map_re(xtmp,ytmp,xtmp2,ytmp2,B) ! W1=cuspnormalising map for cusp j
!      write(*,*) 'before'
!      write(*,*) 'xtmp2,ytmp2=',xtmp2,ytmp2
                                !!! The pullbacked point is xtmp2+i*ytmp2
      !!! and this is where we shall evaluate f...
      !!! j(sigma_I(j),z_mj^*)^k
      ! this is the complete multiplier we have to use
      call get_alphas()
      alpha=100.0_DP
      do j=1,num_cusps
         if(alphas(j).lt.alpha) then
            alpha=alphas(j)
         endif
      enddo
      summa=0.0D0
      tmp=0.0D0
      if(.not.(allocated(k_vec))) then 
         allocate(k_vec(-M:M))
         ytmp2_old=100.0D0
      elseif(size(k_vec,1).ne.(2*M+1)) then 
         deallocate(k_vec)
         allocate(k_vec(-M:M))
      endif
!      do_interp=.false.
      if(do_interp) then 
         call setup_interp_kbes(R)
      endif
      !! first we see if we use the same Y-value as before
      !! in which case we use the stored k_vec - vector
      if(Ytmp2.ne.ytmp2_old) then 
!         write(*,*) 'Ytmp2=',ytmp2
!         write(*,*) 'Ytmp2_old=',ytmp2_old
         k_vec(:)=0.0_DP
         do j=1,M
            l_r=(real(j,DP)+alphas(ind_cusp))
            YN=l_r*Ytmp2
            XN=l_r*Xtmp2
            IF(yn.EQ.0.0_DP) then 
               cycle
            endif
            if(weight.eq.0.0_DP) then
               if(do_interp) then
                  tmp=sqrt(Ytmp2)*interp_kbes(PI2*abs(YN))
               else
                  tmp=sqrt(Ytmp2)*RKBessel(R,abs(YN)*PI2)
               endif
!               write(*,*) 'kbes(',R,',',abs(YN)*PI2,')='
!               write(*,*) RKBessel(R,abs(YN)*PI2)
!               tmp=RKBessel(R,abs(YN)*PI2)*sqrt(Ytmp2)
!               write(*,*) 'tmp=',tmp
!               write(*,*) 'tmp=kbes*',sqrt(Ytmp2),'=',tmp
            else
               if(do_interp) then
                  if(YN.gt.0.0_DP) then
                     tmp=interp_whittw(1,PI4*abs(YN))
                  else
                     tmp=interp_whittw(2,PI4*abs(YN))
                  endif
               else
                  wt=weight*dsign(0.5_DP,l_r)
                  tmp=WhittW(wt,R,PI4*abs(YN))
               endif
               if(do_exceptional) then
                  tmp=tmp/((PI4*abs(real(j,DP)+alphas(ind_cusp)))            &
     &                 **(0.5_DP*weight))
               else
                  tmp=tmp/(sqrt(abs(real(j,DP)+alphas(ind_cusp))))
               endif
            endif
!            k_vec(j)=tmp*exp(-PIhalf*R)
            k_vec(j)=tmp
!            write(*,*) 'k_vec(',j,')=',tmp,'*',exp(PIhalf*R),'=',       &
!     &           k_vec(j)
!            k_vec(-j)=tmp*exp(PIhalf*R)
         enddo
      else
!         write(*,*) 'Saved Y=',ytmp2
      endif
      ytmp2_old=ytmp2
!      write(*,*) 'type=',type
      do j=1,M
         l_r=(real(j,DP)+alphas(ind_cusp))
         XN=l_r*Xtmp2
         if(type.eq.0) then 
            tmp=k_vec(j)*C(ind_cusp,j)*cos(XN*PI2)
         else
            tmp=k_vec(j)*C(ind_cusp,j)*sin(XN*PI2)

!            write(*,*) 'tmp(',j,'),',k_vec(j),'*',C(ind_cusp,j),'*',      &
!     &           sin(XN*PI2)
!            
         endif
!         write(*,*) '=',tmp
         summa=summa+tmp
         ! We might have a very large sum here, but we don't need 
         ! that many terms usually
         ! so unless hq=.true. I will stop after awhile
         if((.not.(hq)).and.(abs(tmp/summa).lt.(10.0D-15))) then
            exit
         endif
      enddo
!      write(*,*) 'Maasfval=',summa
      !! Remember that the K-Bessel function is scaled by e^(-PI*R/2)
      evalMaass_r=char*summa
!*exp(PIhalf*R)
      end function evalMaass_r
      
!!! computes f(z)*exp(Pi*R/2)    
      function evalMaass_c(X,Y,C,M,R,type,hq_in)
      use commonvariables
      use kbessel
      use whittakerw
      use characters
      use groups
      use interpolation
      use pullback
      implicit none
      real(kind=DP) :: X,Y,R,YN,XN
      complex(DP)::evalMaass_c
      logical,optional::hq_in
      logical::hq
      integer :: M
      integer,optional::type
      complex(kind=DP),dimension(1:num_cusps,-M:M)::C
      complex(DP)::tmp_c,multip,char1,char2,char3,summa
      integer,dimension(2,2)::map_tmp,maptmp2,maptmp3
      real(DP),dimension(2,2)::B
      real(kind=DP) :: wt,tmp,xtmp,ytmp,xpb,ypb,xtmp2,ytmp2,l_r
      integer :: j,ind_cusp,ind_vertex,M_start,M_stop
      real(DP)::alpha,e
      if(PRESENT(hq_in)) then
         hq=hq_in
      else
         hq=.false.
      endif
      hq=.true.
      if(present(type)) then 
         M_start=1
         if(type.eq.0) e=1.0D0
         if(type.eq.1) e=-1.0D0
      else
        M_start=-M
      endif
      M_stop=M
!      do_interp=.true.
      if(do_interp) then 
         if(weight.eq.0.0) then 
            call setup_interp_kbes(R)
         else 
            write(*,*) 'wieght=',weight
            call setup_interp_whittW(R)
         endif
      endif
      summa=czero
      !!! We want to evaluate the function
      !!! with respect to the correct cusp
      !!! e.g. using the correct set of coefficients
      map_tmp=mapId
      char1=cone
      call pullback_map(X,Y,xpb,ypb,map_tmp)               
      call seek_vertex(xpb,ypb,ind_vertex)
      call get_cusp_from_vertex(ind_vertex,ind_cusp)
      call apply_map_int(xpb,ypb,xtmp,ytmp,Uw(ind_vertex,:,:)) 
      maptmp2=MATMUL(Uw(ind_vertex,:,:),map_tmp)
      call invert_sl2z(maptmp2,maptmp3)
                                ! now we are at the right cusp, and we have to normalize
      char2=get_multiplier(maptmp3,xtmp,ytmp)
      call gl_inverse(sigma_j(ind_cusp,:,:),B)
      call apply_map_re(xtmp,ytmp,xtmp2,ytmp2,B) ! W1=cuspnormalising map for cusp j
      !!! The pullbacked point is xtmp2+i*ytmp2
      !!! and this is where we shall evaluate f...
      !!! j(sigma_I(j),z_mj^*)^k
      char3=autom_j_r(sigma_j(ind_cusp,:,:),xtmp2,ytmp2,weight)
      ! this is the complete multiplier we have to use
      multip=char1*char2*char3
      call get_alphas()
      alpha=100.0_DP
      do j=1,num_cusps
         if(alphas(j).lt.alpha) then
            alpha=alphas(j)
         endif
      enddo
      summa=dcmplx(0.0,0.0)
      tmp_c=dcmplx(0.0,0.0)
      if(.not.(allocated(k_vec))) then 
         allocate(k_vec(-M:M))
         ytmp2_old=100.0D0
      elseif(size(k_vec,1).ne.(2*M+1)) then 
         deallocate(k_vec)
         allocate(k_vec(-M:M))
      endif
      if(Ytmp2.ne.ytmp2_old) then 
!         write(*,*) 'Ytmp2=',ytmp2
!         write(*,*) 'Ytmp2_old=',ytmp2_old
         k_vec(:)=0.0_DP
         do j=M_start,M_stop
            l_r=(real(j,DP)+alphas(ind_cusp))
            YN=l_r*Ytmp2
            XN=l_r*Xtmp2
            IF(yn.EQ.0.0_DP) then 
               cycle
            endif
            if(weight.eq.0.0_DP) then
               if(do_interp) then
                  tmp=sqrt(Ytmp2)*interp_kbes(PI2*abs(YN))
               else
                  tmp=sqrt(Ytmp2)*RKBessel(R,abs(YN)*PI2)
               endif
            else
               if(do_interp) then
                  if(YN.gt.0.0_DP) then
                     tmp=interp_whittw(1,PI4*abs(YN))
                  else
                     tmp=interp_whittw(2,PI4*abs(YN))
                  endif
               else
                  wt=weight*dsign(0.5_DP,l_r)
                  tmp=WhittW(wt,R,PI4*abs(YN))
               endif
               if(do_exceptional) then
                  tmp=tmp/((PI4*abs(real(j,DP)+alphas(ind_cusp)))            &
     &                 **(0.5_DP*weight))
               else
                  tmp=tmp/(sqrt(abs(real(j,DP)+alphas(ind_cusp))))
               endif
            endif
            k_vec(j)=tmp
         enddo
      else
!         write(*,*) 'Saved Y=',ytmp2
      endif
      ytmp2_old=ytmp2
      do j=-M,M
         l_r=(real(j,DP)+alphas(ind_cusp))
         XN=l_r*Xtmp2
         if(present(type)) then 
            if(type.eq.0) then 
               tmp_c=dcmplx(k_vec(j),0.0_DP)*C(ind_cusp,j)*                            &
     &              cos(XN*PI2)
            else
               tmp_c=dcmplx(k_vec(j),0.0_DP)*C(ind_cusp,j)*                            &
     &           sin(XN*PI2)
            endif
         else
            tmp_c=dcmplx(k_vec(j),0.0_DP)*C(ind_cusp,j)*                            &
     &           exp(dcmplx(0.0,XN*PI2))
         endif
         summa=summa+tmp_c
         ! We might have a very large sum here, but we don't need 
         ! that many terms usually
         ! so unless hq=.true. I will stop after awhile
         if((.not.(hq)).and.(abs(tmp_c/summa).lt.(10.0D-15))) then
            exit
         endif
      enddo
      evalMaass_c=multip*summa
      end function evalMaass_c
      




      subroutine display_coefficients(CY,M0,N_disp,dig,offs)
      use groups
      use characters
      implicit none
      integer,intent(in) :: M0,N_disp
      integer,optional:: dig
      integer,optional::offs   ! the offset for display
      complex(kind=DP),dimension(1:M0*num_cusps),intent(in)::CY
      integer :: i,j,k

      if(.not.(PRESENT(dig))) then
         dig=7
      else
!Note this made some trouble when I earlier set dig=12 here
! and called the function with the constant argument 1
! I was then trying to modify '1'... not so good         
         dig=dig   
      endif
      if(.not.(PRESENT(offs))) then
         offs=-1
      endif
       
      write(*,*) 'FOURIER COEFFICIENTS offs=',offs
      do j=1,num_cusps
         write(*,*) 'AT Cusp(',j-1,')=',cusps(j-1,1),'/',cusps(j-1,2)
         if(offs.ge.0) then
            do k=1,N_disp
               i=k+(j-1)*M0
                                !            write(*,*) 'i=',i
               if(dig.eq.7) then
                  write(*,1700) k-offs,real(CY(i),DP),dimag(CY(i))
               else
                  write(*,3700) k-offs,real(CY(i),DP),dimag(CY(i))
               endif
            enddo
         endif
         i=(j-1)*M0
         if((real(CY(i+1))+dimag(CY(i+1))).ne.1.0) then ! else have to account for it
            write(*,1701) 2,3,6,abs(CY(i+2)*CY(i+3)*CY(i+1)*CY(i+1)-      &
     &           CY(i+6)*CY(i+1))
         else
            write(*,1701) 2,3,6,abs(CY(i+2+offs)*CY(i+3+offs)-            &
     &           CY(i+6+offs))
         endif
         write(*,*) 
      enddo
 
 1700 FORMAT('C(',I5,')=',F15.7,'+I*',F15.7)   
 1701 FORMAT('|C',I2,'*C',I2,'-C',I2,'|=',ES15.7)   


 3700 FORMAT('C(',I5,')=',F17.12,'+I*',F17.12)   
! 3701 FORMAT('|C',I2,'*C',I2,'-C',I2,'|=',ES15.7)   
      end subroutine display_coefficients


      subroutine display_coefficients2_c(CY,M0,N_disp,dig,offs_in)
      use groups
      use characters
      implicit none
      integer,intent(in) :: M0,N_disp
      integer,optional:: dig,offs_in
      integer::offs   ! the offset for display
      complex(kind=DP),dimension(1:M0),intent(in)::CY
      integer :: i,j,k

      if(.not.(PRESENT(dig))) then
         dig=7
      else
!Note this made some trouble when I earlier set dig=12 here
! and called the function with the constant argument 1
! I was then trying to modify '1'... not so good         
         dig=dig   
      endif
      IF(.NOT.(PRESENT(offs_in))) then
         offs=1
      else
         offs=offs_in
      endif
      if(weight.gt.2) then
         dig=12
      endif
      dig=12
      write(*,*) 'FOURIER COEFFICIENTS'
      do k=1,N_disp
         i=k
         if(dig.eq.7) then
            write(*,6700) k-offs,real(CY(i),DP),dimag(CY(i))
         elseif(dig.eq.12) then
            if(abs(CY(i)).lt.1.0E5) then
               write(*,6703) k-offs,real(CY(i),DP),dimag(CY(i))
            else
               write(*,6705) k-offs,real(CY(i),DP),dimag(CY(i))
            endif
         else
            if(abs(CY(i)).lt.1.0E3) then
               write(*,6702) k-offs,real(CY(i),DP),dimag(CY(i))
            else
               write(*,6704) k-offs,real(CY(i),DP),dimag(CY(i))
            endif
         endif
      enddo
      i=0
      if(size(CY,1).ge.(i+6+offs)) then
      if((real(CY(i+1))+dimag(CY(i+1))).ne.1.0) then ! else have to account for it
         write(*,6701) 2,3,6,abs(CY(i+2+offs)*CY(i+3+offs)/                    &
     &        CY(i+1+offs)-CY(i+6+offs))
      else
         write(*,6701) 2,3,6,abs(CY(i+2+offs)*CY(i+3+offs)/CY(i+1+offs)       &
     &        -CY(i+6+offs))
      endif
      !! We also write a normalized by c(j)/c(0)

      if((i+offs.lt.M0).and.(i+offs.gt.1)) then 
         if(abs(CY(i+offs)).gt.1.0E-15_DP) then ! else have to account for it
            write(*,6706) 2,3,6,abs(CY(i+2+offs)*CY(i+3+offs)/                    &
     &           CY(i+offs)-CY(i+6+offs))
         endif
      endif
      endif
      write(*,*) 
 6700 FORMAT('C(',I5,')=',F15.7,'+I*',F15.7)   
 6701 FORMAT('|C',I2,'*C',I2,'-C',I2,'|=',ES12.3)   
 6706 FORMAT('|C',I2,'*C',I2,'/C0-C',I2,'|=',ES12.3)   


 6702 FORMAT('C(',I5,')=',F19.14,'+I*',F19.14)   
 6703 FORMAT('C(',I5,')=',F22.14,'+I*',F22.14)   
      !!! If the numbers are too large
 6704 FORMAT('C(',I5,')=',ES19.14,'+I*',ES19.14)   
 6705 FORMAT('C(',I5,')=',ES22.14,'+I*',ES22.14)   
! 3701 FORMAT('|C',I2,'*C',I2,'-C',I2,'|=',F15.7)   
      end subroutine display_coefficients2_c

      subroutine display_coefficients2_r(CY,M0,N_disp,dig,offs_in)
      use groups
      use characters
      implicit none
      integer,intent(in) :: M0,N_disp
      integer,optional:: dig,offs_in
      integer::offs   ! the offset for display
      real(kind=DP),dimension(1:M0),intent(in)::CY
      integer :: i,j,k

      if(.not.(PRESENT(dig))) then
         dig=7
      else
!Note this made some trouble when I earlier set dig=12 here
! and called the function with the constant argument 1
! I was then trying to modify '1'... not so good         
         dig=dig   
      endif
      IF(.NOT.(PRESENT(offs_in))) then
         offs=1
      else
         offs=offs_in
      endif
      if(weight.gt.2) then
         dig=12
      endif
      dig=12
      write(*,*) 'FOURIER COEFFICIENTS'
      do k=1,N_disp
         i=k
         if(dig.eq.7) then
            write(*,7700) k-offs,CY(i)
         elseif(dig.eq.12) then
            if(abs(CY(i)).lt.1.0E5) then
               write(*,7703) k-offs,CY(i)
            else
               write(*,7705) k-offs,CY(i)
            endif
         else
            if(abs(CY(i)).lt.1.0E3) then
               write(*,7702) k-offs,CY(i)
            else
               write(*,7704) k-offs,CY(i)
            endif
         endif
      enddo
      i=0
      if(size(CY,1).ge.(i+6+offs)) then
      if(CY(i+1).ne.1.0) then ! else have to account for it
         write(*,7701) 2,3,6,abs(CY(i+2+offs)*CY(i+3+offs)/                    &
     &        CY(i+1+offs)-CY(i+6+offs))
      else
         write(*,7701) 2,3,6,abs(CY(i+2+offs)*CY(i+3+offs)/CY(i+1+offs)       &
     &        -CY(i+6+offs))
      endif
      !! We also write a normalized by c(j)/c(0)

      if((i+offs.lt.M0).and.(i+offs.gt.1)) then 
         if(abs(CY(i+offs)).gt.1.0E-15_DP) then ! else have to account for it
            write(*,7706) 2,3,6,abs(CY(i+2+offs)*CY(i+3+offs)/                    &
     &           CY(i+offs)-CY(i+6+offs))
         endif
      endif
      endif

      
      write(*,*) 
 7700 FORMAT('C(',I5,')=',F15.7)   
 7701 FORMAT('|C',I2,'*C',I2,'-C',I2,'|=',ES12.3)   
 7706 FORMAT('|C',I2,'*C',I2,'/C0-C',I2,'|=',ES12.3)   


 7702 FORMAT('C(',I5,')=',F19.14)   
 7703 FORMAT('C(',I5,')=',F22.14)   
      !!! If the numbers are too large
 7704 FORMAT('C(',I5,')=',ES19.14)   
 7705 FORMAT('C(',I5,')=',ES22.14)   
! 3701 FORMAT('|C',I2,'*C',I2,'-C',I2,'|=',F15.7)   
      end subroutine display_coefficients2_r




      subroutine display_hecke(CY,M0,offs,hecke)
      use groups
      use characters
      implicit none
      integer,intent(in) :: M0
      integer,optional::offs   ! the offset for display
      real(DP),optional::hecke
      complex(kind=DP),dimension(1:M0),intent(in)::CY
      integer :: i,j,k
      write(*,*) 'FOURIER COEFFICIENTS'
      
      if((real(CY(1))+dimag(CY(1))).ne.1.0) then ! else have to account for it
         hecke=abs(CY(2+offs)*CY(3+offs)*                                  &
     &        CY(1+offs)*CY(1+offs)-CY(6+offs)*CY(1+offs))
         write(*,7701) 2,3,6,hecke
      else
         hecke=abs(CY(2+offs)*CY(3+offs)-CY(6+offs))
         write(*,7701) 2,3,6,hecke
      endif
      write(*,*)  
 7701 FORMAT('|C',I2,'*C',I2,'-C',I2,'|=',ES12.3)   
      end subroutine display_hecke


      subroutine display_hecke_r(CY,M0,offs,hecke)
      use groups
      use characters
      implicit none
      integer,intent(in) :: M0
      integer,optional::offs   ! the offset for display
      real(DP),optional::hecke
      real(kind=DP),dimension(1:M0),intent(in)::CY
      integer :: i,j,k
      write(*,*) 'FOURIER COEFFICIENTS'
      
      if(CY(1).ne.1.0) then ! else have to account for it
         hecke=abs(CY(2+offs)*CY(3+offs)*                                  &
     &        CY(1+offs)*CY(1+offs)-CY(6+offs)*CY(1+offs))
         write(*,7701) 2,3,6,hecke
      else
         hecke=abs(CY(2+offs)*CY(3+offs)-CY(6+offs))
         write(*,7701) 2,3,6,hecke
      endif
      write(*,*)  
 7701 FORMAT('|C',I2,'*C',I2,'-C',I2,'|=',ES12.3)   
      end subroutine display_hecke_r

      !! Display a set of symmetrized real coefficients
      subroutine display_coefficients_real(CY,M0,N_disp,dig,offs)
      use groups
      use characters
      implicit none
      integer,intent(in) :: M0,N_disp
      integer,optional:: dig,offs
      real(kind=DP),dimension(1:M0),intent(in)::CY
      integer :: i,j,k

      if(.not.(PRESENT(dig))) then
         dig=7
      else
!Note this made some trouble when I earlier set dig=12 here
! and called the function with the constant argument 1
! I was then trying to modify '1'... not so good         
         dig=dig   
      endif
      if(.not.(PRESENT(offs))) then
         offs=0
      endif
       write(*,*) 'FOURIER COEFFICIENTS'

!        write(*,*) 'AT Cusp(',j-1,')=',cusps(j-1,1),'/',cusps(j-1,2)
       if(offs.ge.0) then
          do k=1,N_disp
             if(dig.eq.7) then
                write(*,1800) k-offs,CY(k)
             else
                write(*,3800) k-offs,CY(k)
             endif
          enddo      
       endif
       write(*,1801) 2,3,6,abs(CY(2)*CY(3)-CY(6))
       write(*,*) 
 
 1800 FORMAT('C(',I5,')=',F15.7)   
 1801 FORMAT('|C',I2,'*C',I2,'-C',I2,'|=',ES12.3)   
 3800 FORMAT('C(',I5,')=',F20.14)   
! 3801 FORMAT('C(',I5,')=',F17.12)   

! 3701 FORMAT('|C',I2,'*C',I2,'-C',I2,'|=',ES15.7)   
      end subroutine display_coefficients_real


      subroutine display_differences(CY1,CY2,M0,sym,N_disp,dig)
      use groups
      use characters
      implicit none
      integer,intent(in) :: M0,N_disp
      integer,optional:: dig
      ! THese should now simply have length M0
      ! E.g. we are supposed to compare expansions at different cusps
      complex(kind=DP),dimension(1:M0),intent(in)::CY1,CY2
      complex(kind=DP),dimension(1:M0)::CY
      real(DP)::sym
      integer :: i,j,k,nn

      if(.not.(PRESENT(dig))) then
         dig=7
      else         
!Note this made some trouble when I earlier set dig=12 here
! and called the function with the constant argument 1
! I was then trying to modify '1'... not so good         
         dig=dig   
      endif
      do j=1,M0
         CY(j)=CY1(j)-dcmplx(sym)*CY2(j)
      enddo
!      write(*,*) 'FOURIER COEFFICIENTS'
      NN=min(M0,N_disp)
      do k=1,NN
                                         !            write(*,*) 'i=',i
         if(dig.eq.7) then
            write(*,1700) k,real(CY(k),DP),dimag(CY(k))
         else
            write(*,3700) k,real(CY(k),DP),dimag(CY(k))
         endif
      enddo
         
 1700 FORMAT('C(',I5,')=',F15.7,'+I*',F15.7)   
 1701 FORMAT('|C',I2,'*C',I2,'-C',I2,'|=',F15.7)   
 3700 FORMAT('C(',I5,')=',F17.12,'+I*',F17.12)   
! 3701 FORMAT('|C',I2,'*C',I2,'-C',I2,'|=',F15.7)   
      end subroutine display_differences



      ! Cusp = 0 means we only print coefficients at one cusp
      ! by symmetry reasons  

      subroutine print_coefficients(CY,M0,N_disp,pr_real,cusp,             &
     &     dig,FILENAME)
      use groups
      use characters
      implicit none
      integer,intent(in) :: M0,N_disp
      integer,optional:: dig
      complex(kind=DP),dimension(1:num_cusps*M0),intent(in)::CY
      integer :: i,j,k,cusp
      logical,optional::pr_real
      CHARACTER*35::FILENAME
      if(.not.(PRESENT(pr_real))) then
         pr_real=.false.
      endif
      if(.not.(PRESENT(dig))) then
         dig=7
      endif
      
      FILENAME=trim(FILENAME)
      write(*,*) 'filename=',FILENAME
!      write(*,*) 'AT Cusp(',j-1,')=',cusps(j-1,1),'/',cusps(j-1,2)
      open(unit=12,FILE=FILENAME)
      do k=1,N_disp
         i=k+(cusp)*M0
         if(dig.eq.7) then
            write(12,1700) CY(i)   !real(CY(i),DP),dimag(CY(i))
         else
            write(12,3700) CY(i)    !real(CY(i),DP),dimag(CY(i))
!            write(12,*) CY(i)    !real(CY(i),DP),dimag(CY(i))
         endif
      enddo
      close(12)
 1700 FORMAT(F15.7,F15.7,'i')   
 3700 FORMAT(F17.12,3X,F17.12)   
      end subroutine


      !!! Choose suitable i1, i2 and i3
      !!! for a given Level, character type and possibly
      !!! solution parameter (i.e. if some coefficients are set
      !!! (and also a possible upper restriction by M0)
      subroutine choose_i1i2i3(i1,i2,i3,M0,param)
      use groups
      use characters
      implicit none
      integer::i1,i2,i3,M0
      integer,optional::param
      integer::par,j
      logical::no_i1,no_i2,no_i3
      real(DP)::char_r
      if(PRESENT(param))then
         par=param
      else
         par=0
      endif
      if(par.eq.-1) then  !interactive unless already set 
         if((i1_set*i2_set*i3_set).eq.0) then
            write(*,*) 'Set :'
            write(*,*) 'i1,i2,i3='
            read(*,*) i1_set,i2_set,i3_set
         endif
         i1=i1_set
         i2=i2_set
         i3=i3_set            
         return
      else
      !!! Standard choice
      i1=2
      i2=3
      i3=4
      endif


      !!! Standard choice if param is set
      if(abs(par).eq.2) then
         i1=5
      elseif(abs(par).eq.3) then
         i2=5            
      elseif(abs(par).eq.4) then
         i3=5            
      endif
      if(from_perm) then 
         if((par.eq.0).or.(par.eq.1)) then            
         elseif(M0.gt.(4*abs(par)+3)) then
            i1=2*abs(par)
            i2=3*abs(par)
            i3=4*abs(par)
         elseif(abs(par).le.2) then
            !!! The coefficient which is set is min(Level,M0)
            if(min(Level,M0).eq.2) then
               i1=3
               i2=4
               i3=5
            elseif(min(Level,M0).eq.3) then
               i1=2
               i2=4
               i3=5
            elseif(min(Level,M0).eq.4) then
               i3=5
            endif
         elseif(abs(par).eq.3) then
            i1=2
            i2=4
            i3=5
         elseif(abs(par).eq.4) then
            i3=5                   
         endif
         !!! If 4 or 9 divides the index and it is a congruence group
        !!! the c2,c4 or c3 are =0
      elseif(MOD(Level,9).eq.0) then
         i2=5
      elseif(MOD(Level,4).eq.0) then
         if((weight.gt.0.0).and.(.not.(do_eta))) then
            !!! So we are in the case of theta-multiplier
            !!! and we must use different normalizations
            !!! depending on the parameter param
            i1=2
            i2=3
            i3=4
            if(param.ge.1) then !! set c1=1, c2=0
               i1=4              !! =>cn=0, n==2,3 mod 4
               i2=5
               i3=8

            elseif(param.eq.-2) then !! c2=1, c1=0 
               i1=3
               i2=4
               i3=5
            elseif(param.eq.-3) then !! c3=1, c1=0
               i2=4
               i3=5
            elseif(param.eq.-4) then
               i3=5
            endif
         else            
            i1=3
            i2=5
            i3=7
         endif
      elseif(CType.eq.1) then
         !! If we have a character we might have a CM-form with many 
                                !! zero coefficients.
         no_i1=.true.
         no_i2=.true.
         no_i3=.true.
         if(MOD(Level,4).eq.1) then !! It is likely we have a CM-form
            do j=2,min(3*Level,M0)
               call get_char(j,char_r)
               if(is_prime(j).or.((.not.(is_square_free(j))).and.           &
     &              (char_r.eq.1))) then
                  if(no_i1.and.(char_r.ne.(-1.0_DP))) then
                     i1=j
                     no_i1=.false.
                     cycle
                  endif
                  if(no_i2.and.(char_r.ne.(-1.0_DP))) then
                     i2=j
                     no_i2=.false.
                     cycle
                  endif
                  if(no_i3.and.(char_r.ne.(-1.0_DP))) then
                     i3=j
                     no_i3=.false.
                     cycle
                  endif
               endif
            enddo               
         endif
      endif
      i1_set=i1;i2_set=i2;i3_set=i3
      end subroutine




!! compute Hecke relations for characters, i.e. c(a)c(b)=sum_{d|(a,b)} chi(d)c(ab/d^2)

      subroutine Hecke_relations_cplx(C,M,a_in,b_in,diff)
      use commonvariables
      use characters
      integer::j,N,a_in,b_in,a,b
      complex(DP),dimension(1:M)::C
      integer::d,m,sgd,x,y
      complex(DP)::tmp,char
      complex(DP)::diff
      a=abs(a_in)
      b=abs(b_in)
      if(a*b.gt.M) then
!         write(*,*) 'Not enough coefficients present for this test!'
!         write(*,*) 'a,b=',a,b
!         write(*,*) 'M=',M
         diff=0.0_DP
         return
      elseif(a*b.eq.0) then 
         write(*,*) 'Do not use 0 in Hecke relation!'
         write(*,*) 'm,n=',a,b
      endif       
      tmp=0.0_DP
      call gcd(a,b,sgd,x,y)
!      write(*,*) 'sgd=',sgd
       do d=1,sgd
         if(MOD(sgd,d).eq.0) then
            j=(a/d)*(b/d)
!! note that the character should be 0 for (d,N)>1
            call get_char(d,char)
            tmp=tmp+C(j)*char
         endif
      enddo
      diff=(C(a)*C(b)-tmp)
!      if(PRESENT(diff_arg)) then 
!         diff_arg=argument(C(a)*C(b)-tmp)
!      endif
!      write(*,1660) a,b,diff
! 1660 FORMAT('C(',I4,')C(',I4,')-Sum_d|(m,n) chi(d)*C(ab/d^2)=',ES30.20)
      end subroutine Hecke_relations_cplx

      subroutine Hecke_relations_re(C,M,a_in,b_in,diff)
      use commonvariables
      use characters
      integer::j,N,a_in,b_in,a,b
      real(DP),dimension(1:M)::C
      integer::d,m,sgd,x,y
      real(DP)::tmp,char
      real(DP)::diff
      a=abs(a_in)
      b=abs(b_in)
      if(a*b.gt.M) then
         diff=0.0_DP
         return
      elseif(a*b.eq.0) then 
         write(*,*) 'Do not use 0 in Hecke relation!'
         write(*,*) 'm,n=',a,b
      endif       
      tmp=0.0_DP
      call gcd(a,b,sgd,x,y)
       do d=1,sgd
         if(MOD(sgd,d).eq.0) then
            j=(a/d)*(b/d)
!! note that the character should be 0 for (d,N)>1
            call get_char(d,char)
            tmp=tmp+C(j)*char
         endif
      enddo
      diff=(C(a)*C(b)-tmp)
      end subroutine Hecke_relations_re


      subroutine Hecke_relations_w(C,CN,R,M0,a_in,b_in,diff)
      use commonvariables
      use characters
!      use ISO_VARYING_STRING
      implicit none
      integer::N,a_in,b_in,a,b,DD,M0
      complex(DP),dimension(0:M0)::C
      complex(DP),dimension(1:M0)::CN
      real(DP)::R,LHS,RHS,FAKTOR
      integer::d,m,sgd,x,y
      complex(DP)::tmp,tmp2,char
      complex(DP)::diff,II,C1,C2
      integer::k,j,m1,m2
      logical::deb_loc
      character(LEN=100)::OUTPUT
      character(LEN=100)::tmp_str
      deb_loc=.true.
      a=abs(a_in)
      b=abs(b_in)
      k=dnint(weight)
      II=dcmplx(0.0,1.0_DP)
      OUTPUT='|'
 !     UTPUT='|'
      if(k.eq.0) then 
         write(*,*) 'Use only for weight<>0!'
         return
      endif
      call gcd(k,12,sgd,x,y)
      DD=k/sgd
      write(*,*) 'k=',k,'DD=k/(k,12)=',DD,' R,M=',r,M0
      !! compute the left hand sides
      
      if(mod(k*(a-1),12).eq.0) then
         !! ka==k mod 12
         m1=k*(a-1)/12
         m2=k*(a-DD*DD)/(12*D**2)
         if(m2.gt.M0) then 
            write(*,*) 'Not enough coefficients m2=',m2
            return
         endif
         C1=C(m1)
 !        UTPUT= UTPUT  // '[ C(',m1,')'  
         tmp_str='C('//integer_to_char(m1)//')'
         output=OUTPUT//TRIM(TMP_STR)
!         call INSERT(OUTPUT,201,trim(tmp_str))
!         OUTPUT= '[ C(',m1,')' // trim(OUTPUT) 
         write(*,*) 'a:m1=',m1,'C(m1)=',C(m1)
         if(DD>1) then 
            char=II**dcmplx(real(2*k*(1-DD),DP),0.0)
            C1=C1+char*C(m2)
            write(*,*) 'a:m2=',m2,'C(m2)=',C(m2)
            tmp_str='+chi('//integer_to_char(DD)//',)*C('//                       &
     &           integer_to_char(m2)//') ]'
            output=OUTPUT//TRIM(TMP_STR)            
!            call INSERT(OUTPUT,201,trim(tmp_str))
         else
            output=OUTPUT//TRIM(TMP_STR)
!           call INSERT(OUTPUT,201,' ]')
         endif
         !! We need the same congruence for b too
         if(mod(k*(b-1),12).ne.0) then 
            write(*,*) 'a,b=',a,b,' Need same congruence!'
            return
         endif
         m1=k*(b-1)/12
         m2=k*(b-DD*DD)/(12*DD**2)
         if(m2.gt.M0) then 
            write(*,*) 'Not enough coefficients m2=',m2
            return
         endif
         tmp_str='[ C('//integer_to_char(m1)//')'
         output=OUTPUT//TRIM(TMP_STR)
!         call INSERT(OUTPUT,201,trim(tmp_str))
         C2=C(m1)
         write(*,*) 'b:m1=',m1,'C(m1)=',C(m1)
         if(DD>1) then 
            C2=C2+II**dcmplx(real(2*k*(1-DD),DP),0.0)*C(m2)
            tmp_str='+chi('//integer_to_char(DD)//',)*C('//                       &
     &           integer_to_char(m2)//') ]'
            output=OUTPUT//TRIM(TMP_STR)
!  call INSERT(OUTPUT,201,trim(tmp_str))
            write(*,*) 'b:m2=',m2,'C(m2)=',C(m2)
         endif
         LHS=C1*C2
         FAKTOR=1.0_DP                 
      elseif(mod(k*(a+1),12).eq.0) then
           !! ka==-k mod 12
         m1=k*(a+1)/12
         m2=k*(a+DD*DD)/(12*DD**2)
         C1=CN(m1)
         if(m2.gt.M0) then 
            write(*,*) 'Not enough coefficients m2=',m2
            return
         endif
         if(DD>1) then 
            C1=C1+II**dcmplx(real(2*k*(1-DD),DP),0.0)*CN(m2)
         endif
         if(mod(k*(b+1),12).ne.0) then 
            write(*,*) 'a,b=',a,b,' Need same congruence!'
            return
         endif
         m1=k*(b+1)/12
         m2=k*(b+DD*DD)/(12*DD**2)
         if(m2.gt.M0) then 
            write(*,*) 'Not enough coefficients m2=',m2
            return
         endif
         C2=C(m1)
         if(DD>1) then 
            C2=C2+II**dcmplx(real(2*k*(1-DD),DP),0.0)*C(m2)
         endif
         LHS=C1*C2
         FAKTOR=LambdaR(k,R)    
      else
         write(*,*) 'ERROR: need congruence mod 12!'
         write(*,*) 'k=',k,' a,b=',a,b
         write(*,*) ' ka mod 12=',mod(k*a,12)
         write(*,*) ' kb mod 12=',mod(k*b,12)
         return
      endif
      !! The right hand side
      tmp=0.0_DP
      tmp2=0.0_DP
      if(FAKTOR.eq.1.0) then 
         tmp_str='-C(0)*['
         output=OUTPUT//TRIM(TMP_STR)
!         call INSERT(OUTPUT ,201, '-C(0)*[')
      else
         tmp_str= '-C(0)*lambda_k,R*['
         output=OUTPUT//TRIM(TMP_STR)
!         call INSERT(OUTPUT ,201, '-C(0)*lambda_k,R*[')
      endif
      call gcd(a,b,sgd,x,y)
      do d=1,sgd
         if(MOD(sgd,d).eq.0) then
            j=(a/d)*(b/d)            
            m1=k*(j-1)/12
            tmp2=C(m1)
            tmp_str='chi('//integer_to_char(d)//')*[C('//                          &
     &           integer_to_char(m1)//') '
            output=OUTPUT//TRIM(TMP_STR)
!           call INSERT(OUTPUT ,201,trim(tmp_str))
            write(*,*) 'c:m1=',m1,'C(m1)=',C(m1)
            if(mod(DD,j).eq.0) then 
               m2=k*(j-DD*DD)/12/DD/DD
               char=II**dcmplx(real(2*k*(1-DD),DP),0.0)
               tmp2=tmp2+char*C(m2)
               tmp_str='+chi('//integer_to_char(DD)//')*C(' //                       &
     &              integer_to_char(m2) //') ]'
               write(*,*) 'c:m2=',m2,'chi*C(m2)=',char*C(m2)
               output=OUTPUT//TRIM(TMP_STR)
!     call INSERT(OUTPUT,201,trim(tmp_str))
            else
               output=OUTPUT//']'
!               call INSERT(OUTPUT,201,']')
            endif
            char=II**dcmplx(real(2*k*(1-d),DP),0.0)
            tmp=tmp+tmp2*char
         endif
         output=OUTPUT//']'
!         call INSERT(OUTPUT,201,']')
      enddo
      output=OUTPUT//'|'
!      call INSERT(OUTPUT,201,'|')
      RHS=FAKTOR*C(0)*tmp
      diff=abs(LHS/RHS-1.0_DP)
      write(*,*) 'LHS=',LHS
      write(*,*) 'RHS=',RHS
      write(*,*) '|lhs-rhs|=',abs(LHS-RHS)
      write(*,*) '|lhs/rhs-1|=',abs(LHS/RHS-1.0_DP)
      write(*,*) OUTPUT
!      diff=(C(a)*C(b)-tmp)
!      if(PRESENT(diff_arg)) then 
!         diff_arg=argument(C(a)*C(b)-tmp)
!      endif
!      write(*,1660) a,b,diff
! 1660 FORMAT('C(',I4,')C(',I4,')-Sum_d|(m,n) chi(d)*C(ab/d^2)=',ES30.20)
      end subroutine




      function LambdaR(k,R)
      implicit none
      real(DP)::LambdaR,R,tmp
      integer::k,j,l
      if(mod(k,2).eq.0) then 
         tmp=1.0_DP
         l=k/2
         do j=0,l-1
            tmp=tmp*(real(2*j,DP)+0.25_DP*R*R)**2
         enddo
      elseif(mod(k,2).eq.1) then
         tmp=-R*R
         l=(k-1)/2
         do j=1,l
            tmp=tmp*(real(j,DP)**2+R*R)**2
         enddo
      endif
      LambdaR=tmp
      end function LambdaR




      function MaassWf_c(X,Y,C,M,R,type,hq_in)
      use commonvariables
      use interpolation
      use kbessel
      use whittakerw
      use characters
      use groups
      use pullback
      implicit none
      real(kind=DP) :: X,Y,R,YN,XN
      complex(DP)::MaassWf_c
      logical,optional::hq_in
      logical::hq
      integer :: M
      integer,optional::type
      complex(kind=DP),dimension(1:num_cusps,-M:M)::C
      complex(DP)::tmp_c,multip,char1,char2,char3,summa
      integer,dimension(2,2)::map_tmp,maptmp2,maptmp3
      real(DP),dimension(2,2)::B
      real(kind=DP) :: wt,tmp,xtmp,ytmp,xpb,ypb,xtmp2,ytmp2,l_r
      integer :: j,ind_cusp,ind_vertex
      real(DP)::alpha
      if(PRESENT(hq_in)) then
         hq=hq_in
      else
         hq=.false.
      endif
      hq=.true.
!      write(*,*) 'in evalMAss(',X,Y,'C',M,R,type,')' 
!      write(*,*) 'C=',C
      if(maxval(real(C(:,:),DP))==0.0_DP) then
         write(*,*) 'no coefficients present!'
         stop
      endif
 !     write(*,*) 'do_interp=',do_interp
 !     do_interp=.false.
      summa=czero
      !!! WE want to evaluate the function
      !!! with respect to the correct cusp
      !!! e.g. using the correct set of coefficients
!      icusp=0
      map_tmp=mapId
 !     B=Id
!      xtmp=Xm(j)
!      ytmp=Y
!      B(:,:)=real(Id(:,:),DP)
!      !!! j(sigma_j,z_m)^-k
!      char1=autom_j_r(B,X,Y,-1.0_DP*weight)
      char1=dcmplx(1.0_DP,0.0_DP)
      call pullback_to_gamma0N_map(X,Y,xpb,ypb,map_tmp)               
      call seek_vertex(xpb,ypb,ind_vertex)
      call get_cusp_from_vertex(ind_vertex,ind_cusp)
            ! first get to the corresponding cusp                     
      call apply_map_int(xpb,ypb,xtmp,ytmp,Uw(ind_vertex,:,:)) 
      maptmp2=MATMUL(Uw(ind_vertex,:,:),map_tmp)
      call invert_sl2z(maptmp2,maptmp3)
                                ! now we are at the right cusp, and we have to normalize
      char2=get_multiplier(maptmp3,xtmp,ytmp)
!      write(*,*) 'multip(B)=',multiplier(maptmp3)
                                !     char21=autom_j_r(real(maptmp3(:,:),DP),xtmp,ytmp,weight)
      call gl_inverse(sigma_j(ind_cusp,:,:),B)
      call apply_map_re(xtmp,ytmp,xtmp2,ytmp2,B) ! W1=cuspnormalising map for cusp j
      !!! The pullbacked point is xtmp2+i*ytmp2
      !!! and this is where we shall evaluate f...
      !!! j(sigma_I(j),z_mj^*)^k
      char3=autom_j_r(sigma_j(ind_cusp,:,:),xtmp2,ytmp2,weight)
                                ! this is the complete multiplier we have to use
      multip=char1*char2*char3
!c$$$      if(abs(char1*char2*char3).eq.0.0_DP) then
!c$$$         write(*,*) 'char1=',char1
!c$$$         write(*,*) 'char2=',char2
!c$$$         write(*,*) 'char3=',char3
!c$$$      endif
!c$$$      
!c$$$      write(*,*) 'pullback=',xpb,ypb
!c$$$      write(*,*) 'to cusp=',xtmp,ytmp
!c$$$      write(*,*) 'final=',xtmp2,ytmp2
!c$$$      write(*,*) 'cusp=',ind_cusp
!c$$$      
!c$$$      write(*,*) 'pullback_map=[[',map_tmp(1,:),'],[',map_tmp(2,:),']]'
!c$$$      write(*,*) 'pullba_map=[[',maptmp3(1,:),'],[',maptmp3(2,:),']]'
!c$$$      write(*,*) 'sigma_j=[[',B(1,:),'],[',B(2,:),']]'
!c$$$      write(*,*) 'multip=',char1,'*',char2,'*',char3,'=',multip
      call get_alphas()
      alpha=100.0_DP
      do j=1,num_cusps
         if(alphas(j).lt.alpha) then
            alpha=alphas(j)
         endif
      enddo
 
      summa=dcmplx(0.0,0.0)
      tmp_c=dcmplx(0.0,0.0)
      
      do j=-M,M
         l_r=(real(j,DP)+alphas(ind_cusp))
         YN=l_r*Ytmp2
         XN=l_r*Xtmp2
         IF(yn.EQ.0.0_DP) then 
            cycle
         endif
         if(weight.eq.0.0_DP) then
            if(do_interp) then
               tmp=sqrt(Ytmp2)*interp_kbes(PI2*abs(YN))
            else
               tmp=sqrt(Ytmp2)*RKBessel(R,abs(YN)*PI2)
            endif
         else
            if(do_interp) then
               if(YN.gt.0.0_DP) then
                  tmp=interp_whittw(1,PI4*abs(YN))
               else
                  tmp=interp_whittw(2,PI4*abs(YN))
               endif
            else
               wt=weight*dsign(0.5_DP,l_r)
               tmp=WhittW(wt,R,PI4*abs(YN))
            endif
            if(do_exceptional) then
               tmp=tmp/((PI4*abs(real(j,DP)+alphas(ind_cusp)))            &
     &              **(0.5_DP*weight))
            else
               tmp=tmp/(sqrt(abs(real(j,DP)+alphas(ind_cusp))))
            endif
         endif
         tmp_c=dcmplx(tmp,0.0_DP)*C(ind_cusp,j)*exp(dcmplx(0.0,XN*PI2))
         summa=summa+tmp_c
         ! We might have a very large sum here, but we don't need 
         ! that many terms usually
         ! so unless hq=.true. I will stop after awhile
                                !        write(*,*) 'Term=(',j,')=',tmp_c
         if((.not.(hq)).and.(abs(tmp_c/summa).lt.(10.0D-15))) then
            exit
         endif
      enddo
!      write(*,*) 'summa1=',summa
      MaassWf_c=multip*summa
      !!! Just a test to see that we get the same result 
      !!! using a longer sum with respect to the cusp at oo


      end function MaassWf_c




      function MaassWf2(X,Y,C,M,R,type,hq_in)
      use commonvariables
      use kbessel
      use whittakerw
      use characters
      use groups
      use pullback
      use interpolation
      implicit none
      real(kind=DP) :: X,Y,R,YN,XN
      complex(DP)::MaassWf2
      logical,optional::hq_in
      logical::hq
      integer :: M
      integer,optional::type
      complex(kind=DP),dimension(1:num_cusps,-M:M)::C
      complex(DP)::tmp_c,multip,char1,char2,char3,summa
      integer,dimension(2,2)::map_tmp,maptmp2,maptmp3
      real(DP),dimension(2,2)::B
      real(kind=DP) :: wt,tmp,xtmp,ytmp,xpb,ypb,xtmp2,ytmp2,l_r
      integer :: j,ind_cusp,ind_vertex
      real(DP)::alpha
      if(PRESENT(hq_in)) then
         hq=hq_in
      else
         hq=.false.
      endif
      hq=.true.
!      write(*,*) 'in evalMAss(',X,Y,'C',M,R,type,')' 
!      write(*,*) 'C=',C
      if(maxval(real(C(:,:),DP))==0.0_DP) then
         write(*,*) 'no coefficients present!'
         stop
      endif
 !     write(*,*) 'do_interp=',do_interp
 !     do_interp=.false.
      summa=czero
      !!! WE want to evaluate the function
      !!! with respect to the correct cusp
      !!! e.g. using the correct set of coefficients
!      icusp=0
      map_tmp=mapId
      char1=cone

!      call pullback_to_gamma0N_map(X,Y,xpb,ypb,map_tmp)               
      call pullback_map(X,Y,xpb,ypb,map_tmp)               
      call seek_vertex(xpb,ypb,ind_vertex)
      call get_cusp_from_vertex(ind_vertex,ind_cusp)
            ! first get to the corresponding cusp                     
      call apply_map_int(xpb,ypb,xtmp,ytmp,Uw(ind_vertex,:,:)) 
      maptmp2=MATMUL(Uw(ind_vertex,:,:),map_tmp)
      call invert_sl2z(maptmp2,maptmp3)
                                ! now we are at the right cusp, and we have to normalize
      char2=get_multiplier(maptmp3,xtmp,ytmp)
!      write(*,*) 'multip(B)=',multiplier(maptmp3)
                                !     char21=autom_j_r(real(maptmp3(:,:),DP),xtmp,ytmp,weight)
      call gl_inverse(sigma_j(ind_cusp,:,:),B)
      call apply_map_re(xtmp,ytmp,xtmp2,ytmp2,B) ! W1=cuspnormalising map for cusp j
      !!! The pullbacked point is xtmp2+i*ytmp2
      !!! and this is where we shall evaluate f...
      !!! j(sigma_I(j),z_mj^*)^k
      char3=autom_j_r(sigma_j(ind_cusp,:,:),xtmp2,ytmp2,weight)
                                ! this is the complete multiplier we have to use
      multip=char1*char2*char3

      call get_alphas()
      alpha=100.0_DP
      do j=1,num_cusps
         if(alphas(j).lt.alpha) then
            alpha=alphas(j)
         endif
      enddo
 
      summa=dcmplx(0.0,0.0)
      tmp_c=dcmplx(0.0,0.0)

      if(.not.(allocated(k_vec))) then 
         allocate(k_vec(-M:M))
         ytmp2_old=100.0D0
      elseif(size(k_vec,1).ne.(2*M+1)) then 
         deallocate(k_vec)
         allocate(k_vec(-M:M))
      endif
      if(Ytmp2.ne.ytmp2_old) then 
!         write(*,*) 'Ytmp2=',ytmp2
!         write(*,*) 'Ytmp2_old=',ytmp2_old
         k_vec(:)=0.0_DP
         do j=1,M
            l_r=(real(j,DP)+alphas(ind_cusp))
            YN=l_r*Ytmp2
            XN=l_r*Xtmp2
            IF(yn.EQ.0.0_DP) then 
               cycle
            endif
            if(weight.eq.0.0_DP) then
               if(do_interp) then
                  tmp=sqrt(Ytmp2)*interp_kbes(PI2*abs(YN))
               else
                  tmp=sqrt(Ytmp2)*RKBessel(R,abs(YN)*PI2)
               endif
            else
               if(do_interp) then
                  if(YN.gt.0.0_DP) then
                     tmp=interp_whittw(1,PI4*abs(YN))
                  else
                     tmp=interp_whittw(2,PI4*abs(YN))
                  endif
               else
                  wt=weight*dsign(0.5_DP,l_r)
                  tmp=WhittW(wt,R,PI4*abs(YN))
               endif
               if(do_exceptional) then
                  tmp=tmp/((PI4*abs(real(j,DP)+alphas(ind_cusp)))            &
     &                 **(0.5_DP*weight))
               else
                  tmp=tmp/(sqrt(abs(real(j,DP)+alphas(ind_cusp))))
               endif
            endif
            k_vec(j)=tmp
            k_vec(-j)=tmp
         enddo
      else
!         write(*,*) 'Saved Y=',ytmp2
      endif
      ytmp2_old=ytmp2
      do j=-M,M
         l_r=(real(j,DP)+alphas(ind_cusp))
         XN=l_r*Xtmp2
         tmp_c=dcmplx(k_vec(j),0.0_DP)*C(ind_cusp,j)*                            &
     &        exp(dcmplx(0.0,XN*PI2))
         summa=summa+tmp_c
         ! We might have a very large sum here, but we don't need 
         ! that many terms usually
         ! so unless hq=.true. I will stop after awhile
!         if((.not.(hq)).and.(abs(tmp_c/summa).lt.(10.0D-15))) then
!            exit
!         endif
      enddo
!      write(*,*) 'x,y=',x,y
!      write(*,*) 'summa1=',summa
!      write(*,*) 'multip=',multip
      MaassWf2=multip*summa
      end function Maasswf2

      subroutine clean_coefficients()
      if(allocated(k_vec)) deallocate(k_vec)
      end subroutine


      end module coefficients






