!!! MODULES :  newton_r  newton_cplx newton_w
!!! Description:  A lot of versions of Newtons method to locate eigenvalues
!!!           newton_r      !! real character
!!!



      !! Newtons method in the case of weight
      module newton
      use commonvariables
      use coefficients
      use sys_solve
      use system
      integer::M0_set,i1_n_set,i2_n_set,i3_n_set
      real(DP)::Y1_set,Y2_set
      logical,save::newton_param_set,newton_deb,use_two_y
      logical,save::use_abs
      !! telling which tests to make  
      integer,dimension(:,:),allocatable::n_tests
      complex(DP),dimension(:),allocatable::min_test
      integer,save::ant_tests
      integer,save::newton_maxit
      integer::newton_silent
      interface compute_functional
      module procedure compute_functional_re
      module procedure compute_functional_cplx
      module procedure compute_functional_cplx2
      end interface

      interface compute_functional_old
      module procedure compute_functional_old_re
      module procedure compute_functional_old_cplx
      end interface

      contains
      !! Thus subroutine runs a search for minimizing values of 
      !!!  h(R)=|c(i1)-c'(i1)|+...+|c(i3)-c'(i3)|
      !!! by means of the method of false position
      !!! (i.e. a discrete version of Newton-Raphson)
!c     !!! Input: R1,R2   - interval to search
!c     !!!        x_start - starting point in the interval
!c     !!!        tol     - the wanted error
!c     !!! Output:x_fin   - the resulting R-value
!c     !!!        er      - the estimated error, unless special values:
!c     !!!                 er=1000 => no eigenvalue in the searched interval
!c     !!!                 er<0    => the method went out of the bounds or we
!c     !!!                            exceeded the maximum number of iterations
!c     !!! Auxillary vairables
!c     !!! optionals:
!c     !!!        CO      - a set of Fourier coefficients corresponding to x_fin
!c     !!!        ff      - gives a measure of the error in form of the value of h(x_fin)
!c     !!!        j1,j2,j3- if set we use these coefficients
!c     !!!        e       - if set we use it to symmetrize the coefficients
!c     !!!        type    - if set we use it to symmetrize the coefficients
!c     !!!        Y       - if set we use this value of Y to compute Y1 and Y2

      subroutine set_newton_params(R,M0,Y1,Y2,i1,i2,i3)
      implicit none
      integer::M0,Q,j
      integer,optional::i1,i2,i3
      real(dp)::Y1,Y2,R
      character(1)::ANS
      
      use_two_y=.false.
      if(weight.eq.0.0D0) then 
         use_abs=.false.
      else
         use_abs=.true.
      endif
      if(interactive.and.(.not.(newton_param_set))) then         
         write(*,*) 'Show debug info in Newtons method?'
         if(get_answer_yn()) then
            newton_deb=.true.
         endif 
         Y1=Y0_min
         call get_M0_Q_Y(R,M0,Q,Y1)
         write(*,*) 'Recommended: M0,Y1,Y2=',M0,Y1
         write(*,*) 'Note: Y-values should not be larger than ',Y0_min  
         write(*,*) 'M0?'
         read(*,*) M0
         write(*,*) 'Max number of iterations?'
         read(*,*) newton_maxit
         write(*,*) newton_maxit,'number of iterations!'
         write(*,*) 'Number of tests to use? (default=3)'
         read(*,*) ant_tests
         if(ant_tests.le.0) then 
            ant_tests=3 
         endif
         write(*,*) 'Using ',ant_tests,' tests!'
         if(allocated(n_tests)) then 
            deallocate(n_tests) 
         endif
         allocate(n_tests(ant_tests,1:2))
         write(*,*) 'Give tests of the following forms:'
         write(*,*) 'n 0 => c(y1,n)-c(y2,n)'
         write(*,*) 'm n => |c(m)c(n)-Sum_d chi(d)c(mn/d^2)|'
         write(*,*) '(The latter should only be used when Hecke',        &
     &        ' operators are present!)'
         write(*,*) 'negative m or n => |H(m,n)|*sgn(arg(H(m,n)))'
         do j=1,ant_tests
            write(*,'(A)',ADVANCE='NO') 'Test nr.'
            write(*,'(I2)',ADVANCE='NO') j
            write(*,'(A)',ADVANCE='NO') '= '
            read(*,*) n_tests(j,1:2)
            write(*,*) n_tests(j,1:2)
            if(n_tests(j,1)*n_tests(j,2).eq.0) then 
               use_two_y=.true.
            endif
            if((n_tests(j,1).lt.0).or.(n_tests(j,2).lt.0))then 
               use_abs=.false.
               n_tests(j,1)=abs(n_tests(j,1))
               n_tests(j,2)=abs(n_tests(j,2))
            endif            
         enddo
         write(*,*) 'Y?'
         read(*,*) Y1         
         Y2=0.0_DP
         if((M0.le.0).or.(Y1.le.0.0_DP)) then 
            Y2=Y1  !! We want to keep the user-supplied Y1 if it is present
            if(abs(Y2).lt.1.0D-15) then 
               Y2=Y0_min*0.8_DP
            endif
            call get_M0_Q_Y(R,M0,Q,Y2)
            
            if(Y1.le.0.0_DP) then 
               Y1=Y2
            endif
            Y2=0.0_DP
         endif
         if(use_two_y) then 
            write(*,*) 'Y2?'
            read(*,*) Y2
         endif
         M0_set=M0
         Y1_set=Y1
         Y2_set=Y2         
      elseif(.not.(interactive)) then 
                                !! we have to set default values
                                !! find good values of M0 and Y

         newton_maxit=35
         Y1=Y0_min*0.95_DP
         call get_M0_Q_Y(R,M0,Q,Y1)
         Y2=0.98_DP*Y1
         Y1_set=Y1
         Y2_set=Y2         
         M0_set=M0
         ant_tests=3
         call choose_i1i2i3(i1,i2,i3,M0)      
         if(allocated(n_tests)) deallocate(n_tests)
         allocate(n_tests(ant_tests,1:2))
         i1_n_set=i1;i2_n_set=i2;i3_n_set=i3
         n_tests(1,1:2)=(/ i1_n_set ,0 /)
         n_tests(2,1:2)=(/ i2_n_set ,0 /)
         n_tests(3,1:2)=(/ i3_n_set ,0 /)
         use_two_y=.true.
      else
         ! We might need to update M0 and Y1
         Y1=Y0_min*0.95_DP
         call get_M0_Q_Y(R,M0,Q,Y1)
         Y2=0.95_DP*Y1


      endif
         !! For insurance
         if(newton_maxit.le.0) then
            newton_maxit=30
         endif
      newton_param_set=.true.
      if(newton_silent.gt.0) then
         write(*,*) 'Set Y,M0,MAXIT',Y1,M0,newton_maxit
      endif
 !     write(*,*) 'R,i1,i2,i3=',R,i1,i2,i3
      end subroutine

      subroutine get_eigenv_by_NR_w(R1,R2,x_start,x_fin,type,tol,         &
     &     er,CP0_in,CN0_in,M0_in,ff_in)
!,j1,j2,j3,Y,ff_in,param,e_in,num_set,c_set,which_c)
      use commonvariables
      use groups
      use system
      use characters
      implicit none
      real(kind=DP),intent(in)::R1,R2,x_start,tol
      real(kind=DP),intent(out)::x_fin,er
      real(DP),optional::ff_in
      real(DP)::x_er
      integer,optional::M0_in
      complex(kind=DP),dimension(1:real_num_cusps)::e
      integer,intent(in),optional::type
      complex(DP),dimension(:),optional,allocatable::CP0_in,CN0_in
      complex(DP),dimension(:),allocatable::CP0,CN0
      !!! internal variables
      integer::par
      integer::i1,i2,i3
      real(kind=DP)::R0,x_new,ff
      real(kind=DP)::x1,x2,x0,f,f0,f1,f2
      real(kind=DP),dimension(:),allocatable::m
      integer::M0,Q,i,j,k
      real(kind=DP)::y1,y2,q1,q0,f_old,x_old,h
      real(kind=DP),dimension(:,:),allocatable::test
      real(kind=DP),dimension(:,:),allocatable::all_test
!      real(kind=DP),dimension(:),allocatable::t_
      real(DP),dimension(1:3)::vec1,vec0
      integer::ant1,ant0
      ! MAXIT iterations with N-R should be good enough
      integer::MAXIT
      logical::deb,done
      integer,dimension(:),allocatable::is
      integer::num_tests,best
      num_tests=3
      allocate(is(num_tests))
      !!! Do we use absolute values or real values in h(R) ?
      !!! This is mostly important in the case of 2 y's
      deb=.false.
!      deb=.true.
      done=.false.
      do_interp=.false.
      if(deb) then
         write(*,*) 'in NR_w args: R1,R2=',R1,R2,' x_start=',x_start,        &
     &        ' tol=',tol
         write(*,*) 'Maxit=',maxit
      endif
      if(use_abs) then
         write(*,*) 'Using absolute-values!'
      endif
      R0=x_start
      if(abs(R1-R2).lt.tol) then
         ! Can't get closer unless higher precision is requested!
         x_fin=x_start
         er=abs(R1-R2)
         ff=-1.0_DP
         write(*,*) 'Difference of starting values are within ',         &
     &        'requested limits !'
         return
      endif
!      if(PRESENT(Y)) Y1=Y
      call set_newton_params(R2,M0,Y1,Y2,i1,i2,i3)    
!      write(*,*) 'all set!'
      maxit=newton_maxit
      Q=M0+10
!     deb=newton_deb
      if(allocated(CP0_in)) deallocate(CP0_in)
      if(allocated(CN0_in)) deallocate(CN0_in)
      if(PRESENT(CP0_in)) then 
         allocate(CP0_in(1:M0+1))
         endif
      if(PRESENT(CN0_in)) allocate(CN0_in(1:M0))
      allocate(CP0(1:M0+1))
      allocate(CN0(1:M0))

      if(deb) then 
         open(UNIT=17,FILE='newton_data.txt')
      endif
      if(deb) then
         write(*,*) 'Maxit=',maxit
         write(*,*) 'R1,R2=',R1,R2
         write(*,*) 'M=',M0,'Q=',Q,'Y=',Y1,Y2,'CTYPE=',CType
      endif
!!DEB_______for_testing_purposes
!      Y1=0.803_DP
!      Y2=0.84535_DP
      allocate(test(0:3,1:ant_tests))
      allocate(all_test(0:MAXIT,1:ant_tests))
      allocate(m(1:ant_tests))
      m(:)=1.0_DP
      !!! Treat the method as usual newtons method if no R0 is present???
      x1=R1
      x2=R2
      call compute_functional(x1,f1,test(1,:),m,                         &
     &     M0,Q,Y1,Y2,CP0,CN0)
      f_old=0.0_DP
      x_old=0.0_DP
      call compute_functional(x2,f2,test(2,:),m,                        &
     &     M0,Q,Y1,Y2,CP0,CN0)
      if(deb) then
         write(*,*) 'R1=',R1,' R2=',R2 
!         write(*,*) 'i1,i2,i3=',i1,i2,i3      
         do k=1,ant_tests
            write(*,2099) k,test(1,k),test(2,k)
         enddo
      endif
      !! aligning the terms in the functional properly
      !! and give a warning if the tests do not move in 
      !! the same direction
      do i=1,ant_tests
         if(test(1,i).lt.test(2,i)) then
            m(i)=-1.0_DP               
         else
            m(i)=1.0_DP
         endif
         if(deb) then
            write(*,*) 'm(',i,')=',m(i)
         endif
      enddo
      if(test(1,1)*test(2,1).le.0.0_DP) then 
         !! T1 has a sign change in the interval 
         !! we must make sure that the other also has that         
         do i=2,ant_tests
            if(test(1,i)*test(2,i).gt.0.0_DP) then 
               write(*,*) 'All tests do not have zero in the same ',     &
     &             ' intervall. This interval does not seem to contain', &
     &              'a true eigenvalue !'
               ff=-1.0_DP
               done=.true.
!               return
            endif
         enddo
         !! If T1 does not have a zero here we still want all tests
         !! to move towards 0 in the same direction         
      elseif(abs(test(1,1)).lt.test(2,1)) then  !! Here T1(R1)<T1(R2)          
         do i=2,ant_tests
            if(abs(test(1,i)).ge.abs(test(2,i))) then 
               write(*,*) 'All tests do not have zero in the same ',     &
     &             ' intervall. This interval does not seem to contain', &
     &              'a true eigenvalue and/or includes a local extrema '
               ff=-1.0_DP
               done=.true.
!               return
            endif
         enddo
      else  !! in this case T1(R1)>T1(R2) 
         do i=2,ant_tests
            if(abs(test(1,i)).lt.abs(test(2,i))) then 
               write(*,*) 'All tests do not have zero in the same ',     &
     &             ' intervall. This interval does not seem to contain', &
     &              'a true eigenvalue and/or includes a local ',        &
     &              'extrema.'
               ff=-1.0_DP
                done=.true.
!              return
            endif
         enddo
      endif
      if(.not.(done)) then 
         f1=0.0_DP
         f2=0.0_DP
         do i=1,ant_tests
            f1=f1+test(1,i)*m(i)
            f2=f2+test(2,i)*m(i)
         enddo
         if(deb) then
            write(17,*) x1,f1
            write(17,*) x2,f2
         endif
      endif
      !! Having (x1,y1) and (x2,y2) we predict an x0 and compute y0
      newton_loop: do j=1,MAXIT
      !!! The zero should be between x0 aqnd x1 
      !!! and the crossings should be from x0+ to x1-
      !! here we should have x0 < x1 so f < 0 < f1

      !! offer a way out directly
         if(done) then
            exit newton_loop
         endif
         if(deb) then
            write(*,*) 'fore: x1=',x1,' x2=',x2, 'f1=',f1,                  &
     &           ' f2=',f2
         endif
         x_new=prediction(x1,f1,x2,f2)
         
         if(deb) then
            !!! Let's see what would be predicted by individual tests
            do i=1,ant_tests
               write(*,*) 'x_new(',i,')=',prediction(x1,test(1,i),x2,         &
     &              test(2,i))
            enddo
            write(*,*) 'efter: x_new=',x_new
            write(*,*) '|x1-x_new|<',abs(x1-x_new)
            write(*,*) '|x2-x_new|<',abs(x2-x_new)
         endif
         !! We can certainly not have an eigenvalue <0 in this setting since the functional is even in R
         !! So we make a new starting guess instead
         !! Take x_new=x2+(x2-x1)  i.e. jump ahead a little 
         if(x_new.lt.0.0_DP) then
            if(deb) then
               write(*,*) 'x_new <0: Make a new starting guess!'
            endif
            er=1000.0_DP
            exit newton_loop
         endif
         x_er=min(abs(x1-x_new),abs(x2-x_new))
         call compute_functional(x_new,f,test(3,:),m,                         &
     &        M0,Q,Y1,Y2,CP0,CN0)
         write(17,*) x_new,f
         ff=abs(f)
         if(deb) then 
            write(*,*) 'x_new,f=',x_new,f
         endif
         if((abs(x_er).lt.tol).or.(abs(ff).lt.tol)) then ! we are done
            !! compute the coefficients at the last iteration
!            call compute_functional(x_new,f,test(3,:),m,                     &
!     &        M0,Q,Y1,Y2,CP0,CN0)
            !! This is a predicted error
            er=abs(f)*(f2-f1)/(x2-x1)
            er=min(abs(x1-x_new),abs(x2-x_new))
            er=abs(er)
            if(deb) then 
                                !! print out the first few coefficients
               WRITE(*,*) 'Iteration stopped succesfully!'
               write(*,*) 'coeff. at R=',x_new
               write(*,*) 'C0=',CP0(1)
               write(*,*) 'C-1=',CN0(1)
               write(*,*) 'C2=',CP0(3)
               write(*,*) 'C-2=',CN0(2)
               write(*,*) 'C3=',CP0(4)
               write(*,*) 'C-3=',CN0(4)
               write(*,*) 'C4=',CP0(5)
               write(*,*) 'C-4=',CN0(5)
               write(*,*) 'C6=',CP0(7)
               write(*,*) 'ff=',ff
               write(*,*) 'f1=',f1
               write(*,*) 'f2=',f2
               write(*,*) 'x1=',x1
               write(*,*) 'x2=',x2
               write(*,*) 'er=',er
               write(*,*) 'x_er=',x_er
            endif
            exit newton_loop
         elseif(abs(f).gt.100.0_DP) then
            if(deb) then
               write(*,*) 'Probably no zero here!'
               write(*,*) '(f large)'  
               write(*,*) 'Try to call back with different parameters!'
               do k=1,ant_tests
                  write(*,2099) k,test(3,k),test(1,k)
               enddo
               do k=1,ant_tests
                  write(*,3000) k,test(3,k),test(0,k)
               enddo
            endif
            er=1000.0_DP
            exit newton_loop 
            x_fin=x_new
         endif

         !! DEtermine when to stop
         !! Presumably, if we are more than 1 unit away from the starting point we are lost...
         if((x_new.gt.(R2+1.0_DP)).or.(x_new.lt.(R1-1.0_DP))) then
                    ! We are out of the interval and there was probably just a singularity here
            x_fin=R0
            er=2000.0_DP        ! TO signify something is amiss
            exit newton_loop
         endif
         !! If we are not lost we continue


         !! choose the "best" values of (x1,y1) and (x2,y2) as new starting values
         !! together with x_new,f_new
         !! We start to check for changes of sign and proceed then to compare sizes
         if((f1*f.le.0.0_DP).and.(f2*f.le.0.0_DP)) then 
            if(abs(f1).lt.abs(f2)) then
               best=1
            else
               best=2
            endif
         elseif(f1*f.le.0.0_DP) then
            best=1
         elseif(f2*f.le.0.0_DP) then
            best=2
         elseif(abs(f1).lt.abs(f2)) then
            best=1
         else
            best=2
         endif
         if(best.eq.1) then   !! If f1 is better than f2
            if(x1.lt.x_new) then 
               x2=x_new
               f2=f
               test(2,:)=test(3,:)
            else
               x2=x1
               f2=f1
               test(2,:)=test(1,:)
               x1=x_new
               f1=f
               test(1,:)=test(3,:)
            endif
         else
            if(x2.lt.x_new) then
               x1=x2
               f1=f2
               test(1,:)=test(2,:)
               x2=x_new
               f2=f
               test(2,:)=test(3,:)
            else
               x1=x_new
               f1=f
               test(1,:)=test(3,:)
            endif
         endif
            
 2099    FORMAT('test(new:1,',I1,')=',ES10.3,2X,ES10.3)
 3000    FORMAT('test(new:0,',I1,')=',ES10.3,2X,ES10.3)
        ! We should actually take a bit care here...
        ! It might be that if the differences in size
        ! are to big we might not have a zero anyway
      enddo newton_loop
      x_fin=x_new
      if(ff.eq.-1.0_DP) then 
         x_fin=R1
         er=-1000.0_DP
      endif
      if(deb) then
         write(*,*) 'Finally: x_fin =',x_fin,' er=',er
      endif
      if(j.ge.MAXIT) then 
         x_fin=x_new
         !! Should we indicate that maxit is exceeded?
         !! Before Iused a minus sign  to tell signify that
         er=abs(x_new-x1)
         ff=abs(f)
         if(abs(x_new-x1).eq.0.0) then !! We certainly do not have 0 error, this just means that the newton algorithm got stuck
            er=max(abs(f),abs(x_new-x2))
         endif
      endif         
      if((deb).and.(j.ge.MAXIT)) then
         write(*,*) 'Note that MAXIT is exceeded!'
      endif
      if(deb) then
         write(*,*) 'Out of newton_loop!'
      endif
      if(PRESENT(CP0_in)) then
         CP0_in=CP0
      endif
      if(PRESENT(CN0_in)) then
         CN0_in=CN0
      endif
      if(PRESENT(M0_in)) then
         M0_in=M0
      endif
!      if(PRESENT(ff_in)) then
!         ff_in=ff
!      endif
      deallocate(test)!
      end subroutine get_eigenv_by_NR_w


!! For the real case when we only have coefficients in range 1:M0
      subroutine get_eigenv_by_NR_RE(R1,R2,x_start,x_fin,type,e,tol,         &
     &     er,CP0_in,M0_in,ff_in)
!,j1,j2,j3,Y,ff_in,param,e_in,num_set,c_set,which_c)
      use commonvariables
      use groups
      use system
      use characters
      implicit none
      real(kind=DP),intent(in)::R1,R2,x_start,tol
      real(kind=DP),intent(out)::x_fin,er
      real(DP),optional::ff_in
      real(DP)::x_er
      integer,optional::M0_in
      real(kind=DP),dimension(1:num_cusps)::e
      integer,intent(in),optional::type
      real(DP),dimension(:),optional,allocatable::CP0_in
      real(DP),dimension(:),allocatable::CP0
      !!! internal variables
      integer::par
      integer::i1,i2,i3
      real(kind=DP)::R0,x_new,ff
      real(kind=DP)::x1,x2,x0,f,f0,f1,f2
      real(kind=DP),dimension(:),allocatable::m
      integer::M0,Q,i,j,k
      real(kind=DP)::y1,y2,q1,q0,f_old,x_old,h
      real(kind=DP),dimension(:,:),allocatable::test
      real(kind=DP),dimension(:,:),allocatable::all_test
!      real(kind=DP),dimension(:),allocatable::t_
      real(DP),dimension(1:3)::vec1,vec0
      integer::ant1,ant0
      ! MAXIT iterations with N-R should be good enough
      integer::MAXIT
      logical::deb,done
      integer,dimension(:),allocatable::is
      integer::num_tests,best
      real(DP)::diff_x1_old,diff_x2_old
      num_tests=3
      allocate(is(num_tests))
      !!! Do we use absolute values or real values in h(R) ?
      !!! This is mostly important in the case of 2 y's
      deb=.false.
      if(newton_silent.gt.1) then
         deb=.true.
      endif
      done=.false.
      do_interp=.false.
      if(deb) then
         write(*,*) 'in NR_RE args: R1,R2=',R1,R2,' x_start=',x_start,        &
     &        ' tol=',tol
         write(*,*) 'Maxit=',maxit
      endif
      if(use_abs) then
         write(*,*) 'Using absolute-values!'
      endif
      R0=x_start
      if(abs(R1-R2).lt.tol) then
         ! Can't get closer unless higher precision is requested!
         x_fin=x_start
         er=abs(R1-R2)
         ff=-1.0_DP
         write(*,*) 'Difference of starting values are within ',         &
     &        'requested limits !'
         return
      endif
!      if(PRESENT(Y)) Y1=Y
      call set_newton_params(R2,M0,Y1,Y2,i1,i2,i3)    
!! Set type
      
!      write(*,*) 'all set!'
      maxit=newton_maxit
      Q=M0+10
      if((Q_set.gt.0).and.(Q.lt.Q_set).and.(Q_set-Q.le.10)) then 
         Q=Q_set
      endif
!     deb=newton_deb
      if(allocated(CP0_in)) deallocate(CP0_in)
      if(PRESENT(CP0_in)) then 
         allocate(CP0_in(1:M0))
      endif
      allocate(CP0(1:M0+1))
      if(deb) then 
         open(UNIT=17,FILE='newton_data.txt')
      endif
      if(deb) then
         write(*,*) 'Maxit=',maxit
         write(*,*) 'R1,R2=',R1,R2
         write(*,*) 'M=',M0,'Q=',Q,'Y=',Y1,Y2,'CTYPE=',CType
      endif
!!DEB_______for_testing_purposes
!      Y1=0.803_DP
!      Y2=0.84535_DP
      allocate(test(0:3,1:ant_tests))
      allocate(all_test(0:MAXIT,1:ant_tests))
      allocate(m(1:ant_tests))
      m(:)=1.0_DP
      !!! Treat the method as usual newtons method if no R0 is present???
      x1=R1
      x2=R2
      call compute_functional(x1,f1,test(1,:),m,                         &
     &     M0,Q,Y1,Y2,CP0,type,e)
      f_old=0.0_DP
      x_old=0.0_DP
      call compute_functional(x2,f2,test(2,:),m,                        &
     &     M0,Q,Y1,Y2,CP0,type,e)
      if(deb) then
         write(*,*) 'R1=',R1,' R2=',R2 
!         write(*,*) 'i1,i2,i3=',i1,i2,i3      
         do k=1,ant_tests
            write(*,2099) k,test(1,k),test(2,k)
         enddo
      endif
      !! aligning the terms in the functional properly
      !! and give a warning if the tests do not move in 
      !! the same direction
      do i=1,ant_tests
         if(test(1,i).lt.test(2,i)) then
            m(i)=-1.0_DP               
         else
            m(i)=1.0_DP
         endif
         if(deb) then
            write(*,*) 'm(',i,')=',m(i)
         endif
      enddo
      if(test(1,1)*test(2,1).le.0.0_DP) then 
         !! T1 has a sign change in the interval 
         !! we must make sure that the other also has that         
         do i=2,ant_tests
            if(test(1,i)*test(2,i).gt.tol) then 
               if(newton_silent.gt.0) then
               write(*,*) 'All tests do not have zero in the same ',     &
     &             ' intervall. This interval does not seem to contain', &
     &              'a true eigenvalue !'
               ff=-1.0_DP
               done=.true.
               endif
!               return
            endif
         enddo
         !! If T1 does not have a zero here we still want all tests
         !! to move towards 0 in the same direction         
      elseif(abs(test(1,1)).lt.test(2,1)) then  !! Here T1(R1)<T1(R2)          
         do i=2,ant_tests
            if(abs(test(1,i)).ge.abs(test(2,i))) then 
               if(newton_silent.gt.0) then
               write(*,*) 'All tests do not have zero in the same ',     &
     &             ' intervall. This interval does not seem to contain', &
     &              'a true eigenvalue and/or includes a local extrema '
               ff=-1.0_DP
               done=.true.
               endif
!               return
            endif
         enddo
      else  !! in this case T1(R1)>T1(R2) 
         do i=2,ant_tests
            if(abs(test(1,i)).lt.abs(test(2,i))) then 
               if(newton_silent.gt.0) then
               write(*,*) 'All tests do not have zero in the same ',     &
     &             ' intervall. This interval does not seem to contain', &
     &              'a true eigenvalue and/or includes a local ',        &
     &              'extrema.'
               ff=-1.0_DP
                done=.true.
               endif
!              return
            endif
         enddo
      endif
      if(.not.(done)) then 
         f1=0.0_DP
         f2=0.0_DP
         do i=1,ant_tests
            f1=f1+test(1,i)*m(i)
            f2=f2+test(2,i)*m(i)
         enddo
         if(deb) then
            write(17,*) x1,f1
            write(17,*) x2,f2
         endif
      endif
      !! Having (x1,y1) and (x2,y2) we predict an x0 and compute y0
      newton_loop: do j=1,MAXIT
      !!! The zero should be between x0 aqnd x1 
      !!! and the crossings should be from x0+ to x1-
      !! here we should have x0 < x1 so f < 0 < f1

      !! offer a way out directly
         if(done) then
            exit newton_loop
         endif
         if(deb) then
            write(*,*) 'fore: x1=',x1,' x2=',x2, 'f1=',f1,                  &
     &           ' f2=',f2
         endif
         x_new=prediction(x1,f1,x2,f2)
         x_er=min(abs(x1-x_new),abs(x2-x_new))
!         if(x_er.eq.0.0D0) then !!
            !! We presumably had
!         endif
         call compute_functional(x_new,f,test(3,:),m,                         &

     &        M0,Q,Y1,Y2,CP0,type,e)
         ff=abs(f)
         if(deb) then 
            write(*,*) 'x_new,f=',x_new,f
            write(17,*) x_new,f
         endif
         if(deb) then
            !!! Let's see what would be predicted by individual tests
            do i=1,ant_tests
               write(*,*) 'x_new(',i,')=',prediction(x1,test(1,i),x2,         &
     &              test(2,i))
            enddo
            write(*,*) 'after: x_new=',x_new
            write(*,*) '|x1-x_new|<',abs(x1-x_new)
            write(*,*) '|x2-x_new|<',abs(x2-x_new)
         endif
         !! We can certainly not have an eigenvalue <0 in this setting since the functional is even in R
         !! So we make a new starting guess instead
         !! Take x_new=x2+(x2-x1)  i.e. jump ahead a little 
         if(x_new.lt.0.0_DP) then
            if(deb) then
               write(*,*) 'x_new <0: Make a new starting guess!'
            endif
            er=1000.0_DP
            exit newton_loop
         endif

         if((abs(x_er).lt.tol).and.(ff.lt.tol)) then ! we are done
            !! compute the coefficients at the last iteration
!            call compute_functional(x_new,f,test(3,:),m,                     &
!     &        M0,Q,Y1,Y2,CP0,CN0)
            !! This is a predicted error
            er=abs(f)*(f2-f1)/(x2-x1)
            er=min(abs(x1-x_new),abs(x2-x_new))
            er=abs(er)
            if(deb) then 
                                !! print out the first few coefficients
               WRITE(*,*) 'Iteration stopped succesfully!'
               write(*,*) 'coeff. at R=',x_new
               write(*,*) 'C0=',CP0(1)
               write(*,*) 'C2=',CP0(3)
               write(*,*) 'C3=',CP0(4)
               write(*,*) 'C4=',CP0(5)
               write(*,*) 'C6=',CP0(7)
               write(*,*) 'ff=',ff
               write(*,*) 'f1=',f1
               write(*,*) 'f2=',f2
               write(*,*) 'x1=',x1
               write(*,*) 'x2=',x2
               write(*,*) 'er=',er
               write(*,*) 'x_er=',x_er
            endif
            exit newton_loop
         elseif(abs(f).gt.100.0_DP) then
            if(deb) then
               write(*,*) 'Probably no zero here!'
               write(*,*) '(f large)'  
               write(*,*) 'Try to call back with different parameters!'
               do k=1,ant_tests
                  write(*,2099) k,test(3,k),test(1,k)
               enddo
               do k=1,ant_tests
                  write(*,3000) k,test(3,k),test(0,k)
               enddo
            endif
            er=1000.0_DP
            exit newton_loop 
            x_fin=x_new
         endif

         !! DEtermine when to stop
         !! Presumably, if we are more than 1 unit away from the starting point we are lost...
         if((x_new.gt.(R2+1.0_DP)).or.(x_new.lt.(R1-1.0_DP))) then
                    ! We are out of the interval and there was probably just a singularity here
            x_fin=R0
            er=2000.0_DP        ! TO signify something is amiss
            exit newton_loop
         endif
         !! If we are not lost we continue

         !! We now want to check if we improved something since last time, otherwise we stop
         if(((abs(x_new-x1).eq.diff_x1_old).and.(abs(x_new-x2).eq.        &
     &        diff_x2_old)).or.(x_new.eq.x1).or.(x_new.eq.x2)) then 
            !! Nothing changed since last time so the loop is stuck
            !! But if the functional is small we are probably 
            !! close to a zero
            er=min(max(abs(x_new-x1),abs(x_new-x2)),f)
            x_fin=x_new
            if(deb) then 
               write(*,*) 'The Newton loop seems stuck! Exiting!'
            endif
            exit newton_loop
         endif
         if(deb) then 
            write(*,*) '|x-x1|=',abs(x_new-x1)
            write(*,*) 'diff_x1_old=',diff_x1_old
            write(*,*) '|x-x2|=',abs(x_new-x2)
            write(*,*) 'diff_x2_old=',diff_x2_old
         endif
         diff_x1_old=abs(x_new-x1)
         diff_x2_old=abs(x_new-x2)

         !! choose the "best" values of (x1,y1) and (x2,y2) as new starting values
         !! together with x_new,f_new
         !! We start to check for changes of sign and proceed then to compare sizes
         if((f1*f.le.0.0_DP).and.(f2*f.le.0.0_DP)) then 
            if(abs(f1).lt.abs(f2)) then
               best=1
            else
               best=2
            endif
         elseif(f1*f.le.0.0_DP) then
            best=1
         elseif(f2*f.le.0.0_DP) then
            best=2
         elseif(abs(f1).lt.abs(f2)) then
            best=1
         else
            best=2
         endif
         if(best.eq.1) then   !! If f1 is better than f2
            if(x1.lt.x_new) then 
               x2=x_new
               f2=f
               test(2,:)=test(3,:)
            else
               x2=x1
               f2=f1
               test(2,:)=test(1,:)
               x1=x_new
               f1=f
               test(1,:)=test(3,:)
            endif
         else
            if(x2.lt.x_new) then
               x1=x2
               f1=f2
               test(1,:)=test(2,:)
               x2=x_new
               f2=f
               test(2,:)=test(3,:)
            else
               x1=x_new
               f1=f
               test(1,:)=test(3,:)
            endif
         endif

 2099    FORMAT('test(new:1,',I1,')=',ES10.3,2X,ES10.3)
 3000    FORMAT('test(new:0,',I1,')=',ES10.3,2X,ES10.3)
        ! We should actually take a bit care here...
        ! It might be that if the differences in size
        ! are to big we might not have a zero anyway
      enddo newton_loop
      x_fin=x_new
      if(ff.eq.-1.0_DP) then 
         x_fin=R1
         er=-1000.0_DP
      endif
      if(deb) then
         write(*,*) 'Finally: x_fin =',x_fin,' er=',er
      endif
      if(j.ge.MAXIT) then 
         x_fin=x_new
         !! Should we indicate that maxit is exceeded?
         !! Before Iused a minus sign  to tell signify that
         er=abs(x_new-x1)
         ff=abs(f)
         if(abs(x_new-x1).eq.0.0) then !! We certainly do not have 0 error, this just means that the newton algorithm got stuck
            er=max(abs(f),abs(x_new-x2))
         endif
      endif         
      if((deb).and.(j.ge.MAXIT)) then
         write(*,*) 'Note that MAXIT is exceeded!'
      endif
      if(deb) then
         write(*,*) 'Out of newton_loop!'
      endif
      if(PRESENT(CP0_in)) then
         CP0_in=CP0
      endif
      if(PRESENT(M0_in)) then
         M0_in=M0
      endif
!      if(PRESENT(ff_in)) then
!         ff_in=ff
!      endif
      deallocate(test)!
      end subroutine get_eigenv_by_NR_RE



!! A bit more recent than the following one
      subroutine get_eigenv_by_NR_w_newer(R1,R2,x_start,x_fin,tol,         &
     &     er,CO_in,e_in,j1,j2,j3,Y,ff_in,param,num_set,c_set,which_c)
      use commonvariables
      use groups
      use system
!      use sys_solve_cplx
      use pullback,only:Q_set
      use characters
      implicit none
      real(kind=DP),intent(in)::R1,R2,x_start,tol
      real(kind=DP),intent(out)::x_fin,er
      real(DP),optional::Y
      real(DP),optional::ff_in
      real(DP)::x_er
      complex(kind=DP),dimension(1:real_num_cusps),optional::e_in
      complex(kind=DP),dimension(1:real_num_cusps)::e
      complex(DP),dimension(:),optional::c_set
      integer,dimension(:),optional::which_c
      integer,intent(in),optional::num_set
      integer,optional::param   !!! optional input parameter
      complex(DP),dimension(:),allocatable,optional::CO_in
      complex(DP),dimension(-3:6)::CO
      integer,optional::j1,j2,j3
      !!! internal variables
      integer::par
      integer::i1,i2,i3
      real(kind=DP)::R0,x_new,ff
      real(kind=DP)::x1,x2,x0,f,f0,f1,f2
      real(kind=DP),dimension(:),allocatable::m
      integer::M0,Q,i,j,k
      real(kind=DP)::y1,y2,q1,q0,f_old,x_old,h
!!      complex(kind=DP),dimension(:,:,:),allocatable::CY
!!      complex(kind=DP),dimension(:),allocatable::CNY
!!      complex(kind=DP),dimension(:,:),allocatable::CYtmp,CNYtmp
      complex(kind=DP),dimension(:,:),allocatable::test
!      real(kind=DP),dimension(:),allocatable::t_
      real(DP),dimension(1:3)::vec1,vec0
      integer::ant1,ant0
      ! MAXIT iterations with N-R should be good enough
      integer,parameter::MAXIT=35
      logical::deb,done
      integer,dimension(:),allocatable::is
      integer::num_tests,best
      real(DP)::diff_x1_old,diff_x2_old
      num_tests=3
      allocate(is(num_tests))
      
      if(PRESENT(CO_in)) then
         if(.not.(allocated(CO_in))) then
            allocate(CO_in(-3:6))
         endif
         CO_in(:)=dcmplx(0.0_DP)
      endif
      if(PRESENT(e_in)) then
         e(:)=e_in(:)
      else
         e(:)=dcmplx(0.0,0.0)
      endif
      !!! Do we use absolute values or real values in h(R)?
      deb=.false.
      if(R1-6.61D0.lt.0.01) then 
         deb=.true.
      endif
      deb=.false.
!      deb=.true.
      done=.false.
      do_interp=.false.
      if(deb) then
         write(*,*) 'in NR_w args: R1,R2=',R1,R2,' x_start=',x_start,        &
     &        ' e=',e,' tol=',tol
      endif
      if(use_abs) then
         write(*,*) 'Using absolute-values!'
      endif

      R0=x_start
      if(abs(R1-R2).lt.tol) then
         ! Can't get closer unless higher precision is supplied
         x_fin=x_start
         er=abs(R1-R2)
         ff=-1.0_DP
         return
      endif
      Y1=Y0_min*0.9_DP
      if(tol.lt.1D-10) then
         Y1=0.5_DP*Y1
      endif
      if(PRESENT(Y).and.(Y.gt.0.0_DP)) then
         if(deb) then
            write(*,*) 'Y=',Y
         endif
         Y1=Y
      endif
      call get_M0_Q_Y(R2,M0,Q,Y1)
      if((Q_set.gt.0).and.(Q.lt.Q_set).and.(Q_set-Q.le.10)) then 
         Q=Q_set
      endif
      if((.not.(PRESENT(j1)).or.(j1.eq.0).or.(j2.eq.0)                   &
     &     .or.(j3.eq.0))) then   
         call choose_i1i2i3(i1,i2,i3,M0,par)      
      else
         i1=j1
         i2=j2
         i3=j3
      endif   
      !!! usually I have Y ok, but there is no guarantee that 1.05*Y is ok..
      Y2=0.98_DP*Y1
      call set_newton_params(R2,M0,Y1,Y2,i1,i2,i3)    
      deb=newton_deb
      if(R1-6.61D0.lt.0.01) then 
!         deb=.true.
      endif
      if(deb) then 
         open(UNIT=17,FILE='newton_data.txt')
      endif
      is(1)=i1
      is(2)=i2
      is(3)=i3
      if(.not.(PRESENT(param))) then
         par=0
      else
         par=param
      endif
      Q=M0+10
      if(deb) then
         write(*,*) 'R0,R1,R1=',R0,R1,R2
         write(*,*) 'M=',M0,'Q=',Q,'Y=',Y1,Y2,'CTYPE=',CType
         write(*,*) 'par=',par,' e=',e(:)
      endif
      allocate(test(0:3,1:M0))
      allocate(m(1:M0))
      m(:)=1.0_DP
      ! First determine which one of R1 and R2 I should start with
      ! other than the initial x_0
      !!! Treat the method as usual newtons method if no R0 is present???
      x1=R1
      x2=R2
      call compute_functional_old_cplx(x1,f1,test(1,:),num_tests,m,is,                 &
     &     M0,Q,Y1,Y2,par,e_in,num_set,c_set,which_c,CO,deb)
      f_old=0.0_DP
      x_old=0.0_DP
      call compute_functional_old_cplx(x2,f2,test(2,:),num_tests,m,is,                 &
     &     M0,Q,Y1,Y2,par,e_in,num_set,c_set,which_c,CO,deb)
      if(deb) then
         write(*,*) 'R1=',R1,' R2=',R2 
         write(*,*) 'i1,i2,i3=',i1,i2,i3      
         do k=2,min(max(8,i3),size(test,2))
            write(*,2099) k,real(test(1,k),DP),real(test(2,k),DP)
            write(*,2099) k,dimag(test(1,k)),dimag(test(2,k))
         enddo
      endif
      !! We check first in detail if there is a zero here 
      !! also with respect to the imaginary parts, othre we exit
      if((real(test(1,i1),DP)*real(test(2,i1),DP).le.0.0D0).and.                    &
     &     (real(test(1,i2),DP)*real(test(2,i2),DP).le.0.0D0).and.                    &
     &     (real(test(1,i3),DP)*real(test(2,i3),DP).le.0.0D0)) then 
         if(deb) then 
            write(*,*) 'Real zero!!'
         endif
      else
         if(deb) then 
            write(*,*) 'No real zero!'
         endif
         er=1000.0_DP
         done=.true.
      endif
      if((dimag(test(1,i1))*dimag(test(2,i1)).le.tol).and.                    &
     &     (dimag(test(1,i2))*dimag(test(2,i2)).le.tol).and.                    &
     &     (dimag(test(1,i3))*dimag(test(2,i3)).le.tol)) then 
         if(deb) then 
            write(*,*) 'Imaginary zero!!'
         endif
      else
         if(deb) then 
            write(*,*) 'No imaginary zero!'
         endif
         er=1000.0_DP
         done=.true.
      endif
      if(.not.(done)) then 
     !! aligning the terms in the functional properly
         do i=1,M0
            if((i.eq.i1).or.(i.eq.i2).or.(i.eq.i3)) then
               if(real(test(1,i),DP).lt.real(test(2,i),DP)) then
                  m(i)=-1.0_DP               
               else
                  m(i)=1.0_DP
               endif
               if(deb) then
                  write(*,*) 'm(',i,')=',m(i)
               endif
            endif
         enddo
!         f1=real(test(1,i1),DP)*m(i1)+real(test(1,i2),DP)*m(i2)+                      &
!     &        real(test(1,i3),DP)*m(i3)
         f1=sum(real(test(1,is(:)),DP)*m(is(:)))
         f2=sum(real(test(2,is(:)),DP)*m(is(:)))
!         f2=real(test(2,i1),DP)*m(i1)+real(test(2,i2),DP)*m(i2)+                      &
!     &        real(test(2,i3),DP)*m(i3)
!      f2=test(2,i1)*m(i1)+test(2,i2)*m(i2)+test(2,i3)*m(i3)
         if(deb) then
            write(17,*) x1,f1
            write(17,*) x2,f2
         endif
      endif
      !! Having (x1,y1) and (x2,y2) we predict an x0 and compute y0
      newton_loop: do j=1,MAXIT
      !!! The zero should be between x0 aqnd x1 
      !!! and the crossings should be from x0+ to x1-
      !! here we should have x0 < x1 so f < 0 < f1

      !! offer a way out directly
         if(done) then
            exit newton_loop
         endif
         if(deb) then
            write(*,*) 'fore: x1=',x1,' x2=',x2, 'f1=',f1,                  &
     &           ' f2=',f2
         endif
         x_new=prediction(x1,f1,x2,f2)
         if(deb) then
            write(*,*) 'efter: x_new=',x_new
            write(*,*) '|x1-x_new|<',abs(x1-x_new)
            write(*,*) '|x2-x_new|<',abs(x2-x_new)
         endif
         !! We can certainly not have an eigenvalue <0 in this setting since the functional is even in R
         !! So we make a new starting guess instead
         !! Take x_new=x2+(x2-x1)  i.e. jump ahead a little 
         if(x_new.lt.0.0_DP) then
            if(deb) then
               write(*,*) 'x_new <0: Make a new starting guess!'
            endif
            er=1000.0_DP
            exit newton_loop
            
!c$$$            x_new=x2+(x2-x1)
!c$$$            x1=x2
!c$$$            f1=f2
!c$$$            x2=x_new
!c$$$            f2=
!c$$$            x_new=
!c$$$            if(deb) then
!c$$$               write(*,*) 'efter: x_new=',x_new
!c$$$               write(*,*) '|x1-x_new|<',abs(x1-x_new)
!c$$$               write(*,*) '|x2-x_new|<',abs(x2-x_new)
!c$$$            endif
!c$$$         endif
         endif
         x_er=min(abs(x1-x_new),abs(x2-x_new))
         call compute_functional_old_cplx(x_new,f,test(3,:),num_tests,m,  &
     &        is,M0,Q,Y1,Y2,par,e_in,num_set,c_set,which_c,CO,deb)
         write(17,*) x_new,f
         ff=abs(f)
         if((x_er.lt.tol).and.(ff.lt.tol)) then ! we are done
            !! compute the coefficients at the last iteration
            call compute_functional_old_cplx(x_new,f,test(3,:),              &
     &           num_tests,m,is,M0,Q,Y1,Y2,par,e_in,num_set,c_set,           &
     &           which_c,CO)
            !! This is a predicted error
            if(present(CO_in)) then 
               CO_in=CO
            endif
            er=abs(f)*(f2-f1)/(x2-x1)
            er=abs(er)
            if(deb) then 
                                !! print out the first few coefficients
               WRITE(*,*) 'Iteration stopped succesfully!'
               write(*,*) 'coeff. at R=',x_new
               write(*,*) 'C0=',CO(0)
               write(*,*) 'C-1=',CO(-1)
               write(*,*) 'C2=',CO(2)
               write(*,*) 'C-2=',CO(-2)
               write(*,*) 'C3=',CO(3)
               write(*,*) 'C-3=',CO(3)
               write(*,*) 'C6=',CO(6)
               write(*,*) 'ff=',ff
               write(*,*) 'er=',er
               write(*,*) 'x_er=',x_er
            endif
            exit newton_loop
         elseif(abs(f).gt.100.0_DP) then
            if(deb) then
               write(*,*) 'Probably no zero here!'
               write(*,*) '(f large)'  
               write(*,*) 'Try to call back with different parameters!'
               do k=2,min(max(9,i3),size(test,2))
                  write(*,2099) k,test(3,k),test(1,k)
               enddo
               do k=2,min(max(9,i3),size(test,2))
                  write(*,3000) k,test(3,k),test(0,k)
               enddo
            endif
            er=1000.0_DP
            exit newton_loop 
            x_fin=x_new
         endif

         !! DEtermine when to stop
         !! Presumably, if we are more than 1 unit away from the starting point we are lost...
         if((x_new.gt.(R2+1.0_DP)).or.(x_new.lt.(R1-1.0_DP))) then
                    ! We are out of the interval and there was probably just a singularity here
            x_fin=R0
            er=2000.0_DP        ! TO signify something is amiss
            exit newton_loop
         endif
         !! If we are not lost we continue




  !! We now want to check if we improved something since last time, otherwise we stop
         if(((abs(x_new-x1).eq.diff_x1_old).and.(abs(x_new-x2).eq.        &
     &        diff_x2_old)).or.(x_new.eq.x1).or.(x_new.eq.x2)) then 
            !! Nothing changed since last time so the loop is stuck
            er=min(f,max(abs(x_new-x1),abs(x_new-x2)))
            x_fin=x_new
            if(deb) then 
               write(*,*) 'The Newton loop seems stuck! Exiting!'
            endif
            exit newton_loop
         endif
         diff_x1_old=abs(x_new-x1)
         diff_x2_old=abs(x_new-x2)




         !! choose the "best" values of (x1,y1) and (x2,y2) as new starting values
         !! together with x_new,f_new
         !! We start to check for changes of sign and proceed then to compare sizes
         if((f1*f.le.0.0_DP).and.(f2*f.le.0.0_DP)) then 
            if(abs(f1).lt.abs(f2)) then
               best=1
            else
               best=2
            endif
         elseif(f1*f.le.0.0_DP) then
            best=1
         elseif(f2*f.le.0.0_DP) then
            best=2
         elseif(abs(f1).lt.abs(f2)) then
            best=1
         else
            best=2
         endif
         if(best.eq.1) then   !! If f1 is bettar than f2
            if(x1.lt.x_new) then 
               x2=x_new
               f2=f
            else
               x2=x1
               f2=f1
               x1=x_new
               f1=f
            endif
         else
            if(x2.lt.x_new) then
               x1=x2
               f1=f2
               x2=x_new
               f2=f
            else
               x1=x_new
               f1=f
            endif
         endif
            
 2099    FORMAT('test(new:1,',I1,')=',ES10.3,2X,ES10.3)
 3000    FORMAT('test(new:0,',I1,')=',ES10.3,2X,ES10.3)
        ! We should actually take a bit care here...
        ! It might be that if the differences in size
        ! are to big we might not have a zero anyway
      enddo newton_loop
      x_fin=x_new
      if(deb) then
         write(*,*) 'Finally: x_fin =',x_fin
      endif
      if(j.ge.MAXIT) then
         write(*,*) 'Note that MAXIT is exceeded!'
         x_fin=x_new
         er=abs(x_new-x1)
         ff=abs(f)
         if(abs(x_new-x1).eq.0.0) then !! We certainly do not have 0 error, this just means that the newton algorithm got stuck
            er=max(abs(f),abs(x_new-x2))
         endif
!         call compute_functional_old_cplx(x_new,f,test(3,:),num_tests,     &
!     &        m,is,M0,Q,Y1,Y2,par,e_in,num_set,c_set,which_c,CO,deb)
!         er=-abs(f)
!         ff=er
      endif
      if((deb).and.(j.ge.MAXIT)) then
         write(*,*) 'Note that MAXIT is exceeded!'
      endif
      if(deb) then
         write(*,*) 'Out of newton_loop!'
      endif
      if(PRESENT(CO_in)) then
         CO_in=CO
      endif
      if(PRESENT(ff_in)) then
         ff_in=ff
      endif
      deallocate(test)!
      end subroutine get_eigenv_by_NR_w_newer

      subroutine get_eigenv_by_NR_w_old(R1,R2,x_start,x_fin,type,tol,         &
     &     er,CO_in,j1,j2,j3,Y,ff_in,param,e_in,num_set,c_set,which_c)
      use commonvariables
      use groups
      use system
!      use sys_solve_cplx
      use characters
      implicit none
      real(kind=DP),intent(in)::R1,R2,x_start,tol
      real(kind=DP),intent(out)::x_fin,er
      real(DP),optional::Y
      real(DP),optional::ff_in
      complex(kind=DP),dimension(1:real_num_cusps),optional::e_in
      complex(kind=DP),dimension(1:real_num_cusps)::e
      complex(DP),dimension(:),optional::c_set
      integer,dimension(:),optional::which_c
      integer,intent(in),optional::type,num_set
      integer,optional::param   !!! optional input parameter
      complex(DP),dimension(-3:6),optional::CO_in
      complex(DP),dimension(-3:6)::CO
      integer,optional::j1,j2,j3
      !!! internal variables
      integer::par
      integer::i1,i2,i3
      real(kind=DP)::R0,x_new,ff
      real(kind=DP)::x1,x0,f,f0,f1
      real(kind=DP),dimension(:),allocatable::m
      integer::M0,Q,i,j,k
      real(kind=DP)::y1,y2,q1,q0,f_old,x_old,h
!!      complex(kind=DP),dimension(:,:,:),allocatable::CY
!!      complex(kind=DP),dimension(:),allocatable::CNY
!!      complex(kind=DP),dimension(:,:),allocatable::CYtmp,CNYtmp
      real(kind=DP),dimension(:,:),allocatable::test
!      real(kind=DP),dimension(:),allocatable::t_
      real(DP),dimension(1:3)::vec1,vec0
      integer::ant1,ant0
      ! MAXIT iterations with N-R should be good enough
      integer,parameter::MAXIT=35
      logical::deb,done
      integer,dimension(:),allocatable::is
      integer::num_tests
      num_tests=3
      allocate(is(num_tests))
      if(PRESENT(CO_in)) then
         CO_in(:)=dcmplx(0.0_DP)
      endif
      if(PRESENT(e_in)) then
         e(:)=e_in(:)
!         write(*,*) 'e_in=',e_in(:)
      else
         e(:)=dcmplx(0.0,0.0)
      endif
      !!! Do we use absolute values or real values in h(R)?

      deb=.false.
!      deb=.true.

!      if(interactive) then
!         write(*,*) 'Debugging info for Newtons method? (y/n)'
!         if(get_answer_yn()) then
!            deb=.true.
!         endif
!      endif

      done=.false.
      

      do_interp=.false.
      if(deb) then
         write(*,*) 'in NR_w args: R1,R2=',R1,R2,' x_start=',x_start,        &
     &        ' e=',e,' tol=',tol
      endif
      if(use_abs) then
         write(*,*) 'Using absolute-values!'
      endif
      R0=x_start
      if(abs(R1-R2).lt.tol) then
         ! Can't get closer unless higher precision is supplied
         x_fin=x_start
         er=abs(R1-R2)
         ff=-1.0_DP
         return
      endif
      if(Level.gt.1) then
         Y1=1.72_DP/(real(2*Level,DP))
      else
         Y1=0.35_DP
      endif
      if(tol.lt.1D-10) then
         Y1=0.5_DP*Y1
      endif
      if(PRESENT(Y).and.(Y.gt.0.0_DP)) then
         if(deb) then
            write(*,*) 'Y=',Y
         endif
         Y1=Y
      endif
      if(weight.ne.0.0_DP) then
!!! remember there is 4kY in the argument if weight!=0
         M0=ceiling((R2+15.0_DP*R2**(0.33333333_DP))/(2.0_DP*PI2*Y1))            
      else
!!! else 2kY         
         M0=ceiling((R2+15.0_DP*R2**(0.33333333_DP))/(PI2*Y1))            
      endif
      if(M0.lt.6) then
         M0=6
         if((Level.eq.1).and.(R2.lt.10.0_DP)) then
            call get_M0_Q_Y(R2,M0,Q,Y1)
         endif
      endif
      write(*,*) 'R2,M0,Y1=',R2,M0,Y1
      call get_M0_Q_Y(R2,M0,Q,Y1)
      if((.not.(PRESENT(j1)).or.(j1.eq.0).or.(j2.eq.0)                   &
     &     .or.(j3.eq.0))) then   
         call choose_i1i2i3(i1,i2,i3,M0,par)      
      else
         i1=j1
         i2=j2
         i3=j3
      endif
      if(M0.lt.i1) then
         M0=i1+1
      endif
      if(M0.lt.i2) then
         M0=i2+1
      endif
      if(M0.lt.i3) then
         M0=i3+1
      endif
   
      !!! usually I have Y ok, but there is no guarantee that 1.05*Y is ok..
      Y2=0.98_DP*Y1
      call set_newton_params(R2,M0,Y1,Y2,i1,i2,i3)    
      deb=newton_deb
      if(deb) then 
         open(UNIT=17,FILE='newton_data.txt')
      endif
!c$$$      if((interactive)) then
!c$$$         write(*,*) 'Recommended: M0,Y1,Y2,i1,i2,i3=',M0,Y1,Y2,i1,i2,i3
!c$$$         write(*,*) 'Note: Y-values should not be larger than ',Y0_min  
!c$$$         write(*,*) 'M0?'
!c$$$         read(*,*) M0
!c$$$         write(*,*) 'Y1?'
!c$$$         read(*,*) Y1
!c$$$         write(*,*) 'Y2?'
!c$$$         read(*,*) Y2
!c$$$         write(*,*) 'i1?'
!c$$$         read(*,*) i1
!c$$$         write(*,*) 'i2?'
!c$$$         read(*,*) i2
!c$$$         write(*,*) 'i3?'
!c$$$         read(*,*) i3
!c$$$      endif
      is(1)=i1
      is(2)=i2
      is(3)=i3
      if(.not.(PRESENT(param))) then
         par=0
      else
         par=param
      endif
      Q=M0+10   !max(ceiling(1.5*M0),100) 
!      call get_M0_Q_Y(R2,M0,Q,Y2)
!      if(deb) then
!         write(*,*) 'R,M0,Q,Y=',R2,M0,Q,Y2
!      endif
      if(deb) then
         write(*,*) 'R0,R1,R1=',R0,R1,R2
         write(*,*) 'M=',M0,'Q=',Q,'Y=',Y1,Y2,'CTYPE=',CType
         write(*,*) 'par=',par,' e=',e(:)
      endif
!      allocate(CYtmp(1:num_cusps,1:M0+1))
!      allocate(CNYtmp(1:num_cusps,1:M0))
!      allocate(CY(1:2,0:2,0:M0))
!      allocate(CNY(1:M0))
      allocate(test(0:3,1:M0))
      allocate(m(1:M0))
      m(:)=1.0_DP
      ! First determine which one of R1 and R2 I should start with
      ! other than the initial x_0
      call compute_functional_old(R0,f0,test(0,:),num_tests,m,is,                 &
     &     M0,Q,Y1,Y2,par,e_in,num_set,c_set,which_c,CO,deb)
      f_old=0.0_DP
      x_old=0.0_DP
      call compute_functional_old(R1,f1,test(1,:),num_tests,m,is,               &
     &     M0,Q,Y1,Y2,par,e_in,num_set,c_set,which_c,CO,deb)
      if(deb) then
         write(*,*) 'R0=',R0,' R1=',R1 
         write(*,*) 'i1,i2,i3=',i1,i2,i3      
         do k=2,min(max(8,i3),size(test,2))
            write(*,2099) k,test(1,k),test(0,k)
         enddo
      endif
      if(change_between(0,1,M0,test,num_tests,is)) then! the change is between R1 and x_0
         if(deb) write(*,*) 'zero between R1 and R0'
         x0=R1
         x1=R0
!c     ! f1 is at R0 and f0 at R1 from now on
!c     ! Note that x1 > x0 so we want f1<0 and 0<f0
         do j=1,M0
            if(test(0,j).lt.0.0_DP) then
               m(j)=-1.0_DP               
            endif
            if((j.eq.i1).or.(j.eq.i2).or.(j.eq.i3)) then
               if(deb) write(*,*) 'test(0,',j,')=',test(0,j)
               if(deb) write(*,*) 'test(1,',j,')=',test(1,j)
               if(deb) write(*,*) 'm(',j,')=',m(j)
            endif
         enddo      
         test(3,1:M0)=test(0,1:M0)
         test(0,1:M0)=test(1,1:M0)
         test(1,1:M0)=test(3,1:M0)
         f0=test(0,i1)*m(i1)+test(0,i2)*m(i2)+test(0,i3)*m(i3)
         f1=test(1,i1)*m(i1)+test(1,i2)*m(i2)+test(1,i3)*m(i3)
!         h=f1
!         f1=f0
!         f0=h
         ff=f0
      else
         call compute_functional_old(R2,h,test(2,:),num_tests,m,is,     &
     &        M0,Q,Y1,Y2,par,e_in,num_set,c_set,which_c,CO,deb)
         if(deb) then
            write(*,*) 'R2=',R2
            do k=2,min(max(8,i3),size(test,2))
               write(*,2099) k,test(0,k),test(2,k)
            enddo
         endif
         if(change_between(0,2,M0,test,num_tests,is)) then
!c     !!! keep the zero between x0 and x1
            x0=R0
            x1=R2               ! No need to do this if we don't have to 
                                !!  here x0 < x1 so we want f0< 0 < f1
            test(1,:)=test(2,:)
            do j=1,M0
               if(test(1,j).lt.0.0_DP) then
                  m(j)=-1.0_DP               
               endif
            enddo
            f0=test(0,i1)*m(i1)+test(0,i2)*m(i2)+test(0,i3)*m(i3)
            f1=test(1,i1)*m(i1)+test(1,i2)*m(i2)+test(1,i3)*m(i3)
            ff=f0
         elseif(max(maxval(abs(test(:,i1))),maxval(abs(test(:,i2))))           &
     &           .lt.tol) then
            if(deb) then
               write(*,*) 'Our precision is not sufficient!'
               write(*,*) 'test(:,i1)=',test(:,i1)
               write(*,*) 'test(:,i2)=',test(:,i2)
               write(*,*) 'test(:,i3)=',test(:,i3)
            endif
            x_fin=R0
            er=abs(R1-R2)
            ff=test(0,i1)*m(i1)+test(0,i2)*m(i2)+test(0,i3)*m(i3)
            done=.true.
         else
            if(deb) then
               write(*,*) 'NO Zeros here!'
            endif
            x_fin=R1
            er=2000.0_DP
            ff=-1.0_DP
            done=.true.
         endif
      endif
      if(abs(R0-R1).lt.tol) then ! we are done
         x_fin=R0
         er=abs(R1-R0)
         if(deb) then
            write(*,*) 'the input data is within tolerance!'
         endif
         done=.true.
      elseif(abs(R0-R2).lt.tol) then ! we are done
         x_fin=R0
         er=abs(R2-R0)
         if(deb) then
            write(*,*) 'the input data is within tolerance!'
         endif
         done=.true.
      endif
      !!! the zero is now in the interval [x_0,x_1]
      !!! and the functionvalues are f0 and f1 resp.
      newton_loop: do j=1,MAXIT
      !!! The zero should be between x0 aqnd x1 
      !!! and the crossings should be from x0+ to x1-
      !! here we should have x0 < x1 so f < 0 < f1
      do i=1,M0
         if((i.eq.i1).or.(i.eq.i2).or.(i.eq.i3)) then
            if(test(1,i).lt.0.0_DP) then
               m(i)=-1.0_DP               
            else
               m(i)=1.0_DP
            endif
            if(deb) then
               write(*,*) 'm(',i,')=',m(i)
            endif
         endif
      enddo
      !! offer a way out directly
         if(done) then
            exit newton_loop
         endif
         if(deb) then
            write(*,*) 'fore: x0=',x0,' x1=',x1, 'f0=',f0,                  &
     &           ' f1=',f1
         endif
!         x_new=x1-f1*(x1-x0)/(f1-f0)
         x_new=prediction(x0,f0,x1,f1)
         if(deb) then
            write(*,*) 'efter: x_new=',x_new
            write(*,*) '|x1-x_new|<',abs(x1-x_new)
            write(*,*) '|x0-x_new|<',abs(x0-x_new)
         endif
         if(min(abs(x1-x_new),abs(x0-x_new)).lt.tol) then ! we are done
            x_fin=x_new
            !! compute the coefficients at the last iteration
            call compute_functional_old(x_new,f,test(3,:),num_tests,m,    &
     &           is,M0,Q,Y1,Y2,par,e_in,num_set,c_set,which_c,CO)
            er=abs(f)
            ff=abs(f)
            if(deb) then 
                                !! print out the first few coefficients
               write(*,*) 'coeff. at R=',x_fin
               write(*,*) 'C0=',CO(0)
               write(*,*) 'C-1=',CO(-1)
               write(*,*) 'C2=',CO(2)
               write(*,*) 'C-2=',CO(-2)
               write(*,*) 'C3=',CO(3)
               write(*,*) 'C-3=',CO(3)
               write(*,*) 'C6=',CO(6)
               write(*,*) 'ff=',ff
            endif
            exit newton_loop
         endif
         if((x_new.gt.(R2+eps0)).or.(x_new.lt.(R1-eps0))) then
                    ! We are out of the interval and there was probably just a singularity here
            x_fin=R0
            er=2000.0_DP        ! TO signify something is amiss
            exit newton_loop
         endif
         call compute_functional_old(x_new,f,test(3,:),num_tests,m,is,            &
     &        M0,Q,Y1,Y2,par,e_in,num_set,c_set,which_c,CO,deb)
         ! we are always between x_new and x1
         er=abs(x0-x1)          ! It is always good to have this even if we don't get the correct accuracy
         x_fin=x_new
         if(deb) then
            write(*,*) 'x_new=',x_new
            write(*,*) 'f_new=',f
            write(*,*) '=',test(3,i1),'*',m(i1),'+',test(3,i2),'*',          &
     &           m(i2),'+',test(3,i3),'*',m(i3) 
            write(*,*) 'f1=',f1
            write(*,*) 'f0=',f0
         endif
         if(f.eq.0.0_DP) then
            ! we are definitely done!!!
            er=abs(x0-x1)
            x_fin=x_new
            if(deb) then 
               !! print out the first few coefficients
               write(*,*) 'approx. coeff. at R=',x_fin
               write(*,*) 'C0=',CO(0)
               write(*,*) 'C-1=',CO(-1)
               write(*,*) 'C2=',CO(2)
               write(*,*) 'C-2=',CO(-2)
               write(*,*) 'C3=',CO(3)
               write(*,*) 'C-3=',CO(-3)
            endif
            exit newton_loop
         elseif(abs(f).gt.100.0_DP) then
            write(*,*) 'Probably no zero here!'
            write(*,*) '(f large)'            
            do k=2,min(max(9,i3),size(test,2))
               write(*,2099) k,test(3,k),test(1,k)
            enddo
            do k=2,min(max(9,i3),size(test,2))
               write(*,3000) k,test(3,k),test(0,k)
            enddo
            er=1000.0_DP
            exit newton_loop 
            x_fin=x_new
         endif
 2099    FORMAT('test(new:1,',I1,')=',ES10.3,2X,ES10.3)
 3000    FORMAT('test(new:0,',I1,')=',ES10.3,2X,ES10.3)
        ! We should actually take a bit care here...
        ! It might be that if the differences in size
        ! are to big we might not have a zero anyway
        ! I therefore make additional tests if this is the case
         q1=f/f1
         q0=f/f0
         !! If their decimal expansion differ with more than an order of 10^15
         if(max(abs(log(abs(q1))),abs(log(abs(q0)))).gt.15.0_DP*               &
     &        log(10.0_DP)) then
            vec0(1)=test(3,i1)*test(0,i1)
            vec0(2)=test(3,i2)*test(0,i2)
            vec0(3)=test(3,i3)*test(0,i3)
            vec1(1)=test(3,i1)*test(1,i1)
            vec1(2)=test(3,i2)*test(1,i2)
            vec1(3)=test(3,i3)*test(1,i3)            
            ant0=count(vec0(:) <= 0.0_DP)
            ant1=count(vec1(:) <= 0.0_DP)
            if(deb) then
               write(*,*) 'q1,q0=',q1,q0
               write(*,*)'max=',max(abs(log(abs(q1))),abs(log(abs(q0))))
               write(*,*) 'ant=',ant0,ant1
               do k=1,3
                  write(*,*) 'vec0(',k,')=',vec0(k)
               enddo
               do k=1,3
                  write(*,*) 'vec1(',k,')=',vec1(k)
               enddo
            endif
            if(ant1.gt.ant0) then
               ! More zeros between x1 and x_new
               x0=x1
               f0=f1
               test(0,:)=test(1,:)
               if(deb) write(*,*) 'zero between x_new & x1 ',x_new,x1
            elseif(ant1.eq.ant0) then !If there are equally many choose the smallest
               q0=maxval(vec0)               
               q1=maxval(vec1)
               if(abs(q1).lt.abs(q0)) then
                  x0=x1
                  f0=f1
                  test(0,:)=test(1,:)
                  if(deb) write(*,*) 'zero between x_new & x1 ',x_new,x1
               endif
            endif
            if(deb) then
               do k=2,min(max(9,i3),size(test,2))
                  write(*,*) 'test(3:1,',k,')=',test(3,k),test(1,k)
               enddo
            endif
         else         
            if(deb) then
               write(*,*) 'f=',f
               write(*,*) 'f0=',f0
               write(*,*) 'f1=',f1
            endif
            !!!  It is best to not rely on f, f1 and f2 too much
            if(change_between(1,3,M0,test,num_tests,is)) then
               x0=x_new
               f0=f
               test(0,:)=test(3,:)
               if(deb) write(*,*) 'zero between x_new & x1 ',x_new,x1
            elseif(change_between(0,3,M0,test,num_tests,is)) then
               if(deb) write(*,*) 'zero between x0 & x_new ',x0,x_new
               !!! I want to keep the zero in the interval x0< 0 <x1
               x1=x_new
               f1=f
               test(1,:)=test(3,:)
            else
               if(deb) then
                  write(*,*) 'No zero for all coeffs i1,i2,i3=',i1,i2,i3
                  write(*,*)'f_old=',f_old,' f=',f, ' (and f1=',f1,')'
               endif
               !!! If the value of the differences is getting larger we jump out of the loop
               !!! f is the supposedly most correct value
               if((abs(f_old).ne.(0.0_DP)).and.(abs(f_old).lt.abs(f)))   &
     &              then
                  if(deb) then
                     write(*,*) 'Error is getting worse! f_old=',f_old
                     write(*,*) 'and f_new=',abs(f)
                     write(*,*) 'Best to get out and use old value!'
                  endif
                  er=abs(f_old)
                  x_fin=x_old
                  exit newton_loop
               else
!c     !!! f_old is the first value of f when we get into this
!c     !!! we do not want it to get larger
!c     !!! x_new is the value corresponding to f
                  f_old=f
                  x_old=x_new
                  er=2000.0_DP  ! TO signify something is amiss
                  if(deb) then
                     do k=2,min(max(9,i3),size(test,2))
                        write(*,2099) k,test(3,k),test(1,k)
                     enddo
                     do k=2,min(max(9,i3),size(test,2))
                        write(*,3000)k,test(3,k),test(0,k)
                     enddo
                  endif
                                !!! check to see which seems the best choice
                  if(f*f1.le.0.0_DP)  then  
                                !!! between x1 and x_new seems ok...
                     if(deb) write(*,*) 'Prob. 0 between x_new and x1!'
                     x0=x_new
                     f0=f
                     test(0,:)=test(3,:)
                  elseif(f0*f.le.0.0_DP) then
                                !! We have to go with the other choice
                     if(deb) write(*,*) 'Maybe 0 between x0 and x_new!'
                     x1=x_new
                     f1=f
                     test(1,:)=test(3,:)
                  elseif(((test(1,i1)*test(3,i1).le.0.0_DP).and.                               &
     &                    (test(1,i2)*test(3,i2).le.0.0_DP)).or.                    &
     &                    ((test(1,i1)*test(3,i1).le.0.0_DP).and.                               &
     &                    (test(1,i3)*test(3,i3).le.0.0_DP)).or.                    &
     &              ((test(1,i2)*test(3,i2).le.0.0_DP).and.                               &
     &                    (test(1,i3)*test(3,i3).le.0.0_DP)))  then
                                !!! between x1 and x_new seems ok...
                     if(deb) write(*,*) 'Maybe 0 between x_new and x1!'
                                !! want to keep the zero in interval x0< <x1
                     x0=x_new
                     f0=f
                     test(0,:)=test(3,:)                     
                  else
                                !! We have to go with the other choice
                     if(deb) write(*,*) 'Maybe 0 between x0 and x_new!'
                     x1=x_new
                     f1=f
                     test(1,:)=test(3,:)
                  endif
               endif
            endif
         endif
         if(deb) then
            do k=2,min(max(9,i3),size(test,2))
               write(*,*) 'test(0:1,',k,')=',test(0,k),test(1,k)
            enddo
            write(*,*) 'x0,x1=',x0,x1
         endif
         if((test(0,i2)*test(1,i2).gt.0.0_DP).and.                                  &
     &        (min(test(0,i2),test(1,i2)).gt.1D-3)) then
            if(deb) then
               write(*,*) 'NO Zeros here!'
            endif           
            x_fin=x1
            !! well, we might be at some approximation at leaqst
            if(abs(f).lt.0.01_DP) then
               er=-abs(f)
            else
               er=2000.0_DP
            endif
            exit newton_loop
         endif
      enddo newton_loop
      if((deb).and.(j.ge.MAXIT)) then
         write(*,*) 'Note that MAXIT is exceeded!'
         x_fin=x_new
         !! the minus sign is to tell that we exceeded maxit
         er=-abs(x_new-x1)
         !! compute the coefficients at the last iteration
         call compute_functional_old(x_new,f,test(3,:),num_tests,m,is,            &
     &        M0,Q,Y1,Y2,par,e_in,num_set,c_set,which_c,CO,deb)
         er=-abs(f)
         ff=er
      endif
!      deallocate(CYtmp)
!      deallocate(CNYtmp)
!      deallocate(CY)
!      deallocate(CNY)
      if(deb) then
         write(*,*) 'Out of newton_loop!'
      endif

      if(PRESENT(CO_in)) then
         CO_in=CO
      endif
      if(PRESENT(ff_in)) then
         ff_in=ff
      endif
!      if(deb) then
!         write(*,*) 'CO_in set!'
!      endif
      deallocate(test)!
!      if(deb) then
!         write(*,*) 'test deallocated!'
!      endif

!      deallocate(t_)
      end subroutine get_eigenv_by_NR_w_old

      !! Predicts x0- the zero of a linear function f(x1)=y1 and f(x2)=y2 
      function prediction(x1,y1,x2,y2)
      implicit none
      real(DP)::x1,y1,x2,y2,x0,prediction
      if(x2.ne.x1) then
           x0=x1-y1*(x2-x1)/(y2-y1)
      else
         write(*,*) 'You must have two DIFFERENT points in Newton!'
         write(*,*) 'Have x1,x2=',x1,x2
         stop
      endif
      prediction=x0
      end function

      !!! computes the functional h=|c(y1,i1)-c(y2,i1)|+...+|c(y1,in)-c(y2,in)|
      !!! or, rather h'=m(i1)*(c(y1,i1)-c(y2,i1))+...+m(in)*(c(y1,in)-c(y2,in))
      subroutine compute_functional_cplx(R,h,test,m,M0,Q,Y1,Y2,CP0,CN0)
      implicit none
      real(kind=DP),intent(in)::R
      real(DP)::Y1,Y2,h
      integer::M0,Q
      complex(DP),dimension(1:ant_tests)::test
      real(DP),dimension(1:ant_tests)::m
      complex(DP),dimension(1:ant_tests)::abs_test
      complex(DP),dimension(1:M0+1),optional::CP0
      complex(DP),dimension(1:M0),optional::CN0
      integer::a,b,j
      logical::deb_loc
      complex(DP)::diff,tmp
      complex(kind=DP),dimension(:,:),allocatable::CY,CNY,CY2
      allocate(CY(1:num_cusps,1:M0+1))
      allocate(CNY(1:num_cusps,1:M0))
      allocate(CY2(1:num_cusps,1:M0+1))
 !     test(:)=0.0_DP

!      call set_norm(par,num_set,c_set,e_in,which_c)
!      write(*,*) 'deb=',deb
!      write(*,*) 'num_tests=',num_tests
      deb_loc=newton_deb
!      deb_loc=.true.
      if(.not.(allocated(min_test))) then 
         allocate(min_test(1:ant_tests))
         min_test(:)=czero
      endif
      if(deb_loc) then
!         write(*,*) 'in comp_func!'
!         write(*,*) 'R=',R,' Y1=',Y1,' Y2=',Y2,' M0=',M0,' Q=',Q
         write(*,3187) R,Y1,Y2,M0,Q
         write(*,*) 'Use absolute=',use_abs
!         do j=1,ant_tests
!            write(*,*) n_tests(j,1),n_tests(j,2)
!         enddo
      endif
 3187 FORMAT('R=',F25.20,' Y1=',F15.10,' Y2=',F15.10,' M0=',I4,' Q=',I4)
!         write(*,3187) R,Y1,Y2,M0,Q
!      write(*,*) 'sizeCY=',size(CY,1),size(CY,2)
!      write(*,*) 'sizeCNY=',size(CNY,1),size(CNY,2)
      call compute_coeffs_cplx(R,CY,CNY,M0,Y1,Q)
!         do j=2,7
!            write(*,*) 'CY(',j,')=',CY(1,j)
!         enddo
         if(use_two_y) then
         if(deb_loc) then
            write(*,*) 'Use two Ys'
         endif
         call compute_coeffs_cplx(R,CY2,CNY,M0,Y2,Q)
!         do j=2,7
!            write(*,*) 'CY2(',j,')=',CY2(1,j)
!         enddo
      endif
      h=0.0_DP
      do j=1,ant_tests
         a=n_tests(j,1)
         b=n_tests(j,2)
         if(use_two_y) then 
!            if(use_abs) then
!               test(j)=(abs(CY(1,a+1))-abs(CY2(1,a+1)))
!            else
               test(j)=CY(1,a+1)-CY2(1,a+1)
!            endif
            if((deb_loc)) then
               write(*,*) 'a=',a
               write(*,*) 'b=',b

               write(*,*) 'test(',j,')=',test(j),'=',real(CY(1,a+1),DP),      &
     &              '-',real(CY2(1,a+1),DP)
            endif
         elseif(a*b.ne.0) then 
            call Hecke_relations(CY(1,2:M0+1),M0,a,b,diff)   
            !!! Have to determine which type of test to do
            abs_test(j)=diff
            if(use_abs) then 
               test(j)=abs(diff)
            else
               if(abs(min_test(j)).eq.0.0_DP) then
                  min_test(j)=diff
               endif
               tmp=diff*dcmplx(abs(min_test(j)),0.0-DP)/min_test(j)
               if(abs(dimag(tmp)).gt.abs(real(tmp,DP))) then 
                  write(*,*) 'WARNING!'
                  write(*,*) 'The curve has twisted more than 45deg!'
               endif
               test(j)=abs(min_test(j))*real(diff/min_test(j),DP)
            endif
            if(deb_loc) then
               write(*,*) 'relation(',j,')=',diff
               write(*,*) 'Re(Tj*|Tj0|/Tj0(',j,'))=',test(j)
!abs(diff),argument(diff)/PI2
            endif
         else
            write(*,*) 'Error with the tests chosen!'
            write(*,*) 'test',j,'a,b=',a,b              
         endif
      enddo
      !! Pick the value with smallest absolute-value
      !! for the first time at least
      
!c$$$      do j=1,ant_tests
!c$$$!         if(deb_loc) then
!c$$$!            write(*,*) 'abs_test ',j,'=',abs_test(j)
!c$$$!            write(*,*) 'min_test ',j,'=',min_test(j)
!c$$$!         endif
!c$$$         if(abs(abs_test(j)).lt.abs(min_test(j))) then
!c$$$            min_test(j)=abs_test(j)
!c$$$            if(deb_loc) then
!c$$$               write(*,*) 'smallest ',j,'=',abs_test(j)
!c$$$            endif
!c$$$         endif
!c$$$      enddo
      do j=1,ant_tests
         h=h+m(j)*test(j)
      enddo
      
      if(deb_loc) then
         write(*,*) 'h(',R,')=',h
      endif
!            test(is(j))=(abs(CY(1,is(j)))-abs(CY2(1,is(j))))
!         else
!            test(is(j))=(real(CY(1,is(j)),DP)-real(CY2(1,is(j)),DP))
!         endif
!            h=h+m(j)*test(is(j))
!      enddo
      if(present(CP0)) then 
         CP0(:)=CY(1,:)
      endif
      if(present(CN0)) then 
         CN0(:)=CNY(1,:)
      endif
      end subroutine compute_functional_cplx

    !!! computes the functional h=|c(y1,i1)-c(y2,i1)|+...+|c(y1,in)-c(y2,in)|
      !!! or, rather h'=m(i1)*(c(y1,i1)-c(y2,i1))+...+m(in)*(c(y1,in)-c(y2,in))
      subroutine compute_functional_cplx2(R,h,test,m,M0,Q,Y1,Y2,CP0,CN0)
      implicit none
      real(kind=DP),intent(in)::R
      real(DP)::Y1,Y2,h
      integer::M0,Q
      real(DP),dimension(1:ant_tests)::test
      real(DP),dimension(1:ant_tests)::m
      complex(DP),dimension(1:ant_tests)::abs_test
      complex(DP),dimension(1:M0+1),optional::CP0
      complex(DP),dimension(1:M0),optional::CN0
      integer::a,b,j
      logical::deb_loc
      complex(DP)::diff,tmp
      complex(kind=DP),dimension(:,:),allocatable::CY,CNY,CY2
      allocate(CY(1:num_cusps,1:M0+1))
      allocate(CNY(1:num_cusps,1:M0))
      allocate(CY2(1:num_cusps,1:M0+1))
      deb_loc=newton_deb
      if(.not.(allocated(min_test))) then 
         allocate(min_test(1:ant_tests))
         min_test(:)=czero
      endif
      if(deb_loc) then
!         write(*,*) 'in comp_func!'
!         write(*,*) 'R=',R,' Y1=',Y1,' Y2=',Y2,' M0=',M0,' Q=',Q
         write(*,3187) R,Y1,Y2,M0,Q
         write(*,*) 'Use absolute=',use_abs
      endif
 3187 FORMAT('R=',F25.20,' Y1=',F15.10,' Y2=',F15.10,' M0=',I4,' Q=',I4)
      call compute_coeffs_cplx(R,CY,CNY,M0,Y1,Q)
         if(use_two_y) then
         if(deb_loc) then
            write(*,*) 'Use two Ys'
         endif
         call compute_coeffs_cplx(R,CY2,CNY,M0,Y2,Q)
!         do j=2,7
!            write(*,*) 'CY2(',j,')=',CY2(1,j)
!         enddo
      endif
      h=0.0_DP
      do j=1,ant_tests
         a=n_tests(j,1)
         b=n_tests(j,2)
         if(use_two_y) then 
            if(use_abs) then
               test(j)=(abs(CY(1,a+1))-abs(CY2(1,a+1)))
            else
              test(j)=real(CY(1,a+1)-CY2(1,a+1),DP)
            endif
            if((deb_loc)) then
               write(*,*) 'a=',a
               write(*,*) 'b=',b

               write(*,*) 'test(',j,')=',test(j),'=',real(CY(1,a+1),DP),      &
     &              '-',real(CY2(1,a+1),DP)
            endif
         elseif(a*b.ne.0) then 
            call Hecke_relations(CY(1,2:M0+1),M0,a,b,diff)   
            !!! Have to determine which type of test to do
            abs_test(j)=diff
            if(use_abs) then 
               test(j)=abs(diff)
            else
               if(abs(min_test(j)).eq.0.0_DP) then
                  min_test(j)=diff
               endif
               tmp=diff*dcmplx(abs(min_test(j)),0.0-DP)/min_test(j)
               if(abs(dimag(tmp)).gt.abs(real(tmp,DP))) then 
                  write(*,*) 'WARNING!'
                  write(*,*) 'The curve has twisted more than 45deg!'
               endif
               test(j)=abs(min_test(j))*real(diff/min_test(j),DP)
            endif
            if(deb_loc) then
               write(*,*) 'relation(',j,')=',diff
               write(*,*) 'Re(Tj*|Tj0|/Tj0(',j,'))=',test(j)
!abs(diff),argument(diff)/PI2
            endif
         else
            write(*,*) 'Error with the tests chosen!'
            write(*,*) 'test',j,'a,b=',a,b              
         endif
      enddo
      do j=1,ant_tests
         h=h+m(j)*test(j)
      enddo
      
      if(deb_loc) then
         write(*,*) 'h(',R,')=',h
      endif
      if(present(CP0)) then 
         CP0(:)=CY(1,:)
      endif
      if(present(CN0)) then 
         CN0(:)=CNY(1,:)
      endif
      end subroutine compute_functional_cplx2

      subroutine compute_functional_old_cplx(R,h,test,num_tests,m,is,          & 
     &     M0,Q,Y1,Y2,par,e_in,num_set,c_set,which_c,CO,deb)
      implicit none
      real(kind=DP),intent(in)::R
      real(DP)::Y1,Y2,h
      integer::M0,Q,num_tests
      complex(DP),dimension(1:M0)::test
      integer,dimension(1:num_tests)::is
      real(DP),dimension(1:M0)::m
      complex(DP),dimension(1:real_num_cusps),optional::e_in
!      complex(DP),dimension(1:real_num_cusps)::e
      complex(DP),dimension(:),optional::c_set
      integer,dimension(:),optional::which_c
      integer,intent(in),optional::num_set
      complex(DP),dimension(-3:6),optional::CO
      integer,optional::par
      integer::j
      logical,optional::deb
      logical::deb_loc
      complex(kind=DP),dimension(:,:),allocatable::CY,CNY,CY2
      allocate(CY(1:num_cusps,1:M0+1))
      allocate(CNY(1:num_cusps,1:M0))
      allocate(CY2(1:num_cusps,1:M0+1))
      test(:)=0.0_DP
      if(present(e_in)) then
         call set_cusp_norm(e_in)
      endif
      if(PRESENT(deb)) deb_loc=deb
      if(deb_loc) then
         
         write(*,*) 'R=',R,' Y1=',Y1,' Y2=',Y2,' M0=',M0,' Q=',Q,         &
     &        ' use_abs=',use_abs
         write(*,*) 'is(:)=',is(:)
      endif
      call compute_coeffs_cplx(R,CY,CNY,M0,Y1,Q)
      call compute_coeffs_cplx(R,CY2,CNY,M0,Y2,Q)
      h=0.0_DP
      do j=1,M0-1
!         if(use_abs) then
!            test(j)=(abs(CY(1,j+1))-abs(CY2(1,j+1)))
!         else
         test(j)=CY(1,j+1)-CY2(1,j+1)
!         endif
         if((deb_loc).and.(j.le.4)) then
            write(*,*) 'test(',j,')=',test(j),'=',real(CY(1,j+1),DP),      &
     &           '-',real(CY2(1,j+1),DP)
         endif
      enddo
      do j=1,num_tests
         h=h+m(is(j))*real(test(is(j)),DP)
      enddo
      if(deb_loc) then
         write(*,*) 'h(',R,')=',h
      endif
      CO(0)=CY(1,1)             !c0
      CO(1)=CY(1,2)             !c1
      CO(-1)=CNY(1,1)           !c-1
      CO(2)=CY(1,3)             ! c2
      CO(-2)=CNY(1,2)           !c-2
      CO(3)=CY(1,4)
      CO(-3)=CNY(1,3)
      CO(6)=CY(1,7)
      end subroutine compute_functional_old_cplx


      subroutine compute_functional_old_re(R,h,test,num_tests,m,is,          & 
     &     M0,Q,Y1,Y2,par,e_in,num_set,c_set,which_c,CO,deb)
      implicit none
      real(kind=DP),intent(in)::R
      real(DP)::Y1,Y2,h
      integer::M0,Q,num_tests
      real(DP),dimension(1:M0)::test
      integer,dimension(1:num_tests)::is
      real(DP),dimension(1:M0)::m
      complex(DP),dimension(1:real_num_cusps),optional::e_in
!      complex(DP),dimension(1:real_num_cusps)::e
      complex(DP),dimension(:),optional::c_set
      integer,dimension(:),optional::which_c
      integer,intent(in),optional::num_set
      complex(DP),dimension(-3:6),optional::CO
      integer,optional::par
      integer::j
      logical,optional::deb
      logical::deb_loc
      complex(kind=DP),dimension(:,:),allocatable::CY,CNY,CY2
      allocate(CY(1:num_cusps,1:M0+1))
      allocate(CNY(1:num_cusps,1:M0))
      allocate(CY2(1:num_cusps,1:M0+1))
      test(:)=0.0_DP
      if(PRESENT(deb)) deb_loc=deb
      if(deb_loc) then
         write(*,*) 'R=',R,' Y1=',Y1,' Y2=',Y2,' M0=',M0,' Q=',Q,         &
     &        ' use_abs=',use_abs
         write(*,*) 'is(:)=',is(:)
      endif
      if(present(e_in)) then
         call set_cusp_norm(e_in)
      endif
      call compute_coeffs_cplx(R,CY,CNY,M0,Y1,Q)
      call compute_coeffs_cplx(R,CY2,CNY,M0,Y2,Q)
      h=0.0_DP
      do j=1,M0-1
         if(use_abs) then
            test(j)=(abs(CY(1,j+1))-abs(CY2(1,j+1)))
         else
            test(j)=real(CY(1,j+1),DP)-real(CY2(1,j+1),DP)
         endif
         if((deb_loc).and.(j.le.4)) then
            write(*,*) 'test(',j,')=',test(j),'=',real(CY(1,j+1),DP),      &
     &           '-',real(CY2(1,j+1),DP)
         endif
      enddo
      do j=1,num_tests
         h=h+m(is(j))*test(is(j))
      enddo
      if(deb_loc) then
         write(*,*) 'h(',R,')=',h
      endif
      CO(0)=CY(1,1)             !c0
      CO(1)=CY(1,2)             !c1
      CO(-1)=CNY(1,1)           !c-1
      CO(2)=CY(1,3)             ! c2
      CO(-2)=CNY(1,2)           !c-2
      CO(3)=CY(1,4)
      CO(-3)=CNY(1,3)
      CO(6)=CY(1,7)
      end subroutine compute_functional_old_re


     !!! computes the functional h=|c(y1,i1)-c(y2,i1)|+...+|c(y1,in)-c(y2,in)|
      !!! or, rather h'=m(i1)*(c(y1,i1)-c(y2,i1))+...+m(in)*(c(y1,in)-c(y2,in))
      subroutine compute_functional_re(R,h,test,m,M0,Q,Y1,Y2,CP0,type,e)
      implicit none
      real(kind=DP),intent(in)::R
      real(DP)::Y1,Y2,h
      integer::M0,Q
      real(DP),dimension(1:ant_tests)::test
      real(DP),dimension(1:ant_tests)::m
      real(DP),dimension(1:M0),optional::CP0
      real(DP)::e(1:num_cusps)
      integer::a,b,j,type
      logical::deb_loc
      real(DP)::diff,tmp
      real(kind=DP),dimension(:,:),allocatable::CY,CY2
!      allocate(CY(1:num_cusps,1:M0))
!      allocate(CY2(1:num_cusps,1:M0))
!      call set_norm(par,num_set,c_set,e_in,which_c)
      deb_loc=newton_deb
!      deb_loc=.true.
      if(.not.(allocated(min_test))) then 
         allocate(min_test(1:ant_tests))
         min_test(:)=czero
      endif
!      write(*,*) 'comp_fun:R=',R,' Y1=',Y1,' Y2=',Y2,' M0=',M0,' Q=',Q
      if(deb_loc) then
!         write(*,*) 'in comp_func!'
!         write(*,*) 'R=',R,' Y1=',Y1,' Y2=',Y2,' M0=',M0,' Q=',Q
         write(*,3187) R,Y1,Y2,M0,Q
         write(*,*) 'Use absolute=',use_abs
!         do j=1,ant_tests
!            write(*,*) n_tests(j,1),n_tests(j,2)
!         enddo
      endif
 3187 FORMAT('R=',F25.20,' Y1=',F15.10,' Y2=',F15.10,' M0=',I4,' Q=',I4)
      call set_cusp_norm(e)
      call compute_coeffs_real(R,CY,type,e,M0,Q,Y1)
      if(deb_loc) then
         write(*,*) 'R=',R,'Y1=',Y1
            write(*,*) 'e=',e(:)
         do j=2,7
            write(*,*) 'CY1(',j,')=',CY(1,j)
         enddo
      endif
      if(use_two_y) then
         call compute_coeffs_real(R,CY2,type,e,M0,Q,Y2)
         if(deb_loc) then
            write(*,*) 'Use two Ys'
            write(*,*) 'R=',R,'Y2=',Y2
            do j=2,7
               write(*,*) 'CY2(',j,')=',CY2(1,j)
            enddo
         endif
      endif
      h=0.0_DP
      do j=1,ant_tests
         a=n_tests(j,1)
         b=n_tests(j,2)
         if(use_two_y) then 
            test(j)=CY(1,a)-CY2(1,a)
            if((deb_loc)) then
               write(*,*) 'a=',a
               write(*,*) 'b=',b
               write(*,*) 'test(',j,')=',test(j),'=',real(CY(1,a),DP),      &
     &              '-',real(CY2(1,a),DP)
            endif
         elseif(a*b.ne.0) then 
            call Hecke_relations(CY(1,1:M0),M0,a,b,diff)   
            !!! Have to determine which type of test to do
            if(abs(min_test(j)).eq.0.0_DP) then
               min_test(j)=diff
            endif
!            tmp=diff*min_test(j)/min_test(j)
!            if(abs(tmp).gt.abs(real(tmp,DP))) then 
!               write(*,*) 'WARNING!'
 !              write(*,*) 'The curve has twisted more than 45deg!'
!            endif
            test(j)=abs(min_test(j))*real(diff/min_test(j),DP)
            if(deb_loc) then
               write(*,*) 'relation(',j,')=',diff
               write(*,*) 'Re(Tj*|Tj0|/Tj0(',j,'))=',test(j)
!abs(diff),argument(diff)/PI2
            endif
         else
            write(*,*) 'Error with the tests chosen!'
            write(*,*) 'test',j,'a,b=',a,b              
         endif
      enddo
      !! Pick the value with smallest absolute-value
      !! for the first time at least
      do j=1,ant_tests
         h=h+m(j)*test(j)
      enddo
      if(deb_loc) then
         write(*,*) 'h(',R,')=',h
      endif
      if(present(CP0)) then 
         CP0(:)=CY(1,:)
      endif
      end subroutine compute_functional_re

   
     

      function change_between(x1,x2,M0,test,num_tests,is)
      implicit none
      integer::x1,x2,num_tests,M0
      real(DP),dimension(0:3,1:M0)::test
      integer,dimension(1:num_tests)::is
      integer::j
      logical::change_between
      change_between=.true.
      do j=1,num_tests
         if(test(x1,is(j))*test(x2,is(j)).gt.0.0_DP) then
            change_between=.false.
            return
         endif
      enddo

      end function 


      subroutine clean_newton()
      implicit none
      if(allocated(n_tests)) deallocate(n_tests)
      if(allocated(min_test)) deallocate(min_test)
      end subroutine



      end module

