      module phase2
      use coefficients
      !!! Sets the level of output to STDOUT 
      !!   1 => shouts all kind of uneccesary stuff
      !!   0 => prints a lot of helpful stuff but that are unecessary if everything is ok
      !!  -1 => skips even the initial "greeting" kind of messages
      !! <-1 => really quiet
      integer::phase2_silent
      contains
   



     !! Even more optimized for real character
      !! and Prime number, e.g. including symmetries...
      subroutine phase2_new(R,Y,M0,NA,NB,NN,CY,CY2,type,e,contig) 
      use commonvariables
      use system
      use giant_mod
      use groups
      use characters
      use kbessel
      use interpolation
      implicit none
      integer :: NA,NB,Q,M0,M,type,j  
      real(kind=DP) :: Y,R
      complex(kind=DP),dimension(1:M0*num_cusps) :: CY
      complex(kind=DP),dimension(1:((NN)*num_cusps)) :: CY2
      real(kind=DP), dimension(0:num_cusps-1) :: e
      complex(DP)::summa,tmp1
      integer :: n,l,icusp,jcusp,NN,NNA,min_j
      logical,optional::contig
      real(DP),dimension(:,:,:,:),allocatable::KBvec
      complex(DP)::Vnlij
      real(kind=DP)::minimum,error,max_y,min_y
      real(DP)::xpb,ypb,l_r,n_r,rkbes,tmp,argpb,arg_m
      real(DP)::tmpVIm,tmpVR
      complex(DP)::tmpV
      integer::y_j,i
      character*70::UTFILNAME
      character(LEN=20)::filtyp
      logical::ch_real
      ! Q should be for NB
      call get_M(R,Y,M)
      Q=max(M+10,100)
      if(present(contig)) then
         contig=contig
      else
         contig=.false.
      endif
      if((CType.eq.1).and.(Level.eq.7)) then
         ch_real=.false.
      else
         ch_real=.true.
      endif
      filtyp='temp_coeff'
      i=anint(e(1))
      UTFILNAME=make_filename(filtyp,Level,type,i,1,R)
      open(15,FILE=UTFILNAME)
      write(*,*) 'in phase 2 even R=',R,'Y=',Y,' Q=',Q,' M0=',M0
      write(*,*) 'NA=',NA,' NB=',NB,'  M=',M
      write(*,*) 'type=',type,' parity=',e
      write(*,*) 'Width=',Width
      write(*,*) 'size(CY)=',size(CY), 'size(CY2)=',size(CY2)

      if(NA.gt.M0) then
         if(contig) then        !If we want to have a contiguous set of coefficients
            NNA=M0
         else
            write(*,*) 'You will get a gap between old and new',                 &
     &           'coefficients!'            
         NNA=NA
      endif
      else
         NNA=NA
         contig=.true.
      endif
      if(contig) then
         do n=1,NNA-1
            do jcusp=0,num_cusps-1
               CY2(jcusp*(NB)+n)=CY(jcusp*M0+n)
            enddo
         enddo
      endif
      ! we will change Y if the error gets too big
      ! but no more than 100 times
      call setup_interp_kbes(R)
      Yloop: do y_j=1,100
      call get_M(R,Y,M)
      Q=max(M+10,100)
      write(*,*) 'Y=',Y,' Q=',Q
      write(*,*) 'NA=',NA,' NB=',NB,'  M=',M
      if((ch_real).and.(weight.eq.0.0)) then
         sampletype=2
         call get_pb_points(R,Y,Q)                                           
      else
         sampletype=1
         call get_pb_points_cplx_char(R,Y,Q)                                 
      endif
      write(*,*) 'points done!'
      write(*,*) 'Q_start=',Q_start
      write(*,*) 'Q_start=',Q_stop

      if(allocated(KBvec)) then
         deallocate(KBvec)
      endif
      allocate(KBvec(1:M0,0:num_cusps-1,0:num_cusps-1,Q_start:          &
     &     Q_stop))      
      minimum=10.0_DP
      min_j=0
      max_y=maxval(Y_pb_s)*2.0_DP*Pi
      min_y=minval(Y_pb_s)
      write(*,*) 'min y_pb=',min_y
      write(*,*) 'max 2Pi(na)y=',max_y*NA
      write(*,*) 'max 2Pi(nb)y=',max_y*NB
 !     write(*,*) 'sample_norm=',sample_norm
!      stop
      do icusp=0,num_cusps-1
         do jcusp=0,num_cusps-1
            do l=1,M0
               l_r=real(l,DP)*PI2
               do j=Q_start,Q_stop  
                                ! the point is near the j:th-cusp)
                  ypb=Y_pb_s(icusp,jcusp,j)
                  if(ypb.gt.0.0_DP) then  
                     rkbes=interp_kbes(l_r*ypb)                  
!                     rkbes = RKBessel(R,l_r*ypb)
                     KBvec(l,icusp,jcusp,j)=rkbes*sqrt(ypb)
!                     if(rkbes.eq.0) then
!                        write(*,*) 'RKBES(',R,',',PI2*l_r*ypb,')=0'
                  endif
               enddo
            enddo
         enddo
      enddo
      !! I probably could replace the Y_pb_s vector with an indicator vector of integers instead to save some memory
!      if(allocated(Y_pb_s)) then
!         deallocate(Y_pb_s)
!      endif
      write(*,*) 'Done computing K-Bessel!'
!      write(*,*) 'bessel_max=',maxval(KBvec)
      do n=NNA,NB         
         n_r=real(n,DP)*PI2
         do icusp=0,num_cusps-1
            summa=dcmplx(0.0_DP,0.0_DP)            
            do jcusp=0,num_cusps-1
               tmp1=dcmplx(0.0_DP,0.0_DP) 
               do l=1,M0
                  if(abs(CY(l+jcusp*M0)).eq.0.0_DP) then
                     cycle
                  endif
                                ! MAke the V_nl^ij
                  Vnlij = dcmplx(0.0_DP,0.0_DP) !
                  l_r=real(l,DP)*PI2
                  do j=Q_start,Q_stop  
                     ypb=Y_pb_s(icusp,jcusp,j)
                     if(ypb.gt.0.0_DP) then ! the point is near the j:th-cusp)
                        xpb=X_pb_s(icusp,jcusp,j)
           !                        rkbes = interp_kbes(l_r*ypb)
                  !     rkbes = RKBessel(R,l_r*ypb)
!                        tmp=rkbes*sqrt(ypb)
                        tmp=KBvec(l,icusp,jcusp,j)
                                !                        if(tmp.ne.0.0_DP) then
                        argpb=l_r*xpb ! l_r including 2*PI
                        arg_m=n_r*Xm_s(j) ! n_r including 2*PI
                        if(type.eq.0) then
                           tmpVR=dcos(argpb)*dcos(arg_m)
                           tmpVIm=0.0_DP
                        else
                           tmpVR=dsin(argpb)*dsin(arg_m)
                           tmpVIm=0.0_DP
                        endif
                        tmpV=dcmplx(tmp*tmpVR,tmp*tmpVIm)                         
                        Vnlij = Vnlij + tmpV*                                    &
     &                       dcmplx(char_vec_r_s(icusp,jcusp,j)                  &
     &                       ,0.0)                              
                     endif
                  enddo
                  Vnlij=Vnlij*dcmplx(sample_norm,0.0_DP)
                  tmp1=tmp1+CY(l+jcusp*M0)*Vnlij
               enddo               
               summa=summa+tmp1
            enddo

            tmp=sqrt(Y)*RKBessel(R,PI2*real(n,DP)*Y)
            if(abs(tmp).lt.minimum) then
               minimum=abs(tmp)
               min_j=n
            endif
            if(tmp.ne.0.0_DP) then
               CY2(icusp*(NB)+n)=summa/dcmplx(tmp,0.0_DP)
               ! In case we can't finish in time we get partial 
               ! results anyway

            else
                                ! If K_IR(2piny)=0 we need to get smaller Y
               write(*,*) 'Warning!: tmp=',tmp
               write(*,*) 'RKBesselIP(',R,',',PI2*real(n,DP)*Y,')=',                 &
     &              rkbes
               write(*,*) 'Decreasing  Y!'
               Y=0.95_DP*Y
               NNA=n            ! Meaning we will do this one over again
               cycle Yloop
            endif
         enddo
         ! Error control number
         ! When too large we change the Y and continue
         ! 
         error=abs(abs(CY2(n))-abs(CY2(n+NB)))
         if(error.gt.10E-11_DP) then
            write(*,*) 'Warning Y to big!'
            write(*,*) 'We got CY2(',n,')=',CY2(n),' er=',error
            write(*,*) 'Halving Y!'
            Y=0.9_DP*Y
            NNA=n         ! Meaning we will do this one over again
            cycle Yloop
         else
            write(*,3821) n,CY2(n),error
            write(15,3821) n,CY2(n),error
            call FLUSH(15)
         endif

      enddo
      exit Yloop
      enddo Yloop
!      call display_coefficients(CY2,NN,NN,1)
      write(*,*) 'min K_iR(2Pi*Y*',min_j,')=',minimum
      
 3821 FORMAT('C(',I5,')=',F27.12,'+I*',F17.12,5X,ES10.4)   
      end subroutine phase2_new




      subroutine phase2_cplxchar2(R,Y,M0,NA,NB,NN,CY,CYP,CYN,           &
     &     tol0,type) 
      use commonvariables
      use system
      use giant_mod
      use groups
      use characters
      use kbessel
      use whittakerw
      use interpolation
!      use permutations
      implicit none
      integer :: NA,NB,Q,M0,M,j
      real(kind=DP) :: Y,R
      real(DP),optional::tol0
      integer,optional::type
!      integer::type
      real(DP)::tol
      complex(kind=DP),dimension(1:num_cusps,-M0:M0) :: CY
      complex(kind=DP),dimension(1:num_cusps,1:NN) :: CYN
      complex(kind=DP),dimension(1:num_cusps,0:NN) :: CYP
      complex(kind=DP),allocatable,dimension(:,:)::CY2N,CY2P
!      real(kind=DP), dimension(0:num_cusps-1) :: e
      integer :: n,l,icusp,jcusp,NN,NNA,min_j
      real(DP),dimension(:,:,:,:,:),allocatable::KBvec
      real(DP)::l_r,argpb,minimum,error
      real(DP)::n_r_p,n_r_n,arg_m_p,arg_m_n
      complex(DP)::tmpV_p,tmpV_n,tmp_p,tmp_n,summa_p,summa_n
      complex(DP)::Vnlij_p,Vnlij_n
      real(DP)::tmp,ll_ypb
      integer::y_j
      character*70::UTFILNAME
      character(LEN=20)::filtyp
      real(DP)::xpb,ypb,Y1,wt,alpha,ll_ypb_old
      integer::i_stop
      logical::do_k_vec
      integer::y_i,y_start,y_stop,IO
      real(DP),dimension(1:2)::Yvec
      !! this sets the tolerance of our algorithm
      write(*,*) 'phase2test: NN=',NN
      tol=1.0E-8_DP
      if(PRESENT(tol0)) then
!         write(*,*) 'phase2test: tol=',tol0
         tol=tol0
         if(tol0.eq.0.0) then
            tol=10E-9_DP
            if(weight.ne.0.0) then
               tol=10E-9_DP
            endif
         endif
!         stop
      else
         tol=10E-9_DP
         if(weight.ne.0.0) then
            tol=10E-9_DP
         endif
      endif
      if((tol.gt.10E-6_DP).and.(weight.ne.0.0)) then
         tol=10E-9_DP
      endif

!      write(*,*) 'phase2test: NN=',NN

      if(Level.eq.1) then
         allocate(CY2P(0:1,0:NN))
         allocate(CY2N(0:1,0:NN))
      endif
!c$$$      do k=0,num_cusps-1
!c$$$         write(*,*) 'C4=',CY(k,4),CY(k,-4)         
!c$$$      enddo
      ! Q should be for NB
      write(*,*) 'R=',R,' Y=',Y
      M=0
      call get_M(R,Y,M)
      Q=max(M+10,100)
!c$$$      if(present(contig)) then
!c$$$         contig=contig
!c$$$      else
!c$$$         contig=.false.
!c$$$      endif

      filtyp='temp_coeff'
      UTFILNAME=make_filename(filtyp,Level,type,NA,1,R)
      open(15,FILE=UTFILNAME,IOSTAT=IO)

      write(*,*) 'in phase 2 cplxchar2 R=',R,'Y=',Y,' Q=',Q,' M0=',M0
      write(*,*) 'NA=',NA,' NB=',NB,'  M=',M,' tol=',tol
      write(*,*) 'type=',type
      write(*,*)  'weight=',weight
      write(*,*) 'Width=',Width, 'tol=',tol
      write(*,*) 'size(CY,1)=',size(CY,1), 'size(CY,2)=',size(CY,2)
      nna=na
     
      ! we will change Y if the error gets too big
      ! but no more than 100 times
    !  if(do_interp) then
    
    !  endif
      call get_alphas()
      alpha=10.0_DP
      do j=1,num_cusps
         if(alphas(j).lt.alpha) then
            alpha=alphas(j)
         endif
      enddo


      Yloop: do y_j=1,100
!      call get_M(R,Y,M)
      Y1=Y*1.05_DP
      !! we make sure that Y < Y1
      call get_M0_Q_Y(R,M,Q,Y)
!      Q=max(M+10,100)
      write(*,*) 'Y=',Y,' Y1=',Y1,' Q=',Q
      write(*,*) 'NA=',NA,' NB=',NB,'  M=',M
      
      if(Level.eq.1) then
         y_start=1
         y_stop=2
         Yvec(1)=Y
         Yvec(2)=Y1
      else
         y_start=1
         y_stop=1
         Yvec(1)=Y
      endif
      if(Na.eq.1) then
         i_stop=num_cusps
      else
         i_stop=1
      endif
      i_stop=num_cusps

      
      if(weight.eq.0.0) then
         call setup_interp_kbes(R,Y)
      elseif(do_interp) then
         call setup_interp_WhittW(R,alpha,Y)
      endif
      write(*,*) 'as compared to Antal==',(2*M0+1)*2*Q
      sampletype=1
      if(Level.ne.1) then
         call get_pb_points_cplx_char(R,Y,Q)                                 
!     &        Q_start,Q_stop,sample_norm,sampletype,.false.)
      else
         !! make two sets of points
         call get_pb_points_cplx_char2(R,Y,Y1,Q)                            
!     &        Q_start,Q_stop,sample_norm,sampletype,.false.)
      endif
!      max_y=maxval(Y_pb_s)*2.0_DP*Pi
!      min_y=minval(Y_pb_s)
!      write(*,*) 'min y_pb=',min_y
!      write(*,*) 'max 2Pi(na)y=',max_y*NA
!      write(*,*) 'max 2Pi(nb)y=',max_y*NB


      write(*,*) 'Q_start=',Q_start
      write(*,*) 'Q_start=',Q_stop
      write(*,*) 'sample_norm=',sample_norm
      minimum=10.0_DP
      min_j=0


      do_k_vec=.false.
      do_k_vec=.true.
      
      if((do_k_vec)) then 
!.and.(weight.eq.0.0)) then
         if(allocated(KBvec)) then
            deallocate(KBvec)
         endif
         allocate(KBvec(-M0:M0,1:num_cusps,1:num_cusps,Q_start:          &
     &        Q_stop,y_start:y_stop))    
         KBvec(:,:,:,:,:)=0.0_DP
         ll_ypb_old=100.0_DP
         do y_i=y_start,y_stop  
            do l=-M0,M0
               do j=Q_start,Q_stop  
                  do icusp=1,i_stop
                     do jcusp=1,num_cusps
                        l_r=real(l,DP)+alphas(jcusp)
                        if(l_r.eq.0.0) then
                           cycle
                        endif
                        if(y_i.eq.1) then
                           ypb=Y_pb_s(icusp,jcusp,j)
                        else
                           ypb=Y_pb_s2(icusp,jcusp,j)
                        endif
                        if(ypb.gt.0.0_DP) then  
                           ll_ypb=l_r*ypb
                           if(abs((ll_ypb-ll_ypb_old)/ll_ypb).gt.             &
     &                          1.0E-14_DP) then
!                           if(.true.) then
                   !! only if the arguments differ we compute again
                              if(weight.eq.0.0) then
                                 if(do_interp) then
                                    tmp=sqrt(ypb)*interp_kbes(abs(PI2*        &
     &                                   ll_ypb))
                                 else
                                    tmp=sqrt(ypb)*RKBessel(R,abs(PI2*       &
     &                                   ll_ypb))
                                 endif
                              else
                                 if(do_interp) then
                                    if(l_r.gt.0.0) then
                                       tmp=interp_whittw(1,PI4*            &
     &                                      abs(ll_ypb))
                                    else
                                       tmp=interp_whittw(2,PI4*            &
     &                                      abs(ll_ypb))
                                    endif
                                 else
                                    wt=weight*dsign(0.5_DP,l_r)
                                    tmp=WhittW(wt,R,PI4*abs(ll_ypb))
                                 endif
                                 if(do_exceptional) then
                                    tmp=tmp/((PI4*abs(l_r))**(0.5_DP*          &
     &                                   weight))
                                 else
                                    tmp=tmp/(sqrt(abs(l_r)))
                                 endif
                              endif                           
                              ll_ypb_old=ll_ypb
                           else
!c$$$                              write(*,*) 'Do not compute...'
!c$$$                              write(*,*) 'diff=',(abs((ll_ypb-ll_ypb_old)   &
!c$$$     &                             /ll_ypb))
!c$$$                              write(*,*) 'tmp_old=',tmp
!c$$$                              wt=weight*dsign(0.5_DP,l_r)
!c$$$                              write(*,*) 'new=',WhittW(wt,R,PI4*                &
!c$$$     &                             abs(ll_ypb))
                           endif
                           KBvec(l,icusp,jcusp,j,y_i)=tmp 
                        endif
                     enddo
                  enddo
               enddo
            enddo
         enddo
      endif
       !! I probably could replace the Y_pb_s vector with an indicator vector of integers instead to save some memory
!      if(allocated(Y_pb_s)) then
!         deallocate(Y_pb_s)
!      endif
!      write(*,*) 'Done computing K-Bessel!'
!      write(*,*) 'bessel_max=',maxval(KBvec)

      do n=NNA,NB      
         !! I only need coefficients for one cusp
         !! (the other series are just multiples of the first)
         do y_i=y_start,y_stop
         do icusp=1,i_stop   !num_cusps-1
            n_r_p=(real(n,DP)+alphas(icusp))
            n_r_n=(-real(n,DP)+alphas(icusp))         
            if(n_r_p.eq.0.0_DP) then
               cycle
            endif
            summa_p=dcmplx(0.0_DP,0.0_DP)            
            summa_n=dcmplx(0.0_DP,0.0_DP)            
            do jcusp=1,num_cusps
               tmp_p=dcmplx(0.0_DP,0.0_DP) 
               tmp_n=dcmplx(0.0_DP,0.0_DP) 
               do l=-M0,M0
                  l_r=(real(l,DP)+alphas(jcusp))
                  if(l_r.eq.0.0_DP) then
                     cycle
                  endif
                  if(abs(CY(jcusp,l)).eq.0.0_DP) then
!                     write(*,*) 'A zero coefficient!'
!                     write(*,*) 'CY(',jcusp,',',l,')=',CY(jcusp,l)
                     cycle
                  endif
                                ! MAke the V_nl^ij
                  Vnlij_p = dcmplx(0.0_DP,0.0_DP) !
                  Vnlij_n = dcmplx(0.0_DP,0.0_DP) !
                  do j=Q_start,Q_stop  
                     if(y_i.eq.1) then
                        ypb=Y_pb_s(icusp,jcusp,j)
                     else
                        ypb=Y_pb_s2(icusp,jcusp,j)
                     endif
                     if(ypb.gt.0.0_DP) then ! the point is near the j:th-cusp)
                        if(y_i.eq.1) then
                           xpb=X_pb_s(icusp,jcusp,j)
                        else
                           xpb=X_pb_s2(icusp,jcusp,j)
                        endif
                        if(do_k_vec) then
                           tmp=KBvec(l,icusp,jcusp,j,y_i)
                        else
                           if(weight.eq.0.0) then
                              if(do_interp) then
                                 tmp=sqrt(ypb)*interp_kbes(PI2*abs(l_r* &
     &                                ypb))
                              else
                                 tmp=sqrt(ypb)*RKBessel(R,abs(PI2*l_r*  &
     &                                ypb))
                              endif
                           else
                              if(do_interp) then
                                 if(l_r.gt.0.0) then
                                    tmp=interp_whittw(1,PI4*abs(l_r)*   &
     &                                   ypb)
                                 else
                                    tmp=interp_whittw(2,PI4*abs(l_r)*   &
     &                                   ypb)
                                 endif
                              else
                                 wt=weight*dsign(0.5_DP,l_r)
                                 tmp=WhittW(wt,R,PI4*abs(l_r)*ypb)
                              endif
                              if(do_exceptional) then
                                 tmp=tmp/((PI4*abs(l_r))**(0.5_DP*      &
     &                                weight))
                              else
                                 tmp=tmp/(sqrt(abs(l_r)))
                              endif
                           endif
                        endif
                        argpb=PI2*l_r*xpb
                        arg_m_p=PI2*n_r_p*Xm_s(j) 
                        arg_m_n=PI2*n_r_n*Xm_s(j) 
                        !! remember we need both positive and negative n
                        !! here, but this is the only place where the  sign of n matters
                        tmpV_p=dcmplx(tmp,0.0_DP)*exp(dcmplx(0.0,            &
     &                       (argpb-arg_m_p)))
                        tmpV_n=dcmplx(tmp,0.0_DP)*exp(dcmplx(0.0,           &
     &                       (argpb-arg_m_n)))

                        if(y_i.eq.1) then
                           Vnlij_n = Vnlij_n + tmpV_n*                                    &
     &                          char_vec_c_s(icusp,jcusp,j)
                           Vnlij_p = Vnlij_p + tmpV_p*                                    &
     &                          char_vec_c_s(icusp,jcusp,j)
                        else
                           Vnlij_n = Vnlij_n + tmpV_n*                                    &
     &                          char_vec_c_s2(icusp,jcusp,j)
                           Vnlij_p = Vnlij_p + tmpV_p*                                    &
     &                          char_vec_c_s2(icusp,jcusp,j)
                        endif
                     endif

                  enddo ! j
        
                  tmp_p=tmp_p+CY(jcusp,l)*Vnlij_p
                  tmp_n=tmp_n+CY(jcusp,l)*Vnlij_n
               enddo  ! l
               summa_p=summa_p+tmp_p
               summa_n=summa_n+tmp_n
            enddo               ! jcusp
            summa_p=summa_p*dcmplx(sample_norm,0.0_DP)
            summa_n=summa_n*dcmplx(sample_norm,0.0_DP)
            if(weight.eq.0.0) then
               tmp_p=dcmplx(sqrt(Yvec(y_i))*RKBessel(R,PI2*              &
     &              abs(n_r_p)*Yvec(y_i)),0.0_DP)
               if(n_r_n.eq.n_r_p) then
                  tmp_n=tmp_p
               else
                  tmp_n=dcmplx(sqrt(Yvec(y_i))*RKBessel(R,PI2*            &
     &                 abs(n_r_n)*Yvec(y_i)),0.0_DP)
               endif
            else

               if(do_interp) then
                  if(n_r_p.gt.0.0) then
                     tmp_p=dcmplx(interp_whittw(1,PI4*abs(n_r_p)*            &
     &                    Yvec(y_i)),0.0_DP)
                  else
                     tmp_p=dcmplx(interp_whittw(2,PI4*abs(n_r_p)*            &
     &                    Yvec(y_i)),0.0_DP)
                  endif
!c$$$                  write(*,*) 'arg=',PI4*abs(n_r_p)*Yvec(y_i)
!c$$$                  write(*,*) 'whit_ip=',tmp_p
!c$$$                  wt=weight*dsign(0.5_DP,n_r_p)
!c$$$                  tmp_p=dcmplx(WhittW(wt,R,PI4*abs(n_r_p)*                &
!c$$$     &                 Yvec(y_i)),0.0_DP)
!                  write(*,*) 'whit=',tmp_p
               else
                  wt=weight*dsign(0.5_DP,n_r_p)
                  tmp_p=dcmplx(WhittW(wt,R,PI4*abs(n_r_p)*                &
     &                 Yvec(y_i)),0.0_DP)
               endif
               if(do_exceptional) then
                  tmp_p=tmp_p/dcmplx(((PI4*abs(n_r_p))**                &
     &                 (0.5_DP*weight)),0.0_DP)
               else
                  tmp_p=tmp_p/dcmplx((sqrt(abs(n_r_p))),0.0_DP)
               endif
               if(n_r_n.eq.n_r_p) then
                  tmp_n=tmp_p
               else
                  if(do_interp) then
                     if(n_r_n.gt.0.0) then
                        tmp_n=dcmplx(interp_whittw(1,PI4*abs(n_r_n)*       &
     &                       Yvec(y_i)),0.0)
                     else
                        tmp_n=dcmplx(interp_whittw(2,PI4*abs(n_r_n)*       &
     &                       Yvec(y_i)),0.0)
                     endif
!c$$$                     wt=weight*dsign(0.5_DP,n_r_n)
!c$$$                     write(*,*) 'arg=',PI4*abs(n_r_n)*Yvec(y_i),'wt=',wt
!c$$$                     write(*,*) 'whit_ip=',tmp_n
!c$$$                     tmp_n=dcmplx(WhittW(wt,R,PI4*abs(n_r_n)*                &
!c$$$     &                    Yvec(y_i)),0.0_DP)
!                     write(*,*) 'whit=',tmp_n
                  else
                     wt=weight*dsign(0.5_DP,n_r_n)
                     tmp_n=dcmplx(WhittW(wt,R,PI4*abs(n_r_n)*           &
     &                    Yvec(y_i)),0.0_DP)
                  endif
                  if(do_exceptional) then
                     tmp_n=tmp_n/dcmplx(((PI4*abs(n_r_n))**              &
     &                    (0.5_DP*weight)),0.0_DP)
                  else
                     tmp_n=tmp_n/dcmplx((sqrt(abs(n_r_n))),0.0_DP)
                  endif
               endif
            endif
            if(abs(tmp_p).lt.minimum) then
               minimum=abs(tmp_p)
               min_j=n
            endif
            error=0.0_DP
            if(abs(tmp_p).ne.0.0_DP) then
               if(y_i.eq.1) then
                  CYP(icusp,n-NA+1)=summa_p/tmp_p
               else
                  CY2P(icusp,n-NA+1)=summa_p/tmp_p
               endif
            else
               error=10.0_DP
            endif
            if(abs(tmp_n).ne.0.0_DP) then
               if(n.ne.0) then
                  if(y_i.eq.1) then
                     CYN(icusp,n-NA+1)=summa_n/tmp_n
                  else
                     CY2N(icusp,n-NA+1)=summa_n/tmp_n
                  endif
               endif
            elseif(.not.(holomorphic)) then 
               error=10.0_DP
            endif
               ! In case we can't finish in time we get partial 
               ! results anyway
            if(error.eq.10.0_DP) then
                                ! If K_IR(2piny)=0 we need to get smaller Y
               write(*,*) 'Warning!: min(tmp)=',min(abs(tmp_p),           &
     &              abs(tmp_n))
               write(*,*) 'RKBesselIP(',R,',',n_r_p*Y,')=',                 &
     &              tmp_p
               write(*,*) 'Decreasing  Y!'
               Y=0.95_DP*Y
               NNA=n            ! Meaning we will do this one over again
               cycle Yloop
            endif
         enddo                  ! icusp

         enddo                     !Y_i
         !! If index=1 we now have two sets of coefficients
         ! Error control number
         ! When too large we change the Y by *0.5 and continue
         ! 
         error=0.0_DP
         if(Level.ne.1) then
            if((Level.eq.4).and.(type.eq.1)) then
               !!! multidimensional, and we have cn=0 n==2 or 3 mod 4
               if(mod(n,4).eq.2) then
                  error=abs(CYP(1,n-Na+1))
               endif
            elseif((Level.eq.4).and.(type.eq.-2)) then
               !!! multidimensional, and we have cn=0 n==2 or 3 mod 4
               if(mod(n,8).eq.1) then
                  error=abs(CYP(1,n-Na+1))
               endif
            elseif((n.gt.0).and.(icusp.gt.1).and.(num_cusps.gt.1)) then
               error=abs(abs(CYP(1,n-Na+1))-abs(CYP(2,n-NA+1)))
            else
               error=0.0_DP
            endif
            !!! One way to measure if function is even or odd...
            if(from_perm) then
               error=abs(abs(CYP(1,n-Na+1))-abs(CYN(1,n-NA+1)))
            endif
            if(error.gt.tol) then
               write(*,*) 'Warning Y to big!'
               write(*,*) 'We got CY1',n,')=',CYP(1,n-NA+1),' er=',       &
     &              error                       
               if(from_perm) then
                  write(*,*)'We got CYN1(',n,')=',CYN(1,n-NA+1),' er=',      &
     &                 error
               else
                  write(*,*)'We got CY2(',n,')=',CYP(2,n-NA+1),' er=',       &
     &                 error
               endif
                  write(*,*) 'Halving Y!'
               Y=0.9_DP*Y
               NNA=n            ! Meaning we will do this one over again
               cycle Yloop
            else 
               do icusp=1,num_cusps
!                  write(*,3821) icusp,n,CYP(icusp,n-NA+1),error
                  write(15,3821) icusp,n,CYP(icusp,n-NA+1),error
!                  write(*,3822) icusp,n,CYN(icusp,n-NA+1),error
                  write(15,3822) icusp,n,CYN(icusp,n-NA+1),error
               enddo
               call FLUSH(15)
            endif
         else
          !! here the difference is between two Y-values
            error=abs(abs(CYP(1,n-Na+1))-abs(CY2P(1,n-NA+1)))
            if(error.gt.tol) then
               write(*,*) 'Warning Y to big!'
               write(*,*) 'CY1(',n,')=',CYP(1,n-NA+1)
               write(*,*)'CY2(',n,')=',CY2P(1,n-NA+1)
               write(*,*) '|CY1(n)-CY2(n)|=',error
               write(*,*) 'CY1(-',n,')=',CYN(1,n-NA+1)
               write(*,*)'CY2(-',n,')=',CY2N(1,n-NA+1)
               write(*,*) 'Halving Y!'
               Y=0.9_DP*Y
               NNA=n            ! Meaning we will do this one over again
               cycle Yloop
            else     
               write(*,3821) 1,n,CYP(1,n-NA+1),error
               write(15,3821) 1,n,CYP(1,n-NA+1),error
               write(*,3822) 1,n,CYN(1,n-NA+1),error
               write(15,3822) 1,n,CYN(1,n-NA+1),error
               write(*,3821) 2,n,CY2P(1,n-NA+1),error
               write(15,3821) 2,n,CY2P(1,n-NA+1),error
               write(*,3822) 2,n,CY2N(1,n-NA+1),error
               write(15,3822) 2,n,CY2N(1,n-NA+1),error
               call FLUSH(15)
            endif
         endif
      enddo    ! n
      exit Yloop
      enddo Yloop
!      call display_coefficients(CY2,NN,NN,1)
      write(*,*) 'min K_iR(2Pi*Y*',min_j,')=',minimum
      
 3821 FORMAT('C',I1,'(',I5,')=',F27.12,5X,F17.12,5X,ES10.4)   
 3822 FORMAT('C',I1,'(-',I5,')=',F27.12,5X,F17.12,5X,ES10.4)   
      end subroutine phase2_cplxchar2


      !! WE want a completely general phase2 algorithm
      !!! This is the most recent one
      subroutine phase2_gen(R,Y_in,M0,NA,NB,NN,CY,CYP,CYN,                  &
     &     tol0,param,e_set,num_set,c_set,which_c) 
      use commonvariables
      use pullback
      use system
      use groups
      use characters
      use kbessel
      use whittakerw
      use interpolation
!      use permutations
      implicit none
      real(DP),intent(in) :: Y_in,R
      integer,intent(in) :: M0,NA,NB,NN
      real(DP),optional::tol0
      integer,optional::param,num_set
      integer::par
      complex(kind=DP), dimension(1:num_cusps),optional::e_set
      complex(kind=DP), dimension(1:num_cusps)::e
      complex(kind=DP), dimension(1:M0),optional::c_set
      integer, dimension(1:M0),optional::which_c
      real(DP)::tol,Y
      complex(kind=DP),dimension(1:num_cusps,-M0:M0) :: CY
!!      complex(kind=DP),dimension(1:num_cusps,1:NN) :: CYN
!!      complex(kind=DP),dimension(1:num_cusps,0:NN) :: CYP

      complex(kind=DP),allocatable,dimension(:,:,:)::CYN,CYP
      complex(kind=DP),allocatable,dimension(:)::CPold,CNold
      complex(kind=DP),allocatable,dimension(:,:,:)::CY2N,CY2P
      real(DP),dimension(:,:,:,:,:),allocatable::KBvec
      real(DP),dimension(:,:,:),allocatable::X_pb1,X_pb2,Y_pb1,Y_pb2
      complex(DP),dimension(:,:,:),allocatable::char_vec1,char_vec2      
      integer :: n,l,icusp,jcusp,NNA,min_j,M,j,Q
      real(kind=DP)::tmp,minimum,error
      real(DP)::l_r,argpb
      real(DP)::n_r_p,n_r_n,arg_m_p,arg_m_n
      complex(DP)::tmpV_p,tmpV_n,tmp_p,tmp_n,summa_p,summa_n
      complex(DP)::tmp_p2,tmp_p_n,tmp_p_p,tmp_n_p,tmp_n_n
      complex(DP)::Vnlij_p,Vnlij_n
      real(DP)::ll_ypb,xmj
!      real(DP),dimension(0:num_cusps-1)::alpha
      integer::y_j
      character*70::UTFILNAME
      real(DP)::xpb,ypb,Y1,wt,alpha,ll_ypb_old,faktor_minus,                &
     &     sample_norm_minus,error_old
      integer::i_stop,i_start
      logical::do_k_vec,integer_weight
      integer::y_i,y_start,y_stop,IO
      real(DP),dimension(1:2)::Yvec
      !! this sets the tolerance of our algorithm
      tol=1.0E-9_DP
      par=1
      if(weight.eq.0.0) tol=1.0E-8_DP
      if(PRESENT(tol0)) then
         if(tol0.ne.0.0) tol=tol0
      endif
      if(PRESENT(param)) par=param
      e(:)=0.0_DP
      if(present(e_set)) then
         e=e_set(:)
      endif
 
      Y=Y_in
      ! Q should be for NB
      M=0
      call get_M(R,Y,M)
      Q=max(M+10,100)

      UTFILNAME='temp_coeffN'//trim(integer_to_char(Level))//'R'//             &
     &     trim(integer_to_char(floor(1000.0_DP*R)))//'n'//                   &
     &     trim(integer_to_char(NA))//'to'//trim(integer_to_char(NB))//      &
     &     '.txt'
      if(phase2_silent.gt.-2) then 
         open(15,FILE=UTFILNAME,IOSTAT=IO)
      endif
      if(phase2_silent.ge.1) then 
      write(*,*) 'in phase 2gen  cplxchar R=',R,'Y=',Y,' Q=',Q,' M0=',M0
      write(*,*) 'NA=',NA,' NB=',NB,'  M=',M,' tol=',tol,'NN=',NN
      write(*,*) 'param=',par,' parity=',e
      write(*,*) 'Width=',Width, 'tol=',tol,'weight=',weight
      write(*,*) 'size(CY,1)=',size(CY,1), 'size(CY,2)=',size(CY,2)
      write(*,*) 'fil=',UTFILNAME
      write(*,*) 'phase2_gen: NN=',NN
      write(*,*) 'tol=',tol
      endif
      nna=na
!      nn=nb-na
      ! we will change Y if the error gets too big
      ! but no more than 100 times

      call get_alphas()
      alpha=10.0_DP
      do j=1,num_cusps
         if(alphas(j).lt.alpha) then
            alpha=alphas(j)
         endif
      enddo
!      write(*,*) 'here'
      if(allocated(CYP)) deallocate(CYP)
      if(allocated(CYN)) deallocate(CYN)
      allocate(CYP(1:num_cusps,1:NN,1:2))
      allocate(CYN(1:num_cusps,1:NN,1:2))

      if((Level.eq.1).or.(from_perm)) then
         if(allocated(CY2P)) deallocate(CY2P)
         if(allocated(CY2N)) deallocate(CY2N)
         allocate(CY2P(1:num_cusps,1:NN,1:2))
         allocate(CY2N(1:num_cusps,1:NN,1:2))
      endif

      !! Use scaling for integer weights
      

      if(ceiling(weight).eq.floor(weight)) then 
         integer_weight=.true.
         if(mod(int(weight),2).eq.1) then 
            faktor_minus=R
            do l=1,(int(weight)-1)/2
               faktor_minus=faktor_minus*(real(l,DP)**2+R*R)
            enddo
         else
            faktor_minus=1.0_DP
            do l=1,(int(weight)/2)
               faktor_minus=faktor_minus*(real(l*(l-1),DP)+R*R+0.25_DP)
            enddo
         endif
!         write(*,*) 'sqrt(lambda)=',faktor_minus
      endif
      NNA=NA
      error_old=10.0D0

      Yloop: do y_j=1,1000
!      call get_M(R,Y,M)      
      !! we make sure that Y1 < Y < Y0
      call get_M0_Q_Y(R,M,Q,Y)
      Y1=Y*0.95_DP
!      Q=max(M+10,100)
      if(phase2_silent.ge.1) then 
         write(*,*) 'Y=',Y,' Y1=',Y1,' Q=',Q
         write(*,*) 'NNA=',NNA,' NB=',NB,'  M=',M
      endif
      !!! use two parallell Y's
!      if(Level.eq.1) then
      if((Level.eq.1).or.(from_perm)) then
         y_start=1
         y_stop=2
         Yvec(1)=Y
         Yvec(2)=Y1
         if(allocated(CPold)) deallocate(Cpold,cnold)
         allocate(Cpold(1:2),CNold(1:2))
      else
         y_start=1
         y_stop=1
         Yvec(1)=Y
         if(allocated(CPold)) deallocate(Cpold,cnold)
         allocate(Cpold(1:num_cusps),CNold(1:num_cusps))
      endif
      i_Start=1
      i_stop=num_cusps
      if(phase2_silent.ge.0) then 
         write(*,*) 'i_start=',i_start
         write(*,*) 'i_stop=',i_stop
      endif
      if(weight.eq.0) then 
         do_interp=.true.
      endif
      do_interp=.false.
      if((weight.eq.0.0).and.(do_interp)) then
         call setup_interp_kbes(R,Y)
         if(phase2_silent.ge.0) then 
            write(*,*) 'as compared to Antal=',(2*M0+1)*2*Q
         endif
      elseif(do_interp) then
         call setup_interp_WhittW(R,alpha,Y)
            if(phase2_silent.ge.0) then                
               write(*,*) 'as compared to Antal=',(2*M0+1)*2*Q
            endif
      endif
      sampletype=1
      if(y_stop.gt.1) then
         !! make two sets of points
         if(allocated(X_pb1)) then
            deallocate(X_pb1); deallocate(Y_pb1); deallocate(char_vec1)
            deallocate(X_pb2); deallocate(Y_pb2); deallocate(char_vec2)
         endif
         allocate(X_pb1(1:num_cusps,1:num_cusps,1-Q:Q))
         allocate(Y_pb1(1:num_cusps,1:num_cusps,1-Q:Q))
         allocate(char_vec1(1:num_cusps,1:num_cusps,1-Q:Q))
         allocate(X_pb2(1:num_cusps,1:num_cusps,1-Q:Q))
         allocate(Y_pb2(1:num_cusps,1:num_cusps,1-Q:Q))
         allocate(char_vec2(1:num_cusps,1:num_cusps,1-Q:Q))
        call get_points(Y,Q,X_pb1,Y_pb1,char_vec1)
        call get_points(Y1,Q,X_pb2,Y_pb2,char_vec2)
!     &        Q_start,Q_stop,sample_norm,sampletype,.false.)
      else
!! y_stop=1
!! Here Y_pb_s and X_pb_s etc are defined
         call get_pb_points_cplx_char(R,Y,Q,.false.)                                 
!     &        Q_start,Q_stop,sample_norm,sampletype,.false.)
      endif
      if(integer_weight) then 
         sample_norm_minus=sample_norm/faktor_minus
      else
         sample_norm_minus=sample_norm
      endif
      if(phase2_silent.ge.-1) then 
         write(*,*) 'Q_start=',Q_start
         write(*,*) 'Q_start=',Q_stop
         write(*,*) 'Y_start=',Y_start
         write(*,*) 'Y_stop=',Y_stop
         write(*,*) 'sample_norm=',sample_norm
         write(*,*) 'sample_norm_minus=',sample_norm_minus
      endif
      minimum=10.0_DP
      min_j=0
      do_k_vec=.false.
      do_k_vec=.true.
      if((do_k_vec)) then 
         if(allocated(KBvec)) then
            deallocate(KBvec)
         endif
!         write(*,*) 'num_kbes=',(Q_stop-Q_start)*num_cusps**2*(2*M0+1)*2
         allocate(KBvec(-M0:M0,1:num_cusps,1:num_cusps,Q_start:          &
     &        Q_stop,y_start:y_stop))    
         KBvec(:,:,:,:,:)=0.0_DP
         ll_ypb_old=100.0_DP
         do y_i=y_start,y_stop  
            do l=-M0,M0
               do j=Q_start,Q_stop  
                  do icusp=i_start,i_stop
                     do jcusp=1,num_cusps
                        l_r=real(l,DP)+alphas(jcusp)
                        if(l_r.eq.0.0) then
                           cycle
                        endif
                        if(y_stop.eq.1) then 
                           ypb=Y_pb_s(icusp,jcusp,j)
                        elseif(y_i.eq.1) then
                           ypb=Y_pb1(icusp,jcusp,j)
                        else
                           ypb=Y_pb2(icusp,jcusp,j)
                        endif
                        if(ypb.gt.0.0_DP) then  
                           ll_ypb=l_r*ypb
                           if(abs((ll_ypb-ll_ypb_old)/ll_ypb).gt.             &
     &                          1.0E-14_DP) then
!                           if(.true.) then
                   !! only if the arguments differ we compute again
                              if(weight.eq.0.0) then
                                 if(do_interp) then
                                    tmp=sqrt(ypb)*interp_kbes(abs(PI2*        &
     &                                   ll_ypb))
                                 else
!                                    tmp=sqrt(ypb)*RKBessel(R,abs(PI2*       &
!     &                                   ll_ypb))
                                    tmp=sqrt(ypb)*Wf(R,abs(PI2*ll_ypb))
                                 endif
                              elseif(holomorphic.and.(l_r.ne.0.0_DP))      &
     &                                then                                 
                                 tmp=sqrt(ypb)*((ll_ypb)**(0.5_DP*                       &
     &                                (weight-1.0_DP)))*exp(-PI2*ll_ypb)
                              elseif(holomorphic.and.(l_r.eq.0.0)) then  
                                 tmp=ypb**(0.5_DP*weight)               
                              elseif(holomorphic) then 
                                 cycle
                              else
                                 if(do_interp) then
                                    if(l_r.gt.0.0) then
                                       tmp=interp_whittw(1,PI4*            &
     &                                      abs(ll_ypb))
                                    else
                                       tmp=interp_whittw(2,PI4*            &
     &                                      abs(ll_ypb))
                                    endif
                                 else
                                    wt=weight*dsign(0.5_DP,l_r)
                                    tmp=WhittW(wt,R,PI4*abs(ll_ypb))
                                 endif
                                 if(do_exceptional) then
                                    tmp=tmp/((PI4*abs(l_r))**(0.5_DP*          &
     &                                   weight))
                                 else
                                    tmp=tmp/(sqrt(abs(l_r)))
                                 endif
                              endif                           
                              ll_ypb_old=ll_ypb
                           else
!c$$$                              write(*,*) 'Do not compute...'
!c$$$                              write(*,*) 'diff=',(abs((ll_ypb-ll_ypb_old)   &
!c$$$     &                             /ll_ypb))
!c$$$                              write(*,*) 'tmp_old=',tmp
!c$$$                              wt=weight*dsign(0.5_DP,l_r)
!c$$$                              write(*,*) 'new=',WhittW(wt,R,PI4*                &
!c$$$     &                             abs(ll_ypb))
                           endif
                           KBvec(l,icusp,jcusp,j,y_i)=tmp 
                        endif
                     enddo
                  enddo
               enddo
            enddo
         enddo
      endif
       !! I probably could replace the Y_pb_s vector with an indicator vector of integers instead to save some memory
!      if(allocated(Y_pb_s)) then
!         deallocate(Y_pb_s)
!      endif
!      write(*,*) 'Done computing K-Bessel!'
!      write(*,*) 'bessel_max=',maxval(KBvec)
      
      do n=NNA,NB      
         !! I only need coefficients for one cusp
         !! (the other series are just multiples of the first)
         do y_i=y_start,y_stop
         do icusp=i_start,i_stop   !num_cusps-1
            n_r_p=(real(n,DP)+alphas(icusp))
            n_r_n=(-real(n,DP)+alphas(icusp))         
            if((n_r_p.eq.0.0).and.(.not.(holomorphic))) then
               cycle
            elseif((n_r_p.lt.0.0).and.(holomorphic)) then 
               cycle
            endif
            summa_p=dcmplx(0.0_DP,0.0_DP)            
            summa_n=dcmplx(0.0_DP,0.0_DP)            
!            do jcusp=0,num_cusps-1
            do jcusp=1,num_cusps
               tmp_p_p=dcmplx(0.0_DP,0.0_DP) 
               tmp_n_p=dcmplx(0.0_DP,0.0_DP) 
               tmp_p_n=dcmplx(0.0_DP,0.0_DP) 
               tmp_n_n=dcmplx(0.0_DP,0.0_DP) 
               do l=-M0,M0
                  l_r=(real(l,DP)+alphas(jcusp))
                  if((l_r.eq.0.0).and.(.not.(holomorphic))) then
                     cycle
                  elseif((l_r.lt.0.0).and.(holomorphic)) then 
                     cycle
                  endif
                  if(abs(CY(jcusp,l)).eq.0.0_DP) then
!                     write(*,*) 'A zero coefficient!'
!                     write(*,*) 'CY(',jcusp,',',l,')=',CY(jcusp,l)
                     cycle
                  endif
                                ! MAke the V_nl^ij
                  Vnlij_p = dcmplx(0.0_DP,0.0_DP) !
                  Vnlij_n = dcmplx(0.0_DP,0.0_DP) !
                  do j=Q_start,Q_stop  
                     if(y_stop.eq.1) then 
                        ypb=Y_pb_s(icusp,jcusp,j)
                     elseif(y_i.eq.1) then
                        ypb=Y_pb1(icusp,jcusp,j)
                     else
                        ypb=Y_pb2(icusp,jcusp,j)
                     endif
                     if(ypb.gt.0.0_DP) then ! the point is near the j:th-cusp)
                        if(y_stop.eq.1) then 
                           xpb=X_pb_s(icusp,jcusp,j)
                        elseif(y_i.eq.1) then
                           xpb=X_pb1(icusp,jcusp,j)
                        else
                           xpb=X_pb2(icusp,jcusp,j)
                        endif
                        if(do_k_vec) then
                           tmp=KBvec(l,icusp,jcusp,j,y_i)
                        else
                           if(weight.eq.0.0) then
                              if(do_interp) then
                                 tmp=sqrt(ypb)*interp_kbes(PI2*abs(l_r* &
     &                                ypb))
                              elseif(R.eq.0.0) then
                                 tmp=sqrt(ypb)*bessk_real(R,abs(PI2*l_r*  &
     &                                ypb))
                              else
!                                 tmp=sqrt(ypb)*RKBessel(R,abs(PI2*l_r*  &
!     &                                ypb))
                                 tmp=sqrt(ypb)*Wf(R,abs(PI2*l_r*ypb))
                              endif
                           elseif(holomorphic.and.(l_r.gt.0.0_DP))then                                 
                              tmp=sqrt(ypb)*((l_r*ypb)**(0.5_DP*                       &
     &                             (weight-1.0_DP)))*exp(-PI2*l_r*ypb)
!                              WRITE(*,*) 'tmp=',tmp,'=',sqrt(ypb),'*',                   &
!     &                             (l_r*ypb),'**',(0.5_DP*                       &
!     &                            (weight-1.0_DP)),'*',exp(-PI2*l_r*ypb)
                           elseif(holomorphic.and.(l_r.eq.0.0)) then  
                              tmp=ypb**(0.5_DP*weight)               
                           elseif(holomorphic) then 
                              tmp=0.0_DP
!                              cycle
                           else
                              if(do_interp) then
                                 if(l_r.gt.0.0) then
                                    tmp=interp_whittw(1,PI4*abs(l_r)*   &
     &                                   ypb)
                                 else
                                    tmp=interp_whittw(2,PI4*abs(l_r)*   &
     &                                   ypb)
                                 endif
                              else
                                 wt=weight*dsign(0.5_DP,l_r)
                                 tmp=WhittW(wt,R,PI4*abs(l_r)*ypb)
                              endif
                              if(do_exceptional) then
                                 tmp=tmp/((PI4*abs(l_r))**(0.5_DP*      &
     &                                weight))
                              else
                                 tmp=tmp/(sqrt(abs(l_r)))
                              endif
!                              tmp=tmp/faktor_minus
                           endif
                        endif
                        argpb=PI2*l_r*xpb
                        if(y_stop.eq.1) then 
                           xmj=Xm_s(j)
                        else
                           xmj=Xm(j)
                        endif
                        arg_m_p=PI2*n_r_p*xmj 
                        arg_m_n=PI2*n_r_n*xmj 
                        !! remember we need both positive and negative n
                        !! here, but this is the only place where the  sign of n matters
                        tmpV_p=dcmplx(tmp,0.0_DP)*exp(dcmplx(0.0,            &
     &                       (argpb-arg_m_p)))
                        tmpV_n=dcmplx(tmp,0.0_DP)*exp(dcmplx(0.0,           &
     &                       (argpb-arg_m_n)))
!                        WRITE(*,*) 'TMPv_P=',TMP,'*',exp(dcmplx(0.0,           &
!     &                  (argpb-arg_m_n))),'*',char_vec1(icusp,jcusp,j)
                        if(y_stop.eq.1) then 
                           Vnlij_n = Vnlij_n + tmpV_n*                                    &
     &                          char_vec_c_s(icusp,jcusp,j)
                           Vnlij_p = Vnlij_p + tmpV_p*                                    &
     &                          char_vec_c_s(icusp,jcusp,j)
                        elseif(y_i.eq.1) then
                           Vnlij_n = Vnlij_n + tmpV_n*                                    &
     &                          char_vec1(icusp,jcusp,j)
                           Vnlij_p = Vnlij_p + tmpV_p*                                    &
     &                          char_vec1(icusp,jcusp,j)
!                           write(*,*) 'Vnlij_p=',Vnlij_p,'+',tmpV_p,'*',                                    &
!     &                          char_vec1(icusp,jcusp,j)
                        else
                           Vnlij_n = Vnlij_n + tmpV_n*                                    &
     &                          char_vec2(icusp,jcusp,j)
                           Vnlij_p = Vnlij_p + tmpV_p*                                    &
     &                          char_vec2(icusp,jcusp,j)
                        endif
                     endif
                  enddo         ! j
                  if(l_r.gt.0) then 
                     tmp_p_p=tmp_p_p+CY(jcusp,l)*Vnlij_p
                     tmp_n_p=tmp_n_p+CY(jcusp,l)*Vnlij_n
                  else
                     tmp_p_n=tmp_p_n+CY(jcusp,l)*Vnlij_p
                     tmp_n_n=tmp_n_n+CY(jcusp,l)*Vnlij_n
                  endif
               enddo  ! l
               if(integer_weight) then 
                  tmp_p_n=tmp_p_n*faktor_minus
                  tmp_n_p=tmp_n_p/faktor_minus
               endif                                       
               summa_p=summa_p+tmp_p_p+tmp_p_n
               summa_n=summa_n+tmp_n_p+tmp_n_n
            enddo               ! jcusp
            summa_p=summa_p*dcmplx(sample_norm,0.0_DP)
!            summa_n=summa_n*dcmplx(sample_norm_minus,0.0_DP)
            summa_n=summa_n*dcmplx(sample_norm,0.0_DP)
            if(weight.eq.0.0) then
               tmp_p=dcmplx(sqrt(Yvec(y_i))*Wf(R,PI2*                      &
     &              abs(n_r_p)*Yvec(y_i)),0.0_DP)
               if(n_r_n.eq.n_r_p) then
                  tmp_n=tmp_p
               else
                  tmp_n=dcmplx(sqrt(Yvec(y_i))*Wf(R,PI2*                     &
     &                 abs(n_r_n)*Yvec(y_i)),0.0_DP)
               endif
            elseif(holomorphic.and.(n_r_p.ne.0.0_DP)) then                                 
               tmp_p=sqrt(Yvec(y_i))*((n_r_p*Yvec(y_i))**(0.5_DP*                            &
     &              (weight-1.0_DP)))*exp(-PI2*n_r_p*Yvec(y_i))
!               write(*,*) 'tmp_p(',n_r_p,Yvec(y_i),')=',tmp_p
               tmp_n=0.0_DP
!               write(*,*) 'summa_p=',summa_p
            elseif(holomorphic.and.(n_r_p.eq.0.0)) then  
               tmp_p=Yvec(y_i)**(0.5_DP*weight)               
               tmp_n=0.0_DP
            elseif(holomorphic) then 
               tmp_p=0.0_DP
               tmp_n=0.0_DP
               cycle
            else
               if(do_interp) then
                  if(n_r_p.gt.0.0) then
                     tmp_p=dcmplx(interp_whittw(1,PI4*abs(n_r_p)*            &
     &                    Yvec(y_i)),0.0_DP)
                  else
                     tmp_p=dcmplx(interp_whittw(2,PI4*abs(n_r_p)*            &
     &                    Yvec(y_i)),0.0_DP)
                  endif
!DEB
!                  write(*,*) 'arg=',PI4*abs(n_r_p)*Yvec(y_i)
!                  write(*,*) 'whit_ip=',tmp_p
                  wt=weight*dsign(0.5_DP,n_r_p)
                  tmp_p2=dcmplx(WhittW(wt,R,PI4*abs(n_r_p)*                &
     &                 Yvec(y_i)),0.0_DP)
!                  write(*,*) 'whit=',tmp_p2
                  if(abs(tmp_p-tmp_p2).gt.10) then
                     stop
                  endif
               else
                  wt=weight*dsign(0.5_DP,n_r_p)
                  tmp_p=dcmplx(WhittW(wt,R,PI4*abs(n_r_p)*                &
     &                 Yvec(y_i)),0.0_DP)
               endif
               if(do_exceptional) then
                  tmp_p=tmp_p/dcmplx(((PI4*abs(n_r_p))**                &
     &                 (0.5_DP*weight)),0.0_DP)
               else
                  tmp_p=tmp_p/dcmplx((sqrt(abs(n_r_p))),0.0_DP)
               endif
               if(n_r_n.eq.n_r_p) then
                  tmp_n=tmp_p
               else
                  if(do_interp) then
                     if(n_r_n.gt.0.0) then
                        tmp_n=dcmplx(interp_whittw(1,PI4*abs(n_r_n)*       &
     &                       Yvec(y_i)),0.0)
                     else
                        tmp_n=dcmplx(interp_whittw(2,PI4*abs(n_r_n)*       &
     &                       Yvec(y_i)),0.0)
                     endif
!c$$$                     wt=weight*dsign(0.5_DP,n_r_n)
!c$$$                     write(*,*) 'arg=',PI4*abs(n_r_n)*Yvec(y_i),'wt=',wt
!c$$$                     write(*,*) 'whit_ip=',tmp_n
!c$$$                     tmp_n=dcmplx(WhittW(wt,R,PI4*abs(n_r_n)*                &
!c$$$     &                    Yvec(y_i)),0.0_DP)
!                     write(*,*) 'whit=',tmp_n
                  else
                     wt=weight*dsign(0.5_DP,n_r_n)
                     tmp_n=dcmplx(WhittW(wt,R,PI4*abs(n_r_n)*           &
     &                    Yvec(y_i)),0.0_DP)
                  endif
                  if(do_exceptional) then
                     tmp_n=tmp_n/dcmplx(((PI4*abs(n_r_n))**              &
     &                    (0.5_DP*weight)),0.0_DP)
                  else
                     tmp_n=tmp_n/dcmplx((sqrt(abs(n_r_n))),0.0_DP)
                  endif
               endif
            endif
            if(abs(tmp_p).lt.minimum) then
               minimum=abs(tmp_p)
               min_j=n
            endif
            error=0.0_DP
            if(abs(tmp_p).ne.0.0_DP) then
               if(y_i.eq.1) then
                  CYP(icusp,n-NA+1,1)=summa_p/tmp_p
               else
                  CY2P(icusp,n-NA+1,1)=summa_p/tmp_p
               endif
            else
               error=10.0_DP
            endif
            if(abs(tmp_n).ne.0.0_DP) then
               if(n.ne.0) then
                  if(y_i.eq.1) then
                     CYN(icusp,n-NA+1,1)=summa_n/tmp_n
                  else
                     CY2N(icusp,n-NA+1,1)=summa_n/tmp_n
                  endif
               endif
            elseif(.not.(holomorphic)) then
               error=10.0_DP
            endif
               ! In case we can't finish in time we get partial 
               ! results anyway
            if(error.eq.10.0_DP) then
               if(phase2_silent.gt.0) then 
                                ! If K_IR(2piny)=0 we need to get smaller Y
                  write(*,*) 'Warning!: min(tmp)=',min(abs(tmp_p),           &
     &                 abs(tmp_n))
                  write(*,*) 'RKBesselIP(',R,',',n_r_p*Y,')=',                 &
     &                 tmp_p
                  write(*,*) 'Decreasing  Y!'
               endif
               Y=0.95_DP*Y
               NNA=n            ! Meaning we will do this one over again
               cycle Yloop
            endif
         enddo                  ! icusp

         enddo                     !Y_i
         !! If index=1 we now have two sets of coefficients
         ! Error control number
         ! When too large we change the Y by *0.5 and continue
         ! 
         error=0.0_DP
         if(y_stop.eq.1) then 
            if((Level.eq.4).and.(par.eq.1)) then
               !!! multidimensional, and we have cn=0 n==2 or 3 mod 4
               if(mod(n,4).eq.2) then
                  error=abs(CYP(1,n-Na+1,1))
               endif
            elseif((Level.eq.4).and.(par.eq.-2)) then
               !!! multidimensional, and we have cn=0 n==2 or 3 mod 4
               if(mod(n,8).eq.1) then
                  error=abs(CYP(1,n-Na+1,1))
               endif
            elseif(.not.(holomorphic).and.(r.eq.0.0)) then 
               error=abs(CYP(1,n-Na+1,1))-dnint(abs(CYP(1,n-Na+1,1)))
            elseif((n.gt.0).and.(icusp.gt.0).and.(num_cusps.gt.1)) then
               error=abs(abs(CYP(1,n-Na+1,1))-abs(CYP(2,n-NA+1,1)))
            else
               error=0.0_DP
            endif
            !!! One way to measure if function is even or odd...
            if(from_perm) then
               error=abs(abs(CYP(1,n-Na+1,1))-abs(CYN(1,n-NA+1,1)))
            endif
            if((error.gt.tol).and.(error.lt.error_old)) then             
               if(phase2_silent.gt.0) then 
                  write(*,*) 'Warning Y to big!'
                  write(*,*) 'We got CY1(',n,')=',CYP(1,n-NA+1,1),'er=',       &
     &                 error                       
                  if(from_perm) then
                     write(*,*)'We got CYN1(',n,')=',CYN(1,n-NA+1,1),        &
     &                    ' er=',error
                  else
                     write(*,*)'We got CY2(',n,')=',CYP(2,n-NA+1,1),          &
     &                    ' er=',error
                  endif
                  write(*,*) 'Halving Y!'
               endif
               Y=0.9_DP*Y
               NNA=n            ! Meaning we will do this one over again
               error_old=error
               if(phase2_silent.gt.0) then 
                  write(*,*) 'error_old=',error_old
               endif
               do icusp=1,num_cusps
                  CPold(icusp)=CYP(icusp,n-NA+1,1)
                  CNold(icusp)=CYN(icusp,n-NA+1,1)
               enddo
               
               cycle Yloop
            elseif(error.gt.error_old) then 
               if(phase2_silent.gt.0) then 
                  write(*,*) 'Error > Error_old'
               endif
!     ! If we have too large error and it is getting larger then
!     ! we give up and assume no more can be done for this n
!!!   !! Set the new coefficients to the old ones
               do icusp=1,num_cusps
                  CYP(icusp,n-NA+1,1)=CPold(icusp)
                  CYN(icusp,n-NA+1,1)=CNold(icusp)
               enddo
               error=error_old
            endif               
            do icusp=1,num_cusps
               if(phase2_silent.ge.0) then !! This is not an error, just as expected, no need to shout
                  write(*,3821) icusp,n,CYP(icusp,n-NA+1,1),                     &
     &                 abs(CYP(icusp,n-NA+1,1))
                  write(*,3822) icusp,n,CYN(icusp,n-NA+1,1),                     &
     &                 abs(CYN(icusp,n-NA+1,1))
               endif
               if(phase2_silent.gt.-2) then                   
                  write(15,3821) icusp,n,CYP(icusp,n-NA+1,1),error
                  write(15,3822) icusp,n,CYN(icusp,n-NA+1,1),error
               endif
            enddo
            call FLUSH(15)
            error_old=10.0D0
         else
          !! here the difference is between two Y-values
            if(integer_weight) then
               error=max(abs(abs(CYP(1,n-Na+1,1))-abs(CY2P(1,n-NA+1,1)))             &
     &              ,abs(CYN(1,n-Na+1,1))-abs(CY2N(1,n-NA+1,1)))
            else
               error=abs(abs(CYP(1,n-Na+1,1))-abs(CY2P(1,n-NA+1,1)))
            endif
!            write(*,*) '------------error_old=',error_old
            if((error.gt.tol).and.(error.lt.error_old)) then
               if(phase2_silent.gt.0) then !! This is not an error, just as expected, no need to shout
                  write(*,*) 'Warning Y to big!'
                  write(*,*) 'tmp_p=',tmp_p
                  write(*,*) 'summa_p,n-NA+1=',summa_p,n-NA+1
                  write(*,*) 'CY1(',n,')=',CYP(1,n-NA+1,1)
                  write(*,*)'CY2(',n,')=',CY2P(1,n-NA+1,1)
                  write(*,*) '|CY1(n)-CY2(n)|=',error
                  write(*,*) 'CY1(-',n,')=',CYN(1,n-NA+1,1)
                  write(*,*)'CY2(-',n,')=',CY2N(1,n-NA+1,1)
                  write(*,*) 'Halving Y!'
               endif
               Y=0.9_DP*Y
               NNA=n            ! Meaning we will do this one over again              
               error_old=error
               if(phase2_silent.gt.0) then 
                  write(*,*) 'error_old=',error_old
               endif
               CPold(1)=CYP(1,n-NA+1,1)
               CNold(1)=CYN(1,n-NA+1,1)
               CPold(2)=CY2P(1,n-NA+1,1)
               CNold(2)=CY2N(1,n-NA+1,1)
               cycle Yloop
            elseif(error.gt.error_old) then 
!     ! If we have too large error and it is getting larger then
!     ! we give up and assume no more can be done for this n
!!!   !! Set the new coefficients to the old ones
              if(phase2_silent.gt.0) then 
                 write(*,*) 'Error>Error_old!!!'
              endif
               CYP(1,n-NA+1,1)=CPold(1)
               CYN(1,n-NA+1,1)=CNold(1)
               CY2P(1,n-NA+1,1)=CPold(2)
               CY2N(1,n-NA+1,1)=CNold(2)
               error=error_old
            endif                   
            error_old=10.0D0
            do icusp=i_start,i_stop
               if(phase2_silent.ge.0) then 
                  write(*,3921) 1,icusp,n,CYP(icusp,n-NA+1,1),error
                  write(*,3922) 1,icusp,n,CYN(icusp,n-NA+1,1),error
                  write(*,3921) 2,icusp,n,CY2P(icusp,n-NA+1,1),error
                  write(*,3922) 2,icusp,n,CY2N(icusp,n-NA+1,1),error
               endif
               write(15,3921) 1,icusp,n,CYP(icusp,n-NA+1,1),error               
               write(15,3922) 1,icusp,n,CYN(icusp,n-NA+1,1),error
               write(15,3921) 2,icusp,n,CY2P(icusp,n-NA+1,1),error
               write(15,3922) 2,icusp,n,CY2N(icusp,n-NA+1,1),error
            enddo
            if(abs(CYP(1,n-NA+1,1)/error).lt.1E-10) then 
               write(*,*) 'y_i=',y_i
               write(*,*) 'y_j=',y_j
               write(*,*) 'tmp_p=',tmp_p
               write(*,*) 'tmp_1=(interp_whittw(1,',PI4*abs(n_r_p),     &
     &              '*',Yvec(1),')'
               write(*,*)  'tmp_1=dcmplx(',WhittW(wt,R,PI4*             &
     &              abs(n_r_p)*Yvec(1))
               write(*,*) 'tmp_2=(interp_whittw(1,',PI4*abs(n_r_p),     &
     &              '*',Yvec(2),')'
               write(*,*)  'tmp_2=dcmplx(',WhittW(wt,R,PI4*             &
     &              abs(n_r_p)*Yvec(2))
               write(*,*) 'summa_p,n-NA+1=',summa_p,n-NA+1
               
               write(*,*) 'CY1(',n,')=',CYP(1,n-NA+1,1)
               write(*,*)'CY2(',n,')=',CY2P(1,n-NA+1,1)
               write(*,*) '|CY1(n)-CY2(n)|=',error
               write(*,*) 'CY1(-',n,')=',CYN(1,n-NA+1,1)
               write(*,*)'CY2(-',n,')=',CY2N(1,n-NA+1,1)
               stop
               call FLUSH(15)
            endif
         endif
         CYP(:,n-NA+1,2)=error
         CYN(:,n-NA+1,2)=error
      enddo                     ! n
      exit Yloop
      enddo Yloop
!      call display_coefficients(CY2,NN,NN,1)
      if(phase2_silent.gt.0) then 
         write(*,*) 'min K_iR(2Pi*Y*',min_j,')=',minimum
      endif
 3821 FORMAT('C',I3,'(',I5,' )=',F27.12,5X,F27.12,5X,ES12.3)   
 3822 FORMAT('C',I3,'(-',I5,')=',F27.12,5X,F27.12,5X,ES12.3)   

 3921 FORMAT('C',I3,'(',I3,',',I5,' )=',F27.12,5X,F27.12,5X,ES12.3)   
 3922 FORMAT('C',I3,'(',I3,',-',I5,')=',F27.12,5X,F27.12,5X,ES12.3)   

      call clean_pullback()
      if(phase2_silent.gt.-2) then 
         close(15)
      endif
      end subroutine phase2_gen


    !! WE want a completely general phase2 algorithm
      !!! FOr the holomorphic case now!
      !!! Note that then CY(0:M0) is a real vector
      !!! 
      subroutine phase2_holo(R,Y_in,M0,NA,NB,NN,CY,CYP,                  &
     &     tol0,param,e_set,num_set,c_set,which_c) 

      use commonvariables
      use system
      use giant_mod
      use groups
      use characters
      use kbessel
      use whittakerw
      use interpolation
!      use permutations
      implicit none
      real(DP),intent(in) :: Y_in,R
      integer,intent(in) :: M0,NA,NB,NN
      real(DP),optional::tol0
      integer,optional::param,num_set
      integer::par
      complex(kind=DP), dimension(1:num_cusps),optional::e_set
      complex(kind=DP), dimension(1:num_cusps)::e
      complex(kind=DP), dimension(1:M0),optional::c_set
      integer, dimension(1:M0),optional::which_c
      real(DP)::tol,Y
      real(kind=DP),dimension(1:num_cusps,0:M0) :: CY
      real(kind=DP),dimension(1:num_cusps,1:NN) :: CYP
      real(kind=DP),allocatable,dimension(:,:)::CY2P
      integer :: n,l,icusp,jcusp,NNA,min_j,M,j,Q
      real(DP),dimension(:,:,:,:,:),allocatable::KBvec
      real(DP),dimension(:,:,:),allocatable::X_pb1,X_pb2,Y_pb1,Y_pb2
      complex(DP),dimension(:,:,:),allocatable::char_vec1,char_vec2      
      real(kind=DP)::tmp,minimum,maximum,error
      real(DP)::l_r,argpb
      real(DP)::n_r,arg_m_p
      real(DP)::tmpV,tmp_p,summa_p
      real(DP)::Vnlij_p,ll_ypb
      integer::y_j
      character*70::UTFILNAME
      real(DP)::xpb,ypb,Y1,wt,alpha,ll_ypb_old
      integer::i_stop
      logical::do_k_vec
      integer::y_i,y_start,y_stop,IO
      real(DP),dimension(1:2)::Yvec
      !! this sets the tolerance of our algorithm
      write(*,*) 'phase2holo: NN=',NN
      tol=1.0E-9_DP
      par=1
      if(weight.eq.0.0) tol=1.0E-8_DP
      if(PRESENT(tol0)) then
         if(tol0.ne.0.0) tol=tol0
      endif
      if(PRESENT(param)) par=param
      write(*,*) 'tol=',tol
      e(:)=0.0_DP
      if(present(e_set)) then
         e=e_set(:)
      endif
 
      Y=Y_in
      ! Q should be for NB
      write(*,*) 'R=',R,' Y=',Y
      M=0
      call get_M(R,Y,M)
      Q=max(M+10,100)

      UTFILNAME='temp_coeffN'//trim(integer_to_char(Level))//'R'//             &
     &     trim(integer_to_char(floor(1000.0_DP*R)))//'n'//                  &
     &     trim(integer_to_char(NA))//'to'//trim(integer_to_char(NB))//      &
     &     '.txt'
      if(phase2_silent.gt.-2) then 
         open(15,FILE=UTFILNAME,IOSTAT=IO)
      endif
      if(phase2_silent.gt.1) then 
         write(*,*) 'in phase 2 holom R=',R,'Y=',Y,' Q=',Q,' M0=',M0
         write(*,*) 'NA=',NA,' NB=',NB,'  M=',M,' tol=',tol
         write(*,*) 'param=',par,' parity=',e
         write(*,*) 'Width=',Width, 'tol=',tol,'weight=',weight
         write(*,*) 'size(CY,1)=',size(CY,1), 'size(CY,2)=',size(CY,2)
         write(*,*) 'fil=',UTFILNAME
      endif
      nna=na
     
      ! we will change Y if the error gets too big
      ! but no more than 100 times

      call get_alphas()
      alpha=10.0_DP
      do j=1,num_cusps
         if(alphas(j).lt.alpha) then
            alpha=alphas(j)
         endif
      enddo
 

      if((Level.eq.1).or.(from_perm)) then
         allocate(CY2P(1:1,0:NN))
!         allocate(CY2N(0:1,0:NN))
      endif


      Yloop: do y_j=1,1000
!      call get_M(R,Y,M)
      
      Y1=Y*1.15_DP
      !! we make sure that Y < Y1
      tmp=(weight-1.0_DP)/PI/2.0_DP/Y1
      do l=4*floor(tmp),10*floor(tmp)
         tmp_p=exp(-PI2*real(l,DP)*Y)*sqrt(Y)*                            &
     &        (real(l,DP)*Y)**(0.5_DP*(weight-1.0_DP))
         if(abs(tmp_p).lt.1E-16) then 
            M=l
            Q=M+10
            exit
         endif
      enddo   
!      call get_M0_Q_Y(R,M,Q,Y)
!      Q=max(M+10,100)
      write(*,*) 'Y=',Y,' Y1=',Y1,' Q=',Q
      write(*,*) 'NA=',NA,' NB=',NB,'  M=',M
      

      !!! use two parallell Y's

         y_start=1
         y_stop=2
         Yvec(1)=Y
         Yvec(2)=Y1
      if(Na.eq.1) then
         i_stop=num_cusps
      else
         i_stop=1
      endif
      i_stop=num_cusps

       write(*,*) 'Y1=',Yvec(1)
       write(*,*) 'Y2=',Yvec(2)     
      !! For holomorphic functions we always use a set of two different Y's 
      sampletype=2
      if(y_stop.gt.1) then
         !! make two sets of points
!         write(*,*) 'Making two sets!'
 
!         call get_pb_points_cplx_char2(R,Y,Y1,Q,.false.)                            &
         if(allocated(X_pb1)) then
            deallocate(X_pb1); deallocate(Y_pb1); deallocate(char_vec1)
            deallocate(X_pb2); deallocate(Y_pb2); deallocate(char_vec2)
         endif
         allocate(X_pb1(1:num_cusps,1:num_cusps,1-Q:Q))
         allocate(Y_pb1(1:num_cusps,1:num_cusps,1-Q:Q))
         allocate(char_vec1(1:num_cusps,1:num_cusps,1-Q:Q))
         allocate(X_pb2(1:num_cusps,1:num_cusps,1-Q:Q))
         allocate(Y_pb2(1:num_cusps,1:num_cusps,1-Q:Q))
         allocate(char_vec2(1:num_cusps,1:num_cusps,1-Q:Q))
        call get_points(Y,Q,X_pb1,Y_pb1,char_vec1)
        call get_points(Y1,Q,X_pb2,Y_pb2,char_vec2)
!     &        Q_start,Q_stop,sample_norm,sampletype,.false.)
      else
         call get_pb_points_cplx_char(R,Y,Q,.false.)                                 
!     &        Q_start,Q_stop,sample_norm,sampletype,.false.)
      endif
!      write(*,*) 'Q_start=',Q_start
!     write(*,*) 'Q_start=',Q_stop
!      write(*,*) 'sample_norm=',sample_norm
      
      maximum=0.0_DP
      do j=Q_start,Q_stop  
         ypb=Y_pb1(1,1,j)
!         write(*,*) 'Char(',j,')=',char_vec1(1,1,j)
         if(ypb.gt.maximum) then 
            maximum=ypb
         endif
      enddo
      write(*,*) 'Q_start=',Q_start
      write(*,*) 'Q_stop=',Q_stop
      write(*,*) 'max Ypb1=',maximum
!      stop
      maximum=0.0_DP
      do j=Q_start,Q_stop  
         ypb=Y_pb2(1,1,j)
         if(ypb.gt.maximum) then 
            maximum=ypb
         endif
      enddo
      write(*,*) 'max Yp2=',maximum
!      stop
!      do_k_vec=.true.
      if(.not.(holomorphic)) then 
         write(*,*) 'ERROR: Only for holomorphic!'
         stop
      endif
      minimum=10.0_DP
      min_j=0  
      do n=NNA,NB      
         !! I only need coefficients for one cusp
         !! (the other series are just multiples of the first)
         do y_i=y_start,y_stop
            do icusp=1,i_stop   !num_cusps-1
!               n_r=(real(n,DP)+alphas(icusp))
               n_r=real(n,DP)
               summa_p=0.0_DP
               do jcusp=1,num_cusps
                  tmp_p=0.0_DP 
                  do l=0,M0
!                     l_r=(real(l,DP)+alphas(jcusp))
                     l_r=real(l,DP)
                     !! If we have small enough first coefficient we assume it is really a cuspform
                     if(abs(CY(jcusp,l)).eq.0.0_DP) then
                        cycle
                     endif
                     if(l.eq.0.and.(abs(CY(jcusp,l)).lt.1E-16_DP)) then
                        cycle
                     endif
                                ! MAke the V_nl^ij
                     Vnlij_p = 0.0_DP; tmp=0.0_DP
                     do j=Q_start,Q_stop  
                        if(y_i.eq.1) then
                           ypb=Y_pb1(icusp,jcusp,j)
                        else
                           ypb=Y_pb2(icusp,jcusp,j)
                        endif
                        if(ypb.gt.0.0_DP) then ! the point is near the j:th-cusp)
                           if(y_i.eq.1) then
                              xpb=X_pb1(icusp,jcusp,j)
                           else
                              xpb=X_pb2(icusp,jcusp,j)
                           endif
                           if(abs(l_r).gt.0.0_DP) then                                 
                              tmp=sqrt(ypb)*((l_r*ypb)**(0.5_DP*                       &
     &                             (weight-1.0_DP)))*exp(-PI2*l_r*ypb)
                           elseif(l_r.eq.0.0) then  
                              tmp=ypb**(0.5_DP*weight)               
                           endif
                        endif
!                        if(isnan(tmp).or.(abs(tmp).gt.1E+100))then
                        if(isnan(tmp).or.(abs(tmp).gt.1.D+300))then
                           WRITE(*,*) 'TMP(',j,')=',TMP
                           write(*,*) 'xpb,ypb=',xpb,ypb
                           write(*,*) 'Xm(j)=',xm(j)
                           write(*,*) 'l_r=',l_r
                           if(l_r.ne.0.0_DP) then 
                              write(*,*) 'tmp=',sqrt(ypb),'*',                 &
     &                             (l_r*ypb)**(0.5_DP*(weight-1.0_DP)),        &
     &                             '*',exp(-PI2*l_r*ypb)
                           else
                              write(*,*) 'tmp=',ypb,'**',0.5_DP*weight
                           endif
                           stop
                        endif 
                        argpb=PI2*l_r*xpb
                        arg_m_p=PI2*n_r*Xm(j) 
!                           write(*,*) 'argpb=',argpb
!                           write(*,*) 'argm=',arg_m_p
!                           write(*,*) 'cv1=',real(char_vec1(icusp,jcusp,j),DP)
!                           write(*,*) 'cv2=',real(char_vec2(icusp,jcusp,j),             
                        if(y_i.eq.1) then
                           Vnlij_p = Vnlij_p + tmp*cos(argpb-arg_m_p                                    &
     &                          +real(char_vec1(icusp,jcusp,j),DP))
                        else
                           Vnlij_p = Vnlij_p + tmp*cos(argpb-arg_m_p                                    &
     &                          +real(char_vec2(icusp,jcusp,j),DP))
                        endif
                        if(isnan(Vnlij_p))then
                           write(*,*) 'Vnl1=',Vnlij_p,' + ',tmp,'*',       &
     &                          'cos(',argpb,'-',arg_m_p,'+',              &
     &                          real(char_vec1(icusp,jcusp,j),DP),')'
                           write(*,*) 'Vnl2=',Vnlij_p,' + ',tmp,'*',       &
     &                          'cos(',argpb,'-',arg_m_p,'+',              &
     &                          real(char_vec2(icusp,jcusp,j),DP),')'
                           write(*,*) '=',vnlij_p
                           stop
                        endif
                     enddo      ! j
                     tmp_p=tmp_p+CY(jcusp,l)*Vnlij_p
!                     write(*,*) 'Vnlij_p(',y_i,l,')=',Vnlij_p
!                     WRITE(*,*) 'TMP_P=',TMP_P,'+',CY(jcusp,l),'*',     6
!     &                    Vnlij_p
!                     if(isnan(tmp_p).or.(abs(tmp_p).gt.1E+20))then
                     if(isnan(tmp_p))then
                        WRITE(*,*) 'TMP_P=',TMP_P
                        WRITE(*,*) 'l=',l
                        write(*,*) 'C(l)*Vnl=',CY(jcusp,l),'*',Vnlij_p
                        stop
                     endif
                  enddo         ! l
!                  if(isnan(tmp_p).or.(abs(tmp_p).gt.1E+10))then
                  if(isnan(tmp_p))then
                     WRITE(*,*) 'TMP_P=',TMP_P
                     stop
                  endif
                  summa_p=summa_p+tmp_p
               enddo            ! jcusp
!               write(*,*) 'summa_p=',summa_p
               summa_p=summa_p*sample_norm
!               write(*,*) 'summa_p/norm=',summa_p
               if(n_r.ne.0.0_DP) then                                 
                  tmp_p=sqrt(Yvec(y_i))*((n_r*Yvec(y_i))**(0.5_DP*                            &
     &                 (weight-1.0_DP)))*exp(-PI2*n_r*Yvec(y_i))
!                  write(*,*) 'tmp_p(',n_r,Yvec(y_i),')=',tmp_p
               else
                  tmp_p=(Yvec(y_i))**(0.5_DP*weight)               
                  write(*,*) 'n_r=',0
                  stop
               endif
!               WRITE(*,*) 'TMP_P(',y_i,'=)',TMP_P               
               if(abs(tmp_p).lt.minimum) then
                  minimum=abs(tmp_p)
                  min_j=n
               endif
               error=0.0_DP
               if(abs(tmp_p).ne.0.0_DP) then
                  if(y_i.eq.1) then
                     CYP(icusp,n-NA+1)=summa_p/tmp_p
                  else
                     CY2P(icusp,n-NA+1)=summa_p/tmp_p
                  endif
               else
                  error=10.0_DP
               endif
               ! In case we can't finish in time we get partial 
               ! results anyway
               if(error.eq.10.0_DP) then
                                ! If K_IR(2piny)=0 we need to get smaller Y
                  write(*,*) 'Warning!'
                  write(*,*) 'RKBesselIP(',R,',',n_r*Y,')=',                 &
     &                 tmp_p
                  write(*,*) 'Decreasing  Y!'
                  Y=0.95_DP*Y
                  NNA=n         ! Meaning we will do this one over again
                  cycle Yloop
               endif
            enddo               ! icusp

         enddo                  !Y_i
         !! If index=1 we now have two sets of coefficients
         ! Error control number
         ! When too large we change the Y by *0.5 and continue
         ! 
         error=0.0_DP      
          !! here the difference is between two Y-values
         error=abs(abs(CYP(1,n-Na+1))-abs(CY2P(1,n-NA+1)))
         if((error.gt.tol) .or.(isnan(error)))then
            write(*,*) 'Warning Y to big!'
            write(*,*) 'tmp_p=',tmp_p
            write(*,*) 'CY1(',n,')=',CYP(1,n-NA+1)
            write(*,*)'CY2(',n,')=',CY2P(1,n-NA+1)
            write(*,*) '|CY1(n)-CY2(n)|=',error
            write(*,*) 'Halving Y!'
            Y=0.9_DP*Y
            NNA=n               ! Meaning we will do this one over again
                                !               stop
            
            cycle Yloop
         else     
            write(*,3821) 1,n,CYP(1,n-NA+1),error
            write(15,3821) 1,n,CYP(1,n-NA+1),error
            write(*,3821) 2,n,CY2P(1,n-NA+1),error
            write(15,3821) 2,n,CY2P(1,n-NA+1),error
            call FLUSH(15)
         endif
      enddo                     ! n
      exit Yloop
      enddo Yloop
!      call display_coefficients(CY2,NN,NN,1)
      write(*,*) 'min K_iR(2Pi*Y*',min_j,')=',minimum
      
 3821 FORMAT('C',I1,'(',I5,')=',F27.12,5X,F17.12,5X,ES10.4)   
! 3822 FORMAT('C',I1,'(-',I5,')=',F27.12,5X,F17.12,5X,ES10.4)   
      end subroutine phase2_holo



!!!   2007-08-07
      !! Most optimized for real coefficients
      !! and square-free numbers, e.g. including symmetries...

      !! Note that CR2 at return only contains coeficients from cusp nr. cnr (default cusp nr 1 at infinity) 
      subroutine phase2_real_char(R,Y,M0,NA,NB,NN,CR,CR2,tol,type,e,          &
     &     cnr_in) 
      use commonvariables
      use system
      use giant_mod
      use groups
      use characters
      use kbessel
      use interpolation
      implicit none
      integer :: NA,NB,Q,M0,M,type,j,cnr  
      integer,optional::cnr_in
      real(kind=DP) :: Y,R,tol
      real(kind=DP),dimension(1:num_cusps,1:M0) :: CR
      complex(kind=DP),dimension(1:NN) :: CR2
      real(kind=DP), dimension(:) :: e
      real(DP),dimension(1:2)::Yv,CYtmp
      real(DP),dimension(:,:,:,:),allocatable::X_pb2,Y_pb2
      complex(DP),dimension(:,:,:,:),allocatable::char_vec2
      real(DP)::summa,tmp1
      integer :: n,l,icusp,jcusp,NN,NNA,min_j
!      logical,optional::contig
      real(DP),dimension(:,:,:,:,:),allocatable::KBvec
      real(DP)::Vnlij
      real(kind=DP)::minimum,error,max_y,min_y
      real(DP)::xpb,ypb,l_r,n_r,rkbes,tmp,argpb,arg_m
      real(DP)::tmpVR
      real(DP)::tmpV
      integer::y_j,ny,i
      character*70::UTFILNAME
      character(LEN=20)::filtyp
      logical::ch_real
      if(PRESENT(cnr_in)) then 
         cnr=cnr_in
      else
         cnr=1
      endif
      ! Q should be for NB
      call get_M(R,Y,M)
      Q=max(M+10,100)
      if((CType.eq.1).and.(Level.eq.7)) then
         ch_real=.false.
      else
         ch_real=.true.
      endif
!      do j=1,M0
!        write(*,*) 'Cin(',j,')=',CR(1,j)
!      enddo
      filtyp='temp_coeff'
      i=anint(e(1))
      UTFILNAME=make_filename(filtyp,Level,type,i,1,R)
      open(15,FILE=UTFILNAME)
      write(*,*) 'in phase 2 real R=',R,'Y=',Y,' Q=',Q,' M0=',M0
      write(*,*) 'NA=',NA,' NB=',NB,'  M=',M
      write(*,*) 'type=',type,' parity=',e
      write(*,*) 'tol=',tol
      write(*,*) 'size(CY)=',size(CR), 'size(CY2)=',size(CR2)
      ! we will change Y if the error gets too big
      ! but no more than 100 times
      !! also, since we want to use all symmetries we have, I use two Y-values 
      !! to indicat errors
      
      call setup_interp_kbes(R)
      NNA=NA
      Yloop: do y_j=1,100
!     ! make sure that the Y value is ok
      call get_M(R,Y,M)
      Q=max(M+10,100)      
      write(*,*) 'Y=',Y,' Q=',Q
      write(*,*) 'NNA=',NNA,' NB=',NB,'  M=',M
      Yv(1)=Y
      Yv(2)=0.97_DP*Y
      write(*,*) 'Y1=',Yv(1),' Y2=',Yv(2)
      if((ch_real).and.(weight.eq.0.0)) then
         if(allocated(X_pb2)) then
            deallocate(X_pb2); deallocate(Y_pb2); deallocate(char_vec2)
         endif
         allocate(X_pb2(1:2,1:num_cusps,1:num_cusps,1-Q:Q))
         allocate(Y_pb2(1:2,1:num_cusps,1:num_cusps,1-Q:Q))
         allocate(char_vec2(2,1:num_cusps,1:num_cusps,1-Q:Q))
         call get_points(Yv(1),Q,X_pb2(1,:,:,:),Y_pb2(1,:,:,:),                 &
     &        char_vec2(1,:,:,:))
         call get_points(Yv(2),Q,X_pb2(2,:,:,:),Y_pb2(2,:,:,:),                 &
     &        char_vec2(2,:,:,:))
!         call get_points(Y1,Q,X_pb2,Y_pb2,char_vec2)
      else
         write(*,*) 'use with real coefficients only!'
         stop
         sampletype=1
         call get_pb_points_cplx_char(R,Y,Q)                                 
!     &        Q_start,Q_stop,sample_norm,sampletype)
      endif
!      write(*,*) 'points done!'
!      write(*,*) 'Q_start=',Q_start
!      write(*,*) 'Q_start=',Q_stop

      if(allocated(KBvec)) then
         deallocate(KBvec)
      endif
      allocate(KBvec(1:2,1:M0,1:num_cusps,1:num_cusps,Q_start:          &
     &     Q_stop))      
      minimum=10.0_DP
      min_j=0
      max_y=maxval(Y_pb2)*2.0_DP*Pi
      min_y=minval(Y_pb2)
!      write(*,*) 'min y_pb=',min_y
!      write(*,*) 'max 2Pi(na)y=',max_y*NA
!      write(*,*) 'max 2Pi(nb)y=',max_y*NB
 !     write(*,*) 'sample_norm=',sample_norm
!      stop
      do icusp=1,num_cusps
         do jcusp=1,num_cusps
            do l=1,M0
               l_r=real(l,DP)*PI2
               do j=Q_start,Q_stop  
                                ! the point is near the j:th-cusp)
                  do ny=1,2
                     ypb=Y_pb2(ny,icusp,jcusp,j)
                     if(ypb.gt.0.0_DP) then  
                        rkbes=interp_kbes(l_r*ypb)                  
!     rkbes = RKBessel(R,l_r*ypb)
                        KBvec(ny,l,icusp,jcusp,j)=rkbes*sqrt(ypb)
                     endif
                  enddo
               enddo
            enddo
         enddo
      enddo
      !! I probably could replace the Y_pb_s vector with an indicator vector of integers instead to save some memory
!      if(allocated(Y_pb_s)) then
!         deallocate(Y_pb_s)
!      endif
!      write(*,*) 'Done computing K-Bessel!!'
!      write(*,*) 'bessel_max=',maxval(KBvec)
!      write(*,*) 'NNA=',NNA
!      write(*,*) 'NB=',NB
!      write(*,*) 'cnr=',cnr
      do n=NNA,NB         
         n_r=real(n,DP)*PI2
         do ny=1,2
            do icusp=cnr,cnr
               summa=0.0_DP
               do jcusp=1,num_cusps
                  tmp1=0.0_DP
                  do l=1,M0
                     if(abs(CR(jcusp,l)).eq.0.0_DP) then
                        cycle
                     endif
                                ! MAke the V_nl^ij
                     Vnlij = 0.0_DP
                     l_r=real(l,DP)*PI2
                     do j=Q_start,Q_stop  
                        ypb=Y_pb2(ny,icusp,jcusp,j)
                        if(ypb.gt.0.0_DP) then ! the point is near the j:th-cusp)
                           xpb=X_pb2(ny,icusp,jcusp,j)
                           tmp=KBvec(ny,l,icusp,jcusp,j)
                           argpb=l_r*xpb ! l_r including 2*PI
                           arg_m=n_r*Xm(j) ! n_r including 2*PI


                           if(type.eq.0) then
!                              tmpVR=dcos(argpb)*dcos(arg_m)
                              tmpVR=dcos(argpb-arg_m)
!                              tmpVIm=0.0_DP
                           else
                              tmpVR=dsin(argpb)*dsin(arg_m)
!                              tmpVR=dsin(argpb-arg_m)
!                              tmpVIm=0.0_DP
                           endif
                          tmpV=tmp*tmpVR
                           Vnlij = Vnlij + tmpV*                                    &
     &                          real(char_vec2(ny,icusp,jcusp,j),DP)
                        endif
                     enddo
                     Vnlij=Vnlij*sample_norm
                     tmp1=tmp1+CR(jcusp,l)*Vnlij
                  enddo               
                  summa=summa+tmp1
               enddo
               tmp=sqrt(Yv(ny))*RKBessel(R,PI2*real(n,DP)*Yv(ny))
               if(abs(tmp).lt.minimum) then
                  minimum=abs(tmp)
                  min_j=n
               endif
               if(tmp.ne.0.0_DP) then
                  CYtmp(ny)=summa/tmp
!                  write(*,*) 'CYtmp(',ny,',',n,')=',CYtmp(ny)
                                ! In case we can't finish in time we get partial 
                                ! results anyway
                  
               else
                                ! If K_IR(2piny)=0 we need to get smaller Y
                  write(*,*) 'Warning!: tmp=',tmp
                  write(*,*) 'RKBessel(',R,',',PI2*real(n,DP)*Yv(ny),              &
     &                 ')=',rkbes
                  write(*,*) 'Decreasing  Y!'
                  Y=0.95_DP*Yv(ny)
                  NNA=n         ! Meaning we will do this one over again
                  cycle Yloop
               endif
            enddo !! Loop ove rone cusp 
         enddo                  !! Loop over Yv(j)
         ! Error control number
         ! When too large we change the Y and continue
         ! 
!     error=abs(abs(CR2(n))-abs(CR2(n+NB)))
         error=abs(abs(CYtmp(1))-abs(CYtmp(2)))
         if(error.gt.tol) then
            write(*,*) 'Warning Y to big!'
            write(*,*) 'We got CY2(',n,')=',CR2(n-NNA+1),' er=',error
            write(*,*) 'Decreasing Y!'
            Y=0.95_DP*Y
            NNA=n               !g2264 Meaning we will do this one over again
            cycle Yloop
         else
            write(*,*) 'setting cr2(',n-NA+1,')'
            !!! The complex coordinate is the error
            CR2(n-NA+1)=dcmplx((CYtmp(1)+CYtmp(2))*0.5_DP,error)
            write(*,3821) n,real(CR2(n-NA+1),DP),error
            write(15,3821) n,real(CR2(n-NA+1),DP),error
            call FLUSH(15)
         endif
      enddo                     !! n
      exit Yloop

      enddo Yloop

      write(*,*) 'NA,NB=',NA,NB
      do n=NA,NB
         write(*,*) 'CR2(in phase2)(',n,')=',Cr2(n-NA+1)
      enddo
       

!     call display_coefficients(CY2,NN,NN,1)
      write(*,*) 'min K_iR(2Pi*Y*',min_j,')=',minimum
      
 3821 FORMAT('C(',I5,')=',F27.12,'+I*',F17.12,5X,ES10.4)   
      end subroutine phase2_real_char
!c$$$
!c$$$
!c$$$
!c$$$    !! Note that CR2 at return only contains coeficients from cusp nr. cnr (default cusp nr 1 at infinity) 
!c$$$!! ka,kb=range of cusps to compute for
      subroutine phase2_real(R,Y,M0,ka,kb,NA,NB,NN,D,DOUT,tol,type,             &
     &     errtype) 
      use commonvariables
      use system
      use giant_mod
      use groups
      use characters
      use kbessel
      use interpolation
      use pullback
      implicit none
      integer :: NA,NB,ka,kb,Q,M0,M,NN
      integer::type,errtype
      real(kind=DP) :: Y,R,tol
      real(kind=DP),dimension(1:num_cusps,1:M0) :: D
      real(kind=DP),dimension(ka:kb,1:NN,1:2) :: DOUT
      real(DP),dimension(1:2)::Yv 
      real(DP),dimension(:),allocatable::CYtmp
      real(DP),dimension(:,:,:,:),allocatable::X_pb2,Y_pb2
      complex(DP),dimension(:,:,:,:),allocatable::char_vec2
      real(DP)::summa,tmp1
      integer :: j,n,l,icusp,jcusp,NNA,min_j,nna_old
!      logical,optional::contig
      real(DP),dimension(:,:,:,:,:),allocatable::KBvec
      real(DP)::Vnlij
      real(kind=DP)::minimum,error,max_y,min_y
      real(DP)::xpb,ypb,l_r,n_r,rkbes,tmp,argpb,arg_m
      real(DP)::tmpVR,tmpV,rhkbes(2),YB
      integer::y_j,ny,ydecrease
      character*70::UTFILNAME
      character(LEN=20)::filtyp
      logical::ch_real
      integer::y_start,y_stop,QB,MB,num_kb,io
      ! Y should be for NA
      call get_Y_from_M(R,NA,Q,Y)
      if(Y.gt.Y0_min) Y=Y0_min
      ! And then choose Q>  M corresponding to Y 
      call get_M0_Q_Y(R,M,Q,Y)
      Q=max(M+10,100)
      !! Now for NB (too see if necessary to use interpolation )
      YB=Y
      call get_Y_from_M(R,NB,Q,YB)
      call get_M0_Q_Y(R,MB,QB,YB)
      QB=MB+10
      if(Ctype.gt.0) ch_real=.true.
!      if(weight.ne.0.0)MSG='Use with weight zero only!';call errmsg(1,6)
!     ! Make a temporary file:      
      filtyp='temp_coeff'
    

      UTFILNAME=make_filename(filtyp,Level,type,0,1,R)
      if(phase2_silent.gt.-2) then 
         open(15,FILE=UTFILNAME,IOSTAT=IO)
         close(15)
         open(15,FILE=UTFILNAME,POSITION='APPEND')
      endif
      if(phase2_silent.gt.0) then 
         write(*,*) 'in phase 2 real R=',R,'Y=',Y,' Q=',Q,' M0=',M0
         write(*,*) 'NA=',NA,' NB=',NB,'  M=',M
         write(*,*) 'tol=',tol
         write(*,*) 'type=',type
         write(*,*) 'interpolating=',do_interp
         write(*,*) 'size(D)=',size(D), 'size(DOUT)=',size(DOUT)
         write(*,*) 'Writing to file=',utfilname
      endif
      ! we will change Y if the error gets too big
      ! but no more than 100 times
      !! also, since we want to use all symmetries we have, I use two Y-values 
      !! to indicate errors
      !! Walways use interpolation of the K-Bessel function
      if((errtype.eq.1).or.((kb-ka).eq.0)) then 
         y_start=1; y_stop=2
      else
         y_start=1; y_stop=1;
      endif
      if(y_stop.gt.y_start) then 
         allocate(CYtmp(Y_start:y_stop))
      else
         allocate(CYtmp(ka:kb))
      endif
      if(do_interp) then 
         num_kb=M*2*Q*(y_stop-y_start+1)*num_cusps*num_cusps
         write(*,*) 'num_interpkb=',get_size()
         write(*,*) 'num_kb=',num_kb
         if(get_size().ge.num_kb) do_interp=.false.
      endif
      if(do_interp) then 
         call setup_interp_kbes(R)
      endif

      NNA=NA
      NNA_old=NNA
      ydecrease=0
      y_j=0
      yloop: do while(y_j.lt.100)
         if(NNA.gt.NNA_old) y_j=0
         y_j=y_j+1
         !! First check that if we need to decrease the Y-value
         if(ydecrease.eq.1) Y=Y*0.97_DP
         ydecrease=0
!     !! We should check that Y is good, i.e. that K_iR(2*PI*NNA*Y) is not too small
         rkbes=sqrt(Y)*RKBEssel(R,real(NNA,DP)*PI2*Y)
         if(abs(rkbes).lt.tol) then 
            if(phase2_silent.ge.0) then 
               write(*,*) 'rkbess too small=',abs(rkbes)
            endif
            ydecrease=1; cycle Yloop
         endif
         Yv(1:2)=(/ Y, 0.97_DP*Y /)
         call get_M(R,Y,M)
         Q=max(M+10,100)      
         if(phase2_silent.gt.0) then 
            write(*,*) 'Y=',Y,' Q=',Q
            write(*,*) 'NNA=',NNA,' NB=',NB,'  M=',M
            write(*,*) 'Y1=',Yv(1),' Y2=',Yv(2)
         endif
         if(allocated(X_pb2)) then
            deallocate(X_pb2);deallocate(Y_pb2)
         endif
         call set_sampledata(Q,2)
         allocate(X_pb2(1:2,1:num_cusps,1:num_cusps,Q_start:Q_stop))
         allocate(Y_pb2(1:2,1:num_cusps,1:num_cusps,Q_start:Q_stop))
         do ny=y_start,y_stop
            call get_points_r(Yv(ny),Q,X_pb2(ny,:,:,:),Y_pb2(ny,:,:,:))
         enddo
         if(allocated(KBvec)) then
            deallocate(KBvec)
         endif
         sample_norm=2.0_DP/real(Q,DP)
!         write(*,*) 'num_kbes=',(Q_stop-Q_start)*num_cusps**2*M0*2
         allocate(KBvec(1:2,1:M0,1:num_cusps,1:num_cusps,Q_start:          &
     &        Q_stop))      
         minimum=10.0_DP
         min_j=0
         max_y=maxval(Y_pb2)*2.0_DP*Pi
         min_y=minval(Y_pb2)
         do icusp=1,num_cusps
            do jcusp=1,num_cusps
               do l=1,M0
                  l_r=real(l,DP)*PI2
                  do j=Q_start,Q_stop  
                                ! the point is near the j:th-cusp)
                     do ny=y_start,y_stop
                        ypb=Y_pb2(ny,icusp,jcusp,j)
                        if(ypb.gt.0.0_DP) then  
                           if(do_interp) then 
                              rkbes=interp_kbes(l_r*ypb)                  
                           else
                              rkbes=RKBEssel(R,l_r*ypb)
                           endif
                           KBvec(ny,l,icusp,jcusp,j)=rkbes*sqrt(ypb)
                        endif
                     enddo
                  enddo
               enddo
            enddo
         enddo
         do n=NNA,NB    
            n_r=real(n,DP)*PI2
            rhkbes(1)=sqrt(Yv(1))*RKBessel(R,n_r*Yv(1))
            if(abs(rhkbes(1)).lt.tol) then 
               if(phase2_silent.ge.0) then 
                  write(*,*) 'rkbess too small=',abs(rhkbes(1))
               endif
               NNA=n; ydecrease=1; cycle Yloop
            endif
            rhkbes(2)=sqrt(Yv(2))*RKBessel(R,n_r*Yv(2))
            do icusp=ka,kb
               do ny=y_start,y_stop
                  summa=0.0_DP
                  do jcusp=1,num_cusps
                     tmp1=0.0_DP
                     do l=1,M0
                        if(abs(D(jcusp,l)).eq.0.0_DP) then
                           cycle
                        endif
                                ! MAke the V_nl^ij
                        Vnlij = 0.0_DP
                        l_r=real(l,DP)*PI2
                        do j=Q_start,Q_stop  
                           ypb=Y_pb2(ny,icusp,jcusp,j)
                           if(ypb.gt.0.0_DP) then ! the point is near the j:th-cusp)
                              tmp=KBvec(ny,l,icusp,jcusp,j)
                              argpb=l_r*X_pb2(ny,icusp,jcusp,j)
                              arg_m=n_r*Xm(j) ! n_r including 2*PI
                              if(type.eq.0) then
                                 tmpVR=dcos(argpb)*dcos(arg_m)
                              else
                                 tmpVR=dsin(argpb)*dsin(arg_m)
                              endif
                              tmpV=tmp*tmpVR
                              Vnlij = Vnlij + tmpV
                           endif
                        enddo
                        tmp1=tmp1+D(jcusp,l)*Vnlij
                     enddo               
                     summa=summa+tmp1
                  enddo
                  if(abs(tmp).lt.minimum) then
                     minimum=abs(tmp)
                     min_j=n
                  endif
                  if(y_stop.gt.y_start) then 
                     CYtmp(ny)=summa*sample_norm/rhkbes(ny)
                  else
                     CYtmp(icusp)=summa*sample_norm/rhkbes(ny)
                  endif
               enddo            !! Loop over Yv(j)

                                ! When too large we change the Y and continue
               if((y_stop.gt.y_start).or.icusp.ge.2) then 
                  if(Y_stop.gt.y_start) then 
                     error=abs(CYtmp(1)-CYtmp(2))
!/abs(Yv(2)-Yv(1))
!                     write(*,*) 'er=',abs(CYtmp(1)-CYtmp(2)),'/',          &
!     &                    abs(Yv(2)-Yv(1)),'=',error
                  else
                     error=abs(CYtmp(1)-CYtmp(2))
                  endif
                  if(error.gt.tol) then
                     if(phase2_silent.ge.1) then 
                        write(*,*) 'Warning Y to big!'
                        write(*,*)'Got CY2(',n,')=',CYtmp(1),'er=',error
                        write(*,*) 'Decreasing Y!'
                     endif
                     ydecrease=1; NNA=n; cycle Yloop
                  endif
               endif
               if(y_stop.gt.y_start) then 
                  DOUT(icusp,n-NA+1,1:2)=(/(CYtmp(1)+CYtmp(2))*0.5_DP       &
     &                 ,error /)
               else
                  DOUT(icusp,n-NA+1,1:2)=(/CYtmp(icusp),error /)
               endif
               !! We should also update the coefficients in D(j) if applicable
               if(n.le.M0) then 
                  D(icusp,n)=DOUT(icusp,n-NA+1,1)
               endif
!               write(*,*) 'HERE0!'
               if(phase2_silent.ge.0) then 
                  write(*,3821) icusp,n,DOUT(icusp,n-NA+1,1),error
!                  write(15,3821)icusp,n,DOUT(icusp,n-NA+1,1),error
               endif
               if(phase2_silent.ge.-2) then                   
!                  write(15,3821) icusp,n,DOUT(icusp,n-NA+1,1),error
!                  call FLUSH(15)
               endif
!               write(*,*) 'End icusp=',icusp
            enddo               !! end icusp=ak,bk
            NNA_old=n
         enddo                  !! n
         exit Yloop
      enddo Yloop
      if(phase2_silent.gt.-2) then 
         close(15)
      endif
 3821 FORMAT('C(',I5,',',I5,')=',F27.12,'+I*',F17.12,5X,ES10.4)   
      call clean_pullback()
      end subroutine phase2_real

      end module
