!!! MODULE: pullback
!!! Description: Module containing routines to make pullbacks to the groups

      module pullback
      use commonvariables
      use groups
      use matrix
!      use permutations
      implicit none
      
      real(kind=DP),dimension(:,:,:),allocatable,save::X_pb_s,Y_pb_s,   &
     &     X_pb_s1,Y_pb_s1,X_pb_s2,Y_pb_s2
      real(kind=DP),dimension(:),allocatable,save::Xm,Xm_s,Xm_s2
      real(kind=DP),dimension(:,:,:),allocatable,save::char_vec_r_s,    &
     &     char_vec_r_s2
      complex(kind=DP),dimension(:,:,:),allocatable,save::char_vec_c_s,  &
     &     char_vec_c_s2
      complex(kind=DP),dimension(:,:,:),allocatable,save::char_vec_s1,  &
     &     char_vec_s2
      real(DP)::Y1_pbset,Y2_pbset
      integer::Q_set,Ctype_set
      real(DP),save::weight_set
      integer::Q_start,Q_stop,sampletype
      real(DP)::sample_norm
!!!      private::Y1_set,Y2_set
      contains
      


      subroutine pullback_map(x,y,xpb,ypb,pbmap,rpbmap)
      implicit none
      real(DP),intent(in)::x,y
      real(DP),intent(out)::xpb,ypb
      integer,dimension(2,2),optional::pbmap
      real(DP),dimension(2,2),optional::rpbmap
      if(from_perm) then          
         write(*,*) 'Do not use permutation groups here!'
         stop
!         call pullback_using_perm_map(x,y,xpb,ypb,pbmap)
      elseif(hecke_q.ge.4) then
         call pullback_to_Heckeq(x,y,xpb,ypb,rpbmap)
      else
         call pullback_to_gamma0N_map(x,y,xpb,ypb,pbmap)
      endif     
      end subroutine

      subroutine pullback_panint(x,y,xpb,ypb,dd)
      implicit none
      real(DP),intent(in)::x,y
      real(DP),intent(out)::xpb,ypb
      integer,dimension(2,2)::pbmap
      integer::d
      real(DP),dimension(2,2)::rmap
      integer,optional::dd
      if(from_perm) then 
         write(*,*) 'Do not use permutation groups here!'
         stop
!         write(*,*) 'Pulling back using perm!'
!         call pullback_using_perm(x,y,xpb,ypb,d)
      elseif(hecke_q.ge.4) then
!         write(*,*) 'pb heckeq=',hecke_q
         call pullback_to_Heckeq(x,y,xpb,ypb,rmap)
         d=dnint(rmap(2,2))
      else
         call pullback_to_gamma0N(x,y,xpb,ypb,d)
      endif     
      if(present(dd)) then 
         dd=d
      endif
      end subroutine



      subroutine pullback_to_gamma0N(x_in,y_in,xpb,ypb,                  &
     &     d_g0N_mapping)
      implicit none
      real(kind=DP),intent(in) :: x_in,y_in
      real(kind=DP),intent(out) :: xpb,ypb
      real(kind=DP) :: x_mod,y_mod,xtmp,ytmp
      integer,optional::d_g0N_mapping
      integer, dimension(2,2) :: mod_mapping,tmp_map
      real(DP), dimension(2,2) :: re_mod_mapping
      integer :: cur_index,ix_k,ix_m,ix_j
      integer :: m,n_rep,d
      if((Level==0)) then
         write(*,*) 'ERROR: Level (N) is not set!'
         stop
      elseif(from_perm) then  !!! This is not always a Gamma_0(N)
         write(*,*) 'Do not use permutation groups here!'
         stop
!         call pullback_using_perm(x_in,y_in,xpb,ypb,d_g0N_mapping)
         return
      elseif(cycloidal) then
         if(Level.ne.1) then
            call pullback_to_cycloid(x_in,y_in,xpb,ypb,re_mod_mapping)
            d_g0N_mapping=dnint(re_mod_mapping(2,2))
            return
         else  !! we have not integer mappings
            call pullback_to_cycloid(x_in,y_in,xpb,ypb,re_mod_mapping)
!            d_g0N_mapping=mod_mapping(2,2)
            d_g0N_mapping=1
            !!! we have no need for characters with these groups
            return
         endif
      endif
      call pullback_to_mod(x_in,y_in,x_mod,y_mod,mod_mapping)
      n_rep = get_coset(mod_mapping)

      if(n_rep>0) then
!!! remember it is rep(n_rep)*mod_mapping
         d=mod_mapping(1,2)*reps(n_rep,2,1) +                            &
     &        mod_mapping(2,2)*reps(n_rep,2,2)
         call apply_map_int(x_mod,y_mod,xpb,ypb,reps(n_rep,:,:))
      else
         d=mod_mapping(2,2)
         xpb=x_mod
         ypb=y_mod
      endif
      if(present(d_g0N_mapping)) then
         d_g0N_mapping=d
      endif
      end subroutine pullback_to_gamma0N
      
      ! also returns the map
      subroutine pullback_to_gamma0N_map(x_in,y_in,xpb,ypb,                  &
     &     g0N_mapping)
      implicit none
      real(kind=DP),intent(in) :: x_in,y_in
      real(kind=DP),intent(out) :: xpb,ypb
      real(kind=DP) :: x_mod,y_mod,xtmp,ytmp
      integer, dimension(2,2) :: mod_mapping,g0N_mapping
      real(DP), dimension(2,2) :: re_mod_mapping
      integer :: cur_index,ix_k,ix_m,ix_j
      integer :: m,d_g0N_mapping,n_rep      
      if((Level==0)) then
         write(*,*) 'ERROR: Level (N) is not set!'
         stop
      elseif(from_perm) then  !!! This is not always a Gamma_0(N)
         write(*,*) 'Do not use permutation groups here!'
         stop
!         call pullback_using_perm_map(x_in,y_in,xpb,ypb,g0N_mapping)         
         return
      elseif(cycloidal) then
         if(Level.ne.1) then
            call pullback_to_cycloid(x_in,y_in,xpb,ypb,re_mod_mapping)
            g0N_mapping=dnint(re_mod_mapping)
            return
         else
            call pullback_to_cycloid(x_in,y_in,xpb,ypb,re_mod_mapping)
            !! we have no need for characters or multipliers
            g0N_mapping(:,:)=mapId(:,:)
         endif
      endif
      call pullback_to_mod(x_in,y_in,x_mod,y_mod,mod_mapping)
      n_rep = get_coset(mod_mapping)
!      write(*,*) 'mod_map=',mod_mapping(1,:)
!      write(*,*) 'mod_map=',mod_mapping(2,:)
      if(n_rep>0) then
         g0N_mapping=MATMUL(reps(n_rep,:,:),mod_mapping)
!         d_g0N_mapping=mod_mapping(2,1)*reps(n_rep,1,2) +                   &
!     &        mod_mapping(1,1)*reps(n_rep,1,1)
         call apply_map_int(x_mod,y_mod,xpb,ypb,reps(n_rep,1:2,1:2))
      else
         g0N_mapping=mod_mapping
         xpb=x_mod
         ypb=y_mod
      endif
      end subroutine pullback_to_gamma0N_map


      subroutine pullback_to_mod(x_in,y_in,x_out,y_out,mapping)
      
      implicit none
      real(kind=DP),intent(in) :: x_in,y_in
      real(kind=DP),intent(out) :: x_out,y_out
      integer, parameter :: SAFE_TEST = 1000
      integer, dimension(2,2),intent(out) :: mapping
      integer, dimension(2,2)::mapTT,mapSS
      integer, dimension(2,2)::tmp_mapping
      integer :: num_T,num_S    ! the number of times we apply either
      real(kind=DP) :: x,y,abs_val,dist_x
      integer :: j,numT
      logical :: not_done
      mapSS(1,:)=(/0,-1/)
      mapSS(2,:)=(/1,0/)
      x = x_in
      y = y_in
      mapping = mapId
!reshape((/1,0,0,1 /),(/2,2/))  ! start with the identity
      ! first make sure we get inside the strip by 
      ! applying Tz=z+1 an appropriate number of times
      not_done = .true.
      j=0
      do while(not_done)
         j = j+1
         if(j>SAFE_TEST) then 
            write(*,*) 'ERROR: numerical pullback takes too long'
            write(*,*) 'more than ',SAFE_TEST,' iterations!'
            write(*,*) 'z=',x_in,y_in
            
            stop
            
         endif
         if(abs(x) > 0.5_DP) then 
                                ! apply T an appropriate number of times           
            dist_x = max(x-0.5_DP,-x-0.5_DP) ! distance to x=+-0.5
            numT = ceiling(dist_x) ! round upwnwards
            if(x>0) then ! we have to subtract 
               numT = -numT
            endif  
            x = x+real(numT,DP)
            mapTT(1,:) = (/ 1, numT /)
            mapTT(2,:) = (/ 0, 1 /)
            mapping = MATMUL(mapTT,mapping)
         else
            abs_val=x**2+y**2    
            if(abs_val < 1.0_DP-eps0) then ! apply S
               x = -x/abs_val
               y = y/abs_val
               mapping = MATMUL(mapSS,mapping)
            else 
               not_done = .false. ! we are done
            endif
         endif
      end do
      x_out = x
      y_out = y
      end subroutine pullback_to_mod


!!! Pullback to a Hecke G_q
      subroutine pullback_to_Heckeq(x_in,y_in,x_out,y_out,mapping)
      implicit none
      real(kind=DP),intent(in) :: x_in,y_in
      real(kind=DP),intent(out) :: x_out,y_out
      integer, parameter :: SAFE_TEST = 1000
      real(DP), dimension(1:2,1:2),optional :: mapping
      real(DP), dimension(1:2,1:2)::mapTr,mapSr
      real(DP), dimension(1:2,1:2)::tmp_mapping
      integer :: num_T,num_S    ! the number of times we apply either
      real(kind=DP) :: x,y,abs_val,dist_x,wi
      integer :: j,numT
      logical :: not_done,deb
      deb=.false.
!      mapS(1,1:2)=(/0.0_DP,-1.0_DP/)
!      mapS(2,1:2)=(/1.0_DP,0.0_DP/)
      mapSr(1,1)=0.0_DP
      mapSr(1,2)=-1.0_DP
      mapSr(2,1)=1.0_DP
      mapSr(2,2)=0.0_DP
      x = x_in
      y = y_in
      mapping(1,1)=1.0_DP
      mapping(1,2)=0.0_DP
      mapping(2,1)=0.0_DP
      mapping(2,2)=1.0_DP
!      mapping(1,1:2)= (/1.0_DP,0.0_DP/)
!      mapping(2,1:2)= (/0.0_DP,1.0_DP/)                ! start with the identity
      ! first make sure we get inside the strip by 
      ! applying Tz=z+1 an appropriate number of times
      not_done = .true.
      j=0
      wi=cusp_width(1)
!      deb=.true.
      do while(not_done)
         j = j+1
         if(j>SAFE_TEST) then 
            write(*,*) 'ERROR: numerical pullback takes too long'
            write(*,*) 'more than ',SAFE_TEST,' iterations!'
            write(*,*) 'z=',x_in,y_in            
            stop            
         endif
         !! Tz=z+lambdapo
         if(deb) then
            write(*,*) 'abs(x)=',abs(x)
            write(*,*) '0.5*wi=',0.5_DP*wi
         endif
         if(abs(x) > 0.5_DP*wi) then 
                                ! apply T an appropriate number of times           
            dist_x = max(x-0.5_DP*wi,-x+0.5_DP*wi) ! distance to x=+-0.5*width
            numT = ceiling(dist_x/wi) ! round upwards
            if(x>0) then ! we have to subtract 
               numT = -numT
            endif  
            x = x+real(numT,DP)*wi
            mapTr(1,:) = (/ 1.0_DP, real(numT,DP)*wi /)
            mapTr(2,:) = (/ 0.0_DP, 1.0_DP /)
            mapping = MATMUL(mapTr,mapping)
            if(deb) then
               write(*,*) 'translating with ',numT,'*',wi
            endif
         else
            abs_val=x*x+y*y    
            if(abs_val < 1.0_DP-eps0) then ! apply S
               x = -x/abs_val
               y = y/abs_val
               mapping = MATMUL(mapSr,mapping)
               if(deb) then
                  write(*,*) 'inverting '
               endif
            else 
               not_done = .false. ! we are done
            endif
         endif
      end do
      x_out = x
      y_out = y
      if(deb) then
!         write(*,*) 'x_pb=',x
         write(*,*) x_in,y_in,'--->',x,y
 
         write(*,*) 'by map T='
         write(*,*) '[',mapping(1,:),']'
         write(*,*) '[',mapping(2,:),',]'
      endif
      end subroutine pullback_to_Heckeq


 
      subroutine pullback_to_cycloid(x_in,y_in,x_out,y_out,mapping)
      implicit none
      real(kind=DP),intent(in) :: x_in,y_in
      real(kind=DP),intent(out) :: x_out,y_out
      integer, parameter :: SAFE_TEST = 100
      real(DP), dimension(2,2),intent(out) :: mapping
      real(DP), dimension(2,2)::mapTr,mapSr
      real(DP), dimension(2,2)::tmp_map
      integer :: num_T,num_S    ! the number of times we apply either
      real(kind=DP) :: x,y,abs_val,dist_x,x_ny,y_ny
      integer :: i,j,k,numT
      real(DP)::a,b,c,d
      logical :: deb,outside

!      mapS(1,:)=(/0,-1/)
!      mapS(2,:)=(/1,0/)
      x = x_in
      y = y_in
      mapSr=real(mapS,DP)
!      mapping = reshape((/1.0_DP,0,0,1 /),(/2,2/))  ! start with the identity
      mapping=real(mapId,DP)

      ! first make sure we get inside the strip by 
      ! applying Tz=z+1 an appropriate number of times
    !  deb=.true.

      !!! assume we are outside the fundamental
      !!! domain, i.e. inside some isometric circle
      outside=.true.

!      not_done = .true.
      j=0
!      do while(not_done)
      do while(outside)
         outside=.false.
         !! now we want to verify that we are in the fund. dom.
         j = j+1
         if(j>SAFE_TEST) then 
            write(*,*) 'ERROR:c_numerical pullback takes too long'
            write(*,*) 'more than ',SAFE_TEST,' iterations!'
            write(*,*) 'z=',x_in,y_in
            write(*,*) 'z_ny=',x,y
            stop
            
         endif
         if(deb) then
            write(*,*) 'Outside=',outside
            write(*,*) 'z_ny=',x,y
         endif
         !!! If outside the width of the domain 
         !!! translate back
         if(abs(x) > 0.5_DP*width) then 
                                ! apply T an appropriate number of times           
            dist_x = max(x-0.5_DP*width,-x+0.5_DP*width) ! distance to x=+-0.5*width
            numT = ceiling(dist_x/width) ! round downwards
            if(x>0) then ! we have to subtract 
               numT = -numT
            endif  
            x = x+real(numT,DP)*width
            mapTr(1,:) = (/ 1.0_DP, numT*width /)
            mapTr(2,:) = (/ 0.0_DP, 1.0_DP /)
            mapping = MATMUL(mapTr,mapping)
            outside=.true.
            if(deb) then
               write(*,*) 'translating with ',numT*width
            endif
         else
            !!! we have to see which of the remaining 
            !!! generators to use 
            do k=-num_gens,num_gens
               if(abs(k).le.1) then
                  cycle
               endif
               tmp_map=generators(k,:,:)
               a=tmp_map(1,1)
               b=tmp_map(1,2)
               c=tmp_map(2,1)
               d=tmp_map(2,2)
               if(c.eq.0.0) then
                  cycle
               endif
               if(deb) then
                  write(*,*) 'circle: |x+',d/c,'|=',1.0_DP/c
                  write(*,*) '|x+d/c|=',abs(x+d/c)
               endif
               !!! so we are inside this isometric circle
               
!               if(abs(x+d/c).le.1.0_DP/c) then
                  !! we must now see if we are inside the circle
                  !! or outside it
               abs_val=(x+d/c)**2+y**2      
!                  write(*,*) 'abs_val=',abs_val
               if(abs_val<1.0_DP/(c**2)-eps0) then
                     !! apply this generator
                  call apply_map_re(x,y,x_ny,y_ny,tmp_map)
                  mapping = MATMUL(tmp_map,mapping)
                  x=x_ny
                  y=y_ny
                  outside=.true.
                  if(deb) then
                     write(*,*) 'gen(',k,')='
                     write(*,*) tmp_map(1,:)
                     write(*,*) tmp_map(2,:)
                  endif
               endif
            enddo
            !!! If still not done we probably have 
            !!! a bit of skew fundamental domain 
            !!! i.e. the Ford fundamental domain corresponding
            !!! to these generators is not really symmetric
            !!! We check against a translated Fund.dom. instead
            if(.not.(outside)) then
               !! shift both back and forth
               do i=1,-1,-2
                  do k=2,num_gens
                     tmp_map=MATMUL(generators(1,:,:),generators(k,:,:))
                     a=tmp_map(1,1)
                     b=tmp_map(1,2)
                     c=tmp_map(2,1)
                     d=tmp_map(2,2)
                   !!! so we are inside that particular isom. circle               
                  !! we must now see if we are inside the circle
                                !! or outside it
                     abs_val=(x+d/c)**2+y**2      
                                !                  write(*,*) 'abs_val=',abs_val
                     if(abs_val<(1.0_DP/c**2)-eps0) then
                                !! apply this generator
                        call apply_map_re(x,y,x_ny,y_ny,tmp_map)
                        mapping = MATMUL(tmp_map,mapping)
                        x=x_ny
                        y=y_ny
                        outside=.true.
                        if(deb) then
                           write(*,*) 'gen(',k,')='
                           write(*,*) tmp_map(1,:)
                           write(*,*) tmp_map(2,:)
                        endif
                     endif
                  enddo
               enddo
            endif
         endif
      end do
      x_out = x
      y_out = y
      end subroutine pullback_to_cycloid



      

      
      subroutine get_pb_points(R,Y,Q,sym_in)
      use commonvariables
      use groups
      use characters
      implicit none
      integer :: Q
      real(kind=DP) :: Y,R
      ! 0 = cos : 1 = sin
      real(kind=DP) :: x_in,y_in,xpb,ypb,xtmp,ytmp,xtmp2,ytmp2
      integer,dimension(2,2) :: map_tmp
  !    integer,optional::Q_start_in,Q_stop_in,sampletype_in
!      integer::sampletype
      logical,optional::sym_in
      logical::sym
      !! sym is determined by whether we use cos/sin symmetry or not
      integer :: j,d
      real(kind=DP),dimension(2,2)::B
      real(kind=DP) :: char,tmp,char_i,char_j
      logical :: deb
!      integer :: Q_start,Q_stop
      integer :: type ! even or odd =0,1
      real(kind=DP) :: sample_norm ! normalise the sample
      real(DP)::map_tmpr(2,2)
!      real(kind=DP),optional :: sample_norm_in ! normalise the sample
      integer :: icusp,jcusp,ind_vertex,ind_cusp
 ! We have to decide which type of sample to use in the DFT
      if(.not.(PRESENT(sym_in))) then
         sym=.true.
      else
         sym=sym_in
      endif
!      write(*,*) 'In pb_pt: R,Y,Q=',R,Y,Q
      j=sampletype
!      call CPU_TIME(TIME)
      call set_sampledata(Q,j)
!      if(sym) then
!         sample_norm=1.0_DP/real(Q,DP)
!      else
!         sample_norm=1.0_DP/real(2*Q,DP)
!      endif
!      write(*,*) 'PB:sample_norm=',sample_norm
 !     if(present(Q_start_in)) Q_start_in=Q_start
 !     if(present(Q_stop_in)) Q_stop_in=Q_stop
 !     if(present(sample_norm_in)) sample_norm_in=sample_norm
      if(ctype.gt.1) then 
         write(*,*) 'Use this pullback only for trivial ',
     &        'or quadratic character!'
         stop
      endif
      if(allocated(X_pb_s)) then
         deallocate(X_pb_s)
      endif
      if(allocated(Y_pb_s)) then
         deallocate(Y_pb_s)
      endif
      if(allocated(Xm_s)) then
         deallocate(Xm_s)
      endif
      if(allocated(char_vec_r_s)) then
         deallocate(char_vec_r_s)
      endif
 
      allocate(X_pb_s(1:num_cusps,1:num_cusps,Q_start:Q_stop))
      allocate(Y_pb_s(1:num_cusps,1:num_cusps,Q_start:Q_stop))
      allocate(char_vec_r_s(1:num_cusps,1:num_cusps,Q_start:Q_stop))
      allocate(Xm_s(Q_start:Q_stop))
      do j=Q_start,Q_stop
         Xm_s(j) = width*(real(j,DP)-0.5_DP)/real(2*Q,DP)
      end do
      ! computing the pulled-back points
      ! for the first series with respect to the other two
      X_pb_s(:,:,:)=0.0_DP
      Y_pb_s(:,:,:)=0.0_DP
      do icusp=1,num_cusps
         do j=Q_start,Q_stop
!            if(icusp.ge.1) then
            B(:,:)=sigma_j(icusp,:,:)
            call apply_map_re(Xm_s(j),Y,xtmp,ytmp,B) ! normalize
            call pullback_panint(xtmp,ytmp,xpb,ypb,d)               
!               call pullback_to_Heckeq(xtmp,ytmp,xpb,ypb,map_tmpr)               
            call get_char(d,char_i)
            call seek_vertex(xpb,ypb,ind_vertex)
            call get_cusp_from_vertex(ind_vertex,ind_cusp)
            ! first get to the corresponding cusp                     
            call apply_map_int(xpb,ypb,xtmp,ytmp,Uw(ind_vertex,:,:)) ! sigma_j1=cuspnormalising map for cusp j
            call get_char(Uw(ind_vertex,2,2),char_j)
                                ! now we are at the right cusp, and we have to normalize
            call gl_inverse(sigma_j(ind_cusp,:,:),B)

            call apply_map_re(xtmp,ytmp,xtmp2,ytmp2,B) ! W1=cuspnormalising map for cusp j

            X_pb_s(icusp,ind_cusp,j)=xtmp2
            Y_pb_s(icusp,ind_cusp,j)=ytmp2
            char_vec_r_s(icusp,ind_cusp,j)=char_i*char_j
         enddo
      enddo  
      end subroutine

      subroutine get_pb_points_cplx_char(R,Y,Q,sym_in)
!     &     Q_start,Q_stop,sample_norm,sampletype,sym)
      use commonvariables
      use groups
      use characters
      implicit none
      integer :: Q
      real(kind=DP) :: Y,R
      ! 0 = cos : 1 = sin
      real(kind=DP) :: x_in,y_in,xpb,ypb,xtmp,ytmp,xtmp2,ytmp2
      integer,dimension(2,2) :: map_tmp
!      integer,optional::sampletype
      integer :: j,d
      real(kind=DP),dimension(2,2)::B
      complex(DP)::char_r,char_j,mul1,mul2,mul3
      integer,dimension(2,2)::maptmp,maptmp2,maptmp3
      real(kind=DP) :: char,tmp
      logical :: deb
!      integer,optional :: Q_start,Q_stop
      integer :: type ! even or odd =0,1
!      real(kind=DP) :: sample_norm ! normalise the sample
      integer :: icusp,jcusp,ind_vertex,ind_cusp
      real :: TIME,TIME2
      logical,optional::sym_in
      logical::sym
!            write(*,*) 'Pulling back points! 1'
      !! sym is determined by whether we use cos/sin symmetry or not
      if(.not.(PRESENT(sym_in))) then
         sym=.true.
      else
         sym=sym_in
      endif
 ! We have to decide which type of sample to use in the DFT
  !    if(.not.(present(sampletype))) then
         sampletype=1
  !    endif
      if(sampletype.eq.1) then  ! not using even-oddd symmetry
         Q_start=1-Q
         Q_stop=Q
         if(sym) then
            sample_norm=1.0_DP/real(Q,DP)
         else
            sample_norm=1.0_DP/real(2*Q,DP)
         endif
      else          
         Q_start=1
         Q_stop=Q
!         sample_norm=2.0_DP/real(Q,DP)
         sample_norm=2.0_DP/real(Q,DP)
      endif
      if(allocated(X_pb_s)) then
         deallocate(X_pb_s)
      endif
      if(allocated(Y_pb_s)) then
         deallocate(Y_pb_s)
      endif
      if(allocated(Xm_s)) then
         deallocate(Xm_s)
      endif
      if(allocated(char_vec_c_s)) then
         deallocate(char_vec_c_s)
      endif
!      write(*,*) 'Pulling back points! 2'
      allocate(X_pb_s(1:num_cusps,1:num_cusps,Q_start:Q_stop))
      allocate(Y_pb_s(1:num_cusps,1:num_cusps,Q_start:Q_stop))
      allocate(char_vec_c_s(1:num_cusps,1:num_cusps,Q_start:Q_stop))
      allocate(Xm_s(Q_start:Q_stop))
      do j=Q_start,Q_stop
         Xm_s(j) = Width*0.5_DP*(real(j,DP)-0.5_DP)/real(Q,DP)
      end do
!      write(*,*) 'Pulling back points!'
      ! computing the pulled-back points
      ! for the first series with respect to the other two
      X_pb_s(:,:,:)=0.0_DP
      Y_pb_s(:,:,:)=0.0_DP
      if(weight.eq.0.0) then
         do icusp=1,num_cusps
            do j=Q_start,Q_stop
!               if(icusp.ge.1) then
                  B(:,:)=sigma_j(icusp,:,:)
                  call apply_map_re(Xm_s(j),Y,xtmp,ytmp,B) ! normalize
!               else
!                  xtmp=Xm_s(j)
!                  ytmp=Y
!               endif
               call pullback_to_gamma0N(xtmp,ytmp,xpb,ypb,d)               
               call get_char(d,char_r)
               call seek_vertex(xpb,ypb,ind_vertex)
               call get_cusp_from_vertex(ind_vertex,ind_cusp)
                                ! first get to the corresponding cusp                     
               call apply_map_int(xpb,ypb,xtmp,ytmp,Uw(ind_vertex,:,:)) ! sigma_j1=cuspnormalising map for cusp j
               call get_char(Uw(ind_vertex,2,2),char_j)
                                ! now we are at the right cusp, and we have to normalize
               call gl_inverse(sigma_j(ind_cusp,:,:),B)

               call apply_map_re(xtmp,ytmp,xtmp2,ytmp2,B) ! W1=cuspnormalising map for cusp j
               X_pb_s(icusp,ind_cusp,j)=xtmp2
               Y_pb_s(icusp,ind_cusp,j)=ytmp2
                                ! We really want the conjugate of the character here
               if(abs(char_r*char_j).ne.0) then
                  char_vec_c_s(icusp,ind_cusp,j)=dcmplx(1.0_DP,0)/              &
     &                 (char_r*char_j)
               else
                  write(*,*) 'chi(',Uw(ind_vertex,2,2),')=',char_j
                  write(*,*) 'chi(',d,')=',char_r
                  stop
               endif
            enddo
         enddo  
      else
         do icusp=1,num_cusps
            do j=Q_start,Q_stop
               map_tmp=mapId
               B=mapId
!               if(icusp.ge.1) then
                  B(:,:)=sigma_j(icusp,:,:)
                  call apply_map_re(Xm_s(j),Y,xtmp,ytmp,B) ! normalize
!               else
!                  xtmp=Xm_s(j)
!                  ytmp=Y
!               endif
                                !!! j(sigma_j,z_m)^-k
               mul1=autom_j_r(B,Xm_s(j),Y,-1.0_DP*weight)
               call pullback_to_gamma0N_map(xtmp,ytmp,xpb,ypb,maptmp)               
               call seek_vertex(xpb,ypb,ind_vertex)
               call get_cusp_from_vertex(ind_vertex,ind_cusp)
                                ! first get to the corresponding cusp                     
               call apply_map_int(xpb,ypb,xtmp,ytmp,Uw(ind_vertex,:,:)) 
               maptmp2=MATMUL(Uw(ind_vertex,:,:),maptmp)
               call invert_sl2z(maptmp2,maptmp3)
                                ! now we are at the right cusp, and we have to normalize
               mul2=get_multiplier(maptmp3,xtmp,ytmp)
               call gl_inverse(sigma_j(ind_cusp,:,:),B)
               call apply_map_re(xtmp,ytmp,xtmp2,ytmp2,B) ! W1=cuspnormalising map for cusp j
               X_pb_s(icusp,ind_cusp,j)=xtmp2
               Y_pb_s(icusp,ind_cusp,j)=ytmp2
               B(:,:)=sigma_j(ind_cusp,:,:)
                                !!! j(sigma_I(j),z_mj^*)^k
               mul3=autom_j_r(B,xtmp2,ytmp2,weight)
               char_vec_c_s(icusp,ind_cusp,j)=mul1*mul2*mul3
               if(abs(mul1*mul2*mul3).eq.0.0) then
                  write(*,*) 'char1=',mul1                  
                  write(*,*) 'char2=',mul2,'=mult(['
                  WRITE(*,'(2I3)',ADVANCE='NO') maptmp3(1,:)
                  WRITE(*,'(A)',ADVANCE='NO') '|'
                  WRITE(*,'(2I3)',ADVANCE='NO') maptmp3(2,:)
                  WRITE(*,'(A)',ADVANCE='NO') ']'
                  write(*,*) 'char3=',mul3
                  write(*,*) 'weight=',weight
                  stop
               endif
            enddo
         enddo  
      endif
      end subroutine



      subroutine get_points(Y,Q,X_pb,Y_pb,char_vec,wi)
      !!! assume any non-default settings are done beforehand
      use commonvariables
      use groups
      use characters
      implicit none
      real(DP)::Y
      integer::Q,j
      real(DP),optional::wi
!!!      real(DP),dimension(1-QQ)::Xm
      real(DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::X_pb,Y_pb
      complex(DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::char_vec
      integer::k,l
!      write(*,*) 'get_pts:',Y,Q
!      write(*,*) 'sizes:',size(X_pb),size(Y_pb)
      if(sampletype.eq.2) then
         Q_start=1
         Q_stop=Q
         sample_norm=2.0_DP/real(Q,DP)
      else
         Q_start=1-Q
         Q_stop=Q    
         sample_norm=1.0_DP/real(2*Q,DP)
      endif
!! We have to make sure that if we change weight or multiplier then we must also 
!! compute points (or rather the char_vec) again      
      if((weight.ne.weight_set).or.(Ctype.ne.CType_set)) then
         Q_set=0
      endif
!      write(*,*) 'get_points, sample_type=',sampletype
      if(Q.eq.Q_set.and.(Q_start.eq.Q_start)) then !!!  we have already set at least Y1
         if((Y.eq.Y1_pbset).and.(allocated(X_pb_s1))) then
            X_pb=X_pb_s1
            Y_pb=Y_pb_s1
            char_vec=char_vec_s1
!            write(*,*) 'Y=Y1=',Y
!            return
         elseif((Y.eq.Y2_pbset).and.(allocated(X_pb_s2))) then
            X_pb=X_pb_s2
            Y_pb=y_pb_s2
            char_vec=char_vec_s2
!            write(*,*) 'Y=Y2=',Y
!            return
         else 
            !! Since the Y is neither Y1 nor Y2 we set a new Y2 if Y1 is already set and Y2 is not set
            !! If Y2 is also set we set Y1 instead 
            call get_1_pb_points(Y,Q,X_pb,Y_pb,char_vec,wi)            !! Set the appropriate points
            if(allocated(X_pb_s1).and.(.not.(allocated(X_pb_s2)))) then 
               !! Set a new Y2
               if(allocated(X_pb_s2)) deallocate(X_pb_s2,Y_pb_s2,           &
     &              char_vec_s2)
               allocate(X_pb_s2(1:num_cusps,1:num_cusps,Q_start:Q_stop))
               allocate(Y_pb_s2(1:num_cusps,1:num_cusps,Q_start:Q_stop))
               allocate(char_vec_s2(1:num_cusps,1:num_cusps,                   &
     &              Q_start:Q_stop))
               Y2_pbset=Y
               X_pb_s2=X_pb
               Y_pb_s2=Y_pb
               char_vec_s2=char_vec
!               write(*,*) 'Set Y2:2=',Y
            elseif(allocated(X_pb_s2)) then 
               !! Set a new Y1
               if(allocated(X_pb_s1)) deallocate(X_pb_s1,Y_pb_s1,           &
     &              char_vec_s1)
               allocate(X_pb_s1(1:num_cusps,1:num_cusps,Q_start:Q_stop))
               allocate(Y_pb_s1(1:num_cusps,1:num_cusps,Q_start:Q_stop))
               allocate(char_vec_s1(1:num_cusps,1:num_cusps,                   &
     &              Q_start:Q_stop))
               Y1_pbset=Y
               X_pb_s1=X_pb
               Y_pb_s1=Y_pb
               char_vec_s1=char_vec
!               write(*,*) 'Set Y1:2=',Y
            endif

         endif 
      else
           !!! since we are either here for the first time or with a new Q 
           !!! we must set an Y1
!         write(*,*) 'here for first time!'
!         write(*,*) 'Q=',Q
!         write(*,*) 'Q_set=',Q_set
!         write(*,*) 'before 1pb2'
         call get_1_pb_points(Y,Q,X_pb,Y_pb,char_vec,wi) !! Set the appropriate points
!            write(*,*) 'after 1pb2'
            if(allocated(X_pb_s1)) then
!            write(*,*) 'deallocating X_pb1'
!            write(*,*) 'Xalooc=',allocated(X_pb_s1)
!            write(*,*) 'Yalloc=',allocated(Y_pb_s1)
!            write(*,*) 'char_vec=',allocated(char_vec_s1)
               deallocate(X_pb_s1)
               deallocate(Y_pb_s1)
               deallocate(char_vec_s1)
!               write(*,*) 'deallocated char'
         endif
!         write(*,*) 'after 1pb3'
         allocate(X_pb_s1(1:num_cusps,1:num_cusps,Q_start:Q_stop))
         allocate(Y_pb_s1(1:num_cusps,1:num_cusps,Q_start:Q_stop))
         allocate(char_vec_s1(1:num_cusps,1:num_cusps,Q_start:Q_stop))
         X_pb_s1=X_pb
         Y_pb_s1=Y_pb
         char_vec_s1=char_vec
!         do j=lbound(char_vec,1),ubound(char_vec,1)
!            do k=lbound(char_vec,2),ubound(char_vec,2)
!               do l=lbound(char_vec,3),ubound(char_vec,3)
!                  if(abs(char_vec(j,k,l)).ne.1.0D0) then 
!                     write(*,*) 'char_vec(',j,k,l,')=',char_vec(j,k,l)
!                  endif
!               enddo
!            enddo
!         enddo
         Y1_pbset=Y
         Y2_pbset=0.0_DP  !! to force a recalculation wrt Y2
!         write(*,*) 'Set Y1=',Y
      endif      
      Q_set=Q
      weight_set=weight
      ctype_set=ctype
      Q_start=Q_start
      Q_stop=Q_stop
!      if(allocated(Y_pb_s1)) then
!         write(*,*) 'Y_pbs1(1,1,2)=',Y_pb_s1(1,1,2)
!      endif
!      if(allocated(Y_pb_s2)) then
!         write(*,*) 'Y_pbs2(1,1,2)=',Y_pb_s2(1,1,2)
!      endif
!      write(*,*) 'end: Q_set=',Q_set
!      write(*,*) 'Q_start=',Q_start
!      write(*,*) 'Q_stop=',Q_stop
      end subroutine 


      !!! make two set, one for Y1 and one for Y2
      subroutine get_pb_points_cplx_char2(R,Y1,Y2,Q,sym,wi) 
      use commonvariables
      use groups
      use characters
      implicit none
      integer :: Q
      real(kind=DP) :: Y1,Y2,R,Y
      real(DP),optional::wi
      ! 0 = cos : 1 = sin
      real(kind=DP) :: x_in,y_in,xpb,ypb,xtmp,ytmp,xtmp2,ytmp2
      integer,dimension(2,2) :: map_tmp
!      integer,optional::sampletype
      integer :: i,j,k,d
      real(kind=DP),dimension(2,2)::B
      complex(DP)::char_r,char_j,mul1,mul2,mul3
      integer,dimension(2,2)::maptmp,maptmp2,maptmp3
      real(DP),dimension(2,2)::map_tmpr
      real(kind=DP) :: char,tmp
      logical :: deb
!      integer :: Q_start,Q_stop
      integer :: type ! even or odd =0,1
!      real(kind=DP) :: sample_norm ! normalise the sample
      integer :: icusp,jcusp,ind_vertex,ind_cusp,y_no
      logical,optional::sym
      write(*,*) 'Pullling back2:',R,Y1,Y2,Q,sym,wi
      if((Y1_pbset.eq.Y1).and.(Y2_pbset.eq.Y2)) then
         !!! we have already made all necessary pullbacks
         return
      endif
      !! sym is determined by whether we use cos/sin symmetry or not
      if(.not.(PRESENT(sym))) then
         sym=.true.
      endif
 ! We have to decide which type of sample to use in the DFT
!      if(sampletype.eq.0) then
         sampletype=1
!      endif
      if(.not.(PRESENT(wi))) then 
         if(width.le.0) then
            width=1.0_DP
         endif
      else
         width=wi
      endif
      if(sampletype.eq.1) then  ! not using even-oddd symmetry
         Q_start=1-Q
         Q_stop=Q
         if(sym) then
            sample_norm=1.0_DP/real(Q,DP)
         else
            sample_norm=1.0_DP/real(2*Q,DP)
         endif
      else          
         Q_start=1
         Q_stop=Q
         sample_norm=2.0_DP/real(Q,DP)
      endif
      if(allocated(X_pb_s)) then
         deallocate(X_pb_s)
      endif
      if(allocated(Y_pb_s)) then
         deallocate(Y_pb_s)
      endif
      if(allocated(Xm_s)) then
         deallocate(Xm_s)
      endif
      if(allocated(char_vec_c_s)) then
         deallocate(char_vec_c_s)
      endif
      if(allocated(X_pb_s2)) then
         deallocate(X_pb_s2)
      endif
      if(allocated(Y_pb_s2)) then
         deallocate(Y_pb_s2)
      endif
      if(allocated(char_vec_c_s2)) then
         deallocate(char_vec_c_s2)
      endif

      allocate(X_pb_s(1:num_cusps,1:num_cusps,Q_start:Q_stop))
      allocate(Y_pb_s(1:num_cusps,1:num_cusps,Q_start:Q_stop))
      allocate(char_vec_c_s(1:num_cusps,1:num_cusps,Q_start:Q_stop))
      allocate(Xm_s(Q_start:Q_stop))
      allocate(X_pb_s2(1:num_cusps,1:num_cusps,Q_start:Q_stop))
      allocate(Y_pb_s2(1:num_cusps,1:num_cusps,Q_start:Q_stop))
!      write(*,*) 'allokerar Y_pb_s2!!'
      allocate(char_vec_c_s2(1:num_cusps,1:num_cusps,Q_start:Q_stop))
      do j=Q_start,Q_stop
         Xm_s(j) = width*0.5_DP*(real(j,DP)-0.5_DP)/real(Q,DP)
      end do
      
      ! computing the pulled-back points
      ! for the first series with respect to the other two
      do i=1,num_cusps
         do j=1,num_cusps
            do k=Q_start,Q_stop
               X_pb_s(i,j,k)=0.0_DP
               Y_pb_s(i,j,k)=0.0_DP
               X_pb_s2(i,j,k)=0.0_DP
               Y_pb_s2(i,j,k)=0.0_DP
            enddo
         enddo
      enddo
      DO Y_NO=1,2
         if(y_no.eq.1) then
            Y=Y1
         else
            Y=Y2
         endif
      if(weight.eq.0.0) then
         do icusp=1,num_cusps
            do j=Q_start,Q_stop
               B(:,:)=sigma_j(icusp,:,:)
               call apply_map_re(Xm_s(j),Y,xtmp,ytmp,B) ! normalize
               if((cusp_width(1).ne.1.0_DP).and.(num_cusps.eq.1).and.                  &
     &              (.not.(from_perm))) then
                  call pullback_to_Heckeq(xtmp,ytmp,xpb,ypb,map_tmpr)               
               elseif(do_cont_char) then
                  call pullback_to_gamma0N_map(xtmp,ytmp,xpb,ypb,        &
     &                 map_tmp)               
                  call get_char_cont(map_tmp,char_r)
               else
                  call pullback_to_gamma0N(xtmp,ytmp,xpb,ypb,d)               
                  call get_char(d,char_r)
               endif  
!               call pullback_to_gamma0N(xtmp,ytmp,xpb,ypb,d)               
!               call get_char(d,char_r)
               call seek_vertex(xpb,ypb,ind_vertex)
               call get_cusp_from_vertex(ind_vertex,ind_cusp)
                                ! first get to the corresponding cusp                     
               call apply_map_int(xpb,ypb,xtmp,ytmp,Uw(ind_vertex,:,:)) ! sigma_j^-1=cuspnormalising map for cusp j
               if(do_cont_char) then
                  call get_char_cont(Uw(ind_vertex,:,:),char_j)
               else
                  call get_char(Uw(ind_vertex,2,2),char_j)
               endif
!!               call get_char(Uw(ind_vertex,2,2),char_j)
                                ! now we are at the right cusp, and we have to normalize
               call gl_inverse(sigma_j(ind_cusp,:,:),B)
               call apply_map_re(xtmp,ytmp,xtmp2,ytmp2,B) ! W1=cuspnormalising map for cusp j
               if(Y_no.eq.1) then
                  X_pb_s(icusp,ind_cusp,j)=xtmp2/width
                  Y_pb_s(icusp,ind_cusp,j)=ytmp2/width
               else
                  X_pb_s2(icusp,ind_cusp,j)=xtmp2/width
                  Y_pb_s2(icusp,ind_cusp,j)=ytmp2/width
               endif
                                ! We really want the conjugate of the character here
               if(abs(char_r*char_j).ne.0) then
                  if(Y_no.eq.1) then
                     char_vec_c_s(icusp,ind_cusp,j)=dcmplx(1.0_DP,0)/              &
     &                    (char_r*char_j)
                  else
                     char_vec_c_s2(icusp,ind_cusp,j)=dcmplx(1.0_DP,0)/              &
     &                    (char_r*char_j)
                  endif
               else
                  write(*,*) 'chi(',Uw(ind_vertex,2,2),')=',char_j
                  write(*,*) 'chi(',d,')=',char_r
                  stop
               endif
            enddo
         enddo  
      else
         do icusp=1,num_cusps
            do j=Q_start,Q_stop
               map_tmp=mapId
               B=mapId
!               if(icusp.ge.1) then
               B(:,:)=sigma_j(icusp,:,:)
                  call apply_map_re(Xm_s(j),Y1,xtmp,ytmp,B) ! normalize
!               else
!                  xtmp=Xm_s(j)
!                  ytmp=Y1
!               endif
                                !!! j(sigma_j,z_m)^-k
               mul1=autom_j_r(B,Xm_s(j),Y,-1.0_DP*weight)
               call pullback_to_gamma0N_map(xtmp,ytmp,xpb,ypb,maptmp)               
               call seek_vertex(xpb,ypb,ind_vertex)
               call get_cusp_from_vertex(ind_vertex,ind_cusp)
                                ! first get to the corresponding cusp                     
               call apply_map_int(xpb,ypb,xtmp,ytmp,Uw(ind_vertex,:,:)) 
               maptmp2=MATMUL(Uw(ind_vertex,:,:),maptmp)
               call invert_sl2z(maptmp2,maptmp3)
                                ! now we are at the right cusp, and we have to normalize
               mul2=get_multiplier(maptmp3,xtmp,ytmp)
               call gl_inverse(sigma_j(ind_cusp,:,:),B)                
               call apply_map_re(xtmp,ytmp,xtmp2,ytmp2,B) ! W1=cuspnormalising map for cusp j
               if(Y_no.eq.1) then
                  X_pb_s(icusp,ind_cusp,j)=xtmp2/width
                  Y_pb_s(icusp,ind_cusp,j)=ytmp2/width
               else
                  X_pb_s2(icusp,ind_cusp,j)=xtmp2/width
                  Y_pb_s2(icusp,ind_cusp,j)=ytmp2/width
               endif
!               call B=sigma_j(ind_cusp,:,:)
                                !!! j(sigma_I(j),z_mj^*)^               mul3=autom_j_r(B,xtmp2,ytmp2,weight)
               if(Y_no.eq.1) then
                  char_vec_c_s(icusp,ind_cusp,j)=mul1*mul2*mul3
               else
                  char_vec_c_s2(icusp,ind_cusp,j)=mul1*mul2*mul3
               endif
               if(abs(mul1*mul2*mul3).eq.0.0) then
                  call show_characters(CType)
                  write(*,*) 'Cmod=',cmod
                  write(*,*) 'char1=',mul1
                  write(*,*) 'char2=',mul2
                  write(*,*) 'char3=',mul3
               endif
            enddo
         enddo  
      endif
      enddo
      end subroutine 

   !!! make two set, one for Y1 and one for Y2
      subroutine get_1_pb_points(Y,Q,X_pb,Y_pb,char_vec, wi,st)
      use commonvariables
      use groups
      use characters
      implicit none
      integer :: Q
      real(kind=DP) :: Y
      real(DP),optional::wi
      integer,optional::st
      ! 0 = cos : 1 = sin
      real(kind=DP) :: x_in,y_in,xpb,ypb,xtmp1,ytmp1,xtmp2,ytmp2,xtmp3,    &
     &     ytmp3
      integer,dimension(2,2) :: map_tmp
!      integer,optional::sampletype
      integer ::i,j,k,d,n
      real(kind=DP),dimension(2,2)::B1,B2
      complex(DP)::char_r,char_j,mul1,mul2,mul3,autom1,autom2,autom3
      real(DP),dimension(2,2)::map_tmpr,maptmp2r,maptmp3r
      integer,dimension(2,2)::maptmp
      real(kind=DP) :: char,tmp
      logical :: deb
!      integer :: Q_start,Q_stop
      integer :: type ! even or odd =0,1
!      real(kind=DP) :: sample_norm ! normalise the sample
      integer :: icusp,jcusp,ind_vertex,ind_cusp,y_no
      real :: TIME,TIME2,arg
!      logical,optional::sym
      real(DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::X_pb,Y_pb
      complex(DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::char_vec 
      if(.not.(PRESENT(wi))) then 
         if(width.le.0) then
            width=1.0_DP
         endif
      else
         width=wi
      endif
!      write(*,*) 'In get_1_pb_points! Y,Q,w=',Y,Q,width
      if(present(st)) then
         call set_sampledata(Q,st)
      else
         call set_sampledata(Q,1)
      endif
!      write(*,*) 'CType,cmod=',cType,cmod
!      call show_characters(CType)
!      write(*,*) 'w(undef)=',w
!      if(sampletype.eq.1) then  ! not using even-oddd symmetry
      Q_start=Q_start
      Q_stop=Q_stop
!      write(*,*) 'set Q_start=',Q_start
!      write(*,*) 'set Q_stop=',Q_stop

!      if(PRESENT(sym)) then
!         if(sym) then
!            sample_norm=1.0_DP/real(Q,DP)
!         else
!            sample_norm=1.0_DP/real(2*Q,DP)
!         endif
!      else
      
!      sample_norm=1.0_DP/real(2*Q,DP)
!      if(allocated(Xm).and.(size(Xm,1).ne.(Q_stop-Q_start+1)))              &
!     &     deallocate(Xm)
      if(allocated(Xm)) then
        ! if(size(Xm,1).ne.(Q_stop-Q_start+1)) deallocate(Xm)
         deallocate(Xm)
      endif
      sample_norm=1.0_DP/real(Q_stop-Q_start+1,DP)
      if((Q_stop-Q_start+1.ne.Q).and.                                       &
     &     (Q_stop-Q_start+1.ne.2*Q)) then 
         write(*,*) 'Q_start=',Q_start 
         write(*,*) 'Q_stop=',Q_stop
         stop
      endif
      if(.not.(allocated(Xm))) then 
         allocate(Xm(Q_start:Q_stop))
         do j=Q_start,Q_stop
            Xm(j) = width*0.5_DP*(real(j,DP)-0.5_DP)/real(Q,DP)
!            write(*,*) 'Xm(j)=',Xm(j)
         end do
      endif
      X_pb(:,:,:)=0.0_DP
      Y_pb(:,:,:)=0.0_DP
!      open(UNIT=10,FILE='orig_1.txt')    
!      open(UNIT=11,FILE='pb1_1.txt')
!      open(UNIT=12,FILE='pb2_1.txt')
!      open(UNIT=13,FILE='pb3_1.txt')
!      open(UNIT=13,FILE='char2.txt')
!      write(*,*) 'Y=',Y
      do icusp=1,num_cusps
         do j=Q_start,Q_stop
!            write(*,*) 'j1=',j,' Q_stop=',Q_stop
!            map_tmp=Id
            B1(:,:)=real(mapId(:,:),DP)
            B2(:,:)=real(mapId(:,:),DP)
            B1=sigma_j(icusp,:,:) ! normalize
            call apply_map_re(Xm(j),Y,xtmp1,ytmp1,B1) ! normalize
            if((cusp_width(1).ne.1.0_DP).and.(num_cusps.eq.1).and.                  &
     &           (.not.(from_perm))) then            
               call pullback_to_Heckeq(xtmp1,ytmp1,xpb,ypb,map_tmpr)               
!!!               maptmp=map_tmpr
            elseif(from_perm) then
               write(*,*) 'Do not use permutation groups here!'
               stop
!               call pullback_using_perm_map(xtmp1,ytmp1,xpb,ypb,          &
!     &              map_tmp)
 !              write(12,*) xpb,ypb
               map_tmpr(:,:)=real(map_tmp(:,:),kind=DP)               
            else
               call pullback_to_gamma0N_map(xtmp1,ytmp1,xpb,ypb,map_tmp)               
               map_tmpr(:,:)=real(map_tmp(:,:),kind=DP)
            endif  
!            write(13,*) xpb,ypb 
            call seek_vertex(xpb,ypb,ind_vertex)
            call get_cusp_from_vertex(ind_vertex,ind_cusp)
           ! first get to the corresponding cusp                     
            call apply_map_int(xpb,ypb,xtmp2,ytmp2,Uw(ind_vertex,:,:)) 
            maptmp2r=MATMUL(real(Uw(ind_vertex,:,:),DP),map_tmpr)
            call invert_map_r(maptmp2r,maptmp3r)  !! maptmp3r=(U_w*T_j)^-1
!            write(*,*) '3r=',maptmp3r
            if((abs(maptmp3r(2,2))+abs(maptmp3r(2,1))).eq.0) then
               write(*,*) '0!'
               write(*,*) 'r=',map_tmpr
               write(*,*) '3r=',maptmp3r
!               stop
            endif 
            ! now we are at the right cusp, and we have to normalize
            call gl_inverse(sigma_j(ind_cusp,:,:),B2)
            call apply_map_re(xtmp2,ytmp2,xtmp3,ytmp3,B2) ! W1=cuspnormalising map for cusp j
            if(width.ne.1.0D0) then 
               X_pb(icusp,ind_cusp,j)=xtmp3/width
               Y_pb(icusp,ind_cusp,j)=ytmp3/width
            else
               X_pb(icusp,ind_cusp,j)=xtmp3
               Y_pb(icusp,ind_cusp,j)=ytmp3
            endif
!            write(*,*) Xm(j),Y,'--->',xtmp3,ytmp3
!            if(icusp.eq.1) then 
!            write(13,*) xtmp3/width,ytmp3/width
!            B2(:,:)=sigma_j(ind_cusp,:,:) 
            !!! j(sigma_I(j),z_mj^*)^k
!            write(*,*) 'before'
            if( (weight.ne.0.0D0).or.(CType.ne.0)) then 
               mul1=get_multiplier(maptmp3r,xtmp2,ytmp2) !!! j((UwTj)^-1,sigma_j(z_m))^k*v((UwTj)^-1)
            else
               mul1=1.0_DP
!               write(*,*) 'weight=',weight
!               write(*,*) 'Ctype=',ctype
            endif
!            write(*,*) 'after'
            if(weight.ne.0) then
               autom1=autom_j_r(sigma_j(icusp,:,:),Xm(j),Y,-weight) !!! j(sigma_j,z_m)^-k 
              autom2=autom_j_r(sigma_j(ind_cusp,:,:),xtmp3,ytmp3,weight) !!! j(sigma_I(w),z*_m)^k
               autom3=autom_j_r(maptmp3r,xtmp2,ytmp2,weight)
            endif
!            autom2=autom_j_r(B2,xtmp3,ytmp3,weight)!!! j(sigma_I(w),z*_m)^k
!            write(*,*) 'x,y==',xtmp2,ytmp2
!            write(*,*) map_tmpr,mul1            
!            stop
            
            if(holomorphic) then 
!               autom3=maptmp3r=MATMUL(maptmp2r,B1)
!               maptmp2r=MATMUL(B2,maptmp3r)
!               arg=argument(maptmp2r(2,1)*Xm(j)+maptmp2r(2,2),                    &
!     &              maptmp2r(2,1)*Y)
               arg=argument(autom1*autom2*autom3)
!               n=floor(arg/PI2)
!               arg=arg-real(n,DP)*PI2
               !write(13,*) autom1
               !write(13,*) autom2
               !write(13,*) autom3
               !write(13,*) 'x,y=',xm(j),Y
               !write(13,*) 'xpb,ypb=',xtmp3,ytmp3
!               write(*,*) j,':',arg
               char_vec(icusp,ind_cusp,j)=dcmplx(0.0D0,arg)
!                char_vec(icusp,ind_cusp,j)=autom1*autom2*autom3
            elseif(weight.ne.0.0) then 
               char_vec(icusp,ind_cusp,j)=autom1*mul1*autom2   
            elseif(CType.ne.0) then 
               char_vec(icusp,ind_cusp,j)=mul1   
               autom1=1.0D0
               autom2=1.0D0
            else
               char_vec(icusp,ind_cusp,j)=1.0D0
               autom1=1.0D0
               autom2=1.0D0
            endif
!            write(13,*) autom1,mul1,autom2 
!           write(*,*) maptmp3r(2,2),mul1
!            write(*,*) 'ypb(',j,')=',ytmp3
!            write(*,*) 'xpb(',j,')=',xtmp3
!            if(abs(char_vec(icusp,ind_cusp,j)).ne.1.0D0) then
!               write(*,*) 'char(',j,')=',autom1,'*',mul1,'*',autom2,'=',            &
!     &              char_vec(icusp,ind_cusp,j)
!            endif            
!            WRITE(*,*) 'XTMP2,YTMP2=',xtmp2,ytmp2 
!          write(*,*) 'map=[[',maptmp3r(1,1:2),'],[',maptmp3r(2,1:2),']]'
!char_vec(icusp,ind_cusp,j) 
!            write(*,*) 'j=',j
          if(abs(mul1*autom1*autom2).eq.0.0) then
             call show_characters(CType)
             write(*,*) 'Cmod=',cmod
             write(*,*) 'CType=',CType
             write(*,*) 'mul1=',mul1,':',maptmp3r(2,2),xtmp2,ytmp2
               write(*,*) 'autom1=',autom1
               write(*,*) 'autom2=',autom2
               STOP
            endif
!            write(*,*) 'Char_vec(',icusp,ind_cusp,j,')=',               &
!     &           char_vec(icusp,ind_cusp,j)
         enddo  
         continue
      enddo
!      write(*,*) 'Y0_pb(1,1,2)=',Y_pb(1,1,2)
!c$$$      do j=lbound(char_vec,3),ubound(char_vec,3)
!c$$$         if((abs(char_vec(1,1,j)).ne.1.0D0) then 
!c$$$            write(*,*) 'char_vec(11',j,')=',char_vec(1,1,j)
!c$$$         endif
!c$$$      enddo

!      close(12)
!      close(13)
!      write(*,*) 'end pb pts'
      end subroutine
!      close(10)
!      close(11)
!      close(12)

!      close(14)
!      stop

!!! Pullback without characters
!!! 19.06.08

      subroutine set_sampledata(Q,j)
      implicit none
      integer::j,Q
      sampletype=1
      if(j.eq.2) then 
         sampletype=j
      endif
      if(sampletype.eq.2) then
         Q_start=1
         Q_stop=Q
         sample_norm=2.0_DP/real(Q,DP)
      else
         Q_start=1-Q
         Q_stop=Q    
         sample_norm=1.0_DP/real(2*Q,DP)
      endif
!      write(*,*) 'Q_start,WQ_stop=',Q_start,Q_stop
      end subroutine set_sampledata

      subroutine get_points_r(Y,Q,X_pb,Y_pb)
      !!! assume any non-default settings are done beforehand
      use commonvariables
      use groups
      use characters
      implicit none
      real(DP)::Y
      integer::Q,j
      real(DP),dimension(1:num_cusps,1:num_cusps,Q_start:Q_stop)::          &
     &     X_pb,Y_pb
!      complex(DP),dimension(1:num_cusps,1:num_cusps,Q_start:Q_stop)::char_vec
      if(Q_stop-Q_start.le.0) call set_sampledata(Q,1)
!! weight and character should be zero
      if((weight.ne.0.0).or.(Ctype.ne.0)) then
!                                       &
         MSG='Use without weight and character only!';call errmsg(1,6)
      endif
      if(Q.eq.Q_set.and.(Q_start.eq.Q_start)) then !!!  we have already set at least Y1
         if(Y.eq.Y1_pbset) then
            X_pb=X_pb_s1
            Y_pb=Y_pb_s1
!            write(*,*) 'Use same Y1=',Y
         elseif(Y.eq.Y2_pbset) then
            X_pb=X_pb_s2
            Y_pb=y_pb_s2
!            write(*,*) 'Use same Y2=',Y
         else !!! since we have already at least Y1 we must be at an unset Y2
!            write(*,*) 'We have an Y1,Y2=',Y1_pbset,Y2_pbset,' but Y=',Y
            call get_1_pb_point_r(Y,Q,X_pb,Y_pb) !! Set the appropriate points
            if(allocated(X_pb_s2)) then 
               deallocate(X_pb_s2);deallocate(Y_pb_s2)
            endif
            allocate(X_pb_s2(1:num_cusps,1:num_cusps,Q_start:Q_stop))
            allocate(Y_pb_s2(1:num_cusps,1:num_cusps,Q_start:Q_stop))
            X_pb_s2=X_pb
            Y_pb_s2=Y_pb
            Y2_pbset=Y
!            write(*,*) 'Set Y2=',Y
         endif 
      else
           !!! since we are either here for the first time or with a new Q 
           !!! we must set an Y1
         call get_1_pb_point_r(Y,Q,X_pb,Y_pb) !! Set the appropriate points
         if(allocated(X_pb_s1)) then 
            deallocate(X_pb_s1);deallocate(Y_pb_s1)
         endif
         allocate(X_pb_s1(1:num_cusps,1:num_cusps,Q_start:Q_stop))
         allocate(Y_pb_s1(1:num_cusps,1:num_cusps,Q_start:Q_stop))
         X_pb_s1=X_pb
         Y_pb_s1=Y_pb
         Y1_pbset=Y
         Y2_pbset=0.0_DP  !! to force a recalculation wrt Y2
!         write(*,*) 'Set Y1=',Y
      endif      
      Q_set=Q
      weight_set=weight
      ctype_set=ctype
      Q_start=Q_start
      Q_stop=Q_stop
!      write(*,*) 'end: Q_set=',Q_set
!      write(*,*) 'Q_start=',Q_start
!      write(*,*) 'Q_stop=',Q_stop
      end subroutine get_points_r


  !!! make two set, one for Y1 and one for Y2
      subroutine get_1_pb_point_r(Y,Q,X_pb,Y_pb)
      use commonvariables
      use groups
      use characters
      implicit none
      integer :: Q
      real(kind=DP) :: Y
      real(kind=DP) :: x_in,y_in,xpb,ypb,xtmp1,ytmp1,xtmp2,ytmp2,xtmp3,    &
     &     ytmp3
      integer ::i,j,k,d,n
      complex(DP)::char_r,char_j,mul1,mul2,mul3,autom1,autom2,autom3
      real(DP),dimension(2,2)::map_tmpr,maptmp2r,maptmp3r,B1,B2
      integer,dimension(2,2)::maptmp
      logical :: deb
      integer :: icusp,jcusp,ind_vertex,ind_cusp,y_no,map_tmpi(2,2)
      real :: TIME,TIME2,arg,tmp
      real(DP),dimension(1:num_cusps,1:num_cusps,Q_start:Q_stop)::         &
     &     X_pb,Y_pb
!      write(*,*) 'In get_1_pb_points_r! Y,Q,w=',Y,Q,width
      Q_start=Q_start
      Q_stop=Q_stop
!      if(PRESENT(sym)) then
!         if(sym) then
!            sample_norm=1.0_DP/real(Q,DP)
!         else
!            sample_norm=1.0_DP/real(2*Q,DP)
!         endif
!      else
!      sample_norm=1.0_DP/real(2*Q,DP)
      sample_norm=1.0_DP/real(Q_stop-Q_start+1,DP)
      if((Q_stop-Q_start+1.ne.Q).and.                                          &
     &     (Q_stop-Q_start+1.ne.2*Q)) then 
         write(*,*) 'Q_start,Q_stop=',Q_start,Q_stop 
         stop
      endif
      if((.not.(allocated(Xm))).or.(size(Xm,1).ne.(2*Q))) then
         if(allocated(Xm)) deallocate(Xm)
!         write(*,*) 'allocates Xm...'
         allocate(Xm(1-Q:Q))
         do j=Q_start,Q_stop
            Xm(j) = width*0.5_DP*(real(j,DP)-0.5_DP)/real(Q,DP)
!            write(*,*) 'Xm(j)=',Xm(j)
         end do
      endif
      X_pb(:,:,:)=0.0_DP
      Y_pb(:,:,:)=0.0_DP
      do icusp=1,num_cusps
         do j=Q_start,Q_stop
!            map_tmp=Id
            B1(:,:)=real(mapId(:,:),DP)
            B2(:,:)=real(mapId(:,:),DP)
            B1=sigma_j(icusp,:,:) ! normalize
            call apply_map_re(Xm(j),Y,xtmp1,ytmp1,B1) ! normalize
            call pullback_map(xtmp1,ytmp1,xpb,ypb,map_tmpi,map_tmpr)
            call seek_vertex(xpb,ypb,ind_vertex)
            call get_cusp_from_vertex(ind_vertex,ind_cusp)
           ! first get to the corresponding cusp                     
            call apply_map_int(xpb,ypb,xtmp2,ytmp2,Uw(ind_vertex,:,:)) 
            maptmp2r=MATMUL(real(Uw(ind_vertex,:,:),DP),map_tmpr)
            call invert_map_r(maptmp2r,maptmp3r)  !! maptmp3r=(U_w*T_j)^-1
            if((abs(maptmp3r(2,2))+abs(maptmp3r(2,1))).eq.0) then
               write(*,*) '0!'
               write(*,*) 'r=',map_tmpr
               write(*,*) '3r=',maptmp3r
               stop
            endif 
            ! now we are at the right cusp, and we have to normalize
            call gl_inverse(sigma_j(ind_cusp,:,:),B2)
            call apply_map_re(xtmp2,ytmp2,xtmp3,ytmp3,B2) ! W1=cuspnormalising map for cusp j
            X_pb(icusp,ind_cusp,j)=xtmp3/width
            Y_pb(icusp,ind_cusp,j)=ytmp3/width
         enddo  
      enddo
      end subroutine get_1_pb_point_r


      subroutine clean_pullback()
      use characters
      if(allocated(X_pb_s)) deallocate(X_pb_s)
      if(allocated(Y_pb_s)) deallocate(Y_pb_s)
      if(allocated(X_pb_s1)) deallocate(X_pb_s1)
      if(allocated(Y_pb_s1)) deallocate(Y_pb_s1)
      if(allocated(X_pb_s2)) deallocate(X_pb_s2)
      if(allocated(Y_pb_s2)) deallocate(Y_pb_s2)
      if(allocated(Xm)) deallocate(Xm)
      if(allocated(Xm_s)) deallocate(Xm_s)
      if(allocated(Xm_s2)) deallocate(Xm_s2)
      if(allocated(char_vec_r_s)) deallocate(char_vec_r_s)
      if(allocated(char_vec_r_s2)) deallocate(char_vec_r_s2)
      if(allocated(char_vec_c_s)) deallocate(char_vec_c_s)
      if(allocated(char_vec_c_s2)) deallocate(char_vec_c_s2)
      if(allocated(char_vec_s1)) deallocate(char_vec_s1)
      if(allocated(char_vec_s2)) deallocate(char_vec_s2)
      call clean_characters()
      end subroutine

      end module




