!!! MODULE: system
!!! Description:  includes all functions to compute and set up the linear system
!!!                of V_nl~


      module system
      use commonvariables
      use groups
      use pullback
      use interpolation
      contains

      !! Computes either W(k,R,x) or K_iR(X) or K_R(x)
      function Wf(R,X,k)     
      use whittakerw,only:WhittW
      use kbessel,only:bessk_real,RKBessel
      implicit none
      real(DP)::R,X,Wf
      real(DP),optional::k
!      write(*,*) 'R,X=',R,X
      if(weight.eq.0.0_DP) then
         if(do_exceptional) then
            Wf=bessk_real(R,X)
!            write(*,*) 'K_r(',r,',',x,')=',Wf
         else
            Wf=RKBEssel(R,X)
!            write(*,*) 'RKBES(',r,',',x,')=',Wf
         endif
      elseif(PRESENT(k)) then
         if(holomorphic) then
            Wf=((X*width/PI2)**(0.5_DP*(weight-1.0_DP)))*exp(-X)
         else
            Wf=WhittW(k,R,X)
         endif
      else
         write(*,*) 'ERROR: In Wf: no weight present!'
         stop
      endif
      if(isnan(Wf)) then 
         write(*,*) 'W(',R,X,k,')=',Wf
         stop
      endif
      end function 


      !! This computes the matrix we want to solve for       
      !! e.g. not V_nl really, but U_nl (1<=n<=M0-1, 1<=l<=M0)
      !! ONLY CALL THIS FOR one or two cusps
      !! (e.g. prime index N)
      !! Optimized!!!
      subroutine computeMat_real(R,Y,Q,M0,V,is_tilda,interp)
      use commonvariables
      use groups
      use characters
      use interpolation
      use pullback
      implicit none
      logical,optional::is_tilda,interp
!      integer,optional::s_cs,s_inv
      real(DP)::R,Y,epsilon
      integer::N,m,j,k,l,M0,Q
      integer::icusp,jcusp,type
      real(DP),dimension(:),allocatable::C
      real(DP),dimension(:,:,:),allocatable::Vnl
      !! remember that we have two symmetries to look at
      !!
      real(DP),dimension(1:M0-1,1:M0,0:1,0:1)::V
      real(DP),dimension(:,:),allocatable::Vnlije,Vnlijo
      real(DP)::n_r,l_r
      real(DP)::ypb,xpb,tmp,rkbes,argpb,arg_m,tmpVe,tmpVo
      real(DP)::TT,temp,Kbes
!      real(DP)::sample_norm
!      integer::Q_start,Q_stop,sampletype
!      integer::type_start,type_stop,inv_start,inv_stop
      integer::num_evals
!      write(*,*) 'Interp1=',interp
      if(.not.(PRESENT(is_tilda))) then
         is_tilda=.true.
      endif
      if(.not.(PRESENT(interp))) then
         if(do_interp) then
            interp=.true.
         else
            interp=.false.
         endif
      endif
!      write(*,*) 'Q=',Q
      if(num_cusps.gt.2) then
         write(*,*) 'Only call this Vnl for two cusps!!'
         stop
      endif
      call get_pb_points(R,Y,Q) 
      sample_norm=1.0_DP/real(2*Q,DP)
!      write(*,*) 'num_cusps=',num_cusps
!      write(*,*) 'Q_stop=',sample_stop
      if(do_interp.and.(interp)) then
         write(*,*) 'interpolating!'
         call setup_interp_kbes(R)
      endif
      !! Set up the system
      !!!  The first equation is dropped !!!
      V(:,:,:,:)=0.0_DP
     !! fIRST L=1
!      Vnlije(:,:) = 0.0_DP
!      Vnlijo(:,:) = 0.0_DP
      l_r=pi2                   !real(l,DP)*PI2
                                ! It is enough to do the case icusp=0 since we will drop
                                ! half of the equations any way

!      write(*,*) 'Q_stop=',sample_stop

      do j=Q_start,Q_stop  
         do icusp=1,num_cusps
            do jcusp=1,num_cusps
               ypb=Y_pb_s(icusp,jcusp,j)
!               write(*,*) 'ypb(',icusp,jcusp,j,')=',ypb
               if(ypb.gt.0.0_DP) then ! the point is near the j:th-cusp)
                  xpb=X_pb_s(icusp,jcusp,j)/width
                  if((do_interp.and.interp).and.(.not.(do_exceptional)))  & 
     &                 then
                     rkbes = interp_kbes(l_r*ypb/width)
                  else
                     rkbes = Wf(R,l_r*ypb/width)
                  endif
                  tmp=rkbes*sqrt(ypb)
                  argpb=l_r*xpb ! l_r including 2*PI
                  do n=2,M0
                     n_r=real(n,DP)*PI2
                     arg_m=n_r*Xm_s(j)/width ! n_r including 2*PI
                     tmpVe=tmp*dcos(argpb)*dcos(arg_m)*                  &
     &                    char_vec_r_s(icusp,jcusp,j)  
                     tmpVo=tmp*dsin(argpb)*dsin(arg_m)*                   &
     &                    char_vec_r_s(icusp,jcusp,j)  
                     V(n-1,M0,0,0)=V(n-1,M0,0,0)-tmpVe                        
                     V(n-1,M0,1,0)=V(n-1,M0,1,0)-tmpVo                        
                     if(jcusp.eq.1) then
                        V(n-1,M0,0,1)=V(n-1,M0,0,1)-tmpVe                        
                        V(n-1,M0,1,1)=V(n-1,M0,1,1)-tmpVo                        
                     else
                        V(n-1,M0,0,1)=V(n-1,M0,0,1)+tmpVe
                        V(n-1,M0,1,1)=V(n-1,M0,1,1)+tmpVo                        
                     endif
                  enddo
               endif
            enddo
         enddo
      enddo
      do l=2,M0                  
            ! MAke the V_nl^ij
!        Vnlije(:,:) = 0.0_DP
!        Vnlijo(:,:) = 0.0_DP
         l_r=real(l,DP)*PI2
         do j=Q_start,Q_stop
            do icusp=1,num_cusps
               do jcusp=1,num_cusps  
                  ypb=Y_pb_s(icusp,jcusp,j)
                  if(ypb.gt.0.0_DP) then ! the point is near the j:th-cusp)
                     xpb=X_pb_s(icusp,jcusp,j)/width
                     if((do_interp.and.interp).and.(.not.                 &
     &                    (do_exceptional))) then
                        rkbes = interp_kbes(l_r*ypb/width)
                     else
                        rkbes = Wf(R,l_r*ypb/width)
                     endif
                     tmp=rkbes*sqrt(ypb)
                     argpb=l_r*xpb ! l_r including 2*PI
                     do n=2,M0
                        n_r=real(n,DP)*PI2
                        arg_m=n_r*Xm_s(j)/width ! n_r including 2*PI
                        tmpVe=tmp*dcos(argpb)*dcos(arg_m)*                &
     &                       char_vec_r_s(icusp,jcusp,j)  
                        tmpVo=tmp*dsin(argpb)*dsin(arg_m)*                &
     &                       char_vec_r_s(icusp,jcusp,j)  
                        V(n-1,l-1,0,0)=V(n-1,l-1,0,0)+tmpVe                        
                        V(n-1,l-1,1,0)=V(n-1,l-1,1,0)+tmpVo                        
                        if(jcusp.eq.1) then
                           V(n-1,l-1,0,1)=V(n-1,l-1,0,1)+tmpVe                        
                           V(n-1,l-1,1,1)=V(n-1,l-1,1,1)+tmpVo                        
                        else
                           V(n-1,l-1,0,1)=V(n-1,l-1,0,1)-tmpVe
                           V(n-1,l-1,1,1)=V(n-1,l-1,1,1)-tmpVo                        
                        endif
                     enddo
                  endif
               enddo
            enddo
         enddo
      enddo
      V(:,:,:,:)=V(:,:,:,:)*sample_norm
      do n=2,M0         
         if((do_interp.and.interp).and.(.not.                                &
     &        (do_exceptional))) then
            rkbes=sqrt(Y)*interp_kbes(PI2*real(n,DP)*Y/width)
         else
            rkbes=sqrt(Y)*Wf(R,PI2*real(n,DP)*Y/width)
         endif
         V(n-1,n-1,:,:)=V(n-1,n-1,:,:)-rkbes
      enddo                     ! end n         
      do n=2,M0         
!         write(*,*) 'V(',n-1,',',M0,')=',V(n-1,M0,:,:)
      enddo                     ! end n         

      end subroutine



   !! This computes the matrix we want to solve for       
      !! e.g. not V_nl really, but U_nl (1<=n<=M0-1, 1<=l<=M0)
      !! call only for completely symmetrizable Level N!
      !!
      !!
      subroutine computeVnl_all_real(R,Y,Q,M0,V,interp,type_in)
      use commonvariables
      use groups
      use characters
      use interpolation
      use pullback
      implicit none
      logical,optional::interp
!      integer,optional::s_cs,s_inv
      real(DP)::R,Y,epsilon
      integer::N,m,j,k,l,M0,Q
      integer,optional::type_in
      integer::icusp,jcusp,type
      !! remember that we have two symmetries to look at
!      real(DP),dimension(1:M0*num_cusps,1:M0*num_cusps,0:1)::V
      real(DP),dimension(:,:,:),allocatable::V
      real(DP)::n_r,l_r
      real(DP)::ypb,xpb,tmp,rkbes,argpb,arg_m,tmpV(0:1)
      real(DP)::TT,temp,Kbes,Yw,char,arg_new,arg_old,rkbes_old
      integer::n_tmp,l_tmp,jj
      
      if(.not.(PRESENT(interp))) then
         if(do_interp) then
            interp=.true.
         else
            interp=.false.
         endif
      endif
      if(present(type_in)) then 
         type=type_in
      else
         type=-1
      endif
      if(allocated(V)) deallocate(V)
      if(type.ne.-1) then 
         allocate(V(1:M0*num_cusps,1:M0*num_cusps,type:type))
      else
         allocate(V(1:M0*num_cusps,1:M0*num_cusps,0:1))
      endif
!      write(*,*) 'In Vnl R,Y,Q,M0,width=',R,Y,Q,M0,width
!      write(*,*) 'low_prec=',low_prec
!      if((.not.(is_square_free(Level))).or.(.not.(cycloidal))) then
      if(size(sigma_j,1).ne.count(sigma_j_in_normalizer(:)==1)) then
         write(*,*) 'Only call this Vnl for symmetrizable groups!'         
         stop
      endif

      !!! want to call this for groups which we can symmetrize at all cusps
      sampletype=2
      
      call get_pb_points(R,Y,Q)
      if((interp).and.(do_interp)) then
         call setup_interp_kbes(R)
      endif
      !! Set up the system
      V(:,:,:)=0.0_DP
      arg_old=-1.0_DP
      do l=1,M0                  
         l_r=real(l,DP)*PI2
         do j=Q_start,Q_stop
            do icusp=1,num_cusps
               do jcusp=1,num_cusps  
                  l_tmp=l+(jcusp-1)*M0
                  ypb=Y_pb_s(icusp,jcusp,j)/width
                  if(ypb.gt.0.0_DP) then ! the point is near the j:th-cusp)
                     if(Ctype.eq.1) then !! Use real character
                        char=char_vec_r_s(icusp,jcusp,j)
                     else
                        char=1.0_DP
                     endif
                     xpb=X_pb_s(icusp,jcusp,j)/width
                     if((do_interp.and.interp).and.(.not.                 &
     &                    (do_exceptional))) then
                        rkbes = interp_kbes(l_r*ypb)
                     else
                        arg_new=l_r*ypb
                        if(abs(arg_new-arg_old).le.kbes_prec) then 
                           rkbes=rkbes_old
                        else
                           rkbes = Wf(R,l_r*ypb)
                        endif
                        rkbes_old=rkbes
                        arg_old=arg_new
                     endif
                    
                     tmp=rkbes*sqrt(ypb)
                     argpb=l_r*xpb ! l_r including 2*PI
                     do n=1,M0
                        n_tmp=n+(icusp-1)*M0
                        n_r=real(n,DP)*PI2
                        arg_m=n_r*Xm_s(j)/width ! n_r including 2*PI
                        if(type.eq.-1) then 
                           tmpV(0)=tmp*dcos(argpb)*dcos(arg_m)
                           tmpV(1)=tmp*dsin(argpb)*dsin(arg_m)
                        elseif(type.eq.0) then 
                           tmpV(0)=tmp*dcos(argpb)*dcos(arg_m)
                        else
                           tmpV(1)=tmp*dsin(argpb)*dsin(arg_m)
                        endif
                        do jj=lbound(V,3),ubound(V,3)
                           V(n_tmp,l_tmp,jj)=V(n_tmp,l_tmp,jj)+tmpV(jj)* &
     &                          char
                        enddo
                     enddo
                  endif
               enddo
            enddo
         enddo
      enddo
      V(:,:,:)=V(:,:,:)*sample_norm
      Yw=Y/width
      do n=1,M0         
         if((do_interp.and.interp).and.(.not.                             &
     &        (do_exceptional))) then
            rkbes=sqrt(Yw)*interp_kbes(PI2*real(n,DP)*Yw)
         else
            rkbes=sqrt(Yw)*Wf(R,PI2*real(n,DP)*Yw)
         endif
         if(rkbes.eq.0.0) then
            write(*,*) 'K_i',R,'(',PI2*real(n,DP)*Y/width,')=',rkbes
         endif
         do icusp=1,num_cusps
            n_tmp=n+(icusp-1)*M0
            V(n_tmp,n_tmp,:)=V(n_tmp,n_tmp,:)-rkbes
         enddo
      enddo                     ! end n   
      call clean_pullback()
!      call clean_whittaker()
      end subroutine


      subroutine computeVnl3_co_cplx3(R,Y,Q,M0,V,is_tilda)
      use commonvariables
      use groups
      use characters

      implicit none
      integer,intent(in) :: Q,M0
      real(kind=DP) :: Y,R
      logical,optional::is_tilda
      ! 0 = cos : 1 = sin
!      complex(kind=DP),dimension(:,:,:),allocatable::V
      complex(kind=DP),dimension(1:num_cusps*M0,1:num_cusps*M0,0:1)::V      
      if(.not.(PRESENT(is_tilda))) then
         is_tilda=.true.
      endif
!      allocate(V(1:num_cusps*M0,1:num_cusps*M0,0:1))
!c$$$      if(R.gt.5.4_DP) then
!c$$$         write(*,*) 'in Vnl3 R=',R,' Y=',Y,' Q=',Q,' M0=',M0
!c$$$      endif 
      if(weight.eq.0.0_DP) then
         call computeVnl_cplx_char(R,Y,Q,M0,M0,V,is_tilda)
      else
         write(*,*) 'You must have zero weight here!'
         stop
                                !         call computeVnl_cplx_char_weight(R,Y,Q,M0,M0,V,is_tilda)
      endif
      end subroutine
      
                                !     Compute V_nl (or V_nl~) for 1<=n<=N0, 1<=l<=M0
                                !     including a complex coefficients and characters
                                !     for complex character too
                                !     This shoule be used for general N (non-primes)
      subroutine computeVnl_cplx_char(R,Y,Q,N0,M0,V,is_tilda)
      use commonvariables
      use groups
      use characters
      use interpolation
      implicit none
      integer,intent(in) :: Q,M0,N0
      real(kind=DP) :: Y,R
      logical,optional::is_tilda
      ! 0 = cos : 1 = sin
      complex(kind=DP),dimension(1:num_cusps*N0,1:num_cusps*M0,0:1)::V      
      complex(kind=DP) ::IPI2
      complex(kind=DP) ::tmpV_even,tmpV_odd
      complex(kind=DP),dimension(1:num_cusps,1:num_cusps,0:1)::Vnl
      real(kind=DP) :: x_in,y_in,xpb,ypb,xtmp,ytmp,xtmp2,ytmp2
      real(kind=DP),dimension(1-Q:Q)::Xm
      real(kind=DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::X_pb
      real(kind=DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::Y_pb
      complex(kind=DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::         &
     &     char_vec
      complex(kind=DP)::char_i,char_j
      real(DP)::nn,ll
      real(kind=DP) :: denom,rkbes,argpb,arg_m,tmpVR,tmpVIm
      real(kind=DP) :: tmpVR_even,tmpVIm_even,tmpVR_odd,tmpVIm_odd
      integer,dimension(2,2) :: pb_mapping
      ! indicates which series to connect with which point z_m
      integer :: ind,Nchar
      integer,dimension(2,2) :: map_tmp
      integer :: j,m,n,l,k,d
      real(kind=DP) :: char,tmp,tmpcos,tmpsin,tmpRe,tmpIm
      logical :: deb
!      integer :: sampletype,Q_start,Q_stop
      integer :: type ! even or odd =0,1
!      real(kind=DP) :: sample_norm ! normalise the sample
      integer :: icusp,jcusp,ind_vertex,ind_cusp
      real :: TIME,TIME2
      real(kind=DP),dimension(2,2)::B
      integer::n_tmp,l_tmp
!      if(R.gt.5.4_DP) then
!        write(*,*) 'in Vnl3 R=',R,' Y=',Y,' Q=',Q,' M0=',M0
!      endif
      if(.not.(PRESENT(is_tilda))) then
         is_tilda=.true.         
      else
         is_tilda=.false.
      endif
      if((Width.ne.1.0_DP)) then
!          write(*,*) 'Width!=1: ',width
         stop
      endif
      if((Level==0).or.(Width.eq.0.0_DP)) then 
         write(*,*) 'ERROR(Vnl3): Level is not set!! N=',N
         write(*,*) 'Or Width=0',Width
         stop
      endif  
!c$$$      ! We have to decide which type of sample to use in the DFT
!c$$$      sampletype=2
!c$$$      if(sampletype.eq.1) then  ! not using even-oddd symmetry
!c$$$         Q_start=1-Q
!c$$$         Q_stop=Q
!c$$$!         sample_norm=1.0_DP/real(2*Q,DP)
!c$$$         sample_norm=1.0_DP/real(Q,DP)
!c$$$         do j=Q_start,Q_stop
!c$$$            Xm(j) = Width*0.5_DP*(real(j,DP)-0.5_DP)/real(Q,DP)
!c$$$         end do
!c$$$      else          
!c$$$         Q_start=1
!c$$$         Q_stop=Q
!c$$$         sample_norm=2.0_DP/real(Q,DP)
!c$$$         do j=Q_start,Q_stop
!c$$$            Xm(j) = Width*(real(j,DP)-0.5_DP)/real(2*Q,DP)
!c$$$         end do
!c$$$      endif
!c$$$      ! computing the pulled-back points
!c$$$      ! for the first series with respect to the other two
      X_pb(:,:,:)=0.0_DP
      Y_pb(:,:,:)=0.0_DP
      call get_points(Y,Q,X_pb,Y_pb,char_vec,width)
      deb=.false.
      if(do_interp) then
         call setup_interp_kbes(R)
      endif

      do n=1,N0
         do l=1,M0
            do j=1,num_cusps
               do k=1,num_cusps
                  Vnl(j,k,0:1) = dcmplx(0.0_DP,0.0_DP) !
               enddo
            enddo
            do j=Q_start,Q_stop  
               do icusp=1,num_cusps
                  do jcusp=1,num_cusps
                     if(Y_pb(icusp,jcusp,j)>0.0_DP) then ! the point is near the j:th-cusp)
                        xpb=X_pb(icusp,jcusp,j)
                        ypb=Y_pb(icusp,jcusp,j)
                        ll=real(l,DP)
                        nn=real(n,DP)
                        if(do_interp.and.(.not.(do_exceptional))) then
                           rkbes = interp_kbes(PI2*ll*ypb/Width)
                        else
                           rkbes = Wf(R,PI2*ll*ypb/Width)
                        endif
                        tmp = rkbes*sqrt(ypb)
                        !!! Testing another width....
                        argpb=PI2*ll*xpb/Width
                        arg_m=PI2*nn*Xm(j)/Width
                        tmpVR_even=tmp*dcos(argpb)*dcos(arg_m)
                        tmpVIm_even=-1.0_DP*tmp*dcos(argpb)*dsin(arg_m)
                        tmpV_even=dcmplx(tmpVR_even,tmpVIm_even)
                        tmpVR_odd=tmp*dsin(argpb)*dsin(arg_m)
                        tmpVIm_odd=tmp*dsin(argpb)*dcos(arg_m)
                        tmpV_odd=dcmplx(tmpVR_odd,tmpVIm_odd)
                        
                        Vnl(icusp,jcusp,0) = Vnl(icusp,jcusp,0) +       &
     &                       tmpV_even*char_vec(icusp,jcusp,j)
                 
                        Vnl(icusp,jcusp,1) = Vnl(icusp,jcusp,1) +       &
     &                       tmpV_odd*char_vec(icusp,jcusp,j)
                     endif
                  end do
               end do
            enddo
            do icusp=1,num_cusps
               do jcusp=1,num_cusps
                  do k=0,1
                     if(sampletype.eq.1) then
                        Vnl(icusp,jcusp,k) = Vnl(icusp,jcusp,k)*                   &
     &                       dcmplx(sample_norm,0.0_DP)
                     else
                        Vnl(icusp,jcusp,k) = dcmplx(real(Vnl(icusp,       &
     &                       jcusp,k),DP),0.0_DP)                         &
     &                       *dcmplx(sample_norm,0.0_DP)
                     endif
                  enddo
               enddo
            enddo
               !! This part is what makes it V_nl~ instead of V_nl
            if((n==l).and.(is_tilda)) then 
!               if(MOD(n,50).eq.0) then
!                  write(*,*) 'at n=l=',n
!               endif
               if(do_interp.and.(.not.(do_exceptional))) then
                  tmp=PI2*real(n,DP)*Y/Width
                  rkbes = interp_kbes(PI2*real(n,DP)*Y/Width) 
               else
                  rkbes=Wf(R,PI2*real(n,DP)*Y/Width)
               endif
               rkbes = sqrt(Y)*rkbes
               do icusp=1,num_cusps
                  do k=0,1
                     Vnl(icusp,icusp,k) = Vnl(icusp,icusp,k) -                 &
     &                    dcmplx(rkbes,0.0_DP)
                  enddo
               enddo
            endif
            do icusp=1,num_cusps
               do jcusp=1,num_cusps
                  do k=0,1
                     n_tmp=n+(icusp-1)*N0
                     l_tmp=l+(jcusp-1)*M0
                     V(n_tmp,l_tmp,k) = Vnl(icusp,jcusp,k)
                  enddo
               end do
            end do
         end do
      end do
      !! Now the entire matrix are done!!
      end subroutine computeVnl_cplx_char

      
      subroutine computeVnl3_co_tot_cplx(R,Y,Q,M0,V)
      use commonvariables
      use groups
      use characters
      use interpolation
      implicit none
      integer :: Q,M0
      real(kind=DP),intent(in)::Y,R
      ! 0 = cos : 1 = sin
!      complex(DP),dimension(:,:),allocatable::VV
      complex(kind=DP),dimension(1:num_cusps*(2*M0+1),                   &
     &     1:num_cusps*(2*M0+1))::V     
!      integer::j,k,ii,jj,n,l,i
!      if(weight.eq.0.0) then

!         do j=1,2*M0+1
!         write(*,*) 'V(',j,',M0+1+(0:1))=',V(j,M0+1),V(j,M0+2)
!         write(*,*) 'V(',j,',M0+1+(0:1))=',V(j,M0+1),V(j,M0+2)
!         enddo
!      else
      call computeVnl3_co_tot_cplx_w(R,Y,Q,M0,V)
 !     call computeVnl3_co_tot_cplx_char(R,Y,Q,M0,V)
!c$$$      do ii=1,num_cusps
!c$$$         do jj=1,num_cusps
!c$$$            do n=-M0,M0
!c$$$               do l=-M0,M0
!c$$$                  i=n+M0+1+(ii-1)*(2*M0+1)
!c$$$                  j=l+M0+1+(jj-1)*(2*M0+1)           
!c$$$                  if(abs(V1(i,j)-V2(i,j)).gt.1E-8) then 
!c$$$                     writE(*,*) 'ii,jj,n,l=',ii,jj,n,l
!c$$$                     write(*,*) 'V1(',i,',',j,')=',V1(i,j)
!c$$$                     write(*,*) 'V2(',i,',',j,')=',V2(i,j)
!c$$$                     
!c$$$                 endif
!c$$$               enddo
!c$$$           enddo
!c$$$        enddo
!c$$$      enddo
!      endif
      end subroutine

      !  Compute all coefficients, also for negative n,
      ! e.g. c(n),-M<=n<=M
      ! This must be used if we don't have symmetric f.d.
      ! OR!!! If we have N not square-free so we can't use cos/sine
      ! simultaneously att all cusps



      subroutine computeVnl3_co_tot_cplx_w(R,Y,Q,M0,V)
      use commonvariables
      use groups
      use characters
      use interpolation
      use pullback
      implicit none
      integer :: Q,M0
      real(kind=DP) :: Y,R
      ! 0 = cos : 1 = sin
      complex(kind=DP),dimension(1:num_cusps*(2*M0+1),                  &
     &     1:num_cusps*(2*M0+1))::V     
      complex(kind=DP) ::IPI2
      complex(kind=DP) ::tmpVnl
      complex(kind=DP),dimension(1:num_cusps,1:num_cusps)::Vnl
      real(kind=DP) :: x_in,y_in,xpb,ypb,xtmp,ytmp,xtmp2,ytmp2
!      real(kind=DP),dimension(1-Q:Q)::Xm
      real(kind=DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::X_pb
      real(kind=DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::Y_pb
      complex(kind=DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::         &
     &     char_vec
      real(DP)::nn,ll,wt
      real(kind=DP) :: denom,rkbes,argpb,arg_m,tmpVR,tmpVIm,arg
      real(kind=DP) :: tmpVR_even,tmpVIm_even,tmpVR_odd,tmpVIm_odd
      integer,dimension(2,2) :: pb_mapping
!      integer,dimension(1-Q:Q) :: char_vec0,char_vec1
      ! indicates which series to connect with which point z_m
      integer :: ind,Nchar
      integer,dimension(2,2) :: map_tmp,maptmp2,maptmp3
      integer :: j,m,n,l,k,d
      real(kind=DP) :: char,tmpcos,tmpsin,tmpRe,tmpIm,alpha
      complex(DP)::char_i,char_j,tmp,char1,char2,char3,char11,char21,    &
     &     char31
      logical :: deb
!      integer :: sampletype,Q_start,Q_stop
      integer :: type ! even or odd =0,1
!      real(kind=DP) :: sample_norm ! normalise the sample
      integer :: in_region0,in_region1,in_region2  ! counts how many times we visit each region
      integer :: icusp,jcusp,ind_vertex,ind_cusp
      real :: TIME,TIME2
      real(kind=DP),dimension(2,2)::B,maptmp_re
      real(DP),dimension(2,2)::tmp_map,tmp_map2
      integer,dimension(2,2)::tmp_map3,Smap
      complex(DP)::mul_tmp,tmp_tilde,alla_j,faktor_plus,faktor_minus
!      real(DP),dimension(0:num_cusps-1)::alphas
      integer::l1,count
      real(DP)::Yw,PI2_4,ll_ypb,ll_ypb_old,wt_old,det,nn_old,rkbes_old
      integer::n_tmp,l_tmp,i
      logical::deb_loc
      deb_loc=.true.
      deb_loc=.false.
      if(deb_loc) then
         write(*,*) 'in Vnl_w R=',R,' Y=',Y,' Q=',Q,' M0=',M0
         write(*,*) 'weight=',weight 
         write(*,*) 'width=',width,'CType=',CType,'Cmod=',Cmod
         write(*,*) 'holomorphic=',holomorphic
         write(*,*) 'do_exceptional=',do_exceptional
      endif

      !! We should not be holomorphic here
      if(holomorphic) then 
         call computeVnl3_co_tot_cplx_w_holo(R,Y,Q,M0,V)
         return
      endif
      if(Level==0) then 
         write(*,*) 'ERROR(Vnl3): Level(P) is not set!!'
         stop
      endif
      IPI2=dcmplx(0.0_DP,PI2)
      if((weight.eq.0.0).or.(holomorphic)) then
         PI2_4=PI2
      else
         PI2_4=PI4
      endif
      faktor_plus=dcmplx(1.0_DP,0.0_DP)

      if(ceiling(weight).eq.floor(weight)) then 
      if(mod(int(weight),2).eq.1) then 
         faktor_minus=dcmplx(R,0.0_DP)
         do l=1,(int(weight)-1)/2
            faktor_minus=faktor_minus*(real(l,DP)**2+R*R)
         enddo
      else
         faktor_minus=faktor_plus
         do l=1,(int(weight)/2)
            faktor_minus=faktor_minus*(real(l*(l-1),DP)+R*R+0.25D0)
         enddo
      endif
!      write(*,*) 'sqrt(lambda)=',faktor_minus
!      faktor_minus=dcmplx(1.0_DP,0.0_DP)/faktor_minus
      endif
      sampletype=1
!      X_pb(:,:,:)=0.0_DP
!      Y_pb(:,:,:)=0.0_DP
!      write(*,*) '---------------------_'
!      write(*,*) 'xsizes:',size(X_pb,1),size(X_pb,2),size(X_pb,3)
!      write(*,*) 'ysizes:',size(Y_pb,1),size(Y_pb,2),size(Y_pb,3)
      call get_points(Y,Q,X_pb,Y_pb,char_vec,width)
!      write(*,*) '---------------------_'
!c$$$      do k=1-Q,Q
!c$$$         do i=1,num_cusps
!c$$$            do j=1,num_cusps
!c$$$               write(12,*) X_pb(i,j,k),Y_pb(i,j,k)
!c$$$            enddo 
!c$$$         enddo
!c$$$         write(13,*) Xm(k),Y
!c$$$      enddo
      deb=.false.
      call get_alphas()
      alpha=100.0_DP            !want to find the minimum alpha_j
      do j=1,num_cusps
         if(alphas(j).lt.alpha) then
            alpha=alphas(j)
         endif
!         write(*,*) 'alpha(j)=',alphas(j)
      enddo
!      call show_alphas()
      if(do_interp) then
         if(weight.eq.0.0) then 
            call setup_interp_kbes(R,Y)
         else
            call setup_interp_whittw(R,Y,alpha)
         endif
      endif
      do l=1,num_cusps*(2*M0+1)
         do n=1,num_cusps*(2*M0+1)
            V(l,n)=dcmplx(0.0_DP,0.0_DP)
         enddo
      enddo
!      V(:,:)=dcmplx(0.0_DP,0.0_DP)
      !! try to sum in the correct order...
!      open(unit=12,FILE='whitt_test')
      
 718  FORMAT('ypb=',I2,',',I2,')=',F20.16)
 719  FORMAT('ll=',I3,'+',F7.3,'=',F8.3)
      ll_ypb_old=100.0_DP
      count=0
      do l=-M0,M0
         !!! we try to avoid cancellation here... both with j and l
         !!! suppose that Q_start<0<Q_stop
         do j=Q_start,Q_stop  
            do icusp=1,num_cusps
               do jcusp=1,num_cusps
                  ll=real(l,DP)+alphas(jcusp)
                   if((ll.eq.0.0).and.(.not.(holomorphic)))              &
     &                 cycle 
                  ypb=Y_pb(icusp,jcusp,j)
                  if(ypb.gt.0.0_DP) then ! the point is near the j:th-cusp)
                     xpb=X_pb(icusp,jcusp,j)                   
                     wt=weight*dsign(0.5_DP,ll)
                     ll_ypb=PI2_4*ypb*abs(ll)
                     wt_old=wt
                     ll_ypb_old=ll_ypb  
                     !! the ypb's are usually equal for all cusps
                     if((abs(ll_ypb-ll_ypb_old)/ll_ypb.lt.1.0E-14_DP)   &
     &                    .and.(wt.eq.wt_old)) then                        
                        if(weight.eq.0.0_DP) then
                           rkbes=Wf(R,PI2*abs(ll)*ypb)
!                           write(*,*) 'RKBES(',r,',',PI2*abs(ll)*ypb,    &
!     &                          ')=',rkbes
                           rkbes=rkbes*sqrt(ypb)
                        else
                           rkbes=Wf(R,ll_ypb,wt)
                           if(do_exceptional) then
                                !                             write(12,*) ll_ypb,rkbes
                              rkbes=rkbes/((PI2_4*abs(ll))**                    &
     &                             (0.5_DP*weight))
                           else
                              rkbes=rkbes/(sqrt(abs(ll)))
                              if(ll.lt.0.0) then 
                                 rkbes=rkbes*faktor_minus
                              endif
                           endif
                        endif
                        rkbes_old=rkbes
                     else
                        rkbes=rkbes_old
                     endif
                     argpb=ll*xpb
!                     if(l.eq.0) then 
!                        write(*,*) 'rkbes2=',rkbes
!                     endif                     
                     tmp=dcmplx(rkbes,0.0_DP)*char_vec(icusp,jcusp,j)
!                     write(12,*) l,j,icusp,jcusp,char_vec(icusp,jcusp,j)
!!                     l_tmp=l+M0+1+(jcusp-1)*(2*M0+1)
!                     if(l_tmp.eq.M0+1) then
!                        write(*,*) 'V(',j,',',ll,')=',ypb,'*',               &
!     &                       abs(char_vec(icusp,jcusp,j))
!                     endif
                     do n=-M0,M0
                        nn=real(n,DP)+alphas(icusp)         
                        if((nn.eq.0.0).and.(.not.                              &
     &                       (holomorphic))) then
                           cycle 
                        endif                        
                        arg_m=nn*Xm(j)/width                        
                        tmpVnl=tmp*exp(dcmplx(0.0,PI2*(argpb-arg_m)))                      
!                        if(nn*ll.gt.0.0) then
!                        elseif(nn.lt.0.0) then
!                           tmpVnl=tmpVnl*faktor_minus/faktor_plus
!                        else
!                           tmpVnl=tmpVnl*faktor_plus/faktor_minus
!                        endif
                        n_tmp=n+M0+1+(icusp-1)*(2*M0+1)
                        l_tmp=l+M0+1+(jcusp-1)*(2*M0+1)
                        V(n_tmp,l_tmp)=V(n_tmp,l_tmp)+tmpVnl
!                        if(n_tmp.eq.M0+1) then
! 1                      write(*,*) 'tmp(',n,l,')=',tmpVnl,'=',          &
!     &                 !         tmp,'*exp(dcmplx(0.0,PI2*',               &
!     &                          argpb,'-',arg_m,')) '                     
!                        endif
                     end do

                  endif
               enddo            ! end jcusp
            enddo               ! end icusp 
         enddo                  ! end j
      enddo                     ! end l
!      close(12)
!      V(:,:)=V(:,:)*dcmplx(sample_norm,0.0_DP)
!      do j=1,num_cusps*(2*M0+1)
!         write(*,*) 'Vtmp(1,',j,')=',V(1,j)
!      enddo

      do l=1,num_cusps*(2*M0+1)
         do n=1,num_cusps*(2*M0+1)
            V(n,l)=V(n,l)*dcmplx(sample_norm,0.0_DP)
         enddo
      enddo                               !! Do the tilde part
      nn_old=0
      Yw=Y/width
      do n=-M0,M0
         do icusp=1,num_cusps
            nn=real(n,DP)+alphas(icusp)
            n_tmp=n+M0+1+(icusp-1)*(2*M0+1)
            if((nn.eq.0.0).and.(.not.(holomorphic))) then
               cycle
            endif
            wt=weight*dsign(0.5_DP,nn)
!            if(abs(nn).ne.nn_old) then
            !! We can save half of the computations here
               nn_old=abs(nn)
!!!               tmp_tilde=dcmplx(Wf(R,PI2_4*nn_old*Y,wt),0.0_DP)
               if(weight.eq.0.0) then
                  tmp_tilde=dcmplx(Wf(R,PI2*nn_old*Yw)*sqrt(Yw),0.0_DP)
               elseif(holomorphic) then
                  if(nn.ne.0.0) then
!                     tmp_tilde=(Y**0.5_DP*weight)*(abs(nn)**                       &
!     &                    (0.5_DP*(weight-1.0_DP)))*exp(-PI2*Yw*abs(nn)) *abs(nn))**                            &
!     &                    (0.5_DP*(weight-1.0_DP)))*exp(-PI2*Yw*abs(nn))
                     tmp_tilde=sqrt(Y)*((Y*abs(nn))**                            &
     &                    (0.5_DP*(weight-1.0_DP)))*exp(-PI2*Yw*abs(nn))
!                     if(n_tmp.eq.18) then
!                        write(*,*) 'tmp_tilde(18)(',R,Y,M0,weight,')=',       &
!     &                       tmp_tilde
!!                        WRITE(*,*) sqrt(Y),'*',Y,'*',abs(nn),'**',             &                            &
!     &                    (0.5_DP*(weight-1.0_DP)),'*',                       &
!     &                       'exp(-PI2*',Yw,'*',abs(nn),')'
!                     endif

                  else
                     tmp_tilde=Y**(0.5_DP*weight)
                  endif
               else
                  tmp_tilde=dcmplx(Wf(R,PI2_4*nn_old*Yw,wt),0.0_DP)
                  if(do_exceptional) then                                      
                     tmp_tilde=tmp_tilde/dcmplx(                              &
     &                    (PI2_4*abs(nn))**(0.5_DP*weight),0.0_DP)
                  elseif(.not.(holomorphic)) then
                     tmp_tilde=tmp_tilde/dcmplx(sqrt(abs(nn))            &
     &                    ,0.0_DP)
                  endif
                  if(nn.lt.0.0) then 
                     tmp_tilde=tmp_tilde*faktor_minus
                  endif
               endif
 !           endif            
            V(n_tmp,n_tmp)=V(n_tmp,n_tmp)-tmp_tilde
         enddo
      enddo
!      write(*,*) 'saved :',count
!      do n=1,size(V,1)
!(2*M0+1)*num_cusps
!         write(*,*) 'V(',n,')=',V(n,n)
!      enddo
      !! Now the entire matrix are done!!
      end subroutine computeVnl3_co_tot_cplx_w


      !  Compute all coefficients, also for negative n,
      ! e.g. c(n),-M<=n<=M
      ! This must be used if we don't have symmetric f.d.
      ! OR!!! If we have N not square-free so we can't use cos/sine
      ! simultaneously att all cusps

!!! For holomorphic functions
      subroutine computeVnl3_co_tot_cplx_w_holo(R,Y,Q,M0,V)
      use commonvariables
      use groups
      use characters
      use gamma_function
      use interpolation
      use pullback
      implicit none
      
      integer :: Q,M0
      real(kind=DP) :: Y,R
      ! 0 = cos : 1 = sin
      complex(kind=DP),dimension(1:num_cusps*(2*M0+1),                  &
     &     1:num_cusps*(2*M0+1))::V     
      complex(kind=DP) ::IPI2
      complex(kind=DP) ::tmpVnl
      complex(kind=DP),dimension(1:num_cusps,1:num_cusps)::Vnl
      real(kind=DP) :: x_in,y_in,xpb,ypb,xtmp,ytmp,xtmp2,ytmp2
!      real(kind=DP),dimension(1-Q:Q)::Xm
      real(kind=DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::X_pb
      real(kind=DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::Y_pb
      complex(kind=DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::         &
     &     char_vec
      real(DP)::nn,ll,wt
      real(kind=DP) :: denom,rkbes,argpb,arg_m,tmpVR,tmpVIm,arg
      real(kind=DP) :: tmpVR_even,tmpVIm_even,tmpVR_odd,tmpVIm_odd
      integer,dimension(2,2) :: pb_mapping
!      integer,dimension(1-Q:Q) :: char_vec0,char_vec1
      ! indicates which series to connect with which point z_m
      integer :: ind,Nchar
      integer,dimension(2,2) :: map_tmp,maptmp2,maptmp3
      integer :: j,m,n,l,k,d
      real(kind=DP) :: char,tmpcos,tmpsin,tmpRe,tmpIm,alpha
      complex(DP)::char_i,char_j,tmp,char1,char2,char3,char11,char21,    &
     &     char31
      logical :: deb
!      integer :: sampletype,Q_start,Q_stop
      integer :: type ! even or odd =0,1
!      real(kind=DP) :: sample_norm ! normalise the sample
      integer :: in_region0,in_region1,in_region2  ! counts how many times we visit each region
      integer :: icusp,jcusp,ind_vertex,ind_cusp
      real :: TIME,TIME2
      real(kind=DP),dimension(2,2)::B,maptmp_re
      real(DP),dimension(2,2)::tmp_map,tmp_map2
      integer,dimension(2,2)::tmp_map3,Smap
      complex(DP)::mul_tmp,tmp_tilde,alla_j,faktor_plus,faktor_minus
!      real(DP),dimension(0:num_cusps-1)::alphas
      integer::l1,count
      real(DP)::Yw,PI2_4,ll_ypb,ll_ypb_old,wt_old,det,nn_old
      integer::n_tmp,l_tmp
      logical::deb_loc
      deb_loc=.true.
!      deb_loc=.false.
      if(deb_loc) then
         write(*,*) 'in Vnl_w R=',R,' Y=',Y,' Q=',Q,' M0=',M0
         write(*,*) 'weight=',weight 
         write(*,*) 'width=',width,'CType=',CType,'Cmod=',Cmod
         write(*,*) 'holomorphic=',holomorphic
         write(*,*) 'do_exceptional=',do_exceptional
      endif
      if(Level==0) then 
         write(*,*) 'ERROR(Vnl3): Level(P) is not set!!'
         stop
      endif
      if(.not.(holomorphic)) then
         write(*,*) 'Using only for holomorphic!'
         stop
      endif
      IPI2=dcmplx(0.0_DP,PI2)
      if((weight.eq.0.0).or.(holomorphic)) then
         PI2_4=PI2
      else
         PI2_4=PI4
      endif
      faktor_plus=dcmplx(1.0_DP,0.0_DP)
      faktor_minus=faktor_plus
      sampletype=1
!      X_pb(:,:,:)=0.0_DP
!      Y_pb(:,:,:)=0.0_DP
      call get_points(Y,Q,X_pb,Y_pb,char_vec,width)
      write(*,*) 'Q_start=',Q_start,Q_stop
      deb=.false.
      call get_alphas()
      alpha=100.0_DP            !want to find the minimum alpha_j
      do j=1,num_cusps
         if(alphas(j).lt.alpha) then
            alpha=alphas(j)
         endif
!!         write(*,*) 'alpha(j)=',alphas(j)
      enddo
      if(do_interp) then
         call setup_interp_whittw(R,Y,alpha)
      endif
      do l=1,num_cusps*(2*M0+1)
         do n=1,num_cusps*(2*M0+1)
            V(l,n)=dcmplx(0.0_DP,0.0_DP)
         enddo
      enddo
!      V(:,:)=dcmplx(0.0_DP,0.0_DP)
      !! try to sum in the correct order...
!      open(unit=12,FILE='whitt_test')
      write(*,*) 'Here!'
 718  FORMAT('ypb=',I2,',',I2,')=',F20.16)
 719  FORMAT('ll=',I3,'+',F7.3,'=',F8.3)
      ll_ypb_old=100.0_DP
      count=0
      !! since we only have holomorphic functions here we need only
      !! l,n>=0
      do l=0,M0
         !!! we try to avoid cancellation here... both with j and l
         !!! suppose that Q_start<0<Q_stop
         do j=Q_start,Q_stop  
            do icusp=1,num_cusps
               do jcusp=1,num_cusps
                  ll=real(l,DP)+alphas(jcusp)
                  ypb=Y_pb(icusp,jcusp,j)  !!! This is divided by width
                  if(width.ne.1.0_DP) then 
                     ypb=ypb*width
                  endif
                  if(ypb.gt.0.0_DP) then ! the point is near the j:th-cusp)
                     xpb=X_pb(icusp,jcusp,j)                   
                     ll_ypb=ypb*abs(ll)
                     !! the ypb's are usually equal for all cusps
!                     if((abs(ll_ypb-ll_ypb_old)/ll_ypb.lt.1.0E-14_DP)   &
!     &                    .and.(wt.eq.wt_old)) then
!                     else
                      if(ll.eq.0.0) then 
                          rkbes=(ypb)**(0.5_DP*weight)
                       else
                          rkbes=sqrt(ypb)*((ll*ypb)**                     &
     &                          (0.5_DP*(weight-1.0_DP)))*                       &
     &                          exp(-PI2*ypb/width*ll)
                     endif
                     argpb=ll*xpb
!!                     tmp=dcmplx(rkbes,0.0_DP)*char_vec(icusp,jcusp,j)
                     tmp=dcmplx(rkbes,0.0_DP)
                     do n=0,M0
                        nn=real(n,DP)+alphas(icusp)         
                        if((nn.le.0.0).and.(icusp.ne.0)) cycle
                        arg_m=nn*Xm(j)/width                        
                        iF((l.eq.0).and.(n.eq.0)) then 
!                           write(*,*) 'V00=',RKBES*                      &
!     &                          char_vec(icusp,jcusp,j)
!                        write(*,*) 'char_vec=',
                        endif
                        
                        tmpVnl=tmp*exp(dcmplx(0.0,PI2*(argpb-arg_m))+        &
     &                    char_vec(icusp,jcusp,j))                      
                        !write(13,*) l,n,icusp,jcusp,j,tmp
! argpb,arg_m,        &
!     &                   char_vec(icusp,jcusp,j)
                        n_tmp=n+M0+1+(icusp-1)*(2*M0+1)
                        l_tmp=l+M0+1+(jcusp-1)*(2*M0+1)
                        V(n_tmp,l_tmp)=V(n_tmp,l_tmp)+tmpVnl
!                       if((n_tmp.eq.23).and.(l_tmp.eq.23)) then
!                           write(*,*) 'tmp(',n,l,')=',tmpVnl,'=',          &
!     &                          tmp,'*exp(dcmplx(0.0,PI2*',               &
!     &                          argpb,'-',arg_m,')) '                     
!                        endif
                     end do

                  endif
               enddo            ! end jcusp
            enddo               ! end icusp 
         enddo                  ! end j
      enddo                     ! end l
!      close(12)
!      V(:,:)=V(:,:)*dcmplx(sample_norm,0.0_DP)
!      do j=1,num_cusps*(2*M0+1)
!         write(*,*) 'Vtmp(1,',j,')=',V(1,j)
!      enddo

      do l=1,num_cusps*(2*M0+1)
         do n=1,num_cusps*(2*M0+1)
            V(n,l)=V(n,l)*dcmplx(sample_norm,0.0_DP)
         enddo
      enddo                               !! Do the tilde part
      nn_old=0
      Yw=Y/width
      do n=0,M0
         do icusp=1,num_cusps
            nn=real(n,DP)+alphas(icusp)
            n_tmp=n+M0+1+(icusp-1)*(2*M0+1)
               if(nn.ne.0.0) then
                  tmp_tilde=sqrt(Y)*((Y*abs(nn))**                            &
     &                 (0.5_DP*(weight-1.0_DP)))*exp(-PI2*Yw*abs(nn))
!                  write(*,*) 'tmp_tilde(',n,')=',tmp_tilde

               else
                  tmp_tilde=Y**(0.5_DP*weight)
                  write(*,*) 'tmp_tilde(',n,')=',tmp_tilde

               endif
            V(n_tmp,n_tmp)=V(n_tmp,n_tmp)-tmp_tilde
!            write(*,*) 'V(',n_tmp,')=',V(n_tmp,n_tmp)
         enddo
      enddo
!      write(*,*) 'saved :',count
!      do n=1,10
!(2*M0+1)*num_cusps
         write(*,*) 'V(11,11)=',V(M0+1,M0+1)
!      enddo
      !! Now the entire matrix are done!!
      end subroutine computeVnl3_co_tot_cplx_w_holo



!!! For holomorphic functions
      subroutine computeVnl3_co_tot_real_w_holo(R,Y,Q,M0,V)
      use commonvariables
      use groups
      use characters
      use interpolation
      use pullback
      use whittakerw,only:whittW
      implicit none
      integer :: Q,M0
      real(kind=DP) :: Y,R
      ! 0 = cos : 1 = sin
      real(kind=DP),dimension(1:num_cusps*(2*M0+1),                          &
     &     1:num_cusps*(2*M0+1))::V     
      complex(kind=DP) ::IPI2
      real(kind=DP) ::tmpVnl
!      real(kind=DP),dimension(1:num_cusps,1:num_cusps)::Vnl
      real(kind=DP) :: x_in,y_in,xpb,ypb,xtmp,ytmp,xtmp2,ytmp2
!      real(kind=DP),dimension(1-Q:Q)::Xm
      real(kind=DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::X_pb
      real(kind=DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::Y_pb
      complex(kind=DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::         &
     &     char_vec
      real(DP)::nn,ll,wt
      real(kind=DP) :: denom,rkbes,argpb,arg_m,tmpVR,tmpVIm,arg
!      real(kind=DP) :: tmpVR_even,tmpVIm_even,tmpVR_odd,tmpVIm_odd
!      integer,dimension(2,2) :: pb_mapping
!      integer,dimension(1-Q:Q) :: char_vec0,char_vec1
      ! indicates which series to connect with which point z_m
      integer :: ind,Nchar
      integer,dimension(2,2) :: map_tmp,maptmp2,maptmp3
      integer :: j,m,n,l,k,d
      real(kind=DP) :: char,tmpcos,tmpsin,tmpRe,tmpIm,alpha
      complex(DP)::char_i,char_j,tmp,char1,char2,char3,char11,char21,    &
     &     char31
      logical :: deb
!      integer :: sampletype,Q_start,Q_stop
      integer :: type ! even or odd =0,1
!      real(kind=DP) :: sample_norm ! normalise the sample
      integer :: in_region0,in_region1,in_region2  ! counts how many times we visit each region
      integer :: icusp,jcusp,ind_vertex,ind_cusp
      real :: TIME,TIME2
      real(kind=DP),dimension(2,2)::B,maptmp_re
      real(DP),dimension(2,2)::tmp_map,tmp_map2
      integer,dimension(2,2)::tmp_map3,Smap
      complex(DP)::mul_tmp,tmp_tilde,alla_j,faktor_plus,faktor_minus
!      real(DP),dimension(0:num_cusps-1)::alphas
      integer::l1,count
      real(DP)::Yw,PI2_4,ll_ypb,ll_ypb_old,wt_old,det,nn_old,p
      integer::n_tmp,l_tmp
      complex(DP)::carg
      logical::deb_loc
      deb_loc=.true.
 !     deb_loc=.false.
      if(deb_loc) then
         write(*,*) 'in Vnl_tot_real_h_w R=',R,' Y=',Y,' Q=',Q,' M0=',M0
         write(*,*) 'weight=',weight 
         write(*,*) 'width=',width,'CType=',CType,'Cmod=',Cmod
         write(*,*) 'holomorphic=',holomorphic
         write(*,*) 'do_exceptional=',do_exceptional
      endif
      if(Level==0) then 
         write(*,*) 'ERROR(Vnl3): Level(P) is not set!!'
         stop
      endif
      if(.not.(holomorphic)) then
         write(*,*) 'Using only for holomorphic!'
         stop
      endif
      IPI2=dcmplx(0.0_DP,PI2)
      if((weight.eq.0.0).or.(holomorphic)) then
         PI2_4=PI2
      else
         PI2_4=PI4
      endif
      faktor_plus=dcmplx(1.0_DP,0.0_DP)
      faktor_minus=faktor_plus
      sampletype=1
!      X_pb(:,:,:)=0.0_DP
!      Y_pb(:,:,:)=0.0_DP
      call get_points(Y,Q,X_pb,Y_pb,char_vec,width)
      deb=.false.
      call get_alphas()
      alpha=100.0_DP            !want to find the minimum alpha_j
      do j=1,num_cusps
         if(alphas(j).lt.alpha) then
            alpha=alphas(j)
         endif
!!         write(*,*) 'alpha(j)=',alphas(j)
      enddo
      if(do_interp) then
         call setup_interp_whittw(R,Y,alpha)
      endif
      do l=1,num_cusps*(2*M0+1)
         do n=1,num_cusps*(2*M0+1)
            V(l,n)=0.0_DP
         enddo
      enddo
!      V(:,:)=dcmplx(0.0_DP,0.0_DP)
      !! try to sum in the correct order...
!      open(unit=12,FILE='whitt_test')
      
 718  FORMAT('ypb=',I2,',',I2,')=',F20.16)
 719  FORMAT('ll=',I3,'+',F7.3,'=',F8.3)
      ll_ypb_old=100.0_DP
      count=0
      !! since we only have holomorphic functions here we need only
      !! l,n>=0
      p=0.5_DP*(weight-1.0_DP)
      IF(DEB_LOC) THEN 
         write(*,*) 'scale=',(PI2/p*exp(1.0_DP))**p
      endif
      do l=0,M0
         !!! we try to avoid cancellation here... both with j and l
         !!! suppose that Q_start<0<Q_stop
         do j=1,Q  
            do icusp=1,num_cusps
               do jcusp=1,num_cusps
                  ll=real(l,DP)+alphas(jcusp)
                  ypb=Y_pb(icusp,jcusp,j)  !!! This is divided by width
                  if(width.ne.1.0_DP) then 
                     ypb=ypb*width
                  endif
                  if(ypb.gt.0.0_DP) then ! the point is near the j:th-cusp)
                     xpb=X_pb(icusp,jcusp,j)                   
                     ll_ypb=ypb*abs(ll)
                     !! the ypb's are usually equal for all cusps
!                     if((abs(ll_ypb-ll_ypb_old)/ll_ypb.lt.1.0E-14_DP)   &
!     &                    .and.(wt.eq.wt_old)) then
!                     else
!!! I try with an 
                      if(ll.eq.0.0) then 
!                          rkbes=(ypb)**(0.5_DP*weight)
!                         write(*,*) 'scale=',PI2*exp(1.0_DP)/p
!! Without normalization
!                         rkbes=sqrt(ypb)*(ypb**p)
                         rkbes=ypb**(0.5_DP*weight)

!Norm by (2pi*e/p)^p
!                         rkbes=sqrt(ypb)*((ypb*PI2*exp(1.0_DP))/p)**p
!                          write(*,*) 'Rkbes(',ypb,j,')=',rkbes
                       else
!! Without normalization
!                          rkbes=sqrt(ypb)*((ll*ypb/(p+1.0_DP)*PI2)                   &
!     &                         **p)*exp(-PI2*ypb/width*ll)
                          rkbes=sqrt(ypb)*((ll*ypb)**                     &
     &                         (0.5_DP*(weight-1.0_DP)))*                       &
     &                         exp(-PI2*ypb/width*ll)


!Norm by (2pi*e/p)^p
!                          rkbes=sqrt(ypb)*(((ll/p)*ypb*exp(1.0_DP)*PI2)                   &
!     &                         **p)*exp(-PI2*ypb/width*ll)
!                          rkbes=sqrt(ypb)*((ll*ypb/(p+1.0_DP)*PI2)                   &
!     &                         **p)*exp(-PI2*ypb/width*ll)
                     endif
                     if(isnan(rkbes)) then 
                        write(*,*) 'Rkbes(',ypb,ll,')=',rkbes
                        write(*,*) (ll*ypb/p*PI2)                             &
     &                         ,'**',p,')*exp(',-PI2*ypb/width*ll,')'
                        wt=0.5_DP*weight
                        write(*,*) 'Whittw(',ypb,ll,')=',whittw(wt,wt*         &
     &                       (1.0_DP-wt),PI4*ypb*ll)
                        stop
                     endif
                     argpb=ll*xpb
                     tmp=dcmplx(rkbes,0.0_DP)
                     carg=char_vec(icusp,jcusp,j)
                     do n=0,M0
                        nn=real(n,DP)+alphas(icusp)         
                        arg_m=nn*Xm(j)/width                        
                        iF((l.eq.0).and.(n.eq.0)) then 
!                           write(*,*) 'V00=',RKBES*                       &
!     &                          char_vec(icusp,jcusp,j)
!                        write(*,*) 'char_vec=',
                        endif
                        tmpVnl=rkbes*cos(PI2*(argpb-arg_m)+carg)                      

                        n_tmp=n+M0+1+(icusp-1)*(2*M0+1)
                        l_tmp=l+M0+1+(jcusp-1)*(2*M0+1)
                        V(n_tmp,l_tmp)=V(n_tmp,l_tmp)+tmpVnl
!                       if((n_tmp.eq.23).and.(l_tmp.eq.23)) then
!                           write(*,*) 'tmp(',n,l,')=',tmpVnl,'=',          &
!     &                          tmp,'*exp(dcmplx(0.0,PI2*',               &
!     &                          argpb,'-',arg_m,')) '                     
!                        endif
                     end do

                  endif
               enddo            ! end jcusp
            enddo               ! end icusp 
         enddo                  ! end j
      enddo                     ! end l
!      close(12)
!      V(:,:)=V(:,:)*dcmplx(sample_norm,0.0_DP)
!      do j=1,num_cusps*(2*M0+1)
!         write(*,*) 'Vtmp(1,',j,')=',V(1,j)
!      enddo

      do l=1,num_cusps*(2*M0+1)
         do n=1,num_cusps*(2*M0+1)
!            V(n,l)=V(n,l)*dcmplx(sample_norm,0.0_DP)
            V(n,l)=V(n,l)*dcmplx(1.0_DP/real(Q,DP),0.0_DP)
         enddo
      enddo                               !! Do the tilde part
      nn_old=0
      Yw=Y/width
      do n=0,M0
         do icusp=1,num_cusps
            nn=real(n,DP)+alphas(icusp)
            n_tmp=n+M0+1+(icusp-1)*(2*M0+1)
               if(nn.ne.0.0) then
! Without normalization
                  tmp_tilde=sqrt(Y)*((Y*abs(nn))**                            &
     &                 (p))*exp(-PI2*Y*abs(nn))
!Norm by (2pi*e/p)^p
!                  tmp_tilde=sqrt(Y)*(((abs(nn)/p)*PI2*exp(1.0_DP)*Y)**                            &
!     &                 (p))*exp(-PI2*Y*abs(nn))
               else
! Without normalization
                  tmp_tilde=sqrt(Y)*(Y**p)
!Norm by (2pi*e/p)^p
!                  tmp_tilde=sqrt(Y)*((Y*PI2*exp(1.0_DP))/p)**p
!                  write(*,*) 'tmp_tilde(',n,')=',tmp_tilde

               endif
            V(n_tmp,n_tmp)=V(n_tmp,n_tmp)-tmp_tilde
!            write(*,*) 'V(',n_tmp,')=',V(n_tmp,n_tmp)
         enddo
      enddo
!      write(*,*) 'saved :',count
!      do n=1,10
!(2*M0+1)*num_cusps
!         write(*,*) 'V(11,11)=',V(M0+1,M0+1)
!      enddo
      !! Now the entire matrix are done!!
      end subroutine computeVnl3_co_tot_real_w_holo






      ! Compute all coefficients, also for negative n,
      ! e.g. c(n),-M<=n<=M
      ! This must be used if we don't have symmetric f.d.
      ! OR!!! If we have N not square-free so we can't use cos/sine
      ! simultaneously att all cusps
      subroutine computeVnl3_co_tot_cplx_char(R,Y,Q,M0,V)
      use commonvariables
      use groups
      use characters
      use interpolation
      use pullback
      implicit none
      integer :: Q,M0
      real(kind=DP),intent(in):: Y,R
      ! 0 = cos : 1 = sin
      complex(kind=DP) ::IPI2
      complex(kind=DP),dimension(1:num_cusps*(2*M0+1),                  &
     &     1:num_cusps*(2*M0+1))::V     
!      complex(kind=DP),dimension(:,:),allocatable::V
      complex(kind=DP) ::tmpVnl
!      complex(kind=DP),dimension(1:num_cusps,1:num_cusps)::Vnl
      real(kind=DP) :: x_in,y_in,xpb,ypb,xtmp,ytmp,xtmp2,ytmp2
!      real(kind=DP),dimension(1-Q:Q)::Xm
!      real(DP),dimension(:),allocatable::Xm
!      real(kind=DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::X_pb
      real(kind=DP),dimension(:,:,:),allocatable::X_pb,Y_pb
      complex(DP),dimension(:,:,:),allocatable::char_vec
!      real(kind=DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::Y_pb
!      complex(kind=DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::         &
!     &     char_vec
      real(DP)::nn,ll
      real(kind=DP) :: denom,rkbes,argpb,arg_m,tmpVR,tmpVIm
      real(kind=DP) :: tmpVR_even,tmpVIm_even,tmpVR_odd,tmpVIm_odd
      integer,dimension(2,2) :: pb_mapping
      integer,dimension(1-Q:Q) :: char_vec0,char_vec1
      ! indicates which series to connect with which point z_m
      integer :: ind,Nchar
      integer,dimension(2,2) :: map_tmp
      real,dimension(2,2) :: map_tmpr
      integer :: j,m,n,l,k,d
      complex(DP)::char_i,char_j,tmp
!      real(DP),dimension(0:num_cusps-1)::alphas
      real(kind=DP) :: char,tmpcos,tmpsin,tmpRe,tmpIm
      logical :: deb
!      integer :: sampletype,Q_start,Q_stop
      integer :: type ! even or odd =0,1
!      real(kind=DP) :: sample_norm ! normalise the sample
!      integer :: in_region0,in_region1,in_region2  ! counts how many times we visit each region
      integer :: icusp,jcusp,ind_vertex,ind_cusp
      integer::n_tmp,l_tmp
      real(DP)::Yw
      logical::sym_odd,sym_even
      real(kind=DP),dimension(2,2)::B
      sym_odd=.false.
      sym_even=.false.
      sym_odd=use_sym_odd
      sym_even=use_sym_even
!      write(*,*) 'in Vnl3_co_tot_cplxR=',R,' Y=',Y,' Q=',Q,' M0=',M0
!      real :: TIME,TIME2

!      in_region0=0              ! for debugging purpouses
!      in_region1=0
                                !      in_region2=0
!      write(*,*) 'in Vnl3_co_tot_cplx_char=',R,' Y=',Y,' Q=',Q,' M0=',M0
!      write(*,*) 'width=',width
   !   allocate(Xm(1-Q:Q))
      allocate(X_pb(1:num_cusps,1:num_cusps,1-Q:Q))
      allocate(Y_pb(1:num_cusps,1:num_cusps,1-Q:Q))
      allocate(char_vec(1:num_cusps,1:num_cusps,1-Q:Q))
!c$$$      if(allocated(V)) then
!c$$$         if(size(V,1).ne.num_cusps*(2*M0+1)) then
!c$$$            deallocate(V)
!c$$$            allocate(V(1:num_cusps*(2*M0+1),1:num_cusps*(2*M0+1)))
!c$$$         endif
!c$$$      else
!c$$$         allocate(V(1:num_cusps*(2*M0+1),1:num_cusps*(2*M0+1)))
!c$$$      endif
!      write(*,*) 'U=',size(V)
   
      if(Level.eq.0) then 
         write(*,*) 'ERROR(Vnl3): Level(P) is not set!!'
         stop
      endif
      call get_char(Level-1,char_i)
      if(abs(char_i)-1.gt.1.0E-16_DP) then
         write(*,*) 'The character is odd!!!'
         write(*,*) 'Chi(',Level-1,')=',char_i
         stop
      endif
      IPI2=dcmplx(0.0_DP,PI2)
!      width=cusp_width(1)

      ! We have to decide which type of sample to use in the DFT
      sampletype=1
      call get_points(Y,Q,X_pb,Y_pb,char_vec,width)

      do j=lbound(char_vec,1),ubound(char_vec,1)
         do k=lbound(char_vec,2),ubound(char_vec,2)
            do l=lbound(char_vec,3),ubound(char_vec,3)
         if((abs(char_vec(j,k,l)).ne.1.0D0).and.(Y_pb(j,k,l).gt.0.0D0)) &
     &        then 
            write(*,*) 'char(',j,k,l,')=',char_vec(j,k,l)
            write(*,*) 'Y_pb(',j,k,l,')=',Y_pb(j,k,l)
            stop
         endif
      enddo
      enddo
      enddo
 !     if(Y.eq.0.31) stop
!      call get_points(Y2,Q,X_pb,Y_pb,char_vec,width)
      call get_alphas()
!      write(*,*) 'alphas=',alphas(:)
      !! we have to see if there is any shifts present
!c$$$      do j=0,num_cusps-1
!c$$$         char_j=multiplier(cusp_fixer(j,:,:))
!c$$$         alphas(j)=argument(real(char_j,DP),dimag(char_j))/PI2
!c$$$      enddo
!      stop
      deb=.false.
      deb=.true.
      if(do_interp) then
         call setup_interp_kbes(R)                  
      endif
      do l=1,num_cusps*(2*M0+1)
         do n=1,num_cusps*(2*M0+1)
            V(l,n)=dcmplx(0.0_DP,0.0_DP)
         enddo
      enddo
!      write(*,*) 'Q_start,Q_stop=',Q_start,sample_stop
!      write(*,*) 'num_cusps=',num_cusps
      do l=-M0,M0
         if((sym_odd.or.sym_even).and.l.le.0) cycle
         do j=Q_start,Q_stop  
            do icusp=1,num_cusps
               do jcusp=1,num_cusps
                  ll=real(l,DP)+alphas(jcusp)
                  if(ll.eq.0.0) cycle
                  ypb=Y_pb(icusp,jcusp,j)
!                  write(*,*) 'l,ypb=',l,ypb
!                  if(l.eq.1) then
!                     write(*,*) 'll,ypb=',ll,ypb
!                  endif
                  if(ypb>0.0_DP) then ! the point is near the j:th-cusp)
                     xpb=X_pb(icusp,jcusp,j)
                     if(do_interp) then
                        rkbes = interp_kbes(PI2*abs(ll)*ypb) 
                     else
                        rkbes=Wf(R,PI2*abs(ll)*ypb)
!                        rkbes=Wf(R,PI2*abs(ll)*ypb)
                     endif
                     tmp = dcmplx(sqrt(ypb)*rkbes,0.0_DP)
!*               &
!     &                    char_vec(icusp,jcusp,j)          
!                     argpb=PI2*ll*xpb/width
                     argpb=PI2*ll*xpb
!c$$$                     if(((l.eq.-1).and.(icusp.eq.1).and.(jcusp.eq.        & 
!c$$$     &                    4).and.(j.le.2))) then
!c$$$                        write(*,*) 'xpb=',xpb                              
!c$$$                        write(*,*) 'ypb=',ypb
!c$$$                        write(*,*) 'rkbes(',PI2*abs(ll)*ypb,')*',         &
!c$$$     &                       'sqrt(Y)=',rkbes
!c$$$                     endif
!                     write(11,*) argpb,tmp
                     do n=-M0,M0
                        if((sym_odd.or.sym_even).and.n.le.0) cycle
                        nn=real(n,DP)+alphas(icusp)
                        if(nn.eq.0.0) then
                           cycle
                        endif
                        arg_m=PI2*nn*Xm(j)/width  !Xm is not pre-multiplied now
                                !                        arg_m=PI2*nn*Xm(j)
!                        if(sym_odd) then
!                           tmpVnl=tmp*sin(argpb)*sin(-arg_m)
!                        elseif(sym_even) then 
!                           tmpVnl=tmp*cos(argpb)*cos(arg_m)
!                        else
                           tmpVnl=tmp*exp(dcmplx(0.0_DP,argpb-arg_m))
!                        endif
                        n_tmp=n+M0+1+(icusp-1)*(2*M0+1)
                        l_tmp=l+M0+1+(jcusp-1)*(2*M0+1)
!                        V(tmp_n+M0+1+(icusp-1)*(2*M0+1),l+M0+1+(jcusp-1)*(2*M0+1)) = 
!                        if(l.eq.1) then
!                           write(*,*) 'tmpVnl=',tmpvnl
!                        endif
                        V(n_tmp,l_tmp)=V(n_tmp,l_tmp)+tmpVnl
                     enddo
                  endif
               enddo
            enddo
         enddo
      enddo
      do l=1,num_cusps*(2*M0+1)
         do n=1,num_cusps*(2*M0+1)
            V(n,l)=V(n,l)*dcmplx(sample_norm,0.0_DP)
         enddo
      enddo
      do n=-M0,M0
         if((sym_odd.or.sym_even).and.n.le.0) cycle
!         n_tmp=n+M0+1
!         write(*,*) n,n_tmp,V(n_tmp,n_tmp)
         do icusp=1,num_cusps
            nn=real(n,DP)+alphas(icusp)
            if(nn.eq.0.0) then
               cycle
            endif
            Yw=Y/width
            if(do_interp.and.(.not.(do_exceptional))) then
               write(*,*) 'NO!!!'
               rkbes = sqrt(Yw)*interp_kbes(PI2*abs(nn)*Yw) 
            else
               rkbes = sqrt(Yw)*Wf(R,PI2*abs(nn)*Yw)
            endif
            n_tmp=n+M0+1+(icusp-1)*(2*M0+1)
            V(n_tmp,n_tmp)=V(n_tmp,n_tmp)-dcmplx(rkbes,0.0_DP)
!            write(11,*) V(n_tmp,N_tmp)
!            write(11,*) PI2*abs(nn)*Y/width,rkbes

         enddo
      enddo
!      call clean_pullback()
!c$$$      do icusp=2,2
!c$$$         do n=1,3
!c$$$            n_tmp=n+M0+1+(icusp-1)*(2*M0+1)
!c$$$            write(*,*) 'V(',n_tmp,')=',V(1,N_tmp)
!c$$$         enddo
!c$$$      enddo
!      stop
!      close(11)
      end subroutine computeVnl3_co_tot_cplx_char




      ! Compute positive coefficients only 
      ! by using the sin/cos symmetry. 
      ! we have this also for complex characters!!
      subroutine computeVnl3_co_sym_cplx_char(R,Y,Q,M0,V,type)
      use commonvariables
      use groups
      use characters
      use interpolation
      implicit none
      integer :: Q,M0
      real(kind=DP) :: Y,R
      ! 0 = cos : 1 = sin
      complex(kind=DP),dimension(1:num_cusps*(M0+1),                     &
     &     1:num_cusps*(M0+1))::V     
      complex(kind=DP) ::IPI2
      complex(kind=DP) ::tmpVnl
      complex(kind=DP),dimension(1:num_cusps,1:num_cusps)::Vnl
      real(kind=DP) :: x_in,y_in,xpb,ypb,xtmp,ytmp,xtmp2,ytmp2
      real(DP)::nn,ll
      real(kind=DP) :: denom,rkbes,argpb,arg_m,tmpVR,tmpVIm
      real(kind=DP) :: tmpVR_even,tmpVIm_even,tmpVR_odd,tmpVIm_odd
      integer,dimension(2,2) :: pb_mapping
      integer,dimension(1-Q:Q) :: char_vec0,char_vec1
      ! indicates which series to connect with which point z_m
      integer :: ind,Nchar
      integer,dimension(2,2) :: map_tmp
      integer :: j,m,n,l,k,d
      complex(DP)::char_i,char_j,tmp
      real(kind=DP) :: char,tmpcos,tmpsin,tmpRe,tmpIm
      logical :: deb
!      integer :: sampletype,Q_start,Q_stop
      integer :: type ! even or odd =0,1
!      real(kind=DP) :: sample_norm ! normalise the sample
!      integer :: in_region0,in_region1,in_region2  ! counts how many times we visit each region
      integer :: icusp,jcusp,ind_vertex,ind_cusp
!      real :: TIME,TIME2
      real(kind=DP),dimension(2,2)::B
      logical::sym
      integer::n_tmp,l_tmp
!      write(*,*) 'in Vnl3_co_tot_cplxR=',R,' Y=',Y,' Q=',Q,' M0=',M0
!     &     'type=',type
      if(Level==0) then 
         write(*,*) 'ERROR(Vnl3): Level(P) is not set!!'
         stop
      endif
      call get_char(Level-1,char_i)
      if(abs(char_i)-1.gt.1.0E-16_DP) then
         write(*,*) 'The character is odd!!!'
         write(*,*) 'Chi(',Level-1,')=',char_i
         stop
      endif
      IPI2=dcmplx(0.0_DP,PI2)

      sym=.true.
 !     sym=.false.
      ! We have to decide which type of sample to use in the DFT
      sampletype=2
      call get_pb_points_cplx_char(R,Y,Q,sym)                                 
!     &     Q_start,Q_stop,sample_norm,sampletype,sym)

      call get_alphas()
    !  sample_norm=0.5_DP*sample_norm
      !! we have to see if there is any shifts present
!c$$$      do j=0,num_cusps-1
!c$$$         char_j=multiplier(cusp_fixer(j,:,:))
!c$$$         alphas(j)=argument(real(char_j,DP),dimag(char_j))/PI2
!c$$$      enddo
      deb=.false.
      if(do_interp) then
         call setup_interp_kbes(R)                  
      endif
         
      V(:,:)=dcmplx(0.0_DP,0.0_DP)
      do l=0,M0
         do j=Q_start,Q_stop  
            do icusp=1,num_cusps
               do jcusp=1,num_cusps
                  ll=real(l,DP)+alphas(jcusp)
                  if(ll.eq.0.0) then
                     cycle
                  endif
                  ypb=Y_pb_s(icusp,jcusp,j)
                  if(ypb>1.0E-30_DP) then ! the point is near the j:th-cusp)
                     xpb=X_pb_s(icusp,jcusp,j)
                     if(do_interp) then
                        rkbes = interp_kbes(PI2*abs(ll)*ypb) 
                     else
                        rkbes=Wf(R,PI2*abs(ll)*ypb)
                     endif
                     tmp = dcmplx(sqrt(ypb)*rkbes,0.0_DP)*               &
     &                    char_vec_c_s(icusp,jcusp,j)          
                     argpb=PI2*ll*xpb
!                     write(*,*) 'xpb=',xpb,' ypb=',ypb
!                     write(*,*) 'tmp(',l,')=',tmp
                     do n=0,M0
                        nn=real(n,DP)+alphas(icusp)
                        if(nn.eq.0.0) then
                           cycle
                        endif
                        arg_m=PI2*nn*Xm_s(j)
                        if(type.eq.0) then
                           tmpVnl=tmp*dcmplx(cos(argpb)*cos(arg_m),0.0)
                        else
                           tmpVnl=tmp*dcmplx(0,-sin(argpb)*sin(arg_m))
                        endif

                                !                        tmpVnl=tmp*exp(dcmplx(0.0_DP,argpb-arg_m))
                                !                        tmpVnl=tmp*exp(dcmplx(0.0_DP,argpb-arg_m))
                        n_tmp=n+1+(icusp-1)*(M0+1)
                        l_tmp=l+1+(jcusp-1)*(M0+1)            
                        V(n_tmp,l_tmp)=V(n_tmp,l_tmp)+tmpVnl
!                        V(n+1+icusp*(M0+1),l+1+jcusp*(M0+1))            &
!     &                       = V(n+1+icusp*(M0+1),l+1+                  &
!     &                       jcusp*(M0+1))+tmpVnl
                     enddo
                  elseif(ypb.gt.0) then
                     write(*,*) 'small Y=',ypb                     
                  endif
               enddo
            enddo
         enddo
      enddo
      V(:,:)=V(:,:)*dcmplx(sample_norm,0.0_DP)
      do n=0,M0
         do icusp=1,num_cusps
            nn=real(n,DP)+alphas(icusp)
            if(nn.eq.0.0) then
               cycle
            endif
            if(do_interp.and.(.not.(do_exceptional))) then
               rkbes = sqrt(Y)*interp_kbes(PI2*abs(nn)*Y) 
            else
               rkbes = sqrt(Y)*Wf(R,PI2*abs(nn)*Y)
            endif
!            write(*,*) 'rkbes=',rkbes
            n_tmp=n+1+(icusp-1)*(M0+1)
            V(n_tmp,n_tmp) = V(n_tmp,n_tmp)- dcmplx(rkbes,0.0_DP)       
!     &           = V(n+1+icusp*(M0+1),n+1+icusp*(M0+1))-                 &
!     &           dcmplx(rkbes,0.0_DP)
!            V(n+M0+1+icusp*(2*M0+1),n+M0+1+icusp*(2*M0+1))                  &
!     &           = V(n+M0+1+icusp*(2*M0+1),n+M0+1+icusp*(2*M0+1))-          &
!     &           dcmplx(rkbes,0.0_DP)
         enddo
      enddo
!      do j=1,num_cusps*(M0+1)
!         write(*,*) 'V(',j,')=',V(j,j)
!      enddo
!      stop
!      !! Now the entire matrix are done!!
      end subroutine computeVnl3_co_sym_cplx_char



   

      !!! Only get M0 corresponding to a given Y
      subroutine get_M0(R,M0,Y,eps_m)
      use commonvariables
      use groups
      implicit none
      real(kind=DP)::R,tmp,tmp1,tmp2,tmp3,wt
      real(DP),optional::eps_m
      real(DP)::Y,eps
      integer::M0,k
      if(present(eps_m)) then
         eps=eps_m
      else
         eps=1.0E-14_DP
      endif
      M0=0
      do k=1,10000
         if(weight.ne.0.0_DP) then
            wt=0.5_DP*weight         
                                !! To avoid hitting a zero
            tmp1=Wf(R,PI4*real(k,DP)*Y,wt)
            tmp2=Wf(R,PI4*real(k+1,DP)*Y,wt)
            tmp3=Wf(R,PI4*real(k+2,DP)*Y,wt)

         else
            tmp1=Wf(R,PI2*real(k,DP)*Y)
            tmp2=Wf(R,PI2*real(k+1,DP)*Y)
            tmp3=Wf(R,PI2*real(k+2,DP)*Y)
         endif
         tmp=(tmp1+tmp2+tmp3)/3.0_DP
         if(abs(tmp).lt.eps) then
            M0=k+1
            exit
         else
   !         write(*,*) 'tmp(',k,')=',tmp
         endif
      enddo
      if(M0.eq.0) then
         write(*,*) 'Error computing M0! =',M0
         write(*,*) 'e_R=',R,'Y=',Y,'eps=',eps_m
         write(*,*) 'tmp=',tmp
         
      endif
      end subroutine
      
      subroutine get_M0_Q_Y(R,M0,Q,Y,eps_m)
      use commonvariables
      use groups
      implicit none
      real(kind=DP)::R,Y0,tmp,nn,wt
      real(DP),optional::Y,eps_m
      integer :: M0,Q,k,l
      logical :: ok
!      write(*,*) 'get_M0_Q_Y(',R,M0,Q,Y,')'
      if(present(Y).and.(Y.gt.0.0)) then
         Y0=Y
      else
         if(Y0_min.gt.0.0) then 
            Y0=Y0_min          !! Start high
         else
            Y0=0.5D0
         endif
      endif
!      write(*,*) 'Y0=',Y0
!      write(*,*) 'eps0=',eps0
      ok=.false.
      k_loop: do k=1,1000
         if(R.eq.0.0) then
            M0=max(ceiling(real(40*Level,DP)/(sqrt(3.0_DP)*PI)),                            & 
     &           ceiling((R+12.0_DP*R**0.333)*real(Level,DP)/           &
     &           (sqrt(3.0_DP)*PI)))       
         else
            M0=(R+15.0_DP*R**(0.3333333333_DP))/(PI2*Y0)         
         endif
         if(M0.lt.Level) then
            Y0=0.99_DP*Y0
            cycle k_loop
         endif
!         write(*,*) 'Y=',Y,'M0=',M0,'width=',width,'weight=',weight
         nn=real(M0,DP)
         if(weight.eq.0) then
            tmp=abs(sqrt(Y0)*Wf(R,PI2*nn*Y0/width))
         else
            wt=0.5_DP*weight
            tmp=Wf(R,PI4*abs(nn*Y0),wt)
         endif 
          if(tmp.gt.eps0) then   ! should be about 10^-16 or so 
            do l=1,100          !     write(*,*) 'Y=',Y,'M0=',M0,'tmp=',abs(tmp)  
               M0=M0+2
               if(weight.eq.0) then
                  tmp=abs(sqrt(Y0)*Wf(R,PI2*real(M0,DP)*Y0))
!                  write(*,*) 'l=',l,' tmp=',tmp
               else
                  nn=real(M0,DP)
                  tmp=abs(Wf(R,PI4*abs(nn*Y0),wt))
                  if(do_exceptional) then
                     tmp=tmp/((PI4*abs(nn))**(0.5_DP*weight))
                  else  
                     tmp=tmp/sqrt(abs(nn))
                  endif
               endif
               if(tmp.lt.eps0) then
                  exit
               endif
            enddo
         endif
         Q=M0+10
!         Q=max(M0+10,ceiling(1.5*M0))
         call testY2(Y0,Q,ok)
         if(ok) then
            exit k_loop
         else
            Y0=0.99_DP*Y0            
         endif
      enddo k_loop
      if(.not.(ok)) then
         write(*,*) 'Could not find good M0,Y !!!'
         write(*,*) 'M0=',M0,' Y0=',Y0,' Q=',Q                               !         stop
      else
         Y=Y0
      endif     
      if(cycloidal) then
!         write(*,*) 'increasing M0 with ',width
         M0=M0*dnint(width)
      endif
!      write(*,*) 'M0=',M0,' Y=',Y,' Q=',Q                             
      end subroutine get_M0_Q_Y
      
!! This returns the smallest Y such that 
!! K_iR(2pi*M0*Y) > epsilon0
      subroutine get_Y_from_M(R,M0,Q,Y,N)
      use commonvariables
      use groups,only:Y0_min
      implicit none
      real(kind=DP)::R,Y0,tmp,nn,wt
      integer,optional::N
      real(DP)::Y
      integer :: M0,Q,k,l
      logical :: ok
      !! initial Y
!      write(*,*) 'eps0=',eps0
      if(Y.le.0.0D0) Y=1.0D0
!      write(*,*) 'Yinitial=',Y,' M=',M0
      ok=.false.
!     ! initial Y
      Y=min(Y,(R+15.0_DP*R**(0.3333333333_DP))/(PI2*real(M0,DP)))         
!      write(*,*) 'Ytest=',Y
      k_loop: do k=1,1000
         nn=real(M0,DP)
         if(weight.eq.0) then
            tmp=abs(sqrt(Y)*Wf(R,PI2*nn*Y))
         else
            wt=0.5_DP*weight
            tmp=abs(Wf(R,PI4*abs(nn*Y),wt))
         endif 
         if(tmp.gt.eps0) then   ! should be about 10^-16 or so 
            exit
         endif
         Y=0.99_DP*Y            
      enddo k_loop
!      write(*,*) 'M0=',M0,' Y=',Y,' Q=',Q !         stop
      if(cycloidal) then
!         write(*,*) 'increasing M0 with ',width
         M0=M0*dnint(width)
      endif
!      write(*,*) 'M0=',M0,' Y=',Y,' Q=',Q                             
      end subroutine get_Y_from_M
      


      subroutine testY2(Y,Q,ok)
      use commonvariables
      use groups
      use pullback
      implicit none
      real(kind=DP)::Y,Ymin,xtmp,ytmp
      integer :: Q,cuspi,cuspj
      integer :: j
      logical ::ok
      real(DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::X_pb,Y_pb
      complex(DP),dimension(1:num_cusps,1:num_cusps,1-Q:Q)::char_vec 
      ok=.false.
      Ymin=1.0D0
!      write(*,*) 'Testing Y=',Y
      call set_sampledata(1,Q)
      call get_1_pb_points(Y,Q,X_pb,Y_pb,char_vec)
!      write(*,*) 'here'
      do cuspi=1,num_cusps
         do cuspj=1,num_cusps
            do j=1-Q,Q
               ytmp=Y_pb(cuspi,cuspj,j)
               if(ytmp.gt.0.0) then               
                  if(Ymin.gt.ytmp) then 
                     Ymin=ytmp
                  endif
                  if(ytmp.lt.Y) then 
                     ok=.false.
                     return
                  endif
               endif
            enddo
         enddo
      enddo
 !     write(*,*) 'Ymin=',Ymin
 !     stop
!c$$$      do cusp=1,num_cusps     ! have to look at all cusps
!c$$$         do j=1-Q,Q
!c$$$            X = 0.5_DP*(real(j,DP)-0.5_DP)/real(Q,DP)
!c$$$            call seek_vertex(x,y,ind_vertex)
!c$$$            ! Remember this is sigma_j
!c$$$            ! We want N_I*Uw*sigma_j
!c$$$            B=sigma_j(cusp,:,:)
!c$$$            call apply_map_re(X,Y,xtmp,ytmp,B)
!c$$$            call pullback_to_gamma0N(Xtmp,Ytmp,xpb,ypb,d)               
!c$$$            call seek_vertex(xpb,ypb,ind_vertex)
!c$$$            call get_cusp_from_vertex(ind_vertex,ind_cusp)
!c$$$            call apply_map_int(xpb,ypb,xtmp,ytmp,Uw(ind_vertex,:,:)) ! sigma_j1=cuspnormalising map for cusp j
!c$$$            call gl_inverse(sigma_j(ind_cusp,:,:),B)
!c$$$            call apply_map_re(xtmp,ytmp,xtmp2,ytmp2) ! W1=cuspnormalising map for cusp j            
!c$$$            if(ytmp2.lt.Ymin) then
!c$$$               Ymin=ytmp2
!c$$$            endif
!c$$$         enddo
!c$$$      enddo
      if(Ymin.gt.(Y+0.001D0)) then        
!         write(*,*) 'BAD Y:',Y
!         write(*,*) 'Y_pb_min=',Ymin
         ok=.true.
      else
!         write(*,*) 'Y,Q is OK!',Y,Q
      endif
      end subroutine testY2


      ! FOr a fixed M0 and Y try to find good Q
      subroutine get_Q(M0,Q,Y)
      use commonvariables
      use groups
      implicit none
      real(kind=DP),intent(in)::Y
      integer,intent(in)::M0
      integer,intent(out) :: Q
      logical :: ok
      integer :: k
      
      if(Level.eq.0) then
         write(*,*) 'Group is not initialized!',' P=',Level
         stop
      endif
      if(Y.gt.0) then !If Y is set from outside we start with that value
      else
         write(*,*) 'this should be called with a set Y>0!'
         stop
      endif
      ok=.false.
                                ! We start with this
      Q=max(100,ceiling(1.3*M0))
      do k=1,100                                !         write(*,*) 'Y=',Y
         call testY2(Y,Q,ok)
         if(ok) then
            exit
         else
            Q=Q+1            
         endif
      enddo
      if(.not.(ok)) then
         write(*,*) 'Could not find good Q !!!'
         write(*,*) 'M0=',M0,' Y=',Y,' Q=',Q                               !         stop
      endif     
      end subroutine get_Q
      

      end module
      


