!     ! Module that contains routines for finding eigenvalues
      module find_eigenvalues
      use commonvariables
      use groups
      integer,save::findev_silent
      interface get_h
      module procedure get_h_c
      module procedure get_h_r
      end interface
      
      contains


      !! gs1 = grid size of the coarse grid which is used for interpolating 
      !! gs2 = grid size of the fine grid which is used for tests
      subroutine find_evs(N,R1,R2,gs1,gs2,listR,GTYPE,CH)
      use newton
      use system
      implicit none
      integer::N,gs1,gs2
      real(DP)::R1,R2
      character(1)::GTYPE
      integer::CH
      real(DP),dimension(:,:),allocatable::listR,tests,list_tmp
      real(DP),dimension(:),allocatable::grid0,grid1,grid2
      integer::i,j,k,M0,Q
      real(DP)::c,L1,L2,Y1,Y2,R11,R12,h,f,R01,R02
      real(DP),allocatable,dimension(:)::m,test,v_max
      real(DP),allocatable,dimension(:,:,:,:,:)::A1,A2
      real(DP),allocatable,dimension(:,:,:)::results
      real(DP),allocatable,dimension(:,:)::list_temp,list_temp2
      real(DP)::f01,f02,R0,h1(3),f11(10),h2(3),f12(10),t(3),fs(10)
      real(DP)::Rs,hs(3),delta,df1,df2,f21(10),f22(10),df0,dr
      integer::jj,N0,N1,type,num_res ,nev,num_tests,j1,j2,j3,l,i1,i2
      logical::grid_interp,low_prec_old
      c=0.9999D0                !! P(#([R1,L])=1)>c
!      if(.not.(grp_inited)) 
      call init_g(N)
      num_tests=3
      low_prec_old=low_prec
      low_prec=.true.  !! When searching it is ok with lower precision
      write(*,*) 'R1,R2=',R1,R2
      write(*,*) 'Gamma_0N=',Gamma_0N
      delta=mean_dist(R1,R2)

      L1=R1-delta*log(c*delta)
      L2=L1-delta*log(c)
      write(*,*) 'mean distance of eigenvalues=',delta
      write(*,*) 'delta*ln(c*delta)=',delta*log(c*delta)
      write(*,*) 'L1,L2=',L1,L2
      allocate(grid0(0:gs1))
      allocate(grid1(0:gs2))
!      do_interp=.true.
      Y1=Y0_min*0.98D0
      Y2=Y1*0.97D0
!      Y1=0.12371791482634838
!      Y2=0.11753201908503096
      write(*,*) 'Y=',Y1,Y2
      ant_tests=3
      allocate(n_tests(1:3,1:2),m(1:3),test(1:3))
      n_tests(1,:)=2
      n_tests(2,:)=3
      n_tests(3,:)=4
      m(:)=1.0D0
      use_two_y=.true.
      call set_norm(0)
      h=1E-7
      dr=1E-5_DP
!      R11=R1; R12=R1-delta*log(c)
      if(allocated(list_temp)) deallocate(list_temp)
      allocate(list_temp(1:1000,1:2))
      nev=0
      num_res=1000 
      allocate(results(1:num_res,1:2,1:num_tests+1))
      allocate(v_max(1:num_res))
      allocate(tests(0:N1,1:3))
      
      y_loop: do
      !! R12 is the right endpoint of the interval we are currently searching
         if(R12.eq.R1) then 
            stop
         endif
!!! Calculate an initial derivative to compare with
         call get_h(R1,h1,f11,f12,Y1,Y2,M0,Q,GTYPE,CH)
         call get_h(R1+dr,h2,f21,f22,Y1,Y2,M0,Q,GTYPE,CH)
         df1=sum(abs(f11(:)-f21(:)))/dr
         df2=sum(abs(f12(:)-f22(:)))/dr
         df0=max(df1,df2)
         write(*,*) 'df0_dr(',Y1,Y2,')=',df0
         if(df0.gt.100.0) then  !! We probably need new Y's to begin with
            Y1=0.99D0*Y1; Y2=0.99D0*Y2
            cycle Y_loop
         endif
         write(*,*) 'R1,R12=',R1,R12
         write(*,*) 'h1=',h1(:)
         write(*,*) 'f11=',f11(:)
         write(*,*) 'f12=',f12(:)
         R12=R1+sum(abs(f11(:)))/(2.0_DP*df1)
         write(*,*) 'R12=',R12
!      call test_Kbes_zero(R1,R12,Y1,M0)
!      call test_Kbes_zero(R1,R12,Y2,M0)
         if(maxval(abs(h1(:))).lt.eps0) then !! We have a zero here
            write(*,*) 'Got one eigenvale at R=',R1
         endif
      do j=0,100
         Rs=R1+(R2-R1)*real(j,DP)/100.0D0
         call get_h(Rs,h2,f11,f12,Y1,Y2,M0,Q,GTYPE,CH)
         call get_h(Rs+dr,h2,f21,f22,Y1,Y2,M0,Q,GTYPE,CH)
         df1=sum(abs(f11(:)-f21(:)))/dr
         df2=sum(abs(f12(:)-f22(:)))/dr
         write(17,*) Rs,df1
         write(18,*) Rs,df2
!         do i=1,3
!            jj=10+i
!            write(JJ,*) Rs,h2(i)
!         enddo
!         write(14,*) Rs,f21(3)
!         write(15,*) Rs,f22(3)
      enddo
      close(11);close(12);close(13);close(14);close(15)
      close(17);close(18)
      stop
         JJ=0
         r_loop: do while((R12.le.R2).and.(jj.le.10000))
            jj=jj+1
            write(*,*) '-------------------------------'
            write(*,*) 'R1,R2=',R1,R12
            write(*,*) 'Y1,Y2=',Y1,Y2
            call get_h(R12,h2,f21,f22,Y1,Y2,M0,Q,GTYPE,CH)
            write(*,*) 'h1=',h1(:)
            write(*,*) 'h2=',h2(:)
            write(*,*) 'f11=',f11(:)
            write(*,*) 'f21=',f21(:)
            write(*,*)
            write(*,*) 'f12=',f12(:)
            write(*,*) 'f22=',f22(:)
            df1=sum(abs(f11(:)-f21(:)))/(R12-R1)
            df2=sum(abs(f12(:)-f22(:)))/(R12-R1)
            write(*,*) 'df1_dr=',df1 
            write(*,*) 'df2_dr=',df2 
!            if((df1.gt.5.0*df2).or.(df2.gt.5.0*df1)) then
            if((df1.gt.3.0*df0).or.(df2.gt.3.0*df0)) then
           !! Something is wrong, maybe one of the Y's hit a zero of the K-Bessel
            !! Go back to the last step with differenct Y's
               write(*,*) 'The differences are too large!'
               
               Y1=0.995_DP*Y1; Y2=0.995_DP*Y2;
               call get_h(R1,h1,f11,f12,Y1,Y2,M0,Q,GTYPE,CH)
               call get_h(R1+dr,h1,f21,f22,Y1,Y2,M0,Q,GTYPE,CH)
               df1=sum(abs(f11(:)-f21(:)))/dr
               df2=sum(abs(f12(:)-f22(:)))/dr
               df0=max(df1,df2)
               write(*,*) 'New df0=',df0 
               if(df0.gt.100.0) then 
                  write(*,*) 'Too large df0=',df0 
                  cycle y_loop
               endif
               cycle r_loop
            endif
                                !! Let's compare 
            if(maxval(abs(h2(:))).lt.eps0) then !! We have a zero here

            elseif(sign_change(h1,h2,3)) then
               write(*,*) 'Got a sign change!'
            !! We might have a zero between R1 and R12
            !! Predict a zero between using a linear 
               do i=1,3
                  t(i)=R1-h1(i)*(R12-R1)/(h2(i)-h1(i))
!     write(*,*) 't(',i,')=',R1,'-',h1(i),'*',(r2-r1),'/',         &
!     &              (h2(i)-h1(i))
                  write(*,*) 't(',i,')=',t(i)
                  write(*,*) 'h2(',i,')=',h2(i)
                  write(*,*) 'h1(',i,')=',h1(i)
               enddo
            !! These prediction should of course be similar if we are close to a real zero
               Rs=sum(t(1:3))/real(size(t,1))
               R12=Rs
               cycle r_loop
            else                !! We might have missed a zero here
                                !! Investigating if the f is changed much
               df1=sum(abs(f11(:)-f21(:)))/(R12-R1)
               df2=sum(abs(f12(:)-f22(:)))/(R12-R1)
               write(*,*) 'df1_dr=',df1 
               write(*,*) 'df2_dr=',df2 
               write(*,*)
               if(max(df1,df2).lt.df0*3.0D0) then 
             !! We probably didn't miss anything and continue from R2
                  write(*,*) 'We did not miss any eigenvalues here!'
                  R1=R12
                  f11=f21
                  f12=f22
                  call get_h(R1+dr,h1,f21,f22,Y1,Y2,M0,Q,GTYPE,CH)
                  df1=sum(abs(f11(:)-f21(:)))/dr
                  df2=sum(abs(f12(:)-f22(:)))/dr
                  df0=max(df1,df2)
                  write(*,*) 'New df0=',df0 
               else
                  write(*,*) 'We probably missed some eigenvalues here!'
                  write(*,*) 'Take new right point in the middle!'
                  R12=R1+(R12-R1)*0.5_DP
                  cycle r_loop
                  
               endif
            endif
            R12=R12-delta*log(c*delta)
         enddo r_loop
      enddo y_loop
      low_prec=low_prec_old
      allocate(listR(1:nev,1:2))
      listR(1:nev,:)=list_temp(1:nev,:)
      end subroutine find_evs



      !! gs1 = grid size of the coarse grid which is used for interpolating 
      !! gs2 = grid size of the fine grid which is used for tests
!!! Used only for real coefficients and when we have Atkin-Lehner involutions
!!! e.g. use for weight zero and trivial or quadratic character      

      subroutine find_evs2(N,R1,R2,gs1,gs2,listR,GTYPE,CH)
      use newton
      use system
      use characters
      use giant_mod
      implicit none
      integer::N,gs1,gs2
      real(DP)::R1,R2
      character(1)::GTYPE
      integer::CH
      real(DP),dimension(:,:),allocatable::listR,tests,list_tmp
      real(DP),dimension(:),allocatable::grid0,grid1,grid2,gridR0,gridR1
      integer::i,j,k,M0,Q,yi
      real(DP)::delta,c,L1,L2,Y1,Y2,R11,R12,h,f,R01,R02,R,df,Y01,Y02
      real(DP),allocatable,dimension(:)::m,test,v_max
      real(DP),allocatable,dimension(:,:,:,:,:)::A
      complex(DP),allocatable,dimension(:,:,:,:)::B
      real(DP),allocatable,dimension(:,:,:)::results
      real(DP),allocatable,dimension(:,:)::list_temp,list_temp2
      real(DP)::f01,f02,R0,h1(3),h2(3),f21(10),f22(10),f11(10),f12(10)
      real(DP)::rtype,rs_type,h0,h00,R10,R20,R22
      integer::jj,N0,N1,type,num_res ,nev,num_tests,j1,j2,j3,l,i1,i2
      integer::M00,M000,num_comb,index_in,sym_type,i0,i00
      integer::type0,type1,sym0,sym1
      logical::grid_interp
      if(findev_silent.ge.0) then 
         write(*,*) 'In find eigenvalues: silent=',findev_silent
      endif
      c=0.95D0  !! P(#([R1,L])=1)>c
!      if(.not.(grp_inited)) 
      call init_g(N)
      N0=gs1
      N1=gs2
      if(gamma_0N) then 
         delta=12.0D0/((R1+R2)*real(real_num_cosets,DP))
      elseif(hecke_triangle) then
         delta=real(hecke_q,DP)/real(hecke_q-2,DP)/(R1+R2)
      endif
      L1=R1-delta*log(c*delta)
      L2=L1-delta*log(c)
      
      if(findev_silent.gt.1) then 
         write(*,*) 'R1,R2=',R1,R2
         write(*,*) 'Gamma_0N=',Gamma_0N
         write(*,*) 'mean distance of eigenvalues in [R1,R2]=',delta
         write(*,*) 'L1,L2=',L1,L2
      endif
      Y1=Y0_min*0.97_DP
      Y2=Y1*0.99_DP
      use_two_y=.true.
      call set_norm(0)      !!! Here the coefficients are set - use default c(0)=0 and c(1)=1
      h=1E-7
      if(allocated(list_temp)) deallocate(list_temp)
      allocate(list_temp(1:1000,1:4))
      nev=0
      num_res=1000 
      if(do_real) then 
         num_tests=3
      else
         num_tests=6
      endif
      ant_tests=3
      allocate(n_tests(1:num_tests,1:2),m(1:num_tests),                   &
     &     test(1:num_tests))
      m(:)=1.0D0
      n_tests(1,:)=2
      n_tests(2,:)=3
      n_tests(3,:)=4
      allocate(results(1:num_res,1:2,1:num_tests+1))
      allocate(v_max(1:num_res))
      allocate(tests(0:N1,1:num_tests))
      call get_cusp_combinations()
      if(findev_silent.gt.0) then 
         do j=lbound(norm_cusp_combs,1),ubound(norm_cusp_combs,1)
            write(*,*) 'sym_type',j,'=',norm_cusp_combs(j,:)
         enddo
      endif
      num_comb=num_norm_cusp_combs
      if((CType.le.1).and.(weight.eq.0.0).and.((2**(num_cusps-1).eq.                &
     &     num_comb-1).or.(num_cusps.eq.1))) then 
         do_real=.true.
      else
         do_real=.false.
      endif
!      do_real=.false.
      if(findev_silent.gt.0) then 
         write(*,*) 'num_comb=',num_comb
         write(*,*) 'Do real=',do_real
      endif
      if(findev_silent.gt.1) then 
         write(*,*) 'R1,R2=',R1,R2
         write(*,*) '-----------------------------'
      endif
      !! If the difference between R1 and R2 is not too large we prefer to use constant 
      !! stepsize to make things more efficient
      
      !! Let's first split [R1,R2] into intervals of the length min(R2-R1,1,N1/delta)
      !! so we have on average at most 1 eigenvalue in each box of the coarse grid0
      h0=min(1.0,(R2-R1)/(real(N0,DP)*delta))
      i0=ceiling((R2-R1)/h0)
      h00=(R2-R1)/real(i0,DP)        !! Adjust h0 to fit exactly i0 pieces into [R1,R2]
      if(findev_silent.gt.1) then 
         write(*,*) '(r2-r1)/(n0*delta)=',(R2-R1)/(real(N0,DP)*delta)
         write(*,*) 'h0=',h00
      endif
      if(allocated(gridR0)) deallocate(gridR0)
      allocate(gridR0(0:i0))
      call makegrid(R1,R2,i0,gridR0)
!
      do i=0,i0-1
         R10=gridR0(i)          !! Look in [R10,R20]
         R20=gridR0(i+1)      
         if(findev_silent.gt.0) then 
            write(*,*) 'h=',h
            write(*,*) 'R10,R20=',R10,R20
         endif
         call get_M0_Q_Y(R22,M0,Q,Y1) ! Use the same M0 in [R11,R22]
         M000=max(M0-10,10)
         M00=min(10,M0)

         !! In [R10,R20] I use the same constant gridsize h
         h0=(R20-R10)/real(N0,DP)
         if(allocated(gridR1)) deallocate(gridR1)
         allocate(gridR1(0:N0))
         call makegrid(R10,R20,N0,gridR1)
!         R11=R10
         if(findev_silent.gt.0) then 
            write(*,*) 'gridR1=',gridR1(:)
            write(*,*) 'N0=',N0
            write(*,*) 'h0=',h0
         endif
         do j=0,N0-1,2
            if(allocated(grid0)) deallocate(grid0) 
            allocate(grid0(0:N0))
            if(j.eq.n0-1) then 
               R11=gridR1(N0-1); R12=gridR1(N0)
               I1=6; I2=7  !! The index of starting points of grid1 in grid0
               call makegrid(R11-h0*6.0_DP,R12+6.0_DP*h0,N0,grid0)
            else
               R11=gridR1(j); R12=gridR1(j+2)
               I1=6; I2=8  !! The index of starting points of grid1 in grid0
               call makegrid(R11-h0*6.0_DP,R12+5.0_DP*h0,N0,grid0)
            endif
!            call makegrid(R11-h0*6.0_DP,R12+5.0_DP*h0,N0,grid0)

            if(findev_silent.gt.0) then 
               write(*,*) 'h=',h,' j=',j
               write(*,*) 'R11,R12=',R11,R12
!               cycle
            endif
            if(R11.gt.R20) exit
            index_in=j
            if(allocated(grid1)) deallocate(grid1) 
            allocate(grid1(0:N1))
            call makegrid(R11,R12,N1,grid1)
            if(findev_silent.gt.0) then 
               write(*,*) 'N0=',N0       
               write(*,*) 'N1=',N1       
               write(*,*) 'size(grid0)=',size(grid0,1)
               write(*,*) 'size(grid1)=',size(grid1,1)
               write(*,*) 'grid0=',grid0(0),':',grid0(N0)
               write(*,*) 'grid1=',grid1(0),':',grid1(N1)
            endif
!            cycle
            grid_interp=.true.
!            grid_interp=.false.
            if(do_real) then
               type0=0; type1=1; 
               sym0=1; sym1=num_comb-1
               if(num_cusps.eq.1) sym1=1
            else
               type0=0; type1=0
               sym0=1; sym1=num_comb-1
            endif
            if(do_real) then
               if(allocated(A)) deallocate(A)
               allocate(A(1:2,0:N1,1:M00,type0:type1,sym0:sym1))
               call get_gridcoef_2y_real_new(Y1,Y2,M000,Q,N0,N1,I1,I2,                                  &
     &              M00,grid0,grid1,A(:,:,:,:,:),sym0,sym1,j,do_interp,           &
     &              grid_interp)         
            else
               if(findev_silent.gt.1) then 
                  write(*,*) 'Do_real=false! M0=',M0,' M00=',M00,                &
     &                 ' M000=',M000
                  write(*,*) 'Y1,Y2=',Y1,Y2
               endif
               if(allocated(B)) deallocate(B)
               allocate(B(1:2,0:N1,1:M00,sym0:sym1))
               call get_gridcoef_2y_cplx_new(Y1,Y2,M000,Q,N0,N1,I1,I2,                                  &
     &              M00,grid0,grid1,B(:,:,:,:),num_comb,j,do_interp,           &
     &              grid_interp)         
            endif
               do_interp=.false.
            call choose_i1i2i3(j1,j2,j3,M0)
            if(findev_silent.gt.1) then 
               write(*,*) 'tests=',j1,j2,j3
            endif
            !!! Here is the crucual part if we have real or complex coefficients
            do type=type0,type1
               rtype=real(type,DP)
               do sym_type=sym0,sym1
                  if((findev_silent.ge.4).and.(sym_type.eq.sym0).and.       &
     &                 (type.eq.1)) then
                     if(grid_interp) then
                        open(UNIT=12,FILE='h_test2.in.txt',                &
     &                       position='APPEND')
                        open(UNIT=13,FILE='h_test3.in.txt',                &
     &                       position='APPEND')
                        open(UNIT=14,FILE='h_test4.in.txt',                &
     &                       position='APPEND')
                     else
                        open(UNIT=12,FILE='h_test2.ni.txt',                &
     &                       position='APPEND')
                        open(UNIT=13,FILE='h_test3.ni.txt',                &
     &                       position='APPEND')
                        open(UNIT=14,FILE='h_test4.ni.txt',                &
     &                       position='APPEND')
                     endif
                  endif

                  if(findev_silent.gt.1) then 
                     write(*,*) 'Studying Symmetry type:,',type,':',       &
     &                    sym_type,'e=',norm_cusp_combs(sym_type,:)
                     write(*,*) 'In ',grid1(0),':',grid1(N1) 
                     write(*,*) 'do_real=',do_real
                  endif
                  rs_type=real(sym_type,DP)
                  if(do_real) then 
                     do jj=0,N1
                        tests(jj,1)=A(1,jj,j1,type,sym_type)-            &
     &                       A(2,jj,j1,type,sym_type)
                        tests(jj,2)=A(1,jj,j2,type,sym_type)-            &
     &                       A(2,jj,j2,type,sym_type)                  
                        tests(jj,3)=A(1,jj,j3,type,sym_type)-               &
     &                       A(2,jj,j3,type,sym_type)         
!                        if((findev_silent.ge.4).and.(j.eq.8).and.         &
!     &                       (type.eq.1).and.(sym_type.eq.2)) then
!                           write(*,*) 'R(',jj,')=',grid1(jj)
!                        endif
                        if((jj.eq.136).and.(abs(grid1(jj)-3.45).lt.        &
     &                          0.01)) then 
                           write(*,*) 'R=',grid1(jj)
                           write(*,*) 'tests(1)=',                            &
     &                          A(1,jj,j1,type,sym_type),'-',                 &
     &                          A(2,jj,j1,type,sym_type),'=',                 &
     &                          tests(jj,1)
                           write(*,*) 'tests(2)=',                         &
     &                          A(1,jj,j2,type,sym_type),'-',             &
     &                          A(2,jj,j2,type,sym_type),'=',                 & 
     &                          tests(jj,2)
                           write(*,*) 'tests(3)=',                         &
     &                          A(1,jj,j3,type,sym_type),'-',              &
     &                          A(2,jj,j3,type,sym_type),'=',                 &
     &                          tests(jj,3)
                        endif
                        if((findev_silent.ge.4).and.(sym_type.eq.sym0)     &
     &                       .and.(type.eq.1)) then 
                           write(12,*) grid1(jj),tests(jj,1) 
                           write(13,*) grid1(jj),tests(jj,2) 
                           write(14,*) grid1(jj),tests(jj,3) 
                        endif
                     enddo
                  else
                     do jj=0,N1
                        tests(jj,1)=real(B(1,jj,j1,sym_type),DP)            &
     &                       -real(B(2,jj,j1,sym_type),DP)
                        tests(jj,4)=dimag(B(1,jj,j1,sym_type))-                 &
     &                       dimag(B(2,jj,j1,sym_type))
                        tests(jj,2)=real(B(1,jj,j2,sym_type),DP)            &
     &                       -real(B(2,jj,j2,sym_type),DP)
                        tests(jj,5)=dimag(B(1,jj,j2,sym_type))-                 &
     &                       dimag(B(2,jj,j2,sym_type))
                        tests(jj,3)=real(B(1,jj,j3,sym_type),DP)            &
     &                       -real(B(2,jj,j3,sym_type),DP)
                        tests(jj,6)=dimag(B(1,jj,j3,sym_type))-                 &
     &                       dimag(B(2,jj,j3,sym_type))
                        if((findev_silent.ge.4).and.(sym_type.eq.sym1))     &
     &                       then 
                           write(12,*) grid1(jj),tests(jj,1) 
                           write(13,*) grid1(jj),tests(jj,2) 
                           write(14,*) grid1(jj),tests(jj,3) 
                        endif
                        if(findev_silent.ge.4) then 
                           if((jj.eq.132).and.(abs(grid1(jj)-8.75).lt.        &
     &                          0.1)) then 
                              write(*,*) 'R=',grid1(jj)
                              write(*,*) 'tests(1)=',                     &
     &                             real(B(1,jj,j1,sym_type),DP),'-',     &
     &                             real(B(2,jj,j1,sym_type),DP)
                              write(*,*) 'tests(2)=',                    &
     &                             real(B(1,jj,j2,sym_type),DP),'-',     &
     &                             real(B(2,jj,j2,sym_type),DP)
                              write(*,*) 'tests(3)=',                    &
     &                             real(B(1,jj,j3,sym_type),DP),'-',     &
     &                             real(B(2,jj,j3,sym_type),DP)
                              write(*,*) 'tests(4)=',                    &
     &                             dimag(B(1,jj,j1,sym_type)),'-',       &
     &                             dimag(B(2,jj,j1,sym_type))
                              write(*,*) 'tests(5)=',                    &
     &                             dimag(B(1,jj,j2,sym_type)),'-',        &
     &                             dimag(B(2,jj,j2,sym_type))
                              write(*,*) 'tests(6)=',                    &
     &                             dimag(B(1,jj,j3,sym_type)),'-',       &
     &                             dimag(B(2,jj,j3,sym_type))

                           endif
                        endif
                     enddo
                  endif
                  if(findev_silent.eq.4) then 
                     close(12)
                     close(13)
                     close(14)
                  endif
                  if((type.eq.0).and.(j.eq.8)) then
                     call check_tests(grid0,N0,grid1,N1,tests(0:N1,          &
     &                    1:3),3,results,num_res,v_max,.false.)                              
                  else
                     call check_tests(grid0,N0,grid1,N1,tests(0:N1,          &
     &                    1:3),3,results,num_res,v_max,.false.)                              
                  endif
!                  stop
!     !     Look at all the points where we had either simultenaous sign-changes or some singularity
                     if(maxval(results(:,1,1)).gt.0) then !! We have some candidates
                        do l=1,num_res
                           if((results(l,2,1).ne.0.0).and.(v_max(l).gt.       &
     &                          100.0)) then     !! Recheck with different Y-values 
                              R01=results(l,1,1); R02=results(l,2,1)
                              Y01=Y1; Y02=Y2
                              do yi=1,3 !! If we can not decide whether there is a zero or not for three different Y's there shouldn't be any zero there
                                 Y01=0.97D0*Y01; Y02=0.97*Y02
                                 call get_M0_Q_Y(R02,M0,Q,Y01)
                                 call set_cusp_norm(norm_cusp_combs(       &
     &                                sym_type,:))
!                                 write(*,*) 'which_c=',which_c(:,:)
!                                 write(*,*) 'num_set=',num_set
!                                 write(*,*) 'c_set=',c_set(:)
                                 if(do_real) then 
                                    call get_h(R01,h1,f11,f12,Y01,Y02,    &
     &                                   type,sym_type,M0,Q,GTYPE,CH)
                                    call get_h(R02,h2,f21,f22,Y01,Y02,     &
     &                                   type,sym_type,M0,Q,GTYPE,CH)
                                 else
                                    call get_h(R01,h1,f11,f12,Y01,Y02,       &
     &                                   M0,Q,GTYPE,CH)
                                    call get_h(R02,h2,f21,f22,Y01,Y02,       &
     &                                   M0,Q,GTYPE,CH)
                                 endif
                                 df=maxval(abs(h1(:)-h2(:)))/(R02-R01)
                                 if(sign_change(h1,h2,3).and.(df.le.      &
     &                                50.0_DP)) then 
                                !! This is a real candidate for a zero
                                    if(findev_silent.gt.0) then 
                                       write(*,*) '[',R01,',',R02,        &
     &                                      '] has zero'
                                    endif
                                    exit
                                 elseif((df.le.50.0_DP).or.((df.le.1000.  &
     &                                   0).and.(.not.(sign_change(h1,    &
     &                                   h2,3))))) then 
                                    if(findev_silent.gt.0) then 
                                       write(*,*) '[',R01,',',R02,        &
     &                                      '] no zero'
                                    endif
                                !! Set to zero so we can ignore it in the next loop
                                    results(l,2,1)=0.0_DP
                                    exit
                                 else ! Here either df>50 and we have sign change or df>1000 and we have no sign change
                                ! bothe these cases needs to be investigated further
                                    if(findev_silent.gt.0) then 
                                       write(*,*) '[',R01,',',R02,'] ',    &
     &                                      'maybe  zero  redo !'
                                       write(*,*) 'Y1,Y2=',Y01,Y02,        &
     &                                      ' df=',df
                                       write(*,*) 'signchange=',                &
     &                                      sign_change(h1,h2,3)
                                    endif
                                    cycle
                                 endif
                              enddo
                           endif
                        enddo
!                        write(*,*) 'after check1!'
!     !        Now we should have a list of intervals where there really are eigenvalues               
                  if(maxval(results(:,1,1)).gt.0) then !! We have some candidates
                     do l=1,num_res
!                        write(*,*) 'l1=',l
                        if(results(l,2,1).ne.0.0) then
                           R01=results(l,1,1); R02=results(l,2,1)
                           f01=results(l,1,2); f02=results(l,2,2)
                           if(findev_silent.gt.1) then 
                              write(*,*) 'resultS(',l,',1,:)=',                    &
     &                             results(l,1,:)
                              write(*,*) 'resultS(',l,',2,:)=',                    &
     &                             results(l,2,:)
                           endif
                           call get_one_ev(R01,R02,f01,f02,R0,f,                   &
     &                          type,sym_type,GTYPE,CH)
                           if(abs(f).lt.1E-5) then !! Add this eigenvalue to the list 
                              nev=nev+1
                              if(nev.le.ubound(list_temp,1)) then
                                 list_temp(nev,1:4)=(/R0,rtype,                 &
     &                                rs_type,f/)
                              else 
                                 if(allocated(list_temp2))                         &
     &                                deallocate(list_temp2)
                                 allocate(list_temp2(                              &
     &                                1:ubound(list_temp,1),1:4))
                                 list_temp2=list_temp
                                 deallocate(list_temp)
                                 allocate(list_temp(                               &
     &                                1:ubound(list_temp2,1)+1000,1:4))
                                 list_temp(1:ubound(list_temp2,1),1:4)=               &
     &                                list_temp2
                                 deallocate(list_temp2)
                                 list_temp(nev,:)=(/R0,rtype,rs_type,f/)
                              endif
                           else
                              if(findev_silent.gt.0) then 
                                 write(*,*) '[',R01,',',R02,'] no zero'
                              endif
                           endif
                        endif
                     enddo
                  endif
               endif
            enddo               ! enddo sym_type
         enddo                  !enddo type=0,1
         if(findev_silent.gt.0) then 
            write(*,*) 'Checked [',R11,',',R12+h,']'
!            write(*,*) 'Checked [',gridR1(j),',',gridR1(j+2),']'
         endif
         if(findev_silent.gt.0) then 
            if(j+4.le.N0) then
               write(*,*) 'Next is [',gridR1(j+2),',',gridR1(j+4),']'
            else
               write(*,*) 'Next is [',R12+h,',',gridR1(N0),']'
            endif
         endif
!         write(*,*) 'j=',j
         if(R12+h.ge.gridR1(N0)) exit
      enddo
      enddo
      allocate(listR(1:nev,1:4))
      listR(1:nev,1:4)=list_temp(1:nev,1:4)
      call clean_pullback()
      call clean_giant_mod()
      end subroutine find_evs2



      subroutine get_one_ev(R1,R2,f1,f2,R0,f,type,sym_type,GTYPE,CH)
      use newton
      implicit none
      real(DP)::R1,R2,R0,f,f1,f2
      character(1)::GTYPE
      integer::type,sym_type
      integer::CH
      real(DP),dimension(:),allocatable::CPO
      complex(DP),dimension(:),allocatable::DPO
      complex(DP)::ec(1:num_cusps)
      real(DP)::Rtmp,NR_eps,NR_err,e(1:num_cusps)
      integer::i,j,k
      if(findev_silent.gt.1) then 
         write(*,*) 'Calling Newtons method R1,R2,f1,f2=',R1,R2,f1,f2
      endif
      Rtmp=prediction(R1,R2,f1,f2)
      if((Rtmp.lt.R1).or.(Rtmp.gt.R2)) then 
         Rtmp=0.5*(R1+R2)
      endif
      if(NR_eps.eq.0.0_DP) NR_eps=1E-12_DP
      !! We want to use symmetry type
      newton_silent=findev_silent
      if(do_real) then 
         e(:)=real(norm_cusp_combs(sym_type,:),DP)
         call get_eigenv_by_NR_RE(R1,R2,Rtmp,                               &
     &        R0,type,e,NR_eps,NR_err,CPO)
         if(NR_err.lt.1000.0D0) then 
            if((findev_silent.gt.1).AND.(allocated(cPO))) then 
               do i=lbound(cPO,1),min(ubound(cPO,1),10)
                  write(*,*) 'CPO(',i,')=',cPO(i)
               enddo
            endif
         endif
      else
         ec(:)=dcmplx(norm_cusp_combs(sym_type,:),0.0_DP)
         call get_eigenv_by_NR_w_newer(R1,R2,Rtmp,R0,NR_eps,NR_err         &
     &        ,DPO,ec)
!         if((findev_silent.gt.1).AND.(allocated(DPO))) then 
         if(NR_err.lt.1000.0D0) then 
            do i=lbound(DPO,1),3
               write(*,*) 'DPO(',i,')=',DPO(i)
            enddo
         endif
      endif
      
      f=NR_err
      if(findev_silent.gt.1) then 
         write(*,*) 'Got R=',R0,' err=',NR_err
      endif
      call clean_newton()
      end subroutine








      subroutine get_h_c(R,h,f1,f2,Y1,Y2,M,Q,GTYPE,CH)
!      use sys_solve,only:set_norm,set_normalization
      use coefficients,only:compute_coeffs
      use sys_solve
      implicit none
      real(DP)::R,Y1,Y2,h(3),f1(10),f2(10)
      character(1)::GTYPE
      integer::CH,M,Q,i,j
      complex(DP),dimension(:,:),allocatable::C1,C2
      complex(DP),dimension(:,:),allocatable::CN1,CN2
      if(.not.(set_normalization)) then 
!         write(*,*) 'set_norm'
         call set_norm(0)
      endif
      call compute_coeffs(R,C1,CN1,M,Y1,Q)
      call compute_coeffs(R,C2,CN2,M,Y2,Q)
!      do j=1,5
!         write(*,35) 1,j,C2(1,j)
!      enddo
!      write(*,*) '----------'
      h(1)=C1(1,2+1)-C2(1,2+1)
      h(2)=C1(1,3+1)-C2(1,3+1)
      h(3)=C1(1,4+1)-C2(1,4+1)
      f1(:)=0.0D0
      f2(:)=0.0D0
      do i=2,min(ubound(C1,2),10)
         f1(i)=C1(1,i)
         f2(i)=C2(1,i)
      enddo
 35   FORMAT('C(',I5,'',I5,')=',F22.16,5X,ES8.2)   
      end subroutine get_h_c

      subroutine get_h_r(R,h,f1,f2,Y1,Y2,type,sym_type,M,Q,GTYPE,CH)
!      use sys_solve,only:set_norm,set_normalization
      use coefficients
      use sys_solve
      implicit none
      integer::type,sym_type
      real(DP)::e(1:num_cusps)
      real(DP)::R,Y1,Y2,h(3),f1(10),f2(10)
      character(1)::GTYPE
      integer::CH,M,Q,i,j
      real(DP),dimension(:,:),allocatable::C1,C2
      if(.not.(set_normalization)) then 
!         write(*,*) 'set_norm'
         call set_norm(0)
      endif
      e(:)=real(norm_cusp_combs(sym_type,:),DP)
      call compute_coeffs_real(R,C1,type,e,M,Q,Y1)
      call compute_coeffs_real(R,C2,type,e,M,Q,Y2)
!      do j=1,5
!         write(*,35) 1,j,C2(1,j)
!      enddo
!      write(*,*) '----------'
      h(1)=C1(1,2+1)-C2(1,2+1)
      h(2)=C1(1,3+1)-C2(1,3+1)
      h(3)=C1(1,4+1)-C2(1,4+1)
      f1(:)=0.0D0
      f2(:)=0.0D0
      do i=2,min(ubound(C1,2),10)
         f1(i)=C1(1,i)
         f2(i)=C2(1,i)
      enddo
 35   FORMAT('C(',I5,'',I5,')=',F22.16,5X,ES8.2)   
      end subroutine get_h_r

      function sign_change(h1,h2,k)
      implicit none
      logical::sign_change
      integer::k,i
      real(DP)::h1(k),h2(k)
      sign_change=.true.
      do i=1,k
         if(h1(i)*h2(i).gt.0.0D0) then 
            sign_change=.false.; return
         endif
      enddo
      end function 
      !! Returns the mean distance between eigenvalues 
      ! in the range [R1,R2]

      function mean_dist(R1,R2)
      use groups
      implicit none
      real(DP)::R1,R2,mean_dist
      mean_dist=1.0D0
      if(gamma_0N) then 
         mean_dist=12.0D0/((R1+R2)*real(real_num_cosets,DP))
      elseif(hecke_triangle) then
         mean_dist=real(hecke_q,DP)/real(hecke_q-2,DP)/(R1+R2)
      endif
      end function 



      subroutine test_Kbes_zero(R1,R2,Y,M)
      use kbessel
      implicit none
      real(DP)::R1,R2,Y,R,kbes,min,rmin
      integer::i,j,n,M,nmax,nmin,jmax
      write(*,*) 'kbes_zero:',R1,R2,Y,M
      jmax=1000
      min=1.0D0
      nmin=1
      do n=1,M
         do j=0,jmax
            R=R1+(R2-R1)*real(j,DP)/real(jmax,DP)
            kbes=RKBessel(R,PI2*real(n,DP)*Y)
            if(abs(kbes).lt.min) then 
               min=kbes
               Rmin=R
!               write(*,*) 'Rmin=',R
!               write(*,*) 'Kmin=',kbes
!               write(*,*) 'n=',n
!               write(*,*) 'j=',j
               nmin=n
            endif
         enddo
      enddo
      write(*,*) 'Minval:'
      write(*,*) 'K_{I*',Rmin,',',PI2*n*Y,'}=',min
      write(*,*) 'n=',nmin
      end subroutine


      end module
