!!! MODULE graphics
!!! Description: Module that contains routines to draw fundamental polygons or plot functions
      module graphics
      use commonvariables
      use groups
      
      contains
 ! Make a metapost plot
      subroutine draw_polygon(disk_mod)
      use pullback
      use system
      implicit none
      ! Store a triangle for each coset 
      ! the triangles are maps of the original fundamental 
      ! triangle
      real(kind=DP)::x0,y0,x1,y1,x,y,v
      real(kind=DP),dimension(3,3,2)::triangle_out,triangle_tmp
      real(kind=DP),dimension(3,3,2)::triangle_in
      real(kind=DP),dimension(3,2)::s1,s2,s3
      real(kind=DP),dimension(2,2)::tmp_map,B
      character(LEN=20)::FILENAME
      integer :: j,k,ix
      logical::disk_mod
      integer::Q,icusp,jcusp
!   ,dimension(1:real_num_cosets,1:3,1:2)::triangles
      

! s1=  [ioo, (-0.5,sqrt(3)/2]
! s2=  [(-0.5,sqrt(3)/2),(0.5,sqrt(3)/2)]
! s3=  [(0.5,sqrt(3)/2),ioo]
      x0=-0.5_DP
      y0=0.5_DP*sqrt(3.0_DP)
      x1=0.5_DP
      y1=0.5_DP*sqrt(3.0_DP)
      v=real(cusp_width(1),DP)
      ! basically (x2=0, y2=oo)
      FILENAME = 'mpFD'//trim(integer_to_char(Level))//'.mp'
      write(*,*) 'Writing to:',FILENAME
 
      open(unit=12,file=FILENAME)
      write(12,*) 'input mp-tool;'
      write(12,*) 'beginfig(1);'
      write(12,*) 'path drawing;'
      write(12,*) 'pair cor;'
      write(12,*) 'pickup pencircle scaled 1pt;'
      write(12,*) 'u=10cm; width=279.4mm; height=215.9mm;'
      write(12,*) 'def draw_panint(expr P, colInt, colPer) ='
      write(12,*) 'fill fullcircle scaled 1.5mm shifted P withcolor ',  &
     &     'colInt;'
      write(12,*) 'draw fullcircle scaled 1.5mm shifted P withcolor ',  &
     &     'colPer;'
      write(12,*) 'enddef;'
                                !      write(12,*) 'u=10cm; width=379.4mm; height=415.9mm;'
      if(disk_mod) then
         write(12,*) 'cor=(u,u);'
         write(12,*) 'z01=(-1*u,0.0)+cor;'
         write(12,*) 'z02=(0,1.0*u)+cor;'
         write(12,*) 'z03=(1*u,0)+cor;'
         write(12,*) 'z04=(0,-1*u)+cor;'
!! should draw the boundary of the disk too
      else
         write(12,*) 'cor=(0.5*u,0.1*u);'
         if(v.eq.1.0_DP) then
            write(12,*) 'z01=(-0.51*u,0.0)+cor;'
            write(12,*) 'z02=(0.51*u,0.0)+cor;'
            write(12,*) 'z03=(0.51*u,2u)+cor;'
            write(12,*) 'z04=(-0.51*u,2u)+cor;'         
         else
            write(12,*) 'z01=(-0.5*u,0.0)+cor;'
            write(12,*) 'z02=(',(v+0.5D0),'*u,0.0)+cor;'
            write(12,*) 'z03=(',(v+0.5D0),'*u,2u)+cor;'
            write(12,*) 'z04=(-0.5*u,2u)+cor;'         
         endif
      endif
      triangle_in(1,1,:)=(/x0,-1.0_DP/)
      triangle_in(1,2,:)=(/x0,y0+1.0_DP/)
      triangle_in(1,3,:)=(/x0,y0/)
      triangle_in(2,1,:)=(/x0,y0/)
      triangle_in(2,2,:)=(/0.0_DP,1.0_DP/)
      triangle_in(2,3,:)=(/x1,y1/)
      triangle_in(3,1,:)=(/x1,y1/)
      triangle_in(3,2,:)=(/x1,y1+1.0_DP/)
      triangle_in(3,3,:)=(/x1,-1.0_DP/)

      call show_cosets()

      do j=1,real_num_cosets
         call apply_map_to_triangle(real(reps(j,:,:),DP),triangle_in,             &
     &     triangle_out,disk_mod)
         s1(:,:)=triangle_out(1,:,:)
         s2(:,:)=triangle_out(2,:,:)
         s3(:,:)=triangle_out(3,:,:)
         write(12,1213) 1,1,j,s1(1,1),s1(1,2) 
         write(12,1213) 1,2,j,s1(2,1),s1(2,2) 
         write(12,1213) 1,3,j,s1(3,1),s1(3,2) 
         write(12,1213) 2,1,j,s2(1,1),s2(1,2) 
         write(12,1213) 2,2,j,s2(2,1),s2(2,2) 
         write(12,1213) 2,3,j,s2(3,1),s2(3,2) 
         write(12,1213) 3,1,j,s3(1,1),s3(1,2) 
         write(12,1213) 3,2,j,s3(2,1),s3(2,2) 
         write(12,1213) 3,3,j,s3(3,1),s3(3,2) 
         write(12,1212) j,j,j,j,j,j,j,j,j
         
         if(.false.) then
                                ! map wrt the normalizers too
                                !         triangle_tmp=triangle_in
!         write(*,*) 'size=',size(sigma_j,1)
         do k=1,real_num_cusps-1
            if((maxval(abs(sigma_j(k,:,:))).gt.0.0_DP).and.                    &
     &           (sigma_j_in_normalizer(k).eq.1)) then
!               write(*,*) 'applying map',k,'=',sigma_j(k,:,:)
               call gl_inverse(sigma_j(k,:,:),B)
               call apply_map_to_triangle(B,triangle_out,                      &
     &              triangle_tmp,disk_mod)
               ix=j*real_num_cosets+k
               s1(:,:)=triangle_tmp(1,:,:)
               s2(:,:)=triangle_tmp(2,:,:)
               s3(:,:)=triangle_tmp(3,:,:)
             !  write(*,*) 's112=',s1(1,2)
!               if(abs(s1(1,1)).gt.10) then
!                  write(*,*) 's1(1,1)=',s1(1,1)
!                  write(*,*) 'map=',sigma_j(k,:,:)
!               endif
               write(12,1213) 1,1,ix,s1(1,1),s1(1,2) 
               write(12,1213) 1,2,ix,s1(2,1),s1(2,2) 
               write(12,1213) 1,3,ix,s1(3,1),s1(3,2) 
               write(12,1213) 2,1,ix,s2(1,1),s2(1,2) 
               write(12,1213) 2,2,ix,s2(2,1),s2(2,2) 
               write(12,1213) 2,3,ix,s2(3,1),s2(3,2) 
               write(12,1213) 3,1,ix,s3(1,1),s3(1,2) 
               write(12,1213) 3,2,ix,s3(2,1),s3(2,2) 
               write(12,1213) 3,3,ix,s3(3,1),s3(3,2) 
               write(12,1212) ix,ix,ix,ix,ix,ix,ix,ix,ix
            endif
         enddo
         endif
      enddo
      write(*,*) 'Insert pullback points?'
      
      if(get_answer_yn()) then
!         call get_M0_Q_Y(5.0_DP,M0,Q,Y)
         Y=sqrt(3.0_DP)/real(Level*2,DP)
         write(*,*) 'Y?'
         read(*,*) Y0
         write(*,*) 'Q?'
         read(*,*) Q
         call get_pb_points(5.0_DP,Y0,Q)
         do j=1-Q,Q
            write(12,1214)  Xm_s(j),Y0
         enddo
         if(Level.gt.1) then
            do jcusp=1,num_cusps
               tmp_map=sigma_j(jcusp,:,:)
               do icusp=1,num_cusps
                  do j=1-Q,Q
                     if(Y_pb_s(icusp,jcusp,j).ne.0.0_DP) then
                        call apply_map_re(X_pb_s(icusp,jcusp,j),Y_pb_s(         &
     &                       icusp,jcusp,j),x,y,tmp_map)
                        write(12,1215) x,y
                     endif
                  enddo
               enddo
            enddo
            tmp_map=sigma_j(1,:,:)
            do j=1-Q,Q
              call apply_map_re(X_pb_s(1,1,j),Y_pb_s(1,1,j),x,y,tmp_map)
               if(y.ne.0.0_DP) then               
                  write(12,1225) x,y
               endif
                  enddo
               else
            do j=1-Q,Q
               write(12,1215) X_pb_s(1,1,j),Y_pb_s(1,1,j)
            enddo
         endif
         !! draw one pair of special points for illustration

         tmp_map=sigma_j(1,:,:)
         do j=Q/4,3*Q/4
            call apply_map_re(X_pb_s(1,1,j),Y_pb_s(1,1,j),x,y,tmp_map)
            if(y.gt.0.0_DP) then
               write(12,1216) Xm_s(j),Y0
               write(12,1217) x,y
               write(12,1218) Xm_s(j),Y0,x,y
               exit
            endif
         enddo
      endif
!      write(12,*) 'drawing = unitsquare xscaled width yscaled height;'
      if(disk_mod) then
         write(12,*) 'dotlabel.bot("0",(0,0)+cor);'
         write(12,*) 'drawing = z01..z02..z03..z04..cycle;'
      else
         write(12,*) 'drawing = z01--z02--z03--z04--cycle;'
      endif
! xscaled width yscaled     &
!     &     height;'
      write(12,*) 'clip currentpicture to drawing;'
      write(12,*) 'draw drawing withcolor white;'
      if(disk_mod) then
         write(12,*) 'draw drawing withcolor black;'
      endif
      write(12,*) 'endfig;'
      write(12,*) 'end;'
      close(12)
 1212    FORMAT('draw z11[',I3,']..z12[',I3,']..z13[',I3,']..',           &
     &        'z21[',I3,']..z22[',I3,']..z23[',I3,']..',                  &
     &        'z31[',I3,']..z32[',I3,']..z33[',I3,'];')
 1213    FORMAT('z',I1,I1,'[',I4,']=(',F17.4,'*u,',F10.4,'*u)+cor;')
 1214  FORMAT('draw ((',F17.12,'*u,',F17.12,'*u)+cor) withcolor green;')
 1215  FORMAT('draw ((',F17.12,'*u,',F17.12,'*u)+cor) withcolor red;')
! 1216  FORMAT('draw (((',F17.12,'*u,',F17.12,'*u) scaled 2)+cor)         &
!     &      withcolor green;')
! 1217  FORMAT('draw (((',F17.12,'*u,',F17.12,'*u) scaled 2)+cor)         &
!     &      withcolor red;')
 1216  FORMAT('draw_pnt((',F17.12,'*u,',F17.12,'*u)+cor,green,black);')
 1217  FORMAT('draw_pnt((',F17.12,'*u,',F17.12,'*u)+cor,red,black);')
 1218  FORMAT('drawarrow ((',F17.12,'*u,',F17.12,'*u)..(',F17.12,'*u,',   &
     &      F17.12,'*u)) shifted cor;')
 1225  FORMAT('draw ((',F17.12,'*u,',F17.12,'*u)+cor) withcolor blue;')
      end subroutine draw_polygon


      subroutine apply_map_to_triangle(mapping,triangle_in,             &
     &     triangle_out,disk_mod)
      use commonvariables
      implicit none
      ! a triangle with three points with two coordinates
      real(kind=DP),dimension(3,3,2)::triangle_in
      real(DP),dimension(2,2)::mapping
      real(kind=DP),dimension(3,3,2)::triangle_out
      real(kind=DP),dimension(3,3,2)::s
!      real(DP)::s11x,s11y,s12x,s12y,s13x,s13y
!      real(DP)::s21x,s21y,s22x,s22y,s23x,s23y
!      real(DP)::s31x,s31y,s32x,s32y,s33x,s33y

!      real(DP)::sj1x,sj1y,sj2x,sj2y,sj3x,sj3y
      real(DP)::a,b,c,d,x,y,sjkx,sjky
      logical::disk_mod
      integer::i,side,k
!c$$$      s11x=triangle_in(1,1,1)
!c$$$      s11y=triangle_in(1,1,2)
!c$$$      s12x=triangle_in(1,2,1)
!c$$$      s12y=triangle_in(1,2,2)
!c$$$      s13x=triangle_in(1,3,1)
!c$$$      s13y=triangle_in(1,3,2)
!c$$$      s21x=triangle_in(2,1,1)
!c$$$      s21y=triangle_in(2,1,2)
!c$$$      s22x=triangle_in(2,2,1)
!c$$$      s22y=triangle_in(2,2,2)
!c$$$      s23x=triangle_in(2,3,1)
!c$$$      s23y=triangle_in(2,3,2)
!c$$$      s31x=triangle_in(3,1,1)
!c$$$      s31y=triangle_in(3,1,2)
!c$$$      s32x=triangle_in(3,2,1)
!c$$$      s32y=triangle_in(3,2,2)
!c$$$      s33x=triangle_in(3,3,1)
!c$$$      s33y=triangle_in(3,3,2)
      
      a=real(mapping(1,1),DP)
      b=real(mapping(1,2),DP)
      c=real(mapping(2,1),DP)
      d=real(mapping(2,2),DP)
!c$$$      call show_cosets()
!c$$$      write(*,*) a,b,c,d
!c$$$!      stop

      !! The first side

      do side=1,3         
         do k=1,3 
            sjkx=triangle_in(side,k,1)
            sjky=triangle_in(side,k,2)
!            sj2x=triangle(side,2,1)
!            sj2y=triangle(side,2,2)
!            sj3x=triangle(side,3,1)
!            sj3y=triangle(side,3,2)
            if(sjky.gt.0.0_DP) then
               call apply_map_re(sjkx,sjky,x,y,mapping(:,:))
               s(side,k,1)=x
               s(side,k,2)=y  
!               write(*,*) sjkx,sjky,x,y,mapping         
            elseif(sjky.eq.0.0_DP) then
            !   write(*,*) 'd=',d,'a,c=',a,c
               if(d.eq.0.0_DP) then
                  s(side,k,1)=a/c
                  s(side,k,2)=-1.0_DP
               else
                  if(abs(c*sjkx+d).lt.0.00001_DP) then                     
                     s(side,k,1)=0.0_DP
                                !! -2 signifies that this is a cusp
                                !! that is mapping to infinity
                     !! and I have to check the x-coordinate later
                     s(side,k,2)=-2.0_DP
                  else
                     s(side,k,1)=(a*sjkx+b)/(c*sjkx+d)
                     s(side,k,2)=0.0_DP
                  endif
!               if(abs(s(side,k,1)).gt.105) then
!                  write(*,*) 'd=',d,'a,c=',a,c
!                  write(*,*) 'x(',side,',',k,')=',s(side,k,1)
!                  write(*,*) '=(',a,'*',sjkx,'+',b,')/(',c,'*',sjkx,'+', &
!     &                 d,')'            
!                  s(side,k,2)=-1.0_DP                 
!               endif
               endif
            else
               if(c.ne.0.0_DP) then
                  s(side,k,1)=a/c
                  s(side,k,2)=0.0_DP
               else             ! we have a parabolic map fixing oo and y=ioo
                  s(side,k,1)=sjkx*a/d+b/d
                  s(side,k,2)=-1.0_DP
               endif
            endif
         enddo
      enddo
      do side=1,3         
         do k=1,3
            if(s(side,k,2).eq.-2.0_DP) then
               if(k.eq.1) then 
                  i=2
               else
                  i=1
               endif
               s(side,k,1)=s(side,i,1)
               s(side,k,2)=12.0_DP
            endif
         enddo
      enddo
!         write(*,*) 'a/c',sj1x,s11y,x,y,mapping         
!      endif
!c$$$      if(sj2y.ge.0.0_DP) then
!c$$$         call apply_map_re(sj2x,sj2y,x,y,mapping(:,:))
!c$$$         s(side,2,1)=x
!c$$$         s(2,2)=y      
!c$$$      else
!c$$$         if(c.gt.0.0_DP) then
!c$$$            s(side,2,1)=a/c
!c$$$            s(side,2,2)=0.0_DP
!c$$$         else
!c$$$            s(side,2,1)=sj2x
!c$$$            s(side,2,2)=-1.0_DP
!c$$$         endif
!c$$$      endif
!c$$$      if(sj3y.ge.0.0_DP) then
!c$$$         call apply_map_re(sj3x,sj3y,x,y,mapping(:,:))
!c$$$         s(side,3,1)=x
!c$$$         s(side,3,2)=y      
!c$$$      else
!c$$$         if(c.gt.0.0_DP) then
!c$$$            s(side,3,1)=a/c
!c$$$            s(side,3,2)=0.0_DP
!c$$$         else
!c$$$            s(side,3,1)=sj3x
!c$$$            s(side,3,2)=-1.0_DP
!c$$$         endif
!c$$$      endif

!c$$$      ! side 2
!c$$$      if(s21y.ge.0.0_DP) then
!c$$$         call apply_map_re(s21x,s21y,x,y,mapping(:,:))
!c$$$         s2(1,1)=x
!c$$$         s2(1,2)=y      
!c$$$      else
!c$$$         if(c.gt.0.0_DP) then
!c$$$         s2(1,1)=a/c
!c$$$         s2(1,2)=0.0_DP
!c$$$         else
!c$$$            s2(1,1)=s21x
!c$$$            s2(1,2)=-1.0_DP
!c$$$         endif
!c$$$      endif
!c$$$      if(s22y.ge.0.0_DP) then
!c$$$         call apply_map_re(s22x,s22y,x,y,mapping(:,:))
!c$$$         s2(2,1)=x
!c$$$         s2(2,2)=y      
!c$$$      else
!c$$$         if(c.gt.0.0_DP) then
!c$$$         s2(2,1)=a/c
!c$$$         s2(2,2)=0.0_DP
!c$$$         else
!c$$$            s2(2,1)=s22x
!c$$$            s2(2,2)=-1.0_DP
!c$$$         endif
!c$$$      endif
!c$$$       if(s23y.ge.0.0_DP) then
!c$$$         call apply_map_re(s23x,s23y,x,y,mapping(:,:))
!c$$$         s2(3,1)=x
!c$$$         s2(3,2)=y      
!c$$$      else
!c$$$         if(c.gt.0.0_DP) then
!c$$$         s2(3,1)=a/c
!c$$$         s2(3,2)=0.0_DP
!c$$$         else
!c$$$            s2(3,1)=s23x
!c$$$            s2(3,2)=-1.0_DP
!c$$$         endif
!c$$$      endif
!c$$$      !! third side
!c$$$      if(s31y.ge.0.0_DP) then
!c$$$         call apply_map_re(s31x,s31y,x,y,mapping(:,:))
!c$$$         s3(1,1)=x
!c$$$         s3(1,2)=y      
!c$$$      else
!c$$$         if(c.gt.0.0_DP) then
!c$$$         s3(1,1)=a/c
!c$$$         s3(1,2)=0.0_DP
!c$$$         else
!c$$$            s3(1,1)=s31x
!c$$$            s3(1,2)=-1.0_DP
!c$$$         endif
!c$$$      endif
!c$$$      if(s32y.ge.0.0_DP) then
!c$$$         call apply_map_re(s32x,s32y,x,y,mapping(:,:))
!c$$$         s3(2,1)=x
!c$$$         s3(2,2)=y      
!c$$$      else
!c$$$         if(c.gt.0.0_DP) then
!c$$$         s3(2,1)=a/c
!c$$$         s3(2,2)=0.0_DP
!c$$$         else
!c$$$            s3(2,1)=s32x
!c$$$            s3(2,2)=-1.0_DP
!c$$$         endif
!c$$$      endif
!c$$$       if(s33y.ge.0.0_DP) then
!c$$$         call apply_map_re(s33x,s33y,x,y,mapping(:,:))
!c$$$         s3(3,1)=x
!c$$$         s3(3,2)=y      
!c$$$      else
!c$$$         if(c.gt.0.0_DP) then
!c$$$         s3(3,1)=a/c
!c$$$         s3(3,2)=0.0_DP
!c$$$         else
!c$$$            s3(3,1)=s33x
!c$$$            s3(3,2)=-1.0_DP
!c$$$         endif
!c$$$      endif
      
      
      if(disk_mod) then
      
         do i=1,3
            call map_to_circle(s(1,i,1),s(1,i,2),x,y)
            s(1,i,1)=x
            s(1,i,2)=y
            call map_to_circle(s(2,i,1),s(2,i,2),x,y)
            s(2,i,1)=x
            s(2,i,2)=y
            call map_to_circle(s(3,i,1),s(3,i,2),x,y)
            s(3,i,1)=x
            s(3,i,2)=y
         enddo
      else                      ! Else I just place the point at infinity at height 10
         do side=1,3
            do k=1,3
               if(s(side,k,2).lt.0.0_DP) then
                  s(side,k,2)=20.0_DP
               endif               
      !         write(*,*) 'y(',side,',',k,')=',s(side,k,2)
            enddo
         enddo
      endif
!      write(*,*) 'orig s112=',s(1,1,2)
      triangle_out(1,:,:)=s(1,:,:)
      triangle_out(2,:,:)=s(2,:,:)
      triangle_out(3,:,:)=s(3,:,:)      
      

      end subroutine

      ! Using the map z->(z-i)/(z+i) 
      ! to map the upper half-plane to the unit circle

      subroutine map_to_circle2(xin,yin,xut,yut)
      implicit none
      real(kind=DP) :: xin,yin,xut,yut
      real(kind=DP) :: den

      den=xin**2+(yin+1.0_DP)**2
      if(den.eq.0.0_DP) then
         write(*,*) 'Error: Dividing with 0!'
         stop
      endif
      xut=(xin**2+yin**2-1.0_DP)/den
      yut=-2.0_DP*xin/den

      end subroutine map_to_circle2

      subroutine map_to_circle(xin,yin,xut,yut)
      implicit none
      real(kind=DP) :: xin,yin,xut,yut
      complex(kind=DP),dimension(2,2)::TT 
      complex(kind=DP)::zin,zut
      TT(1,1)=dcmplx(1.0_DP,0)
      TT(1,2)=dcmplx(0,-1.0_DP)
      TT(2,1)=dcmplx(1.0_DP,0)
      TT(2,2)=dcmplx(0,1.0_DP)

      TT(1,1)=dcmplx(0.0_DP,1.0_DP)
      TT(1,2)=dcmplx(1.0_DP,0)
      TT(2,1)=dcmplx(1.0_DP,0)
      TT(2,2)=dcmplx(0,1.0_DP)
      if(yin.ge.0.0_DP) then 
         zin=dcmplx(xin,yin)
         call apply_map_cplx(zin,zut,TT)
         xut=real(zut,DP)
         yut=dimag(zut)
      else ! y<0 means infinity maps to 1
         xut=real(TT(1,1)/TT(2,1))
         yut=dimag(TT(1,1)/TT(2,1))
      endif


      end subroutine map_to_circle
      subroutine map_to_circle3(xin,yin,xut,yut)
      implicit none
      real(kind=DP) :: xin,yin,xut,yut
      complex(kind=DP),dimension(2,2)::TT 
      complex(kind=DP)::zin,zut
      TT(1,1)=czero
      TT(1,2)=dcmplx(0.0,1.0_DP)
      TT(2,1)=dcmplx(1.0_DP,1.0_DP)
      TT(2,2)=dcmplx(-1.0_DP,0)
      zin=dcmplx(xin,yin)
      call apply_map_cplx(zin,zut,TT)
      xut=real(zut,DP)
      yut=dimag(zut)
      end subroutine map_to_circle3




      

!c$$$      subroutine make_one_image(P,kar,R,D,M,type,xsize,ysize,xmin,xmax   &
!c$$$     &     ,ymin,ymax,FILENAME)
!c$$$      use characters
!c$$$      use pullback
!c$$$      use commonvariables
!c$$$      use maass_interface
!c$$$      implicit none
!c$$$      integer :: M,j,k,P,kar
!c$$$      real(kind=DP),dimension(1:M) :: D
!c$$$      real(kind=DP),dimension(:,:),allocatable :: SCREEN
!c$$$      real(kind=DP) :: R,x,y,F
!c$$$      integer :: xsize,ysize,type,ieps
!c$$$      real(kind=DP) :: xmin,xmax,ymin,ymax
!c$$$      character(70) :: FILENAME
!c$$$!      character(LEN=10) :: sincos,evenodd,chartype
!c$$$      character(LEN=20)::filtyp
!c$$$!      Y0=1.73_DP
!c$$$      Level=P
!c$$$      CType=kar
!c$$$
!c$$$
!c$$$      filtyp='graph'
!c$$$      ieps=kar
!c$$$      if(len_trim(FILENAME).eq.0) then
!c$$$         FILENAME = make_filename(filtyp,P,type,CType,ieps,R)
!c$$$      endif
!c$$$      
!c$$$      write(*,*) 'filnamn=',FILENAME
!c$$$    
!c$$$
!c$$$      if(R<0.0_DP) then
!c$$$         write(*,*) 'Error: R<0!'
!c$$$         stop
!c$$$      endif
!c$$$      if(xsize==0) then
!c$$$         xsize=200
!c$$$      endif
!c$$$      if(ysize==0) then
!c$$$         ysize=200
!c$$$      endif
!c$$$
!c$$$
!c$$$      allocate(SCREEN(0:xsize,0:ysize))
!c$$$      if(xmin==0.0_DP) then
!c$$$         xmin=-0.5_DP
!c$$$      endif
!c$$$      if(xmax==0.0_DP) then
!c$$$         xmax=0.5_DP
!c$$$      endif
!c$$$      if(ymin==0.0_DP) then
!c$$$         ymin=0.05_DP
!c$$$      endif
!c$$$      if(ymax==0.0_DP) then
!c$$$         ymax=1.05_DP
!c$$$      endif
!c$$$
!c$$$
!c$$$      open(UNIT=12,FILE=FILENAME,STATUS='UNKNOWN')       
!c$$$!      write(*,*) 'writing to ',FILENAME
!c$$$      do j=0,xsize
!c$$$         x=xmin+real(j,DP)*(xmax-xmin)/real(xsize,DP)
!c$$$         do k=0,ysize
!c$$$!            write(*,*) '(j,k)=',j,k
!c$$$            y=ymin+real(k,DP)*(ymax-ymin)/real(ysize,DP)
!c$$$!            call pullback_to_gamma0p(x,y,x1,y1)
!c$$$ !           x=x1
!c$$$ !           y=y1
!c$$$!            write(*,*) x,y,M,R,type,D
!c$$$            F=evalMaass(x,y,D(1:M),M,R,type)
!c$$$            SCREEN(j,k)=F
!c$$$         enddo
!c$$$      enddo
!c$$$
!c$$$      do k=0,ysize
!c$$$         write(12,*) SCREEN(:,k)
!c$$$      enddo
!c$$$
!c$$$      deallocate(SCREEN)
!c$$$! 100  FORMAT(F6.3,1X,F6.3,1X,ES12.3)
!c$$$      close(12)
!c$$$      end subroutine make_one_image
!c$$$

      !!! complex-valued functions
      !!! Level, weight and characters are supposed to be set
      !!! beforehand
      subroutine make_one_image_c(R,D,M,xsize,ysize,xmin,xmax            &
     &     ,ymin,ymax,NAME)
      use commonvariables
      use interpolation
      use characters
      use pullback
      use coefficients
      implicit none
      integer :: M,j,k
      complex(kind=DP),dimension(1:num_cusps,-M:M) :: D
      complex(kind=DP),dimension(:,:),allocatable :: SCREEN,FD
      real(kind=DP) :: R,x,y,x1,y1
      complex(DP)::F,norm
      integer,optional :: xsize,ysize
      integer :: x_size,y_size
      real(kind=DP),optional :: xmin,xmax,ymin,ymax
      real(DP):: x_min,x_max,y_min,y_max,test,alpha
      character(100),optional :: NAME
      character(100) :: w_str2,w_str,FILENAME
      character(100) :: FILENAME1,FILENAME2,FILENAME3
!      character(LEN=10) :: evenodd,chartype
      character(LEN=20)::filtyp
      integer::ierr
      integer,dimension(2,2)::tmpmap
      !!Y0=1.73_DP
      !!! I test making 3 files plotting: Re(f), Im(f) and Abs(f)
      filtyp='graph'
      if((.not.(PRESENT(NAME))).or.(len_trim(NAME).eq.0)) then
         FILENAME = make_filename(filtyp,Level,-2,0,0,R)
         if(weight.ne.0.0_DP) then
            w_str='w'
            w_str2='w'
            if(weight.ge.1.0_DP) then
               test=weight-real(floor(weight),DP)
               w_str2=trim(w_str)//trim(integer_to_char(floor(weight)))      &
     &              //'.'
            else
               test=weight
               w_str2=trim(w_str)//'0.'
            endif
            w_str=w_str2
            if(test.ne.0.0_DP) then
               test=weight
               do j=1,50                   
                  test=test*real(10,DP)
                  write(*,*) 'test=',test
                  if(floor(test).eq.ceiling(test)) then
                                !!! test is an integer
                     w_str2=trim(w_str)//                                 &
     &                    trim(integer_to_char(floor(test)))
                     exit
                  else
                     w_str2=trim(w_str) // '0'
                  endif
                  w_str=trim(w_str2)
               enddo
               w_str=trim(w_str2)
            endif
            FILENAME='graphP'//trim(integer_to_char(Level)) //           &
     &           trim(w_str)                                             &
     &           // 'R' // trim(integer_to_char(int(10000D0*R)))
            
         elseif(CType.ne.0) then
            FILENAME='graphP'//trim(integer_to_char(Level))                   &  
     &           // 'ch' // trim(integer_to_char(Cmod))                      &
     &           // 'R' // trim(integer_to_char(int(10000D0*R)))
         else
            FILENAME='graphP'//trim(integer_to_char(Level))                   &  
     &           // 'R' // trim(integer_to_char(int(10000D0*R)))
         endif
      else
         FILENAME=NAME
         write(*,*) FILENAME(1:3)
         write(*,*) 'filnamn=',FILENAME(1:3)
      endif
      FILENAME1=TRIM(FILENAME)//'_RE.txt'
      FILENAME2=trim(FILENAME)//'_IM.txt'
      FILENAME3=trim(FILENAME)//'_ABS.txt'
      !      FILENAME
      write(*,*) 'filnamn=',FILENAME
      if(R<0.0_DP) then
         write(*,*) 'Error: R<0!'
         stop
      endif
      
      if((.not.(PRESENT(xsize))).or.(xsize.eq.0)) then
         x_size=200
      else
         x_size=xsize
      endif
      if((.not.(PRESENT(ysize))).or.(ysize.eq.0)) then
         y_size=200
      else
         y_size=ysize
      endif



      allocate(SCREEN(0:x_size,0:y_size))
      allocate(FD(0:x_size,0:y_size))
      if((.not.PRESENT(xmin))) then
         x_min=-0.5_DP
      else
         x_min=xmin
      endif
      if((.not.(PRESENT(xmax))).or.(xmax.le.xmin)) then
         x_max=0.5_DP
      else
         x_max=xmax
      endif
      if((.not.(PRESENT(ymin))).or.(ymin.eq.0.0_DP)) then
         y_min=0.05_DP
      else
         y_min=ymin
      endif
      if((.not.(PRESENT(ymax))).or.(ymax.lt.ymin)) then
         y_max=1.05_DP
      else
         y_max=ymax
      endif

      open(unit=17,file='FD.txt')

      FILENAME1='/home/fredrik/Programming/tmp/'//FILENAME1
      open(UNIT=11,FILE=FILENAME1,STATUS='UNKNOWN',IOSTAT=ierr,ERR=738)
 738  if(ierr.gt.0) then
         write(*,*) 'ierr=',ierr,' FILENAME=',FILENAME1
      endif
      FILENAME2='/home/fredrik/Programming/tmp/'//FILENAME2
      open(UNIT=12,FILE=FILENAME2,STATUS='UNKNOWN',IOSTAT=ierr,ERR=742)       
 742  if(ierr.gt.0) then
         write(*,*) 'ierr=',ierr,' FILENAME=',FILENAME2
      endif
      FILENAME3='/home/fredrik/Programming/tmp/'//FILENAME3
      open(UNIT=13,FILE=FILENAME3,STATUS='UNKNOWN',IOSTAT=ierr,ERR=746)             
 746  if(ierr.gt.0) then
         write(*,*) 'ierr=',ierr,' FILENAME=',FILENAME3
      endif
      write(*,*) 'writing to ',FILENAME
      write(*,*) 'screen:[',x_min,',',x_max,']x[',y_min,',',y_max,']'
      write(*,*) 'resolution:[',x_size,']x[',y_size,']'
      if((real(x_size,DP)/(x_max-x_min)-real(y_size,DP)/                     &
     &     (y_max-y_min)).gt.0.5_DP) then
         write(*,*) 'NOTE: Not same dots/cm in x and y directions!'
         write(*,*) 'x:',real(x_size,DP)/(x_max-x_min)
         write(*,*) 'y:',real(y_size,DP)/(y_max-y_min)
      endif
!      do_interp=.true.
      if(do_interp) then
         if(weight.eq.0.0_DP) then
            call setup_interp_kbes(R)
         else
            call get_alphas()
            alpha=100.0_DP
            do j=1,num_cusps
!               write(*,*) 'alphas(',j,')=',alphas(j)
               if(alphas(j).lt.alpha) then
                  alpha=alphas(j)
               endif
            enddo
!            write(*,*) 'alpha=',alpha
            call setup_interp_whittw(R,alpha)
         endif
      endif
      if((plot_inside.eq.1)) then
         write(*,*) 'Only plotting inside the Fundamental domain!'
      endif
      write(*,*) 'width=',width
      !! The factor that makes the function real-valued
      if(from_perm) then 
         norm=sqrt(D(1,-1))
         write(*,*) 'norm=',norm
      endif
      do k=0,y_size         
         y=y_min+real(k,DP)*(y_max-y_min)/real(y_size,DP)
         do j=0,x_size
            x=x_min+real(j,DP)*(x_max-x_min)/real(x_size,DP)
            if((plot_inside.eq.1)) then

!               call pullback_panint(x,y,x1,y1)
               call pullback_map(x,y,x1,y1,tmpmap)
!               write(*,*) 'tmpmap=',tmpmap(:,:)
!               if((tmpmap(1,1).ne.1).or.(tmpmap(1,2).ne.0).or.           &
!     &              (tmpmap(2,1).ne.0).or.(tmpmap(2,2).ne.0)) then
               if((y1-y)**2+(x1-x)**2.gt.1D-12) then
                  F=czero
                  FD(j,k)=czero
               else
                  FD(j,k)=cone
                  x1=x/width
                  y1=y/width
                  F=MaassWf2(x1,y1,D(1:num_cusps,-M:M),M,R)
                  !!! For permutation groups we must normalize to get real-valued functions
                  if(from_perm) then 
                     F=F/norm
                  endif
!                  write(*,*) 'arg(Fz)=',argument(real(F,DP),dimag(F))
               endif
            elseif(plot_inside.eq.2) then
               F=dcmplx(abs(MaassWf_c(x,y,D(1:num_cusps,-M:M),M,R)),          &
     &              0.0_DP)
            else
               F=MaassWf_c(x,y,D(1:num_cusps,-M:M),M,R)
            endif
!            if(abs(F).lt.1.0E-16_DP) then
!               F=dcmplx(0,0)
!            endif
            SCREEN(j,k)=F
         enddo
      enddo

      do j=0,y_size
         do k=0,x_size
            write(11,102,ADVANCE='NO') real(SCREEN(k,j),DP)
            write(12,102,ADVANCE='NO') dimag(SCREEN(k,j))
            write(13,102,ADVANCE='NO') abs(SCREEN(k,j))
         enddo
         write(11,*)
         write(12,*)
         write(13,*)
      enddo
      close(11)
      close(12)
      do j=0,y_size
         do k=0,x_size
            write(17,102,ADVANCE='NO') real(FD(k,j),DP)
         enddo
         write(17,*)
      enddo
      close(17)



 102  FORMAT(ES13.4)
! 102  FORMAT(201(ES12.3))
! 103  FORMAT(301(ES12.3))



      end subroutine make_one_image_c
!     ! in=1 => plot only inside the fundamental domain
      subroutine plot_figure(R,a,b,D,filename,xsize,ysize,xmin,xmax,     &
     &     ymin,ymax,N,GTYPE,CH,in)
      use characters
      use pullback
      use commonvariables
      use coefficients
      use groups
      use coefficients,only:evalMaass
      implicit none
      integer::N,CH,res(2),in,a,b,type
      character(1)::GTYPE
      real(DP)::R,xmin,xmax,ymin,ymax
      integer :: M,j,k,P,kar,xsize,ysize,i,tmpmap(2,2)
      complex(kind=DP),dimension(1:num_cusps,a:b) :: D
      real(kind=DP),dimension(:,:),allocatable :: SCREEN
      real(kind=DP) :: x,y,F,x1,y1
      character(70) :: FILENAME
!      logical::do_real
      if(GTYPE.eq.'C') then 
         call init_g(N)
      else
         call init_hecke_triangle(N)
      endif
      if(R.lt.0.0_DP) then
         write(*,*) 'Error: R<0!'
         stop
      endif
      write(*,*) 'making figure: R=',R,' weight=',Weight
!      write(*,*) 'a,b=',a,b
!      write(*,*) 'xmin,xmax=',xmin,xmax
!      write(*,*) 'ymin,ymax=',ymin,ymax
!      write(*,*) 'R=',R,'a,b=',a,b
!      write(*,*) 'd=',lbound(D,1),':',ubound(D,1)
!      write(*,*) 'd=',lbound(D,2),':',ubound(D,2)
!     ! Set defaults if no argument present
      do_real=.true.
      if(abs(D(1,-1)-D(1,1)).le.1E-5) type=0
      if(abs(D(1,-1)+D(1,1)).le.1E-5) type=1
      if((Ctype.gt.1).or.(weight.ne.0.0)) do_real=.false.
!      do i=lbound(D,1),ubound(D,1)
!         do j=lbound(D,2),ubound(D,2)
!            if(abs(dimag(D(i,j))).gt.10.0*eps0) do_real=.false.
!         enddo
!      enddo
!      write(*,*) 'type=',type
!      write(*,*) 'in=',in
      allocate(SCREEN(0:xsize,0:ysize))
!     ! 
!      write(*,*) 'do_real=',do_real
      do j=0,xsize
         x=xmin+real(j,DP)*(xmax-xmin)/real(xsize,DP)
         do k=0,ysize
            y=ymin+real(k,DP)*(ymax-ymin)/real(ysize,DP)
            if(in.eq.1) then 
               call pullback_map(x,y,x1,y1,tmpmap)
               if((y1.ne.y).or.(x1.ne.x)) then 
                  F=0.0D0
               else
                  F=evalMaass(x,y,D,M,R,type)
               endif
            else
!               writE(*,*) 'x,y=',x,y
               F=evalMaass(x,y,D,ubound(D,2),R,type)
!               writE(*,*) 'F=',F
            endif
            SCREEN(j,k)=F
         enddo
      enddo
!      write(*,*) 'in plot3'
!     ! write SCREEN to file
!     

      open(UNIT=11,FILE=FILENAME,STATUS='UNKNOWN')       
      do j=0,ysize
         do k=0,xsize
            if(do_real) then 
               write(11,102,ADVANCE='NO') real(SCREEN(k,j),DP)
            else
               write(11,102,ADVANCE='NO') abs(SCREEN(k,j))
            endif
         enddo
         write(11,*)
      enddo
      deallocate(SCREEN)
 102  FORMAT(ES13.4)
      close(11)
      write(*,*) 'wrote figure to file=',filename
      end subroutine plot_figure



      end module
