!----------------
! Contains functions suitable to interface to C/C++
!----------------


      module interf_to_cpp
      use commonvariables
      use groups,only:init_g,num_cusps,clean_group,init_hecke_triangle,      &
     &     Y0_min
!      use system,only:get_Y_from_M
      use system,only:get_M0_Q_Y
      use coefficients,only:compute_coeffs
      use sys_solve,only:set_norm,clean_sys_solve

      interface get_coefficients
!      module procedure get_c_r  ! real coefficients
      module procedure get_c_c  ! complex coefficients
      
      end interface

      contains
! Get Fourier coefficients for a Maass waveform with eigenvalue R
! on the group Gamma_0(N)
!     R => Eigenvalue
!     M => Number of wanted coefficients 
!     k => number of cusps of Gamma_0(N)
!     C => Coefficients 
!     GTYPE=> ('C' or 'T' for Congruence or Triangle Group)
!     N => Level if GTYPE='C' and Q if GTYPE='T', i.e. group is G_q
!     CH=> Which character to use
      subroutine get_c_c(R,M,k,CTOT,N,GTYPE,CH)
      implicit none
      real(DP)::R,Y
      integer::N,M,k,Q,i,j
      character(1)::GTYPE
      integer::CH
      complex(DP),dimension(:,:),allocatable::C,CN,CTOT ! real and imaginary parts
      ! init the group Gamma_0(N)
      if(GTYPE.eq.'C') then 
         call init_g(N)
      else
         call init_hecke_triangle(N)
      endif
      ! find the maximal Y and minimal corresponding M
      Y=Y0_min*0.95_DP; M=0; Q=10  !! These will be set to a default value in the compute_coeffs subroutine
      ! make normalisations
      call set_norm(0)
      call compute_coeffs(R,C,CN,M,Y,Q)
      k=num_cusps
      allocate(CTOT(1:k,-M:M))
      do i=1,num_cusps
         CTOT(i,0)=C(i,1)
         do j=1,M
            CTOT(i,j)=C(i,j+1); CTOT(i,-j)=CN(i,j)
         enddo
      enddo
      call clean_sys_solve()
!      write(*,*) 'c=',lbound(ctot,1),':',ubound(ctot,1)
!      write(*,*) 'c=',lbound(ctot,2),':',ubound(ctot,2)
      end subroutine get_c_c


! Make a plot of a given Maasswaveform
! for real-valued forms we plot the form itself but for 
! complex-valued ones we plot the absolute value

      subroutine make_plot(R,N,GTYPE,CH,filename,res,xl,xr,yb,yt,in,C)
      use graphics
      use characters
      use pullback
      use commonvariables
!      use maass_interface
      use groups
      use interpolation
      implicit none
      integer::N,CH,i,xsize,ysize,M,k,j
      character(1)::GTYPE
      real(DP)::R,xmin,xmax,ymin,ymax
      real(DP),optional::xl,xr,yb,yt 
      integer,optional::res(2),in
      complex(kind=DP),dimension(:,:),optional :: C
      complex(kind=DP),dimension(:,:),allocatable :: D
!      logical::do_real
      character(100)::filename
!!!   Set defaults
      if(present(res)) then 
         if(res(1).gt.0) xsize=res(1)
         if(res(2).gt.0) ysize=res(2)
      else
         xsize=200; ysize=200
      endif
      if(present(yt)) then 
         xmin=xl; xmax=xr; ymin=yb; ymax=yt
      endif
      if(len_trim(FILENAME).eq.0) then
         FILENAME = 'graphN'//trim(i2c(N))//'R'//trim(r2c(R,4))//            &
     &        trim(i2c(xsize))//'x'//trim(i2c(ysize))//'.txt'
      endif
      xsize=xsize-1; ysize=ysize-1 
      if(xmin.eq.0.0_DP) xmin=-0.5_DP
      if(xmax.eq.0.0_DP) xmax=0.5_DP
      if(ymin.eq.0.0_DP) ymin=0.01_DP
      if(ymax.eq.0.0_DP) ymax=1.01_DP
      if(present(in)) then 
         i=in
      else
         i=0
      endif
      if(.not.(present(C))) then 
         write(*,*) 'R,M=',R,M,k,N
         call get_coefficients(R,M,k,D,N,GTYPE,CH)
!      write(*,*) 'd=',lbound(D,1),':',ubound(D,1)
!      write(*,*) 'd=',lbound(D,2),':',ubound(D,2)
      else
         allocate(D(1:num_cusps,lbound(C,2):ubound(C,2)))
         do i=1,num_cusps
            do j=lbound(C,2),ubound(C,2)
               D(i,j)=C(i,j)
            enddo
         enddo         
      endif
!c$$$         do i=1,num_cusps
!c$$$            do j=lbound(D,2),ubound(D,2)
!c$$$               write(*,*) 'D(',i,',',j,')=',D(i,j)
!c$$$            enddo
!c$$$         enddo         
      do_interp=.true.
      silent_interpolation=-2
      call plot_figure(R,lbound(D,2),ubound(D,2),D,filename,xsize,         &
     &     ysize,xmin,xmax,ymin,ymax,N,gtype,CH,i)
      end subroutine make_plot

!!      ## Produces a longer list of Coefficients
!       ## C(k,n)  for ka<=k<=kb (number of cusp) 
!                  and NA<=n<=NB
      subroutine get_list_of_coeffs(R,N,ka,kb,NA,NB,DOUT,tol,              &
     &     GTYPE,CH)
      use phase2
      use interpolation
      use commonvariables
      implicit none
      real(DP)::R,Y
      integer::N,NA,NB,NN,ka,kb
      real(DP)::CX(NA:NB),CY(NA:NB),tol
      complex(DP),allocatable,dimension(:,:)::C,CP,CN
      real(DP),allocatable,dimension(:,:)::D
      real(DP),allocatable,dimension(:,:,:)::DOUT
      integer::M,k,CH,i,j,type,errtype
      character(1)::GTYPE
!      logical::do_real
      real::t1,t2
!! Get initial coefficient set
      call get_coefficients(R,M,k,C,N,GTYPE,CH)      
      do i=1,k
       do j=lbound(C,2),ubound(C,2)
          if(abs(dimag(C(i,j))).gt.tol*100D0) do_real=.false.
       enddo
      enddo
!! Call phase 2
      if(NA.gt.0) then 
         Y=1.0D0/(PI2*real(NA,DP))
      else
         Y=Y0_min
      endif
      NN=NB-NA+1
!! Choose level of output
      phase2_silent=-1
      allocate(D(1:num_cusps,1:ubound(C,2)))
      do k=1,num_cusps
         do j=1,ubound(C,2) 
            D(k,j)=real(C(k,j),DP)
         enddo
      enddo
      if(abs(C(1,-1)-1.0D0).le.1D-3) then 
         type=0
      else
         type=1
      endif
!      write(*,*) 'type=',type, 'ka,kb=',ka,kb
      if(allocated(DOUT)) deallocate(DOUT)
      allocate(DOUT(ka:kb,NA:NB,1:2))
 !     Y=0.15D0
      errtype=2
!     ! choose way to estimate the error
!     ! =1 uses two Y-values and 
!     ! =2 uses different cusp expansions (faster)

!     ! Compute C(k,n) for ka<=k<=kb, NA<=n<=NB,
!     !         DOUT(k,n,1)=C(k,n), DOUT(k,n,2)=estimated error
      do_interp=.false.
      do_interp=.true.
      if(do_interp) then 
         call set_num_intervals(16)
         call set_degree(30)
      endif
      call cpu_time(t1)
      call phase2_real(R,Y,M,ka,kb,NA,NB,NN,D,DOUT,tol,type,                 &
     &     errtype)
      call cpu_time(t2)
      write(*,*) 'time=',t2-t1
      end subroutine


!     ! Subroutine that finds eigenvalues 
!     ! in interval [R1,R2] 
!     ! GTYPE='C' or 'T'
!     ! N=Level or Hecke triangle parameter
!     ! CH=Character
!     ! listR = list of eigenvalues and estimated errors
      subroutine find_eigenv(R1,R2,N,listR,GTYPE,CH)
      use find_eigenvalues
      implicit none
      real(DP)::R1,R2
      real(DP),dimension(:,:),allocatable::listR
      integer::N,CH,gs1,gs2
      character(1)::GTYPE
      if(GTYPE.eq.'C') then 
         call init_g(N)
      else
         call init_hecke_triangle(N)
      endif      
!     ! Decide how much to split up the interval
    
      gs1=13
      gs2=150
      call find_evs2(N,R1,R2,gs1,gs2,listR,GTYPE,CH)
      




      


      end subroutine find_eigenv

      end module
