!!!   The purpose of this program is to take a list of the format!!! N m CHAR R e0 e1...
!!!   and perform various tests on it      


                                !!! converts real R to character  with d digits 
!     c$$$      function real_to_char(R,d)
!     c$$$      use commonvariables
!     c$$$      implicit none
!     c$$$      real(DP)::R,tmp,tmp2
!     c$$$      integer::d,i,j     
!     c$$$      character(LEN=10)::str1,str2
!     c$$$      character(LEN=20)::res,real_to_char
!     c$$$      !! Always convert the integer part
!     c$$$      i=floor(R)
!     c$$$      tmp=R-real(i,DP) !! Fractional part
!     c$$$      !! and if it is an integer we do not add .0000...
!     c$$$      j=floor(tmp*10.0_DP**d)      
!     c$$$      str1=trim(integer_to_char(i))
!     c$$$      str2=trim(integer_to_char(j))
!     c$$$      if(tmp.eq.0.0_DP) then 
!     c$$$         res=trim(str1)
!     c$$$      else
!     c$$$         res=trim(str1)//'.'//trim(str2)
!     c$$$      endif
!     c$$$      real_to_char=trim(res)
!     c$$$      end function
!     c$$$      




      program process_list
      use commonvariables
      use interpolation
      use characters
      use groups
      use coefficients
      use phase2
      use interf_to_cpp
      use find_eigenvalues
      use graphics
      use kbessel,only:clean_kbessel,A_uk
      use pullback,only:clean_pullback
      implicit none
      real(DP)::R,prec
      character*20::ANS,CHR
      character*200::filename,outfilename,utfilename
      character*200::lcalc_head,lcalc_coef
      character*100::command,VAL,slask,ENV
      integer:: N
      real(DP)::Y,set_ev,R1,R2
      real(DP),dimension(:),allocatable::e
      complex(DP),dimension(:,:,:),allocatable::CYN,CYP,CYP2,CYN2
      complex(DP),dimension(:,:),allocatable::CY,CY2
!     complex(DP),dimension(:,:,:),allocatable::CY,CYN,CYP,CY2,CYP2,CYN2
      real(DP),dimension(:,:,:),allocatable::CYR
      real(DP),dimension(:,:),allocatable::CR,CR2
      real(DP),dimension(:,:),allocatable::listR
      real(DP),dimension(:),allocatable::Dvec
      integer::M0,Q,typ,set_e,j,jj,l
      integer::a,b,c,d,i,k,num_comb
      real(DP)::char,v1,v2,x,wt
      integer,dimension(2,2)::Tmap
      logical::interp
      integer::sym,xsize,ysize
      real(DP)::xmin,xmax,ymin,ymax,tmp,tmp2
      integer::type,sym_type,group_nr,num_coeff,neps,e0,e1,dtol
      real(DP)::tol,errest
      complex(DP)::char_c,d_set(1:2),cdiff,ctmp
      complex(DP),dimension(:),allocatable::ee
      real(DP),dimension(:),allocatable::er
      logical::do_gen,lcalc,output,in,timing
      integer::which_set(1:2),intnorm
      integer::NA,NB,antal,NN,improve_start,na_start
      integer::action,silence,ev_start,ev_stop,ios
      real(DP)::x1,x2,y1,y2,t1,t2,yb,yt
      character(12)::x1_st,y1_st,x2_st,y2_st,r1_st,r2_st
      integer::Nx,Ny,numarg,Kar,Lvl,uf,jjj
!     character(LEN=20)::real_to_char
!     external real_to_char
      real(DP)::count1,count2
      errest=0.0D0
      num_coeff=0
      intnorm=0
      Lvl=0
      Kar=0
      timing=.false.
                                !! Setting defaults
      tol=1.0E-8_DP
      num_coeff=0
      na_start=0
      phase2_silent=-2          ! By default no extra output from Phase 2
      silence=0
      ev_start=0
      ev_stop=100000
      lcalc=.false.     
      output=.false.
      Nx=200; Ny=200
      x1=-0.5_DP; x2=0.5_DP; yb=0.01_DP; yt=1.01_DP
      in=.false.
                                !!! Parsing all command-line arguments
      j=1
      numarg =iargc()
      do while(j.le.numarg)
         call getarg(j,COMMAND)
         COMMAND=trim(COMMAND)
         call getarg(j+1,VAL)
         VAL=trim(VAL)
!     write(*,*) 'COMMAND=VAL:',COMMAND,':',VAL
         if(COMMAND.eq.'') then 
            exit
         else
                                !! Set the different options            
            if(COMMAND.eq.'-f') then !! input file
               FILENAME=VAL
               write(*,*) 'filname=',filename
            elseif(COMMAND.eq.'-o') then !! output file
               OUTFILENAME=VAL
               output=.true.
               write(*,*) 'outfilname=',outfilename
            elseif(COMMAND.eq.'-c') then !! action=> compute coeficients 
                                !!! number of coefficients to compute
!     num_coeff=transfer(VAL,num_coeff)
               num_coeff=char_to_int(VAL,100)
               action=1
               write(*,*) 'VAL=',VAL
               write(*,*) 'num_coeff=',num_coeff
            elseif(COMMAND.eq.'-na') then !! action=> compute coeficients 
                                !!! number of coefficients to compute
               na_start=char_to_int(VAL,100)
               if(silence.gt.1) then 
                  write(*,*) 'VAL=',VAL
                  write(*,*) 'na_start=',na_start
               endif
!     call getarg(j+1,num_coeff)
            elseif(COMMAND.eq.'-v') then !! action=> verify eigenvalues
               action=2
               write(*,*) 'Verifying eigenvalues! VAL=',VAL
            elseif(COMMAND.eq.'-e') then !!error 
               dtol=char_to_int(VAL,100)
               tol=10.0_DP**(-real(dtol,DP))
               if(silence.gt.1) then 
                  write(*,*) 'tol=',tol
               endif
            elseif(COMMAND.eq.'-n') then !! normalization
               if(VAL.eq.'int') then !! If interactive normalization
                  intnorm=1
               endif
            elseif(COMMAND.eq.'-s') then !! Silence level
               silence=char_to_int(VAL,100)
               if(VAL(1:1).eq.'-') then 
                  silence=-silence
               endif
               write(*,*) 'silence=',silence
            elseif(COMMAND.eq.'-start') then !! Starting point of the list 
               if(silence.gt.1) then 
                  write(*,*) 'ev_start=',VAL
               endif
               ev_start=char_to_int(VAL,100)
            elseif(COMMAND.eq.'-stop') then !! Stopping point of the list
               if(silence.gt.1) then 
                  write(*,*) 'ev_stop=',VAL
               endif
               ev_stop=char_to_int(VAL,100)
            elseif(COMMAND.eq.'-lcalc') then !! Make lcalc-files
               lcalc=.true.
               if(silence.gt.1) then 
               write(*,*) 'Lcalc=',VAL
               endif
            elseif(COMMAND.eq.'-plot') then !! Make plot-file to be fed into e.g. Sage
               action=3
               if(silence.gt.1) then 
                  write(*,*) 'Plot=',VAL
               endif
            elseif(COMMAND.eq.'-nx') then !! resolution in x-direction
               nx=char_to_int(VAL,100)
               if(silence.gt.1) then 
                  write(*,*) 'nx=',nx
               endif
            elseif(COMMAND.eq.'-ny') then !! resolution in y-direction
               ny=char_to_int(VAL,100)
               if(silence.gt.1) then 
                  write(*,*) 'ny=',ny
               endif
            elseif(COMMAND.eq.'-x1') then !! left x-limit in plot
               x1_st=VAL
               if(silence.gt.1) then 
                  write(*,*) 'x1_st=',x1_st
               endif
               x1=char_to_real(x1_st,12) !! Then convert to real
            elseif(COMMAND.eq.'-x2') then !! right x-limit in plot
               x2_st=VAL
               if(silence.gt.1) then 
                  write(*,*) 'x2_st=',x2_st
               endif
               x2=char_to_real(x2_st,12) !! Then convert to real
            elseif(COMMAND.eq.'-y1') then !! left x-limit in plot
               y1_st=VAL
               if(silence.gt.1) then 
                  write(*,*) 'y1_st=',y1_st
               endif
               yb=char_to_real(y1_st,12) !! Then convert to real
               if(silence.gt.1) then 
                  write(*,*) 'y1=',yb
               endif
            elseif(COMMAND.eq.'-y2') then !! lower y-limit in plot
               y2_st=VAL
               if(silence.gt.1) then 
                  write(*,*) 'y2_st=',y2_st
               endif
               yt=char_to_real(y2_st,12) !! Then convert to real
            elseif(COMMAND.eq.'-find') then !! upper y-limit in plot
               if(VAL.eq.'1') then
                  action=4
               elseif(VAL.ne.'') then
                  write(*,*) '-find should be followed by 1'
                  stop
               endif
            elseif(COMMAND.eq.'-Rs') then !! Starting R-value in Phase 1
               R1_st=VAL
               if(silence.gt.1) then 
                  write(*,*) 'Rs=',R1_st
               endif
               R1=char_to_real(R1_st,12) !! Then convert to real
            elseif(COMMAND.eq.'-Rf') then !! finishing R-value in Phase 1
               R2_st=VAL
               if(silence.gt.1) then 
                  write(*,*) 'Rf=',R2_st
               endif
               R2=char_to_real(R2_st,12) !! Then convert to real
            elseif(COMMAND.eq.'-lvl') then !! Level
               Lvl=char_to_int(VAL,100)
            elseif(COMMAND.eq.'-chr') then !!Character 
               Kar=char_to_int(VAL,100)
            elseif(COMMAND.eq.'-time') then !!Character 
               timing=.true.
            elseif((COMMAND.eq.'-h').or.(COMMAND.eq.'--help')) then !! action=> compute coeficients
               write(*,*) 'Program list_proc. '
               write(*,*) 'Perform a chosen action on a list of  data:'
               write(*,*) 'command line arguments: (in this order)'
               write(*,*) '-f infile.txt'
               write(*,*) '-o outfile.txt  => write details to file'
               write(*,*) '-na n =>compute coefficients starting at na'
               write(*,*) '-e neps  => precision=10^-neps (>1e-16)'
               write(*,*) '-n [std|int]   => standard or interactive ', &
     &              'normalization'
               write(*,*) '-s j  => silent level j=(-1|0|1) '
               write(*,*) '      j=-1 => very silent'
               write(*,*) '      j= 0 => error and requested messages'
               write(*,*) '      j= 1 => print extra info'
               write(*,*) '      j> 1 => propagates silent level to ',  &
     &              'subroutines'
               write(*,*) '-start  l1 => start at l1 in the list'
               write(*,*) '-stop   l2 => stop  at l2 in the list'      
               write(*,*) '-c n  => compute coefficients up to n'
               write(*,*) '---------  final option choosing what to do:'
               write(*,*) '-lcalc 1 (must be combined with -c n)'
               write(*,*) '        => Does several things: '
               write(*,*) '       * Writes a header file for lcalc '
               write(*,*) '       * Write a file of coefficients   '
               write(*,*) '         for first cusp only'
               write(*,*) '         Naming conventions are: lcalc.he.* '
               write(*,*) '         and                   : lcalc.co.* '
               write(*,*) '-plot  => Writes a plot-file                '
               write(*,*) ' -x1 x1 -x2 x2 -y1 y1 -y2 y2 => '
               WRITE(*,*) '         plot in [x1,x2]x[y1,y2]  default:',           &
     &              '         [-0.5,0.5]x[0.01,1.01]'
               write(*,*) ' -Nx Nx -Ny Ny => use resolution Nx and Ny ', &
     &              ' in the x- and y-direction respectively.         '
               write(*,*) '         Default=200x200.'
               write(*,*) '-v    => verify the given eigenvalues'
               write(*,*) '-------------------------------------------'
 1             write(*,*) '-find 1 => Find eigenvalues on the spec. grp'
               write(*,*) '-lvl N  => Level N'
               write(*,*) '-chr K  => character nr. K (if existing)' 
               write(*,*) '-Rs r1  => search through [r1,r2]'
               write(*,*) '-Rf r2 '
               write(*,*) '-------------------------------------------'
               write(*,*) '-time 1 => Compute the CPU-time' 
               write(*,*) '-------------------------------------------'
               write(*,*) 'Infile should have lines in the following ', &
     &              'format:'
               write(*,*) 'N c k R  e0 eps'
               write(*,*) 'Where: '
               write(*,*) 'N = Level'
               write(*,*) 'c = character'
               write(*,*) 'k = weight'
               write(*,*) 'R = Eigenvalue'
               write(*,*) 'e0= sin/cosine'
               write(*,*) 'eps=proposed error'
               write(*,*) 'Example:'
               write(*,*) '001 0 0  9.533695261354   1  1.581E-13' 
               stop
            endif
!     write(*,*) 'command=(',command,')'
         endif
         j=j+2
      enddo
      if(lcalc.and.(action.eq.0)) then !! We didn't specify which coefficients to compute
         write(*,*) '-lcalc option must be combined with -c n option' 
         stop
      endif
                                !!! Should try to figure out from file which type of group.
                                !!! For now assume congruence group 
!     open(unit=12,file=filename)
!     open(unit=12,file=filename,POSITION = 'ASIS')
      if(action.ne.4) then 
!     ! For everything exept for finding eigenvalues we need a file          
         if(FILENAME.eq.'') stop
         if(ACCESS(filename,'r').ne.0) then
            write(*,*) 'File: ',trim(filename),' cannot be read!'
            stop
         endif
         if(silence.gt.1) then 
            write(*,*) 'Reading file ',trim(filename),'in std format!'
         endif
         jj=0
         open(unit=22,file=filename)
         do while(.true.) 
            read(22,*,IOSTAT=ios) N,wt,CHR,R,e0,e1,slask
            if(ios.ne.0) then 
               if(ios.eq.208) then !! Bad value so probably cusps = 1
                  !! Trying
                  write(*,*) 'N,wt,chr,R,e0=',N,wt,CHR,e0
                  call init_g(N)
                  if(num_cusps.ne.1) then ! SOmething was wrong with the format 
                     write(*,*) 'Wrong format in input file!'
                     exit
                  endif
               elseif(ios.gt.0) then 
                  write(*,*) 'IOSERROR=',ios
                  exit
               endif
            endif
            jj=jj+1
            if(jj.lt.ev_start) cycle
            if(jj.gt.ev_stop) cycle
            CHR=trim(CHR)
            if(silence.ge.1) then 
               write(*,*) 'N=',N
               write(*,*) 'm=',wt
               write(*,*) 'CHR=',CHR
               write(*,*) 'R=',R
               write(*,*) 'e0=',e0
               write(*,*) 'e1=',e1
               write(*,*) 'slask=',SLASK
!     cycle
            endif
                                !!! Perform taske
!     if(num_coeff.gt.0) then 
!     ! Case 1:            
!     ! Compute coefficients 
!     ! Case 2:
!     ! Estimate the error in the eigenvalue
!     ! and try to set as much parameters as possible automaticcally            
            weight=wt
            group_silent=-1
            if(silence.gt.1) then 
               group_silent=silence
            endif
            call init_g(N) 
            if(allocated(ee)) deallocate(ee)
            allocate(ee(1:num_cusps))
            if(CHR.eq.'Dq') then 
               Ctype=1
            elseif(CHR.ne.'0') then 
               Ctype=char_to_int(CHR,20)
            else
               CType=0
            endif
            Y=sqrt(3.0_DP)/real(2*Level,DP)
            call get_M0_Q_Y(R,M0,Q,Y)            
            Q=M0+10
            if(silence.ge.1) then 
               write(*,*) 'M0=',M0,'R=',R,' Y=',Y,' Q=',Q,' Level=',         &
     &              Level,'CMod=',Cmod
            endif            
!     !   If not interactive use standard normalization
!     !   unless one was given in which case we use that of course
            call get_cusp_combinations()
            num_comb=num_norm_cusp_combs
            if(intnorm.gt.1) then 
               d_set(1)=dcmplx(0.0_DP,0.0_DP)
               d_set(2)=dcmplx(1.0_DP,0.0_DP)
               which_set(1:2)= (/ 0,1 /)
               ee(1)=1
               if(num_cusps.gt.1) then 
                  ee(2)=e1
               endif
               call set_norm(1,2,d_set,ee,which_set)
            elseif(intnorm.eq.1) then
               call set_norm(-1)
            else
               ee(1)=1
               open(unit=23,file=filename)
               do jjj=1,jj-1  !! At the last we should be at the current
                  read(23,*,IOSTAT=ios) N,wt,CHR,R,e0,slask
               enddo
               read(23,*,IOSTAT=ios) N,wt,CHR,R,e0,ee(2:num_cusps),       &
     &                 slask
               write(*,*) 'Checking line=',N,wt,CHR,R,e0,ee(2:num_cusps) &
     &              ,'slask=',slask
               write(*,*) 'Got symmetry:',ee(:)
            endif

            !!
!!!   To make sure that we get good accuracy we redo all coefficients with an error greater than tol 
            Y1=0.97_DP*Y
            !! See if we are using real coefficients or not
            if((CType.le.1).and.(weight.eq.0.0).and.((2**(num_cusps-1)     &
     &           .eq.(num_comb-1)).or.(num_cusps.eq.1))) then 
               do_real=.true.
               do_gen=.false.
            else
               do_real=.false.
               do_gen=.true.
            endif
            if(do_real) then 
               if(allocated(e)) deallocate(e)
               allocate(e(1:num_cusps))
               e(:)=real(ee(:),DP)
               call compute_coeffs(R,CR,type,e,M0,Q,Y)
               call compute_coeffs(R,CR2,type,e,M0,Q,Y1)
            else
               call compute_coeffs(R,CY,M0,Y,Q)
               call compute_coeffs(R,CY2,M0,Y1,Q)
            endif
            if(silence.gt.1) then 
               do i=1,num_cusps
                  do k=1,M0
                     if(do_real) then 
                        write(*,*) 'C(',i,',',k,')=',CR(i,k)
                     else
                        write(*,*) 'C(',i,',',k,')=',CY(i,k)
                        write(*,*) 'C(',i,',',-k,')=',CY(i,-k)
                     endif
                  enddo
               enddo
            endif
                                !! Presumably the error is equally spread at all cusps 

            if(action.eq.2) then 
               improve_start=1
            else
               do k=2,M0
                  if(do_real) then 
                     errest=abs(CR(1,k)-CR2(1,k))
                  else
                     errest=abs(CY(1,k)-CY2(1,k))
                  endif
                  if(errest.gt.tol) then 
                     improve_start=k
                     exit
                  endif
               enddo
            endif
            if((weight.eq.0.0).and.(e0.gt.-1)) then 
               type=e0
               !!! Just check that this is true:
               !!! Note that if we used real coefficients we would not have gotten 
               !!! close vectors CYR and CYR2 above 
               if(.not.(do_real)) then 
                  if(abs(CY(1,-1)-(-1.0_DP)**type).gt.abs(CY(1,-1)+              &
     &                 (-1.0_DP)**type))  then 
                     if(silence.gt.-1) then 
                        write(*,*) 'Is type 1/0 set wrong?'
                        write(*,*) 'C(1,-1)=',CY(1,-1)
                     endif
                     stop
!!!   If we are starting with a bad approximation then we probably 
!!!   are also far from a true eigenvalue               
                     if(abs(CY(1,-1)-(-1.0_DP)**type).gt.tol) then 
                        if(action.eq.2) then 
                           errest=abs(CY(1,-1)-(-1.0_DP)**type)
                        endif
                     endif
                  endif
               endif
            else
               type=-1
            endif
            if((action.eq.1).or.(errest.eq.0.0D0)) then
                                !!! If NA>1 we need to improve our initial coefficients starting at improve_start  
               if(NA.gt.1) then 
                  NA=improve_start
                  NB=M0
                  NN=NB-NA+1
                                !!! We do the improvement using the most general phase2-algorithm
                  phase2_silent=silence
                  if(silence.ge.1) then 
                     if(do_Real) then
                        write(*,*) 'Before improvement:'
                        do j=1,num_cusps
                           do k=1,NN
                              write(*,*) 'CY(',j,',',k,')=',CR(j,k)
                           enddo
                        enddo
                     else
                        write(*,*) 'Before improvement:'
                        do j=1,num_cusps
                           do k=1,NN
                              write(*,*) 'CY(',j,',',k,')=',CY(j,k)
                              write(*,*) 'CY(',j,',',-k,')=',CY(j,-k)
                           enddo
                        enddo
                     endif
                  endif
                  if(do_real) then
                     call phase2_real(R,Y,M0,1,num_cusps,NA,NB,NN,CR,            &
     &                    CYR,tol,type,1)
                     do j=1,num_cusps
                        do k=1,NN
                           CR(j,NA+k-1)=CYR(j,k,1)
                        enddo
                     enddo
                  else
                     call phase2_gen(R,Y,M0,NA,NB,NN,CY,CYP,CYN,tol,             &
     &                    type,ee,2,d_set,which_set)
                     do j=1,num_cusps
                        do k=1,NN
                           CY(j,NA+k-1)=CYP(j,k,1)
                           CY(j,-(NA+k-1))=CYN(j,k,1)
                        enddo
                     enddo
                  endif
                  if(silence.ge.1) then 
                     write(*,*) 'After improvement:'
                     do i=1,num_cusps
                        do k=1,M0
                           if(do_real) then 
                              write(*,*) 'C(',i,',',k,')=',CR(i,k)
                           else
                              write(*,*) 'C(',i,',',k,')=',CY(i,k)
                              write(*,*) 'C(',i,',',-k,')=',CY(i,-k)
                           endif
                        enddo
                     enddo
                  endif
               endif
            endif
            if(action.eq.1) then 
               phase2_silent=silence
               if(silence.ge.1) then 
                  write(*,*) 'Computing more coefficients!'
               endif
               if(na_start.gt.0) then 
                  na=na_start
               else
                  NA=M0+1
               endif
               NB=num_coeff
               antal=M0
               NN=NB-NA+1
               if(silence.ge.1) then 
                  write(*,*) 'NA,NB,NN=',NA,NB,NN
               endif
!     ! We should select the most optimized version here 
!     ! If we have a function with real coefficients and square-free level we want to use "all we got" 
!     ! First we check we don't have weights 
               do_gen=.true.
               if((weight.eq.0.0_DP).and.(CType.eq.0).and.                 &
     &                 (type.gt.-1))  then 
                  do_gen=.false.
                  do_real=.true.
               endif
                                !! We also have to set a good starting Y
                     Y=(R+12.0_DP*R**0.33_DP)/(PI2*real(NA,DP))
                     utfilename=trim(integer_to_char(N))//'-'//                            &
     &                    trim(real_to_char(wt,2))  // '-' // trim(CHR)                  &
     &                    //'-'//trim(real_to_char(R,14)) //'-' //                             &
     &                    trim(integer_to_char(type))  // '-' // 'c'//                      &
     &                    trim(integer_to_char(NA_start))  // '-' //                       &
     &                    trim(integer_to_char(NB))  // '.txt' 
                     lcalc_head='lcalc.he.'//utfilename
                     lcalc_coef='lcalc.co.'//utfilename
                     utfilename=trim(outfilename)//utfilename

                                !! This should then  be appended to the "outfile"-prefix in input if supplied.
                     if(silence.ge.1) then 
                        if(outfilename.ne.'') then 
                           write(*,*) 'writing to =',utfilename
                        endif
                        if(lcalc) then 
                         write(*,*) 'write lcalc header to ',lcalc_head
                         write(*,*) 'write lcalc coeffs to ',lcalc_coef
                        endif
                        write(*,*) 'In format: i c(i) c(-i) errest'
                        write(*,*) 'where errest is an estimated error', &
     &                       '< eps'
                     endif
                     if(lcalc) then ! write header
                        open(unit=15,file=lcalc_head)
                        if(do_gen) then 
                           write(15,*) '3' ! complex numbers
                        else
                           write(15,*) '2' ! real coefficients
                        endif
                        write(15,*) '0'
                        write(15,*) NB ! number of coefficients    (e.g. 172899)         
                        write(15,*) 0
                        write(15,*) 2 ! number of Gamma factors = 2 for Maass waveforms
                        write(15,*) 0.5 ! lambda_1
                        write(15,*) '0.5',R*0.5_DP
                        write(15,*) 0.5 ! lambda_1
                        write(15,*) '0.5',-R*0.5_DP
                        write(15,*) sqrt(real(Level,DP))/PI
                        if(do_gen.or.(lbound(CY,2).le.-1)) then 
                           tmp=CY(1,-1)
                        endif
                        if(e0.eq.0) then                   
                           tmp=1.0_DP
                        elseif(e0.eq.1) then 
                           tmp=-1.0_DP
                        endif
                        if(do_gen.or.(CHR.ne.'0').or.(e1.eq.0)) then 
                           ctmp=CY(2,1)*tmp
                           write(15,*) real(ctmp,DP),dimag(ctmp)
                        elseif(e1.ne.0) then 
                           ctmp=real(e1,DP)*tmp
                           write(15,*) real(ctmp,DP),dimag(ctmp) 
                        endif
                        write(15,*) 0 ! No poles
                        close(15)
                     endif
                     write(*,*) 'do_gen=',do_gen
                     if(.not.(do_gen)) then 
                        if(allocated(CR)) deallocate(CR)
                        if(allocated(CYR)) deallocate(CYR)
                        allocate(CYR(1:num_cusps,1:NN,1:2))
                        allocate(CR(1:num_cusps,1:M0))               
!!!   Then we convert the coefficients to real vectors
                        do k=1,num_cusps
                           do j=1,M0
                              CR(k,j)=dreal(CY(k,j))
                           enddo
                        enddo
                        if(allocated(er)) deallocate(er)
                        allocate(er(1:size(ee)))
                        if(silence.ge.1) then 
                           write(*,*) 'er=',er
                           write(*,*) 'ee=',ee
                        endif
                        do k=1,size(ee) 
                           er(k)=real(ee(k),DP)
                        enddo
!     if(CType.ne.0) then 
!     call phase2_real_char(R,Y,M0,NA,NB,NN,CR,             &
!     &                 CY,tol,type,1)
!     else
                        if(timing) then 
                           call cpu_time(t1)
                        endif
                        call phase2_real(R,Y,M0,1,num_cusps,NA,NB,NN,CR, &
     &                       CYR,tol,type,1)
                        if(timing) then 
                           call cpu_time(t2)
                           write(*,*) 'time for phase2=',t2-t1
                        endif
                                !!! And to conform with the output standard I now 
                                !!! transforms the real coefficients back to complex 
                        if(allocated(CYP)) deallocate(CYP)
                        if(allocated(CYN)) deallocate(CYN)
!     !        Print Lcalc coefficient data
                        if(lcalc) then 
                           open(unit=14,file=lcalc_coef)
                           do j=1,NA-1
                              write(14,350) CR(1,j)
                           enddo
                           do j=NA,NB
                              write(14,350) CYR(1,j-NA+1,1)
                           enddo
                           close(14)
                        endif
!     !        Print more detailed data: Positive and negative coefficients for all cusps 
                        if(output.and.(trim(outfilename).ne.'')) then
                           open(unit=13,file=utfilename)
                           do i=lbound(CYR,1),ubound(CYR,1)
                              write(13,250) i,0,0.0,0.0
                           enddo
                           do j=1,NA-1
                              do i=lbound(CYR,1),ubound(CYR,1)
                                 write(13,250) i,j,CR(i,j),0.0
                                 write(*,250) i,j,CR(i,j),0.0
                              enddo
                           enddo
                           do j=NA,NB
                              do i=lbound(CYR,1),ubound(CYR,1)
                                 write(13,250) i,j, CYR(1,j-NA+1,1:2)
                                 write(*,250) i,j,CYR(1,j-NA+1,1:2)
                              enddo
                           enddo
                           close(13)
                        endif
                                !!! Remember that we only use this method for the case where
                                !!! we can symmetrize wrt all cusp normalizing maps (Atkin-Lehner involutions)
                                !!! So we do not need the negative coefficients
!     write(*,*) 'allocatedCR=',allocated(CR)
!     write(*,*) 'allocatedCYR=',allocated(CYR)
                        if(allocated(CR)) deallocate(CR)
!     write(*,*) 'deal. CR'
                        if(allocated(CYR)) deallocate(CYR)
!     write(*,*) 'deal. CYR'
                     else
!     write(*,*) 'do_gen=',do_gen
!     write(*,*) 'sizeCYP=',size(CYP,2)
                                !!! This is the most general version  
                        if(allocated(CYP)) deallocate(CYP,CYN)
                        allocate(CYP(1:num_cusps,1:NN,1:2),                          &
     &                       CYN(1:num_cusps,1:NN,1:2))
                        if(timing) then 
                           call cpu_time(t1)
                        endif
                        call phase2_gen(R,Y,M0,NA,NB,NN,CY,CYP,CYN,tol,      &
     &                       type,ee,2,d_set,which_set)
                        if(timing) then 
                           call cpu_time(t2)
                           write(*,*) 'time for phase2=',t2-t1
                        endif
                        if(silence.gt.0) then 
                           write(*,*) 'After phase 2'
                           write(*,*) 'sizeCYP=',size(CYP,2)
                        endif
                                !! Write the new coefficients to file
!     ! we form the filename in a unique (and intelligent) way 
!     and suffixing with outfilename
                        if(lcalc) then 
                           open(unit=14,file=lcalc_coef)
                           do j=1,NA-1
                              write(14,355) CY(1,j)
                           enddo
                           do j=NA,NB
                              write(14,355) CYP(1,j-NA+1,1)
                           enddo
                           close(14)
                        endif
                        if((trim(outfilename).ne.'').and.(output)) then 
                           open(unit=13,file=utfilename)
!!!   Write only the newly computed Fourier coefficients at the first cusp 
!!!   If NA<M0 we write all coefficients from 0 to NB
                           do i=0,min(NA,M0)
                                !! Remember we improved these coefficients so we have errest < tol
                              errest=tol
                              if(i.le.improve_start) then 
                                 errest=min(abs(CY(1,i)-CY2(1,i)),                            &
     &                                abs(abs(CY(1,i))-abs(CY(1,-i))))
                              else
                                 errest=abs(abs(CY(1,i))-abs(CY(1,-i)))
                              endif
                              if(weight.ne.0.0_DP) then 
                                 write(13,250) i,CY(1,i),errest
                                 if(i.ne.0) then 
                                    write(13,250) 1,-i,CY(1,-i),errest
                                 endif
                              else
                                 write(13,255) 1,i,CY(1,i),errest
                                 write(*,255) 1,i,CY(1,i),errest
                                 if(i.ne.0) then 
                                    write(*,255) 1,-i,CY(1,-i),errest
                                 endif
                              endif
                           enddo
                           do i=1,NN
                              if(weight.ne.0.0_DP) then 
                                 write(13,250) 1,i+NA-1,CYP(1,i,1:2)
                                 write(13,250) 1,-(i+NA-1),CYN(1,i,1:2)
                              else
                                 write(13,255) 1,i+NA-1,CYP(1,i,1:2)
                                 write(*,255) 1,i+NA-1,CYP(1,i,1:2)
                              endif
                           enddo
                        endif
                     endif
                  elseif(action.eq.2) then 
!!!   Verifying the eigenvalue.
!!!   We do this using Hecke relations if weight=0
!!!   Otherwise using 2 Y-values.
                     if(silence.ge.0) then ! This is standard output 
                        write(*,*) 'Verifying eigenvalue=',R
                     endif
                     Y=sqrt(3.0_DP)/real(2*Level,DP)
                     call get_M0_Q_Y(R,M0,Q,Y)            
                     Q=M0+10
                     if(silence.ge.1) then             
                        write(*,*) 'M0=',M0,'R=',R,' Y=',Y,' Q=',Q,      &
     &                       ' Level=',Level,'CMod=',Cmod      
                     endif
                     if(silence.ge.1) then 
                        do j=1,num_cusps
                           write(*,*) 'CY(',j,'1)=',CY(j,1)
                           write(*,*) 'CY(',j,'-1)=',CY(j,-1)
                        enddo
                     endif
                     if(errest.eq.0.0D0) then                
                        if(wt.eq.0) then 
!     ! Use the exceptional eigenvalue 
                           if((M0.gt.N).and.(N.gt.1)) then 
                              if(Ctype.eq.0) then 
                                 errest=abs(abs(CY(1,N))-1.0D0/sqrt(      &
     &                                real(N,kind=DP)))
                              else
                                 errest=abs(abs(CY(1,N))-1.0D0)
                              endif
                           else !! M0 is certainly > 2,3                  
                              if((N.eq.2).or.(N.eq.3)) then !! We can also use C(4)=1
                                 stop
                              endif                  
                              call Hecke_relations(CY(1,1:M0),M0,2,3,       &
     &                             cdiff)
                              errest=abs(cdiff)
                           endif
                        else
                           errest=abs(CY(1,2)-CY2(1,2))
                        endif
                     endif
                     if(silence.ge.0) then 
                        write(*,*) 'Estimated error=',errest
                        write(*,*) 'C(1,-1)=',CY(1,-1)
                        write(*,*) 'C(2,1)=',CY(2,1)
                        
                     endif
                     
                  elseif(action.eq.3) then
                     utfilename='graph'//trim(integer_to_char(N))//'-'//                            &
     &                    trim(real_to_char(wt,2))  // '-' // trim(CHR) &
     &                    //'-'//trim(real_to_char(R,14)) //'-' //                             &
     &                    trim(integer_to_char(nx))  // 'x' //                       &
     &                    trim(integer_to_char(ny))  // '_' //                       &
     &                    trim(real_to_char(x1,2))  // '-' //                       &
     &                    trim(real_to_char(x2,2))  // 'x' //                       &
     &                    trim(real_to_char(yb,2))  // '-' //                       &
     &                    trim(real_to_char(yt,2))  // '.txt'  
                     do_interp=.true. !! In plots it is always good to use interpolation
                     silent_interpolation=-2
                     if(timing) then 
                        call cpu_time(t1)
                     endif
                     call plot_figure(R,lbound(Cy,2),ubound(CY,2),CY,        &
     &                    utfilename,nx-1,ny-1,x1,x2,yb,yt,N,'C',            &
     &                    Ctype,i)
                     if(timing) then 
                        call cpu_time(t2)
                        write(*,*) 'Time for plot=',t2-t1
                     endif
!     call make_plot(R,N,'C',CHR,utfilename,nx-1,ny-1,x1,x2,y1,y2,     &
!     &              in,CY)
                     do_interp=.false.   
                     else
                        write(*,*) 'Action=',action,' not implemented!'            
                     endif
                  enddo
               elseif(action.eq.4) then
                  if(silence.ge.0) then 
                     write(*,*) 'Locating eigenvalues in [',R1,',',      &
     &                    R2,']' 
                     write(*,*) 'Group = Gamma_0(',Lvl,')'
                     if(Kar.gt.0) then 
                        write(*,*) 'Character = ',Kar
                     endif
                  endif
                  if(silence.ge.1) then 
                     findev_silent=silence ! from -1 to 2 gives increasing level of debug info 
                  else
                     findev_silent=-2  !! Otherwise very silent
                  endif
                  weight=0.0_DP
!     ! To find eigenvalues low precision shoud be ok
!     ! This means only that we use asymptotics if appropriate for the K-Bessel function
                  low_prec=.true.
                  call init_g(Lvl)
                  CType=Kar
!                  call cpu_time(t1)
                  if(timing) then 
                     call cpu_time(t1)
                  endif
                  call find_eigenv(R1,R2,Level,listR,'C',Ctype)
                  if(timing) then 
                     call cpu_time(t2)
                     write(*,*) 'Time for locating eigenvalues=',t2-t1
                  endif
!                  call cpu_time(t2)
!                  write(*,*) 'time=',t2-t1
!!!   I want to sort listR in terms of increasing R
                  call sort(listR,1,size(listR,1),3)
!!! Should now decide whether we print to screen or file
!!! At least one of these should apply   
                  utfilename=trim(integer_to_char(Lvl))//'-'//                        &
     &                 trim(real_to_char(wt,2))  // '-' //trim(i2c(Kar))              &
     &                 //'-'//trim(real_to_char(R1,4)) //'-'                        &
     &                 //trim(real_to_char(R2,4)) //                             &
     &                 trim(integer_to_char(NB))  // '.txt' 
                  if(.not.(output)) then !! Meaning no outfile is set
                     !! Then we print to a temporary file anyway
                     outfilename='tmplist-'
                  endif
                  utfilename=trim(outfilename)//trim(utfilename)
                  
                  write(*,*) 'Printing list of eigenvalues to ',          &
     &                 utfilename
                  open(unit=12,file=utfilename)
                  if(allocated(listR)) then 
                     do i=1,size(listR,1)
                        type=anint(listR(i,2))
                        sym_type=anint(listR(i,3))
                        if(listR(i,1).lt.100.0) then 
                           uf=300
                        elseif(listR(i,1).lt.10000.0) then
                           uf=301
                        else
                           uf=302
                        endif
                        if(weight.eq.0.0) then 
                           uf=uf+100
                           if(silence.ge.0) then 
                              write(*,uf,ADVANCE='NO') Level,0,                      &
     &                          Ctype,listR(i,1),type
                           endif
                           write(12,uf,ADVANCE='NO') Level,0,                      &
     &                          CType,listR(i,1),type
                        else
                           if(silence.ge.0) then 
                              write(*,uf,ADVANCE='NO') Level,weight,                      &
     &                          Ctype,listR(i,1),type
                           endif
                           write(12,uf,ADVANCE='NO') Level,weight,                      &
     &                          CType,listR(i,1),type
                        endif
                        do j=2,num_cusps
                           if(silence.ge.0) then 
                              write(*,'(I3,1X)',ADVANCE='NO')                            &
     &                             norm_cusp_combs(sym_type,j)
                           endif
                           write(12,'(I3,1X)',ADVANCE='NO')                            &
     &                          norm_cusp_combs(sym_type,j)
                        enddo
                        if(silence.ge.0) then 
                           write(*,310) listR(i,4)
                        endif
                        write(12,310) listR(i,4)
                     enddo
                  endif
                  close(12)
               else
                  write(*,*) 'Action=',action,' not implemented!'            
               endif
               close(22)
 109           continue
               call clean_group()
               call clean_sys_solve()
               call clean_pullback()
               call clean_kbessel()
               call clean_coefficients()
               call clean_interpolation()
               if(allocated(A_uk)) deallocate(A_uk)
!     ! Works up to 999999
 250           FORMAT(I3,1X,I6,1X,ES28.20,1X,2ES28.20,2X,ES28.20,1X,        &
     &              2ES28.20)   
 255           FORMAT(I3,1X,I6,1X,ES24.16,1X,2ES24.16,2X,ES24.16,1X,        &
     &              2ES24.16)   
 300           FORMAT(I4,2X,F5.3,2X,I5,2X,F19.16,2X,I5,2X)              
 301           FORMAT(I4,2X,F5.3,2X,I5,2X,F21.16,2X,I5,2X)              
 302           FORMAT(I4,2X,F5.3,2X,I5,2X,F27.16,2X,I5,2X)              
 310           FORMAT(ES12.1)              
 350           FORMAT(ES30.20)  ! real coefficients
 355           FORMAT(ES30.20,1X,ES30.20) ! complex coefficients


 400           FORMAT(I5,2X,I1,2X,I5,2X,F19.16,2X,I5,2X)              
 401           FORMAT(I5,2X,I1,2X,I5,2X,F21.16,2X,I5,2X)              
 402           FORMAT(I5,2X,I1,2X,I5,2X,F27.16,2X,I5,2X)              
               end program

