/*
********************************************
* Lattices.mg                              *
*                                          *
* Gabor Wiese, version of 01/01/2008       *
********************************************
*/

// basic idea taken from a program by William Stein
intrinsic ReduceDimensionAndGetLattice ( gen :: SeqEnum : dim := -1 ) -> Tup
{Finds a faithful module (of dimension equal to the degree) 
for the matrix algebra generated by the list gen of (commuting) matrices 
over the rationals.
In this module a basis for the lattice spanned by the images of
gen is computed. A base change of the matrices in gen to this
basis then asserts that the matrices have integral entries.
}
  F := BaseRing(gen[1]);
  n := Nrows(gen[1]);
  if dim lt 0 then dim := Dimension(MatrixAlgebra(gen)); end if;
  V := VectorSpace(F,n);

  foundone := false;
  while not foundone do
    v := V![Random(10) : i in [1..n]];
    list := [v*gen[i] : i in [1..#gen]];
    W := sub<V|list>;
    if (dim eq Dimension(W)) then foundone := true; end if;
  end while;

  ms := KMatrixSpace(RationalField(),#list,n);
  R := Lattice(ms!list);
  T := BaseChangeMatrices(VectorSpaceWithBasis([W!b : b in Basis(R)]));
  return T;
end intrinsic;

