// Attach the package
// We suppose that the files of the package are in the current directory.
AttachSpec("FastBases.spec");

// compute the standard basis in weight 13/2 up to precision 30
FB_standard_basis(13/2,30);

// compute the Kohnen basis of the Kohnen plus space in weight 31/2 up to precision 50
FB_Kohnen_basis(31/2,50);

// compute the Rankin-Cohen basis of the Kohnen plus-space in weight 25/2 up to precision 50
// note that this function requires to be in weight l+1/2 with l even
FB_RC_basis_plus(25/2,50);

// compute the Rankin-Cohen basis of the full space in weight 27/2 up to precision 50
// note that this function requires to be in weight l+1/2 with l odd
FB_RC_basis_full(27/2,50);

// we can nonetheless get a basis of the plus space via this command
k := 27/2; C := FB_RC_basis_full(k,50); FB_plus_subspace(C,k);

// we can also get a basis of the plus space from the standard basis
k := 27/2; C := FB_standard_basis(k,50); FB_plus_subspace(C,k);


// compare some timings
k := 25/2;
bound := 10^6;

t0 := Cputime();
A := FB_RC_basis_plus(k,bound);
t1 := Cputime();
print "Time for RC basis of the plus space",t1-t0;
B := FB_Kohnen_basis(k,bound);
t2 := Cputime();
print "Time for the Kohnen basis of the plus space",t2-t1;
C1 := FB_standard_basis(k,bound);
C := FB_plus_subspace(C1,k);
t3 := Cputime();
print "Time for a basis of the plus space cut out from the standard basis of the full space",t3-t2;


