/*****************************************
 * FB_Standard_Basis.m                   *
 * part of                               *
 * FastBases Magma Package               *
 * Author: Gabor Wiese                   *
 * 5 December 2019                       *
 *****************************************/


intrinsic FB_standard_basis (k, bound) -> Any
{Compute the standard basis of weight k (integral or half-integral) modular forms of level Gamma_0(4).}
  out_basis := []; // write our basis here

  // initialise the basic modular forms as power series
  T := FB_theta(bound);
  F2 := FB_F2(bound);

  // want T^a + F2^b to have weight k, i.e. k = a/2 + 2b
  // write m := 2k = a  + 4 * b
  // put c := m mod 4 (i.e. c = a mod 4) and s := m div 4; then 0 <= b <= s
  m := Integers()!(2*k); 
  c := m mod 4;
  s := m div 4;
  
  // precompute some powers
  T2 := T^2;
  T4 := T2^2;
  if c eq 0 then Tc := Parent(T)!1;
  elif c eq 1 then Tc := T;
  elif c eq 2 then Tc := T2;
  elif c eq 3 then Tc := T2*T;
  end if;
  
  T_powers := [Tc];
  for b := 0 to s-1 do
    Tc := Tc*T4;
    Append(~T_powers, Tc);
  end for;
  
  G := Parent(F2)!1; // this variable contains the powes of F2, starting with F2^0 = 1
  
  for b := 0 to s do
    Append(~out_basis, T_powers[(s-b)+1]*G);
    if b lt s then // there will be another step, so compute new powers
      G := G*F2;
    end if;  
  end for;
  
  return out_basis;
end intrinsic;
