// BigOofNSquareSpaceTables.h: header
////////////////////////////////////////////////////////////////////////////////
//
//   Copyright (C) 2008   Georg S. Weber
//
//   This file is part of the Essen Modular package programs.
//
//   The Essen Modular package programs are
//   free software:
//   you can redistribute them and/or modify them
//   under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   The Essen Modular package programs are
//   distributed in the hope that they will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License along
//   with the Essen Modular package programs,
//   see the text file COPYING in this directory.
//   If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////
//
//   history / version (the version is YYYY-MM-DD of the last change)
//   2008-02-22: creation (gsw) 
//
////////////////////////////////////////////////////////////////////////////////

#ifndef BIG_O_OF_N_SQUARE_SPACE_TABLES_H
#define BIG_O_OF_N_SQUARE_SPACE_TABLES_H

#include "./EssenModularGlobal.h"

inline uint8_t BigOofNSquareSpaceTablesConstruction(EF_sng N);

inline void BigOofNSquareSpaceTablesDestruction(void);

inline EF_sng multiplyModN(EF_sng a, EF_sng b);

EF_sng indexOfRepresentativeNSquareSpace(EF_sng u, EF_sng v);

inline EF_sng arrayOfRepresentativeIndicesNSquareSpace(EF_sng ** ptrptr_list);

inline EF_sng retrieveKusingMulTable(EF_sng a, EF_sng b, EF_sng ka, EF_sng kb);


#endif //BIG_O_OF_N_SQUARE_SPACE_TABLES_H

