// EssenModularGlobal.h: global header file for the Essen Modular package
////////////////////////////////////////////////////////////////////////////////
//
//   Copyright (C) 2008   Georg S. Weber
//
//   This file is part of the Essen Modular package programs.
//
//   The Essen Modular package programs are
//   free software:
//   you can redistribute them and/or modify them
//   under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   The Essen Modular package programs are
//   distributed in the hope that they will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License along
//   with the Essen Modular package programs,
//   see the text file COPYING in this directory.
//   If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////
//
//   history / version (the version is YYYY-MM-DD of the last change)
//   2008-02-03: creation (gsw) 
//   2008-02-11: modified (gsw) 
//   2008-03-07: commentary enlarged (gsw) 
//   2008-04-05: put here macro MAX_PRIME_FACTORS (gsw) 
//
////////////////////////////////////////////////////////////////////////////////

#ifndef ESSEN_MODULAR_GLOBAL_H
#define ESSEN_MODULAR_GLOBAL_H

#include <stdint.h> //uint32_t, etc.
#include <stdio.h>  //printf(), NULL, etc.
#include <stdlib.h> //exit(), etc.
#include <math.h>   //sqrt(), floor(), ceil(), etc.


typedef uint32_t EF_sng;
typedef  int64_t EF_dbl;

// EF_dbl should have two times the bits as the value x of type EF_sng,
// ("x" in module EratosthenesFermat, called also "pBound", and has
//  the size of the square root of the prime p for which we compute)
// and both of the above types must be known to the C-compiler used
// (one can use the same types, provided sufficiently small x will be used only)
//
// EF_dbl must be a signed type for the time being, this puts a restriction on x


//macros
#define MAX_PRIME_FACTORS   9   //suffices up to 2*3*5*7*11*13*17*19*23*29 - 1
                                // which is larger than 2^32


#endif //ESSEN_MODULAR_GLOBAL_H

