// PrimeFactorsTest.c: Test program for PrimeFactors algorithm
////////////////////////////////////////////////////////////////////////////////
//
//   Copyright (C) 2008   Georg S. Weber
//
//   This file is part of the Essen Modular package programs.
//
//   The Essen Modular package programs are
//   free software:
//   you can redistribute them and/or modify them
//   under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   The Essen Modular package programs are
//   distributed in the hope that they will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License along
//   with the Essen Modular package programs,
//   see the text file COPYING in this directory.
//   If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////
//
//   history / version (the version is YYYY-MM-DD of the last change)
//   2008-03-22: creation (gsw) 
//
////////////////////////////////////////////////////////////////////////////////


#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>

#include "./PrimeFactors.h" 

#define TESTLENGTH  400000u
//#define TEST_X      399955577u
//#define TEST_X              2213u
#define TEST_X                26u


//
// function     : main
//
// param     x: 
// param array: 
//              
//              
//              
//              
//              
// returns      : we use exit()
//
// changes      : 2008-03-22, creation (gsw)
//              : 2008-03-23, modified (gsw)
//

int main(void)
{
    //EF_sng * TestArray;
    
    EF_sng TestX = TEST_X;
    
    EF_sng i, j, k;
    
    EF_sng output[MAX_PRIME_FACTORS][0x2];
    int8_t  primeFactorsLength;
    
    printf("2nd Test\n");

    for( k = 0x1; k <= TestX; k++)
    {
        if( 0x0 != PrimeFactorsTableConstruction(k) )
        {
            printf("Table Construction failed!\n");
            exit(1);
        }
        
        printf("\n\n");
        for(i = 1; i <= k; i++)
        {
            printf("%d     ", i);
            primeFactorsLength = PrimeFactorization(i, output);
            for(j = 0; j < primeFactorsLength; j++)
            {
                printf("%d %d   ", output[j][0x0], output[j][0x1]);
            }
            printf("\n");
        }
        
        PrimeFactorsTableDestruction();
    }
    exit(0);
}

