/* ************************************************************
   **                                                        **
   ** FileHandling.mg                                        **
   **                                                        **
   ** Gabor Wiese                                            **
   ** version of 01/01/08                                    **
   **                                                        **
   ************************************************************ */

import "Structure.mg" : ModularFormFormat, AlgebraData;


// -------------- storing and reloading -----------------------------

intrinsic CreateStorageFile ( filename :: MonStgElt )
{Creates a file for storing data.}
  PrintFile(filename,"// File for storing Hecke algebra data." : Overwrite := true);
  PrintFile(filename,"LoadIn := [];");
  PrintFile(filename,"LoadInRel := <>;\n");
end intrinsic;

intrinsic StoreData (filename :: MonStgElt, forms :: SeqEnum)
{Appends the list of Hecke algebra data forms to the file filename. That
file must have been created by CreateStorageFile.}
  for a in forms do
    StoreData(filename,a);
  end for;
end intrinsic;

intrinsic StoreData (filename :: MonStgElt, form :: Rec)
{Appends the Hecke algebra data form to the file filename. That
file must have been created by CreateStorageFile.}

  if not assigned form`ImageName then
    form`ImageName := "";
  end if;
  if not assigned form`Polynomial then
    form`Polynomial := PolynomialRing(Integers())!0;
  end if;

  s := "Append(~LoadIn, "*
        Sprint(<
        form`Level,
        form`Weight,
        form`Characteristic,
        form`BaseFieldDegree,
        form`CharacterOrder,
        form`CharacterConductor,
        form`CharacterIndex,
        form`AlgebraFieldDegree,
        form`ResidueDegree, 
        form`Dimension,
        form`GorensteinDefect,
        form`EmbeddingDimension,
        form`NilpotencyOrder,
        form`NumberGenUsed,
        "\""*form`ImageName*"\"",
        Sprint(form`Polynomial, "Magma")
       >)*");\n";

  if #form`Relations eq 0 then
    s := s * "Append(~LoadInRel, <>);\n";
  else
    hKi := Parent(form`Relations[1][3][1]);
    s := s*"hKi := "*Sprint(Parent(form`Relations[1][3][1]),"Magma")*";\n";
    s := s * "Append(~LoadInRel, "* Sprint(form`Relations,"Magma") *");\n";
  end if;

  PrintFile (filename,s);
end intrinsic;

intrinsic RecoverData (LoadIn :: SeqEnum, LoadInRel :: Tup ) -> SeqEnum
{In order to read Hecke algebra data from file filename, proceed
as follows: load filename; readData := RecoverData(LoadIn,LoadInRel).}
  FormList := [];
  for i := 1 to #LoadIn do
    newEl := rec < AlgebraData |
      Level              := LoadIn[i][1],
      Weight             := LoadIn[i][2],
      Characteristic     := LoadIn[i][3],
      BaseFieldDegree    := LoadIn[i][4],
      CharacterOrder     := LoadIn[i][5],
      CharacterConductor := LoadIn[i][6],
      CharacterIndex     := LoadIn[i][7],
      AlgebraFieldDegree := LoadIn[i][8],
      ResidueDegree      := LoadIn[i][9],
      Dimension          := LoadIn[i][10],
      GorensteinDefect   := LoadIn[i][11],
      EmbeddingDimension := LoadIn[i][12],
      NilpotencyOrder    := LoadIn[i][13],
      NumberGenUsed      := LoadIn[i][14],
      ImageName          := LoadIn[i][15],
      Polynomial         := LoadIn[i][16],
      Relations          := LoadInRel[i]
    >;

    Append(~FormList,newEl);
  end for;
  return FormList;
end intrinsic;

