/* ************************************************************
   **                                                        **
   ** NiceOutput.mg                                          **
   **                                                        **
   ** Gabor Wiese                                            **
   ** version of 01/01/08                                    **
   **                                                        **
   ************************************************************ */

import "Structure.mg" : ModularFormFormat, AlgebraData;

intrinsic HeckeAlgebraPrint (ha :: SeqEnum)
{Prints part of the data stored in the list ha of records of
type AlgebraData in a human readable format.}
  for i:=1 to #ha do
    s := "";
    if assigned ha[i]`Level then 
      s := s*"Level "*Sprint(ha[i]`Level); 
    end if;
    if assigned ha[i]`Weight then 
      s := s*", Weight "*Sprint(ha[i]`Weight); 
    end if;
    if assigned ha[i]`Characteristic then 
      s := s*", Characteristic "*Sprint(ha[i]`Characteristic); 
    end if;
    if assigned ha[i]`GorensteinDefect then 
      s := s*", Gorenstein defect "*Sprint(ha[i]`GorensteinDefect); 
    end if;
    if assigned ha[i]`Dimension then 
      s := s*", Dimension "*Sprint(ha[i]`Dimension); 
    end if;
    if assigned ha[i]`NumberGenUsed then 
      s := s*", Number of operators used "*Sprint(ha[i]`NumberGenUsed); 
    end if;
    if (assigned ha[i]`Level) and (assigned ha[i]`Weight) then 
      s := s*", Primes lt Hecke bound "*Sprint(#PrimesUpTo(HeckeBound(ha[i]`Level,ha[i]`Weight))); 
    end if;
    if assigned ha[i]`ResidueDegree  then 
      s := s*", Residue degree "*Sprint(ha[i]`ResidueDegree); 
    end if;
    print s;
  end for;
end intrinsic;

intrinsic HeckeAlgebraPrint1 (ha :: SeqEnum)
{Prints part of the data stored in the list ha of records of
type AlgebraData in a human readable format.}
  for i:=1 to #ha do
    if assigned ha[i]`Level then 
      print "Level",ha[i]`Level; 
    end if;
    if assigned ha[i]`Weight then 
      print "Weight",ha[i]`Weight; 
    end if;
    if assigned ha[i]`Characteristic then 
      print "Characteristic",ha[i]`Characteristic; 
    end if;
    if assigned ha[i]`GorensteinDefect then 
      print "Gorenstein defect",ha[i]`GorensteinDefect; 
    end if;
    if assigned ha[i]`Dimension then 
      print "Dimension",ha[i]`Dimension; 
    end if;
    if assigned ha[i]`NumberGenUsed then 
      print "Number of operators used",ha[i]`NumberGenUsed; 
    end if;
    if (assigned ha[i]`Level) and (assigned ha[i]`Weight) then 
      print "Primes lt Hecke bound",#PrimesUpTo(HeckeBound(ha[i]`Level,ha[i]`Weight)); 
    end if;
    if assigned ha[i]`ResidueDegree  then 
      print "Residue degree",ha[i]`ResidueDegree; 
    end if;
    print       "---------------------------";
  end for;
end intrinsic;

