/*
********************************************
* Lifts.mg                                 *
*                                          *
* Lifting idempotents with                 *
* Newton method.                           *
*                                          *
* Gabor Wiese, version of 24/01/2014       *
********************************************
*/

intrinsic SomeLift (AF :: Rec, T :: Any) -> Any
{Input: pAdicAlgebra AF and a matrix over the residue field.
Output: some lift to AF of T.}
  c := AF`mod_coords(T);
  out := AF`Aadic!0;

  for i := 1 to Ncols(c) do
    out := out + (AF`R)!(c[i])*(AF`Aadic!(AF`basis[i]));
  end for;

  return out;
end intrinsic;


mstep := function(a);
  return 3*a^2 - 2*a^3;
end function;

mevalv := function(a)
  return a^2-a;
end function;

intrinsic LiftIdempotent (AF :: Any, e :: Any) -> Any
{Input: pAdicAlgebra AF and an idempotent e over the residue field.
Output: An idempotent in AF lifting e.}

  // Newton approximation
  a := SomeLift(AF,e);
  repeat
    a := mstep(a);
  until mevalv(a) eq AF`Aadic!0;

  return a;
end intrinsic;

