// we created a structure for p-adic algebras, called pAdicAlgebraFormat (a record)

// first attach the package; the package ArtinAlgebras is required by pAdicAlgebras
AttachSpec("ArtinAlgebras/ArtinAlgebras.spec");
AttachSpec("pAdicAlgebras/pAdicAlgebras.spec");


/* In our example, we create the algebra using integral Hecke operators.*

/* level, weight */
N := 229; k := 2;

/* the prime p at which we work and the desired precision */
p := 5; prec := 15;

/* create the cusp space of modular symbols and compute all Hecke operators up to the Sturm bound */
C := CuspidalSubspace(ModularSymbols(N,k,1));
L := [];
for n := 1 to HeckeBound(C) do
  Append(~L, IntegralHeckeOperator(C,n));
end for;

/* Create the pAdicAlgebra generated by the matrices in the list L for the prime p and precision prec. */
A := pAdicAlgebra(L,p : prec := prec);

/* Compute the decomposition of A as a product of its localisation at the maximal ideals. */
F := pAdicAlgebraFactors(A);

/* F is a list of tuples <T, phi>, where T is the factor as a pAdicAlgebra and phi is the restriction map from A to T. Examples of commands: */
F[1][1]`dim;   // the dimension of the first factor
F[3][2](L[3]); // the restriction of the Hecke operator L[3] to the second factor
pAdicMatrixAlgebra(F[3][1]); // the third factor as a matrix algebra


/* Alternatively, one can also calculate one factor after the other, as follows. */
_compute_adic_idempotents(~A);     // this computes the decomposition via idempotents
e := A`ipadic[1];                  // take the first idempotent
H,phi := pAdicAlgebraFactor(A,e);  // the factor corresponding to the chosen idempotent

